/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.db.monitor.DBSysConf;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.TimeTransformer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class CountAnomalyTimeThread
implements Runnable {
    private static final Logger LOGGER = LogManager.getInstance().getDaySummLog();
    private static final int SLEEP_FOR_A_WHILE = 60000;
    private static final int DAY_LONG = 86400;
    private static final int HOUR_LONG = 3600;
    private static final String HOUR_TABLE = "atic_ip_anomaly_times_h";
    private static final String DAY_TABLE = "atic_ip_anomaly_times_d";
    private static CountAnomalyTimeThread instance = new CountAnomalyTimeThread();
    private DBSysConf sysConfigDao = new DBSysConf();
    private boolean sumFlag = false;

    public static CountAnomalyTimeThread getInstane() {
        return instance;
    }

    @Override
    public void run() {
        while (true) {
            if (this.isTime() && !this.sumFlag) {
                this.sum();
            }
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Object)"CountAnomalyTimeThread run error", (Throwable)e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sum() {
        long nowDay = TimeTransformer.transferWithoutHour(System.currentTimeMillis() / 1000L);
        Connection conn = DBConnPool.getConnection();
        Statement stmt = null;
        if (conn != null) {
            try {
                stmt = conn.createStatement();
                this.daySum(nowDay, stmt);
                this.hourSum(nowDay, stmt);
                this.sumFlag = true;
            }
            catch (SQLException e) {
                LOGGER.error((Object)"sum method run error", (Throwable)e);
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"When close statement,some errors happened");
                }
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"When close DB connection,some errors happened");
                }
            }
        }
    }

    private boolean isTime() {
        int nowHour = Calendar.getInstance().get(11);
        if (nowHour == 1) {
            return true;
        }
        this.sumFlag = false;
        return false;
    }

    private void hourSum(long nowDay, Statement stmt) {
        for (int i = 0; i < 24; ++i) {
            try {
                long start = nowDay - Long.valueOf(86400L) + (long)i * Long.valueOf(3600L);
                long end = start + 3600L;
                this.excuteSql(HOUR_TABLE, start, end, stmt);
                continue;
            }
            catch (SQLException e) {
                LOGGER.error((Object)"hourSum error ", (Throwable)e);
            }
        }
        this.sysConfigDao.update("hour_count_time", nowDay + "");
    }

    private void daySum(long nowDay, Statement stmt) {
        try {
            long start = nowDay - 86400L;
            long end = nowDay;
            this.excuteSql(DAY_TABLE, start, end, stmt);
            this.sysConfigDao.update("day_count_time", nowDay + "");
        }
        catch (SQLException e) {
            LOGGER.error((Object)"daySum error ", (Throwable)e);
        }
    }

    private void excuteSql(String inserTable, long start, long end, Statement stmt) throws SQLException {
        try {
            String detectSql = "INSERT INTO " + inserTable + " (LOG_TIME,DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,ZONE_IP,ATTACK_TYPE,ALERT_TIMES)" + " (SELECT " + start + ",DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,ZONE_IP,ATTACK_TYPE,COUNT(1)" + " FROM atic_ip_attack_exact_log" + " WHERE DEVICE_TYPE = 1" + " AND START_TIME_ALERT < " + end + " AND END_TIME >= " + start + " AND START_TIME_ALERT > " + (start - 1728000L) + " GROUP BY DEVICE_IP,DIRECTION,ZONE_ID,ZONE_IP,ATTACK_TYPE)";
            String cleanSql = "INSERT INTO " + inserTable + " (LOG_TIME,DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,ZONE_IP,ATTACK_TYPE,ALERT_TIMES,ATTACK_TIMES)" + " (SELECT A.t,A.DEVICE_IP,A.DIRECTION,A.DEVICE_TYPE,A.ZONE_ID,A.ZONE_IP,A.ATTACK_TYPE,A.alert,B.attack" + " FROM " + " (SELECT " + start + " t,DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,ZONE_IP,ATTACK_TYPE,COUNT(1) alert" + " FROM atic_ip_attack_exact_log " + " WHERE DEVICE_TYPE = 0 AND START_TIME_ALERT <" + end + " AND END_TIME>= " + start + " AND START_TIME_ALERT > " + (start - 1728000L) + " GROUP BY DEVICE_IP, DIRECTION, ZONE_ID, ZONE_IP, ATTACK_TYPE) AS A " + " LEFT JOIN " + " (SELECT " + start + " t,DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,ZONE_IP,ATTACK_TYPE,COUNT(1) attack " + " FROM atic_ip_attack_exact_log" + " WHERE DEVICE_TYPE = 0 AND START_TIME_ATTACK >0 AND START_TIME_ATTACK <" + end + " AND END_TIME >= " + start + " AND START_TIME_ALERT > " + (start - 1728000L) + " AND START_TIME_ALERT < " + end + " GROUP BY DEVICE_IP, DIRECTION, ZONE_ID, ZONE_IP, ATTACK_TYPE) AS B" + " ON " + " A.t = B.t AND A.DEVICE_IP = B.DEVICE_IP AND A.DIRECTION = B.DIRECTION AND A.DEVICE_TYPE = B.DEVICE_TYPE AND A.ZONE_ID = B.ZONE_ID AND A.ZONE_IP = B.ZONE_IP AND A.ATTACK_TYPE = B.ATTACK_TYPE) ";
            LOGGER.debug((Object)("detectSql is :" + detectSql));
            LOGGER.debug((Object)("cleanSql is: " + cleanSql));
            stmt.execute(detectSql);
            stmt.execute(cleanSql);
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"excuteSql error", (Throwable)e);
        }
    }
}

