/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import com.hs.atic.collector.biz.event.process.BizType;
import com.hs.atic.collector.biz.event.process.DeviceStyleType;
import com.hs.atic.collector.biz.event.process.DeviceType;
import com.hs.atic.collector.biz.event.process.IpType;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.biz.event.process.ZoneType;
import com.hs.atic.collector.db.Repository;
import com.hs.atic.collector.db.RepositoryFactory;
import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.util.AticInstallUtil;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class EventUtil {
    public static final char TABLENAME_SEPARATOR = '-';
    public static final String EVENT_FILE_DIRECTORY = AticInstallUtil.getInstance().getCollectorInstallPath() + File.separator + "temp";
    public static final String ERROR_EVENT_FILE_DIRECTORY = AticInstallUtil.getInstance().getCollectorInstallPath() + File.separator + "temp" + File.separator + "error";
    public static final String DB_FILE_SEPARATOR = ";";
    public static final String XML_DIRECTORY = AticInstallUtil.getInstance().getCollectorInstallPath() + File.separator + "xml";
    public static final String EVENT_FILE_POSTFIX = ".txt";
    public static final String PART_POSTFIX = ".part";
    private static final int TCP = 1;
    private static final int UDP = 2;
    private static final int HTTP = 3;
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private static final String CONFIG_FILE = "conf" + File.separator + "event.conf";

    private EventUtil() {
    }

    public static long getLogTimeFromCondition(Condition condition) {
        if (condition instanceof ConditionClause) {
            ConditionClause calse = (ConditionClause)condition;
            return (Long)calse.getValue() * 1000L;
        }
        return System.currentTimeMillis();
    }

    public static <T extends Event> void createEvents(List<T> result) {
        if (!result.isEmpty()) {
            Map<Type, List<T>> groups = EventUtil.groupEventsByType(result);
            for (Map.Entry<Type, List<T>> entry : groups.entrySet()) {
                List<T> group = entry.getValue();
                if (group.isEmpty()) continue;
                Event first = (Event)group.get(0);
                Repository repository = RepositoryFactory.getInstance().getRepository(first.getClass().getName());
                if (null == repository) continue;
                LOGGER.info((Object)("begin to create events , size is " + group.size() + " repository type is " + repository.getClass().getSimpleName()));
                try {
                    repository.createObjects(group);
                    LOGGER.info((Object)("end to create events , repository type is " + repository.getClass().getSimpleName()));
                }
                catch (Exception e) {
                    LOGGER.error((Object)"create fail ,reason is ", (Throwable)e);
                }
            }
        }
    }

    public static <T extends Event> void createEventsIgnore(List<T> result) {
        if (!result.isEmpty()) {
            Event first = (Event)result.get(0);
            Repository repository = RepositoryFactory.getInstance().getRepository(first.getClass().getName());
            if (null != repository) {
                LOGGER.info((Object)("begin to create events , size is " + result.size() + " repository type is " + repository.getClass().getSimpleName()));
                try {
                    repository.createObjects(result);
                    LOGGER.info((Object)"create completed");
                }
                catch (Exception e) {
                    LOGGER.error((Object)"create fail ,reason is ", (Throwable)e);
                }
            }
        }
    }

    public static String getEventConfigProperty(String key) {
        Properties properties = CommonUtil.openPropertyFile(CONFIG_FILE);
        return properties.getProperty(key);
    }

    public static long getIntegralTime(int peroid) {
        long time = System.currentTimeMillis();
        time -= time % (long)peroid;
        return time;
    }

    public static long getIntegralTimeByDefaultPeriod(long time) {
        long period = 300000L;
        try {
            period = Long.parseLong(EventUtil.getEventConfigProperty("FlowThreadPeriod"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"get event config value error", (Throwable)e);
        }
        long result = time - time % period;
        return result;
    }

    public static String getTimeStamp(long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(new Date(time));
    }

    public static <T extends Event> Map<Integer, List<T>> groupEventsByCpu(List<T> eventsOfSameIp) {
        HashMap<Integer, List<T>> map = new HashMap<Integer, List<T>>();
        for (Event each : eventsOfSameIp) {
            int cpu = each.getCpu();
            if (map.containsKey(cpu)) {
                ((List)map.get(cpu)).add(each);
                continue;
            }
            ArrayList<Event> group = new ArrayList<Event>();
            group.add(each);
            map.put(cpu, group);
        }
        return map;
    }

    public static <T extends Event> Map<Type, List<T>> groupEventsByDeviceIp(List<T> events) {
        HashMap<Type, List<T>> groupsByDeviceIp = new HashMap<Type, List<T>>();
        for (Event event : events) {
            DeviceType type = new DeviceType(event);
            if (groupsByDeviceIp.containsKey(type)) {
                ((List)groupsByDeviceIp.get(type)).add(event);
                continue;
            }
            ArrayList<Event> array = new ArrayList<Event>();
            array.add(event);
            groupsByDeviceIp.put(type, array);
        }
        return groupsByDeviceIp;
    }

    public static <T extends Event> Map<Type, List<T>> groupEventsByZoneIpIgnoreType(List<T> events) {
        HashMap<Type, List<T>> groupsByIp = new HashMap<Type, List<T>>();
        for (Event event : events) {
            IpType type = new IpType(event.getIdentifier());
            if (groupsByIp.containsKey(type)) {
                ((List)groupsByIp.get(type)).add(event);
                continue;
            }
            ArrayList<Event> array = new ArrayList<Event>();
            array.add(event);
            groupsByIp.put(type, array);
        }
        return groupsByIp;
    }

    public static <T extends Event> Map<Type, List<T>> groupEventsByZoneIpIgnoreTypeAndBiz(List<T> events) {
        HashMap<Type, List<T>> groupsByIp = new HashMap<Type, List<T>>();
        for (Event event : events) {
            IpType type = new IpType(true, event.getIdentifier());
            if (groupsByIp.containsKey(type)) {
                ((List)groupsByIp.get(type)).add(event);
                continue;
            }
            ArrayList<Event> array = new ArrayList<Event>();
            array.add(event);
            groupsByIp.put(type, array);
        }
        return groupsByIp;
    }

    public static <T extends Event> Map<Type, List<T>> groupEventsByType(List<T> events) {
        HashMap<Type, List<T>> groupsByType = new HashMap<Type, List<T>>();
        for (Event event : events) {
            DeviceStyleType type = new DeviceStyleType(event.getType(), event.getDeviceType(), event.isIsMaxEvent());
            if (groupsByType.containsKey(type)) {
                ((List)groupsByType.get(type)).add(event);
                continue;
            }
            ArrayList<Event> array = new ArrayList<Event>();
            array.add(event);
            groupsByType.put(type, array);
        }
        return groupsByType;
    }

    public static <T extends Event> Map<Type, List<T>> groupEventsByZone(List<T> events, boolean ignoreWildIp) {
        HashMap<Type, List<T>> groupsByZone = new HashMap<Type, List<T>>();
        for (Event event : events) {
            if (ignoreWildIp && event.isDefaultZone()) continue;
            ZoneType type = new ZoneType(event.getIdentifier());
            if (groupsByZone.containsKey(type)) {
                ((List)groupsByZone.get(type)).add(event);
                continue;
            }
            ArrayList<Event> array = new ArrayList<Event>();
            array.add(event);
            groupsByZone.put(type, array);
        }
        return groupsByZone;
    }

    public static <T extends Event> Map<Type, List<T>> groupEventsByBiz(List<T> events) {
        HashMap<Type, List<T>> groupsByBiz = new HashMap<Type, List<T>>();
        for (Event event : events) {
            BizType type = new BizType(event.getIdentifier());
            if (groupsByBiz.containsKey(type)) {
                ((List)groupsByBiz.get(type)).add(event);
                continue;
            }
            ArrayList<Event> array = new ArrayList<Event>();
            array.add(event);
            groupsByBiz.put(type, array);
        }
        return groupsByBiz;
    }

    public static <T extends Event> Map<Type, List<T>> groupEventsByBizAndEventType(List<T> events) {
        HashMap<Type, List<T>> groupsByBiz = new HashMap<Type, List<T>>();
        for (Event event : events) {
            BizType type = new BizType(event, false);
            if (groupsByBiz.containsKey(type)) {
                ((List)groupsByBiz.get(type)).add(event);
                continue;
            }
            ArrayList<Event> array = new ArrayList<Event>();
            array.add(event);
            groupsByBiz.put(type, array);
        }
        return groupsByBiz;
    }

    public static <T extends Event> Map<Type, List<T>> groupEventsByZoneAndType(List<T> events) {
        HashMap<Type, List<T>> groupsByZone = new HashMap<Type, List<T>>();
        for (Event event : events) {
            if (event.isDefaultZone()) continue;
            ZoneType type = new ZoneType(event);
            if (groupsByZone.containsKey(type)) {
                ((List)groupsByZone.get(type)).add(event);
                continue;
            }
            ArrayList<Event> array = new ArrayList<Event>();
            array.add(event);
            groupsByZone.put(type, array);
        }
        return groupsByZone;
    }

    public static <T extends Event> Map<Type, List<T>> groupEventsByZoneAndType(List<T> events, boolean ignoreWildIp) {
        HashMap<Type, List<T>> groupsByZone = new HashMap<Type, List<T>>();
        for (Event event : events) {
            if (ignoreWildIp && event.isDefaultZone()) continue;
            ZoneType type = new ZoneType(event);
            if (groupsByZone.containsKey(type)) {
                ((List)groupsByZone.get(type)).add(event);
                continue;
            }
            ArrayList<Event> array = new ArrayList<Event>();
            array.add(event);
            groupsByZone.put(type, array);
        }
        return groupsByZone;
    }

    public static <T extends Event> Map<Type, List<T>> groupEventsByZoneIp(List<T> events) {
        HashMap<Type, List<T>> groupsByIp = new HashMap<Type, List<T>>();
        for (Event event : events) {
            IpType type = new IpType(event.getType(), event.getIdentifier());
            if (groupsByIp.containsKey(type)) {
                ((List)groupsByIp.get(type)).add(event);
                continue;
            }
            ArrayList<Event> array = new ArrayList<Event>();
            array.add(event);
            groupsByIp.put(type, array);
        }
        return groupsByIp;
    }

    public static <T extends Event> Map<Type, List<T>> groupEventsByZoneIpAndBizIdIgnoreZoneId(List<T> events) {
        HashMap<Type, List<T>> groupsByIp = new HashMap<Type, List<T>>();
        for (Event event : events) {
            IpType type = new IpType(event.getType(), event.getIdentifier(), false);
            if (groupsByIp.containsKey(type)) {
                ((List)groupsByIp.get(type)).add(event);
                continue;
            }
            ArrayList<Event> array = new ArrayList<Event>();
            array.add(event);
            groupsByIp.put(type, array);
        }
        return groupsByIp;
    }

    public static String getCustomProtocolStr(int protocol) {
        switch (protocol) {
            case 1: {
                return "TCP";
            }
            case 2: {
                return "UDP";
            }
            case 3: {
                return "HTTP";
            }
        }
        return "";
    }
}

