/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.entity.alarm.AbnormalAlarmEntity;
import com.hs.atic.collector.entity.alarm.IpAlarmEntity;
import com.hs.atic.collector.entity.alarm.IpFlowInfo;
import com.hs.atic.collector.entity.alarm.IpInfoKey;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.sdk.bis.form.FaultSeverityRuleForm;
import com.hs.atic.sdk.bis.model.FaultSeverityRule;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class FaultSeverityRuleUtil {
    private static final Logger LOGGER = LogManager.getInstance().getRMILog();
    private static final Long DEFAULT_RULE_ZONE_ID = 0L;
    private static final String RULE_TALBE_NAME = "atic_fault_severity_rule";
    private static final String UPDATE_RULE_SQL = "UPDATE atic_fault_severity_rule SET zone_id = ?,DIRECTION = ?,severity = ?,in_traffic_pps_status = ?,in_traffic_pps = ?,in_traffic_mbps_status = ?,in_traffic_mbps = ?,current_conn_status = ?,current_connection = ?,new_conn_status = ?,new_connection = ?,duration_status = ?,duration = ?,diversion_action = ? WHERE id = ?";
    private static final String INSERT_RULE_SQL = "insert into atic_fault_severity_rule(id,zone_id,DIRECTION,severity,in_traffic_pps_status,in_traffic_pps,in_traffic_mbps_status,in_traffic_mbps,current_conn_status,current_connection,new_conn_status,new_connection,duration_status,duration,diversion_action) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String DELETE_ALL_RULES = "delete from atic_fault_severity_rule";
    private static final String DELETE_SEVERITY_RULES_BY_ID = "delete from atic_fault_severity_rule where zone_id in(?)";
    private static FaultSeverityRuleUtil instance = null;
    private static Map<Map<Long, Integer>, FaultSeverityRuleForm> ruleFormMap = null;

    private FaultSeverityRuleUtil() {
        if (null == ruleFormMap) {
            ruleFormMap = this.getRuleInDatabase();
            LOGGER.info((Object)("Init ruleFormMap, get from db, ruleFormMap=" + ruleFormMap.toString()));
        }
    }

    public static FaultSeverityRuleUtil getInstance() {
        if (null == instance) {
            instance = new FaultSeverityRuleUtil();
        }
        return instance;
    }

    public FaultSeverityRuleForm getRuleForm(Long zoneId, int direction) {
        HashMap<Long, Integer> ruleId = new HashMap<Long, Integer>();
        ruleId.put(zoneId, direction);
        FaultSeverityRuleForm ruleForm = ruleFormMap.get(ruleId);
        if (null == ruleForm) {
            LOGGER.info((Object)("Donot get severiry rule form by zoneId=" + zoneId + ", return default rule."));
            HashMap<Long, Integer> rulenullId = new HashMap<Long, Integer>();
            rulenullId.put(DEFAULT_RULE_ZONE_ID, direction);
            ruleForm = ruleFormMap.get(rulenullId);
        }
        LOGGER.info((Object)("get ruleForm,of zoneId=" + zoneId + ", ruleForm=" + ruleForm));
        return ruleForm;
    }

    public FaultSeverityRule decideSeverity(IpFlowInfo ipFlowInfo, AbnormalAlarmEntity alarm, long beginTime, long zoneId, int direction) {
        FaultSeverityRuleForm ruleForm = this.getRuleForm(zoneId, direction);
        if (null == ruleForm) {
            LOGGER.error((Object)("get fault severity rule error for zoneId=" + zoneId + ",direction=" + direction));
            return null;
        }
        FaultSeverityRule ruleCritical = ruleForm.getCriticalRule();
        FaultSeverityRule ruleMajor = ruleForm.getMajorRule();
        FaultSeverityRule ruleMinor = ruleForm.getMinorRule();
        FaultSeverityRule ruleWarning = ruleForm.getWarningRule();
        if (this.matchSeverityRule(ipFlowInfo, alarm, beginTime, ruleCritical)) {
            return ruleCritical;
        }
        if (this.matchSeverityRule(ipFlowInfo, alarm, beginTime, ruleMajor)) {
            return ruleMajor;
        }
        if (this.matchSeverityRule(ipFlowInfo, alarm, beginTime, ruleMinor)) {
            return ruleMinor;
        }
        if (this.matchSeverityRule(ipFlowInfo, alarm, beginTime, ruleWarning)) {
            return ruleWarning;
        }
        if (null == alarm) {
            LOGGER.error((Object)"Donot get severity rule of alarm , alarm is null");
        } else {
            LOGGER.error((Object)("Donot get severity rule of alarm" + alarm.toString()));
        }
        return null;
    }

    public FaultSeverityRule decideSeverity(IpFlowInfo ipFlowInfo, long beginTime, long zoneId, int direction) {
        return this.decideSeverity(ipFlowInfo, null, beginTime, zoneId, direction);
    }

    private boolean matchSeverityRule(IpFlowInfo ipFlowInfo, AbnormalAlarmEntity alarm, long beginTime, FaultSeverityRule rule) {
        if (rule == null) {
            if (alarm != null) {
                LOGGER.error((Object)("rule is null to get matchSeverityRule of alarm " + alarm.toString()));
            } else {
                LOGGER.error((Object)"rule is null to get matchSeverityRule of alarm, alarm is null");
            }
            return false;
        }
        LOGGER.info((Object)("matchSeverityRule of  rule=" + rule.toString() + ", beginTime= " + beginTime + ", curTime=" + System.currentTimeMillis()));
        if (alarm != null) {
            LOGGER.info((Object)("alarm=" + alarm.toString()));
        }
        if (ipFlowInfo != null) {
            LOGGER.info((Object)("ipFlowInfo=" + this.getcleanedMessage(ipFlowInfo.toString())));
        }
        if (rule.getInTrafficppsStatus() == 1) {
            if (ipFlowInfo != null && ipFlowInfo.getCurrInPps() >= (long)rule.getInTrafficpps()) {
                LOGGER.debug((Object)("ipFlowInfo.getCurrInPps(): " + ipFlowInfo.getCurrInPps() + ", rule.getInTrafficpps():" + rule.getInTrafficpps() + "; rule.getSeverity():" + rule.getSeverity()));
                return true;
            }
            if (alarm != null && !alarm.isMultiCurrent() && alarm.getPpsOrKbps() != 1 && alarm.getCurrentValue() >= (long)rule.getInTrafficpps()) {
                LOGGER.debug((Object)("alarm.isMultiCurrent(): " + alarm.isMultiCurrent() + ", alarm.getPpsOrKbps():" + alarm.getPpsOrKbps() + ", alarm.getCurrentValue():" + alarm.getCurrentValue() + ", rule.getInTrafficpps():" + rule.getInTrafficpps() + "; rule.getSeverity():" + rule.getSeverity()));
                return true;
            }
        }
        if (rule.getInTrafficMbpsStatus() == 1) {
            long ruleKbps = (long)rule.getInTrafficMbps() * 1024L;
            if (ipFlowInfo != null && ipFlowInfo.getCurrInKbps() >= ruleKbps) {
                LOGGER.debug((Object)("ipFlowInfo.getCurrInKbps(): " + ipFlowInfo.getCurrInKbps() + ", ruleKbps:" + ruleKbps + "; rule.getSeverity():" + rule.getSeverity()));
                return true;
            }
            if (alarm != null && !alarm.isMultiCurrent() && alarm.getPpsOrKbps() == 1 && alarm.getCurrentValue() >= ruleKbps) {
                LOGGER.debug((Object)("alarm.isMultiCurrent(): " + alarm.isMultiCurrent() + ", alarm.getPpsOrKbps():" + alarm.getPpsOrKbps() + ", alarm.getCurrentValue():" + alarm.getCurrentValue() + ", ruleKbps:" + ruleKbps + "; rule.getSeverity():" + rule.getSeverity()));
                return true;
            }
        }
        if (rule.getCurrentConnStatus() == 1) {
            if (ipFlowInfo != null && ipFlowInfo.getCurrConn() >= (long)rule.getCurrentConn()) {
                LOGGER.debug((Object)("ipFlowInfo.getCurrConn(): " + ipFlowInfo.getCurrConn() + ", rule.getCurrentConn():" + rule.getCurrentConn() + "; rule.getSeverity():" + rule.getSeverity()));
                return true;
            }
            if (alarm != null && alarm.isMultiCurrent() && alarm.getCurrentValue() >= (long)rule.getCurrentConn()) {
                LOGGER.debug((Object)("alarm.isMultiCurrent(): " + alarm.isMultiCurrent() + ", alarm.getCurrentValue():" + alarm.getCurrentValue() + " rule.getCurrentConn():" + rule.getCurrentConn() + "; rule.getSeverity():" + rule.getSeverity()));
                return true;
            }
        }
        if (rule.getNewConnStatus() == 1) {
            if (ipFlowInfo != null && ipFlowInfo.getNewConn() >= (long)rule.getNewConn()) {
                LOGGER.debug((Object)("ipFlowInfo.getNewConn(): " + ipFlowInfo.getNewConn() + ", rule.getNewConn():" + rule.getNewConn() + "; rule.getSeverity():" + rule.getSeverity()));
                return true;
            }
            if (alarm != null && alarm.isMultiCurrent() && alarm.getCurrentValue1() >= (long)rule.getNewConn()) {
                LOGGER.debug((Object)("alarm.isMultiCurrent(): " + alarm.isMultiCurrent() + ", alarm.getCurrentValue1():" + alarm.getCurrentValue1() + ", rule.getNewConn():" + rule.getNewConn() + "; rule.getSeverity():" + rule.getSeverity()));
                return true;
            }
        }
        if (1 == rule.getDurationStatus() && System.currentTimeMillis() - beginTime >= (long)rule.getDuration() * 1000L) {
            LOGGER.debug((Object)("System.currentTimeMillis(): " + System.currentTimeMillis() + ", beginTime:" + beginTime + ", rule.getDuration():" + (long)rule.getDuration() * 1000L + "; rule.getSeverity():" + rule.getSeverity()));
            return true;
        }
        LOGGER.info((Object)"matchSeverityRule not match");
        return false;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAllFaultSeverityRules(List<FaultSeverityRuleForm> ruleFormList) {
        if (null == ruleFormList || ruleFormList.isEmpty()) {
            LOGGER.error((Object)"Input ruleFormList is empty");
            return false;
        }
        Connection conn = DBConnPool.getConnection();
        PreparedStatement psDelete = null;
        PreparedStatement psInstert = null;
        if (conn == null) {
            LOGGER.error((Object)"DBConnPool.getConnection() retrun null.");
            return false;
        }
        try {
            conn.setAutoCommit(false);
            psDelete = conn.prepareStatement(DELETE_ALL_RULES);
            psDelete.execute();
            psInstert = conn.prepareStatement(INSERT_RULE_SQL);
            for (FaultSeverityRuleForm ruleForm : ruleFormList) {
                this.setInsertSqlPrepared(psInstert, ruleForm.getCriticalRule());
                this.setInsertSqlPrepared(psInstert, ruleForm.getMajorRule());
                this.setInsertSqlPrepared(psInstert, ruleForm.getMinorRule());
                this.setInsertSqlPrepared(psInstert, ruleForm.getWarningRule());
            }
            psInstert.executeBatch();
            conn.commit();
            this.closePreparedStatement(psDelete);
            this.closePreparedStatement(psInstert);
            this.closeConnection(conn);
        }
        catch (Exception e) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e2) {
                    LOGGER.error((Object)"rollback error", (Throwable)e2);
                }
                LOGGER.error((Object)"save FaultSeverityRuleForm error", (Throwable)e);
                boolean e2 = false;
                this.closePreparedStatement(psDelete);
                this.closePreparedStatement(psInstert);
                this.closeConnection(conn);
                return e2;
            }
            catch (Throwable throwable) {
                this.closePreparedStatement(psDelete);
                this.closePreparedStatement(psInstert);
                this.closeConnection(conn);
                throw throwable;
            }
        }
        ruleFormMap.clear();
        for (FaultSeverityRuleForm ruleForm : ruleFormList) {
            HashMap<Long, Integer> ruleId = new HashMap<Long, Integer>();
            ruleId.put(ruleForm.getCriticalRule().getZoneId(), ruleForm.getCriticalRule().getDirection());
            ruleFormMap.put(ruleId, ruleForm);
        }
        LOGGER.info((Object)"save all fault severity rules success!");
        return true;
    }

    public boolean saveFaultSeverityRule(FaultSeverityRuleForm ruleForm) {
        if (null == ruleForm) {
            LOGGER.info((Object)"fault severity rule is null.");
            return false;
        }
        if (!this.saveInDatabase(ruleForm)) {
            return false;
        }
        HashMap<Long, Integer> ruleId = new HashMap<Long, Integer>();
        ruleId.put(ruleForm.getCriticalRule().getZoneId(), ruleForm.getCriticalRule().getDirection());
        ruleFormMap.put(ruleId, ruleForm);
        LOGGER.info((Object)"save fault severity rule success!");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveInDatabase(FaultSeverityRuleForm ruleForm) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement ps = null;
        if (conn == null) {
            LOGGER.error((Object)"DBConnPool.getConnection() retrun null.");
            return false;
        }
        try {
            conn.setAutoCommit(false);
            if (ruleForm.isNewRule()) {
                LOGGER.info((Object)("create a new rule: " + ruleForm.toString()));
                ps = conn.prepareStatement(INSERT_RULE_SQL);
                this.setInsertSqlPrepared(ps, ruleForm.getCriticalRule());
                this.setInsertSqlPrepared(ps, ruleForm.getMajorRule());
                this.setInsertSqlPrepared(ps, ruleForm.getMinorRule());
                this.setInsertSqlPrepared(ps, ruleForm.getWarningRule());
                ps.executeBatch();
                conn.commit();
            } else {
                LOGGER.info((Object)("update rule: " + ruleForm.toString()));
                ps = conn.prepareStatement(UPDATE_RULE_SQL);
                FaultSeverityRuleUtil.setUpdateSqlPrepared(ps, ruleForm.getCriticalRule());
                FaultSeverityRuleUtil.setUpdateSqlPrepared(ps, ruleForm.getMajorRule());
                FaultSeverityRuleUtil.setUpdateSqlPrepared(ps, ruleForm.getMinorRule());
                FaultSeverityRuleUtil.setUpdateSqlPrepared(ps, ruleForm.getWarningRule());
                ps.executeBatch();
                conn.commit();
            }
            LOGGER.info((Object)"update FaultSeverityRuleForm OK!!");
            this.closePreparedStatement(ps);
            this.closeConnection(conn);
        }
        catch (Exception e) {
            try {
                conn.rollback();
            }
            catch (SQLException e2) {
                LOGGER.error((Object)"rollback error", (Throwable)e2);
            }
            LOGGER.error((Object)"save FaultSeverityRuleForm error", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.closePreparedStatement(ps);
            this.closeConnection(conn);
        }
        return true;
    }

    private void setInsertSqlPrepared(PreparedStatement ps, FaultSeverityRule rule) throws SQLException {
        int paramIndex = 1;
        ps.setLong(paramIndex++, rule.getId());
        ps.setLong(paramIndex++, rule.getZoneId());
        FaultSeverityRuleUtil.addRuleThreadPrepared(ps, rule, paramIndex);
        ps.addBatch();
    }

    private static int addRuleThreadPrepared(PreparedStatement ps, FaultSeverityRule rule, int paramIndex) throws SQLException {
        ps.setInt(paramIndex++, rule.getDirection());
        ps.setInt(paramIndex++, rule.getSeverity());
        ps.setInt(paramIndex++, rule.getInTrafficppsStatus());
        ps.setInt(paramIndex++, rule.getInTrafficpps());
        ps.setInt(paramIndex++, rule.getInTrafficMbpsStatus());
        ps.setInt(paramIndex++, rule.getInTrafficMbps());
        ps.setInt(paramIndex++, rule.getCurrentConnStatus());
        ps.setInt(paramIndex++, rule.getCurrentConn());
        ps.setInt(paramIndex++, rule.getNewConnStatus());
        ps.setInt(paramIndex++, rule.getNewConn());
        ps.setInt(paramIndex++, rule.getDurationStatus());
        ps.setInt(paramIndex++, rule.getDuration());
        ps.setInt(paramIndex++, rule.getDiversionAction());
        return paramIndex;
    }

    private static void setUpdateSqlPrepared(PreparedStatement ps, FaultSeverityRule rule) throws SQLException {
        int paramIndex = 1;
        ps.setLong(paramIndex++, rule.getZoneId());
        paramIndex = FaultSeverityRuleUtil.addRuleThreadPrepared(ps, rule, paramIndex);
        ps.setLong(paramIndex++, rule.getId());
        ps.addBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Map<Long, Integer>, FaultSeverityRuleForm> getRuleInDatabase() {
        HashMap<Map<Long, Integer>, FaultSeverityRuleForm> ruleFormMaps = new HashMap<Map<Long, Integer>, FaultSeverityRuleForm>();
        FaultSeverityRuleForm ruleForm = null;
        FaultSeverityRule rule = null;
        Connection conn = DBConnPool.getConnection();
        PreparedStatement st = null;
        ResultSet rs = null;
        String sql = "SELECT id,zone_id,DIRECTION,severity,in_traffic_pps_status,in_traffic_pps,in_traffic_mbps_status,in_traffic_mbps,current_conn_status,current_connection,new_conn_status,new_connection,duration_status,duration,diversion_action FROM atic_fault_severity_rule";
        try {
            st = conn.prepareStatement(sql);
            rs = st.executeQuery();
            int index = 0;
            while (rs.next()) {
                index = 1;
                rule = new FaultSeverityRule();
                rule.setId(rs.getLong(index++));
                rule.setZoneId(rs.getLong(index++));
                rule.setDirection(rs.getInt(index++));
                rule.setSeverity(rs.getInt(index++));
                rule.setInTrafficppsStatus(rs.getInt(index++));
                rule.setInTrafficpps(rs.getInt(index++));
                rule.setInTrafficMbpsStatus(rs.getInt(index++));
                rule.setInTrafficMbps(rs.getInt(index++));
                rule.setCurrentConnStatus(rs.getInt(index++));
                rule.setCurrentConn(rs.getInt(index++));
                rule.setNewConnStatus(rs.getInt(index++));
                rule.setNewConn(rs.getInt(index++));
                rule.setDurationStatus(rs.getInt(index++));
                rule.setDuration(rs.getInt(index++));
                rule.setDiversionAction(rs.getInt(index++));
                HashMap<Long, Integer> ruleId = new HashMap<Long, Integer>();
                ruleId.put(rule.getZoneId(), rule.getDirection());
                ruleForm = (FaultSeverityRuleForm)ruleFormMaps.get(ruleId);
                if (null == ruleForm) {
                    ruleForm = new FaultSeverityRuleForm();
                    ruleFormMaps.put(ruleId, ruleForm);
                }
                if (4 == rule.getSeverity()) {
                    ruleForm.setCriticalRule(rule);
                    continue;
                }
                if (3 == rule.getSeverity()) {
                    ruleForm.setMajorRule(rule);
                    continue;
                }
                if (2 == rule.getSeverity()) {
                    ruleForm.setMinorRule(rule);
                    continue;
                }
                if (1 != rule.getSeverity()) continue;
                ruleForm.setWarningRule(rule);
            }
            this.closeResultSet(rs);
            this.closePreparedStatement(st);
            this.closeConnection(conn);
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"SQLException", (Throwable)e);
                this.closeResultSet(rs);
                this.closePreparedStatement(st);
                this.closeConnection(conn);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closePreparedStatement(st);
                this.closeConnection(conn);
                throw throwable;
            }
        }
        return ruleFormMaps;
    }

    private void closeResultSet(ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"when resultSet close is error");
            }
        }
    }

    private void closeConnection(Connection conn) {
        try {
            if (null != conn) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"db connection close faile");
        }
    }

    private void closePreparedStatement(PreparedStatement ps) {
        try {
            if (null != ps) {
                ps.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"db statement close faile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteSeverityRules(List<Long> zoneIdList) throws RemoteException {
        if (null == zoneIdList || zoneIdList.isEmpty()) {
            LOGGER.error((Object)"input zoneIdList is empty");
            return false;
        }
        Connection conn = DBConnPool.getConnection();
        PreparedStatement psDelete = null;
        if (conn == null) {
            LOGGER.error((Object)"DBConnPool.getConnection() retrun null.");
            return false;
        }
        StringBuffer zoneIdstrs = new StringBuffer();
        for (int i = 0; i < zoneIdList.size(); ++i) {
            zoneIdstrs.append(zoneIdList.get(i));
            if (i >= zoneIdList.size() - 1) continue;
            zoneIdstrs.append(',');
        }
        try {
            psDelete = conn.prepareStatement(DELETE_SEVERITY_RULES_BY_ID);
            psDelete.setString(1, zoneIdstrs.toString());
            psDelete.execute();
            for (Long zoneId : zoneIdList) {
                HashMap<Long, Integer> ruleinId = new HashMap<Long, Integer>();
                ruleinId.put(zoneId, 1);
                ruleFormMap.remove(ruleinId);
                HashMap<Long, Integer> ruleinoutId = new HashMap<Long, Integer>();
                ruleinoutId.put(zoneId, 2);
                ruleFormMap.remove(ruleinoutId);
            }
        }
        catch (Exception e) {
            try {
                conn.rollback();
            }
            catch (SQLException e2) {
                LOGGER.error((Object)"rollback error", (Throwable)e2);
            }
            LOGGER.error((Object)("deleteSeverityRules error.zoneIdList=" + zoneIdList.toString()), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.closePreparedStatement(psDelete);
            this.closeConnection(conn);
        }
        return true;
    }

    public int getSlotBlackholeAlarmSeverity(String deviceIp, String zoneIp) {
        IpAlarmEntity ipAlarmEntity = null;
        Map<IpInfoKey, IpAlarmEntity> ipAlarmMap = AlarmThread.getInstance().getIpAlarmMap();
        if (null != ipAlarmMap && !ipAlarmMap.isEmpty()) {
            for (Map.Entry<IpInfoKey, IpAlarmEntity> entry : ipAlarmMap.entrySet()) {
                ipAlarmEntity = entry.getValue();
                if (1 != ipAlarmEntity.getDirection() || 6 != ipAlarmEntity.getDiversionAction() || !deviceIp.equals(ipAlarmEntity.getDeviceIp()) || !zoneIp.equals(ipAlarmEntity.getZoneIp()) || 0 != ipAlarmEntity.getDeviceType()) continue;
                return ipAlarmEntity.getSeverity();
            }
        }
        return 0;
    }

    public boolean isBlackholeThresholdTransfinite(String deviceIp, String zoneIp, Integer threshold) {
        AlarmThread alarmThread = AlarmThread.getInstance();
        Map<IpInfoKey, IpAlarmEntity> ipAlarmMap = alarmThread.getIpAlarmMap();
        Map<IpInfoKey, IpFlowInfo> ipFlow70secMap = alarmThread.getIpFlow70secMapOfDev(deviceIp);
        if (null != ipAlarmMap && !ipAlarmMap.isEmpty()) {
            long curInMbps = 0L;
            for (Map.Entry<IpInfoKey, IpAlarmEntity> entry : ipAlarmMap.entrySet()) {
                IpInfoKey ipInfoKey = entry.getKey();
                IpAlarmEntity ipAlarmEntity = entry.getValue();
                curInMbps = this.getCurrInMbps(ipFlow70secMap, entry, ipInfoKey);
                if (1 != ipInfoKey.getDirection() || !deviceIp.equals(ipAlarmEntity.getDeviceIp()) || !zoneIp.equals(ipAlarmEntity.getZoneIp()) || 0 != ipAlarmEntity.getDeviceType()) continue;
                LOGGER.info((Object)("black np isBlackholeThresholdTransfinite curInMbps=" + curInMbps + ", threshold=" + threshold + ", deviceIp=" + ", zoneIp=" + zoneIp));
                if (curInMbps <= (long)threshold.intValue()) continue;
                return true;
            }
            LOGGER.info((Object)("black np isBlackholeThresholdTransfinite threshold:" + threshold + " more than curInMbps:" + curInMbps));
        }
        return false;
    }

    private long getCurrInMbps(Map<IpInfoKey, IpFlowInfo> ipFlow70secMap, Map.Entry<IpInfoKey, IpAlarmEntity> entry, IpInfoKey ipInfoKey) {
        IpFlowInfo ipFlowInfo;
        long curInKbps = 0L;
        curInKbps = null == ipFlow70secMap ? entry.getValue().getCurrInKbps() : (null != (ipFlowInfo = ipFlow70secMap.get(ipInfoKey)) ? ipFlowInfo.getCurrInKbps() : entry.getValue().getCurrInKbps());
        return curInKbps;
    }
}

