/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.DevZoneMapService;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class FilterNameUtil {
    private static final Logger LOGGER = LogManager.getInstance().getRMILog();
    private static final String TALBE_NAME = "atic_filter";
    private static final String DELETE_ALL_SQL = "delete from atic_filter;";
    private static final String INSERT_SQL = "insert into atic_filter (FILTER_ID,FILTER_NAME) values (?,?)";
    private static final String QUERY_SQL = "select FILTER_ID,FILTER_NAME from atic_filter";
    private static FilterNameUtil instance = null;
    private Map<Integer, String> filterNameMap = null;

    private FilterNameUtil() {
    }

    public static FilterNameUtil getInstance() {
        if (null == instance) {
            instance = new FilterNameUtil();
        }
        return instance;
    }

    public String getFilgerName(Integer filterId) {
        String name = "";
        if (null != this.filterNameMap) {
            name = this.filterNameMap.get(filterId);
        }
        if (null != name && !name.isEmpty()) {
            name = name.replace('_', ' ');
            name = name.replace('-', ' ');
            return name;
        }
        LOGGER.error((Object)("get filter name error of filterId=" + filterId));
        return "Filter Attack";
    }

    public String getNPFilgerName(Integer filterId) {
        String name = "";
        if (null != this.filterNameMap) {
            name = this.filterNameMap.get(filterId);
        }
        LOGGER.info((Object)("get np filter name= " + name + "; filterId=" + filterId));
        if (null != name && !name.isEmpty()) {
            name = name.replace('_', ' ');
            name = name.replace('-', ' ');
            return name;
        }
        LOGGER.error((Object)("get np filter name error of filterId=" + filterId));
        return "Hardware Filter Attack";
    }

    public void initAllFilgerNames() {
        DevZoneMapService mapService = (DevZoneMapService)CommonUtil.retreiveAticRmiService("DevZoneMapService");
        if (null != mapService) {
            try {
                this.filterNameMap = mapService.getAllFilters();
            }
            catch (RemoteException e) {
                LOGGER.error((Object)"getAllFilters from ATIC is error,", (Throwable)e);
            }
        }
        if (null != this.filterNameMap) {
            this.updateAllFilterNames(this.filterNameMap);
        } else {
            this.filterNameMap = this.queryFilterNameFromDB();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean updateAllFilterNames(Map<Integer, String> filterMap) {
        if (null == filterMap) {
            LOGGER.error((Object)"input fileterMap is null");
            return false;
        }
        Connection conn = DBConnPool.getConnection();
        PreparedStatement deleteSt = null;
        PreparedStatement insertSt = null;
        ResultSet rs = null;
        try {
            deleteSt = conn.prepareStatement(DELETE_ALL_SQL);
            deleteSt.execute();
            if (!filterMap.isEmpty()) {
                conn.setAutoCommit(false);
                insertSt = conn.prepareStatement(INSERT_SQL);
                for (Map.Entry<Integer, String> entry : filterMap.entrySet()) {
                    insertSt.setInt(1, entry.getKey());
                    insertSt.setString(2, entry.getValue());
                    insertSt.addBatch();
                }
                insertSt.executeBatch();
                conn.commit();
            }
            this.filterNameMap.clear();
            this.filterNameMap.putAll(filterMap);
            boolean bl = true;
            this.closeResultSet(rs);
            this.closePreparedStatement(deleteSt);
            this.closePreparedStatement(insertSt);
            this.closeConnection(conn);
            return bl;
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"updateAllFilterNames error", (Throwable)e);
                boolean bl = false;
                this.closeResultSet(rs);
                this.closePreparedStatement(deleteSt);
                this.closePreparedStatement(insertSt);
                this.closeConnection(conn);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closePreparedStatement(deleteSt);
                this.closePreparedStatement(insertSt);
                this.closeConnection(conn);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, String> queryFilterNameFromDB() {
        HashMap<Integer, String> filterMap = new HashMap<Integer, String>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = conn.prepareStatement(QUERY_SQL);
            rs = st.executeQuery();
            while (rs.next()) {
                filterMap.put(rs.getInt(1), rs.getString(2));
            }
            this.closeResultSet(rs);
            this.closePreparedStatement(st);
            this.closeConnection(conn);
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"SQLException", (Throwable)e);
                this.closeResultSet(rs);
                this.closePreparedStatement(st);
                this.closeConnection(conn);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closePreparedStatement(st);
                this.closeConnection(conn);
                throw throwable;
            }
        }
        return filterMap;
    }

    private void closeResultSet(ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"when resultSet close is error");
            }
        }
    }

    private void closeConnection(Connection conn) {
        try {
            if (null != conn) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"db connection close faile");
        }
    }

    private void closePreparedStatement(PreparedStatement ps) {
        try {
            if (null != ps) {
                ps.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"db statement close faile");
        }
    }
}

