/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public final class GeneratePrimalKey {
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private static final String ORIGNIAL_TABLE_NAME = "ATIC_IP_ATTACK_EXACT_LOG";
    private static final String SERVICE_LEARNING_TABLE_NAME = "ATIC_BIZ_INFO";
    private static final String BASELINE_TABLE_NAME = "ATIC_BASELINE_DATA";
    private static final long START_INCREASE = 100L;
    private static GeneratePrimalKey instance = new GeneratePrimalKey();
    private long originalKey;
    private long serviceLearningKey;
    private long baseLineKey;
    private int offset = this.getDbOffset();
    private int increase = this.getDbIncrease();

    private GeneratePrimalKey() {
        this.originalKey = this.calculateStartDbKey(this.getCurrentDbKey(ORIGNIAL_TABLE_NAME));
        this.serviceLearningKey = this.calculateStartDbKey(this.getCurrentDbKey(SERVICE_LEARNING_TABLE_NAME));
        this.baseLineKey = this.calculateStartDbKey(this.getCurrentDbKey(BASELINE_TABLE_NAME));
    }

    public static GeneratePrimalKey getInstance() {
        return instance;
    }

    public synchronized long getOriginalKey() {
        this.originalKey += (long)this.increase;
        return this.originalKey;
    }

    public synchronized long getServiceLearningKey() {
        this.serviceLearningKey += (long)this.increase;
        return this.serviceLearningKey;
    }

    public synchronized long getBaseLineKey() {
        this.baseLineKey += (long)this.increase;
        return this.baseLineKey;
    }

    private long calculateStartDbKey(long currentKey) {
        currentKey += 100L;
        currentKey = this.offset % 2 == 0 ? (currentKey % 2L == 0L ? (currentKey += 2L) : ++currentKey) : (currentKey % 2L == 0L ? ++currentKey : (currentKey += 2L));
        return currentKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDbOffset() {
        ResultSet rs;
        PreparedStatement query;
        Connection con;
        int dbOffset;
        block5: {
            dbOffset = 1;
            String sql = "SHOW VARIABLES LIKE 'AUTO_INCREMENT_OFFSET'";
            con = null;
            query = null;
            rs = null;
            try {
                con = DBConnPool.getConnection();
                if (null == con) break block5;
                query = con.prepareStatement(sql);
                rs = query.executeQuery();
                while (rs.next()) {
                    dbOffset = rs.getInt(2);
                }
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)("clean event error, and sql is " + sql + " ERROR IS  " + e.getMessage()));
                }
                catch (Throwable throwable) {
                    GeneratePrimalKey.freeDbResource(con, query, rs);
                    throw throwable;
                }
                GeneratePrimalKey.freeDbResource(con, query, rs);
            }
        }
        GeneratePrimalKey.freeDbResource(con, query, rs);
        return dbOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDbIncrease() {
        ResultSet rs;
        PreparedStatement query;
        Connection con;
        int dbIncrease;
        block5: {
            dbIncrease = 1;
            String sql = "SHOW VARIABLES LIKE 'AUTO_INCREMENT_INCREMENT'";
            con = null;
            query = null;
            rs = null;
            try {
                con = DBConnPool.getConnection();
                if (null == con) break block5;
                query = con.prepareStatement(sql);
                rs = query.executeQuery();
                while (rs.next()) {
                    dbIncrease = rs.getInt(2);
                }
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)("clean event error, and sql is " + sql + " ERROR IS  " + e.getMessage()));
                }
                catch (Throwable throwable) {
                    GeneratePrimalKey.freeDbResource(con, query, rs);
                    throw throwable;
                }
                GeneratePrimalKey.freeDbResource(con, query, rs);
            }
        }
        GeneratePrimalKey.freeDbResource(con, query, rs);
        return dbIncrease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentDbKey(String tableName) {
        long currentKey;
        ResultSet rs;
        PreparedStatement query;
        Connection con;
        block5: {
            String sql = "SELECT MAX(PKID) FROM " + tableName;
            con = null;
            query = null;
            rs = null;
            currentKey = 0L;
            try {
                con = DBConnPool.getConnection();
                if (null == con) break block5;
                query = con.prepareStatement(sql);
                rs = query.executeQuery();
                while (rs.next()) {
                    currentKey = rs.getLong(1);
                }
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)("clean event error, and sql is " + sql + " ERROR IS  " + e.getMessage()));
                }
                catch (Throwable throwable) {
                    GeneratePrimalKey.freeDbResource(con, query, rs);
                    throw throwable;
                }
                GeneratePrimalKey.freeDbResource(con, query, rs);
            }
        }
        GeneratePrimalKey.freeDbResource(con, query, rs);
        return currentKey;
    }

    public static void freeDbResource(Connection con, PreparedStatement query, ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"when close resultSet error", (Throwable)e);
            }
        }
        try {
            if (null != query) {
                query.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close statement error", (Throwable)e);
        }
        try {
            if (null != con) {
                con.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close connection error", (Throwable)e);
        }
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

