/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import com.hs.atic.collector.util.CommonUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public final class HostIpSysFileManager {
    private static final Logger LOGGER = Logger.getLogger((String)HostIpSysFileManager.class.getName());

    private HostIpSysFileManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeIpRecordToSystemFile(String conent) {
        String filePath = HostIpSysFileManager.getSystemPath();
        if (CommonUtil.isNull(filePath)) {
            return;
        }
        String ipRecord = "\r\n" + conent + " " + conent;
        String compairRecord = conent + " " + conent;
        HostIpSysFileManager.createWinHostFile(filePath);
        boolean isRecordDuplicate = HostIpSysFileManager.isRecordDuplicate(filePath, compairRecord);
        if (!isRecordDuplicate) {
            BufferedWriter out = null;
            try {
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath, true), "utf-8"));
                out.write(ipRecord);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error((Object)"write collector IP to system file failed!", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                LOGGER.error((Object)"write collector IP to system file failed!");
            }
            catch (IOException e) {
                LOGGER.error((Object)"write collector IP to system file failed!", (Throwable)e);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Close BufferedWriter error!", (Throwable)e);
                }
            }
        }
    }

    public static void deleteIpRecordFromSystemFile(List<String> collectorIpRecordList) {
        String filePath = HostIpSysFileManager.getSystemPath();
        if (CommonUtil.isNull(filePath)) {
            return;
        }
        List<String> sysFileContent = HostIpSysFileManager.readSystemFile(filePath);
        if (!sysFileContent.isEmpty()) {
            ArrayList<String> sysFileNoDuplicate = new ArrayList<String>();
            sysFileNoDuplicate.add(sysFileContent.get(0));
            for (String sTmp : sysFileContent) {
                boolean isDuplicate = false;
                for (int k = 0; k < sysFileNoDuplicate.size(); ++k) {
                    if (!sTmp.equals(sysFileNoDuplicate.get(k))) continue;
                    isDuplicate = true;
                    break;
                }
                if (isDuplicate) continue;
                sysFileNoDuplicate.add(sTmp);
            }
            block2: for (int j = 0; j < collectorIpRecordList.size(); ++j) {
                for (int i = 0; i < sysFileNoDuplicate.size(); ++i) {
                    if (!((String)sysFileNoDuplicate.get(i)).equals(collectorIpRecordList.get(j))) continue;
                    sysFileNoDuplicate.remove(i);
                    continue block2;
                }
            }
            HostIpSysFileManager.rewriteRecordToSysFile(filePath, sysFileNoDuplicate);
        }
    }

    private static String getSystemPath() {
        String strOSPath = System.getenv("SystemRoot");
        StringBuffer filePath = new StringBuffer();
        filePath.append(strOSPath).append(File.separator).append("system32").append(File.separator).append("drivers").append(File.separator).append("etc").append(File.separator).append("hosts");
        if (HostIpSysFileManager.checkSystemPath(filePath.toString())) {
            return filePath.toString();
        }
        return "";
    }

    private static boolean checkSystemPath(String systemPath) {
        File tempFile = new File(systemPath);
        try {
            if (tempFile.exists() && systemPath.startsWith(tempFile.getCanonicalPath())) {
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"get systemPath error");
        }
        return false;
    }

    public static void deleteIpRecordFromSystemFile(String ip) {
        String filePath = HostIpSysFileManager.getSystemPath();
        if (CommonUtil.isNull(filePath)) {
            return;
        }
        String ipRecord = ip + " " + ip;
        List<String> sysFileContent = HostIpSysFileManager.readSystemFile(filePath);
        if (!sysFileContent.isEmpty()) {
            ArrayList<String> sysFileNoDuplicate = new ArrayList<String>();
            sysFileNoDuplicate.add(sysFileContent.get(0));
            for (String sTmp : sysFileContent) {
                boolean isDuplicate = false;
                for (int k = 0; k < sysFileNoDuplicate.size(); ++k) {
                    if (!sTmp.equals(sysFileNoDuplicate.get(k))) continue;
                    isDuplicate = true;
                    break;
                }
                if (isDuplicate) continue;
                sysFileNoDuplicate.add(sTmp);
            }
            for (int i = 0; i < sysFileNoDuplicate.size(); ++i) {
                if (!((String)sysFileNoDuplicate.get(i)).equals(ipRecord)) continue;
                sysFileNoDuplicate.remove(i);
                break;
            }
            HostIpSysFileManager.rewriteRecordToSysFile(filePath, sysFileNoDuplicate);
        }
    }

    private static void createWinHostFile(String filePath) {
        File newFile = new File(filePath);
        if (!newFile.exists()) {
            try {
                if (!newFile.createNewFile()) {
                    LOGGER.error((Object)"create new file failed!");
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"create new file failed!", (Throwable)e);
            }
        }
    }

    private static void rewriteRecordToSysFile(String filePath, List<String> hostsIp) {
        File sysFile = new File(filePath);
        if (sysFile.exists()) {
            if (!sysFile.delete()) {
                LOGGER.error((Object)"delete sysFile in error");
            }
            try {
                if (!sysFile.createNewFile()) {
                    LOGGER.error((Object)"create new sysFile in error");
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"create new file failed after delete it!", (Throwable)e);
            }
        }
        for (int i = 0; i < hostsIp.size(); ++i) {
            String oneLine = hostsIp.get(i);
            if (i != hostsIp.size() - 1) {
                oneLine = oneLine + "\r\n";
            }
            HostIpSysFileManager.writeIpRecordToSystemFile(filePath, oneLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readSystemFile(String filePath) {
        File file = new File(filePath);
        BufferedReader reader = null;
        ArrayList<String> hostsRecord = new ArrayList<String>();
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                hostsRecord.add(tempString);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"Read system file failed!", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"Read system file failed!", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"Read system file failed!");
        }
        catch (IOException e) {
            LOGGER.error((Object)"Read system file failed!", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Close file reader failed!", (Throwable)e);
                }
            }
        }
        return hostsRecord;
    }

    private static boolean isRecordDuplicate(String filePath, String compairRecord) {
        boolean isDuplicate = false;
        List<String> sysFileContent = HostIpSysFileManager.readSystemFile(filePath);
        for (String sTmp : sysFileContent) {
            if (!sTmp.equals(compairRecord)) continue;
            isDuplicate = true;
            break;
        }
        return isDuplicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeIpRecordToSystemFile(String file, String conent) {
        HostIpSysFileManager.createWinHostFile(file);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "utf-8"));
            out.write(conent);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"write collector IP to system file failed!", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"write collector IP to system file failed!");
        }
        catch (IOException e) {
            LOGGER.error((Object)"write collector IP to system file failed!", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"close BufferedWriter error!", (Throwable)e);
            }
        }
    }
}

