/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import com.hs.atic.collector.entity.LocationDev;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.GetLocationDevService;
import com.hs.atic.rmi.impl.CollectorLocationDevImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public final class IpLocationUitl {
    private static final String IP_LOCATION_SERVICE = "GetLocationDevService";
    private static final long USER_DEFIND_LOCAION_ID_START = 2048L;
    private static final int UNKOWN_LOCATION_START = 1000000;
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static IpLocationUitl instance = new IpLocationUitl();
    private static List<LocationDev> allIpLocationList = new ArrayList<LocationDev>();
    private GetLocationDevService getLocationDevService = null;

    private IpLocationUitl() {
    }

    public static IpLocationUitl getInstance() {
        return instance;
    }

    public long getLocationCustomId(long idFromDev, String devIp) {
        if (idFromDev < 2048L) {
            LOGGER.debug((Object)("getLocationCustomId  start, not need to change, the idFromDev=" + idFromDev));
            return idFromDev;
        }
        if (null == devIp || devIp.isEmpty()) {
            LOGGER.error((Object)"getLocationCustomId  start error, the devIp is empty");
            return idFromDev;
        }
        LOGGER.debug((Object)("getLocationCustomId  start, the idFromDev=" + idFromDev + ", devIp=" + devIp));
        if (null == allIpLocationList || allIpLocationList.isEmpty()) {
            this.getAllIpLocationDev();
        }
        if (CollectorLocationDevImpl.isChange()) {
            this.getAllIpLocationDev();
            CollectorLocationDevImpl.setChange(false);
        }
        long locationId = -1L;
        for (LocationDev location : allIpLocationList) {
            if (!devIp.equals(location.getDeviceIp()) || idFromDev != (long)location.getIdFromDev().intValue()) continue;
            LOGGER.debug((Object)("getLocationCustomId: id=" + location.getLocationId()));
            locationId = location.getLocationId();
        }
        if (-1L == locationId) {
            locationId = idFromDev + 1000000L;
        }
        LOGGER.debug((Object)("getLocationCustomId  end, the locationId=" + locationId));
        return locationId;
    }

    private void getAllIpLocationDev() {
        try {
            if (null == this.getLocationDevService) {
                this.getLocationDevService = (GetLocationDevService)CommonUtil.retreiveAticRmiService(IP_LOCATION_SERVICE);
            }
            if (null != this.getLocationDevService) {
                IpLocationUitl.setAllIpLocationList(this.getLocationDevService.getAllLocationDevs());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"get getAllIpLocationDev  error", (Throwable)e);
            this.getLocationDevService = null;
        }
    }

    public static List<LocationDev> getAllIpLocationList() {
        return allIpLocationList;
    }

    public static void setAllIpLocationList(List<LocationDev> allIpLocationList) {
        IpLocationUitl.allIpLocationList = allIpLocationList;
    }
}

