/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class LogUtil {
    private LogUtil() {
    }

    public static int convertTimeString2y(String time) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            cal.setTime(formate.parse(time));
            return cal.get(1);
        }
        catch (ParseException e) {
            cal.setTime(new Date());
            return cal.get(1);
        }
    }

    public static String convertTime2d(long time) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("dd");
        return formate.format(new Date(time * 1000L));
    }

    public static String convertTime2M(long time) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("MM");
        return formate.format(new Date(time * 1000L));
    }

    public static String convertTime2y(long time) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("yy");
        return formate.format(new Date(time * 1000L));
    }

    public static String convertTime2yMd(long time) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyMMdd");
        return formate.format(new Date(time * 1000L));
    }

    public static String convertTime2yM(long time) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyMM");
        return formate.format(new Date(time * 1000L));
    }

    public static String numberToMinute(Integer min) {
        return min < 10 ? "0" + min : String.valueOf(min);
    }

    public static String formateTime(long time) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formate.format(new Date(time * 1000L));
    }

    public static String formateTime(Long time, Locale lc) {
        return LogUtil.formateTime(time);
    }

    public static long convertTimeString(String time, Locale lc) {
        if (time == null || time.length() == 0) {
            return 0L;
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = formate.parse(time.trim());
            return date.getTime() / 1000L;
        }
        catch (ParseException ex) {
            return 0L;
        }
    }

    public static Date convertTimeString(String time) {
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = formate.parse(time.trim());
            return date;
        }
        catch (ParseException ex) {
            return new Date();
        }
    }

    public static Date convertTimeStringByFormat(String time, String fmt) {
        SimpleDateFormat formate = new SimpleDateFormat(fmt);
        try {
            Date date = formate.parse(time.trim());
            return date;
        }
        catch (ParseException ex) {
            return new Date();
        }
    }

    public static String convertTime2DayString(long time, Locale lc) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
        return formate.format(new Date(time * 1000L));
    }

    public static String convertTime2DayString(long time) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
        return formate.format(new Date(time * 1000L));
    }

    public static String convertTime2DayString(Long time, Locale lc) {
        return LogUtil.convertTime2DayString((long)time, lc);
    }

    public static String convertTime2HhMmSs(long time, Locale lc) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeString = formate.format(new Date(time * 1000L));
        String[] tmp = timeString.split(" ");
        try {
            return tmp[1];
        }
        catch (Exception e) {
            return "";
        }
    }

    public static int getHourFromDate(long time) {
        if (time == 0L) {
            return 0;
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String htimeString = formate.format(new Date(time * 1000L));
        String[] tmp = htimeString.split(" ");
        String[] tempHour = tmp[1].split(":");
        return Integer.parseInt(tempHour[0]);
    }

    public static String convertTime2HhMmSs(Long time, Locale lc) {
        return LogUtil.convertTime2HhMmSs((long)time, lc);
    }

    public static String convertTim2MonthString(long time, Locale lc) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM");
        return formate.format(new Date(time * 1000L));
    }

    public static String convertTim2YearString(long time, Locale lc) {
        String year = LogUtil.convertTim2MonthString(time, lc);
        year = year.substring(0, 4);
        return year;
    }

    public static String convertTim2WeekString(long time, Locale lc) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat monthFormat = new SimpleDateFormat("MM");
        SimpleDateFormat weekFormat = new SimpleDateFormat("ww");
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
        String year = yearFormat.format(time * 1000L);
        String month = monthFormat.format(time * 1000L);
        String week = weekFormat.format(time * 1000L);
        if (month.equals("12") && week.equals("01")) {
            week = "53";
        }
        return year + "-" + week;
    }

    public static String convertTim2QuarterString(long time, Locale lc) {
        String quarter = LogUtil.convertTim2MonthString(time, lc);
        String year = quarter.substring(0, 4);
        String month = quarter.substring(5, 7);
        String quarterNum = "";
        int monthNum = Integer.parseInt(month);
        if (monthNum >= 1 && monthNum <= 3) {
            quarterNum = "1";
        } else if (monthNum >= 4 && monthNum <= 6) {
            quarterNum = "2";
        } else if (monthNum >= 7 && monthNum <= 9) {
            quarterNum = "3";
        } else if (monthNum >= 10 && monthNum <= 12) {
            quarterNum = "4";
        }
        return year + "-" + quarterNum;
    }

    public static String convertTim2MonthString(Long time, Locale lc) {
        return LogUtil.convertTim2MonthString((long)time, lc);
    }

    public static String convertTim2WeekString(Long time, Locale lc) {
        return LogUtil.convertTim2WeekString((long)time, lc);
    }

    public static String convertTim2YearString(Long time, Locale lc) {
        return LogUtil.convertTim2YearString((long)time, lc);
    }

    public static String convertTim2QuarterString(Long time, Locale lc) {
        return LogUtil.convertTim2QuarterString((long)time, lc);
    }

    public static long convertTimeDayString(String time, Locale lc) {
        if (time == null || time.length() == 0) {
            return 0L;
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = formate.parse(time.trim());
            return date.getTime() / 1000L;
        }
        catch (ParseException ex) {
            return 0L;
        }
    }

    public static long customFormatTime(String time, String fmt) {
        if (time == null || time.length() == 0 || fmt == null) {
            return 0L;
        }
        SimpleDateFormat formate = new SimpleDateFormat(fmt);
        try {
            Date date = formate.parse(time.trim());
            return date.getTime() / 1000L;
        }
        catch (ParseException ex) {
            return 0L;
        }
    }

    public static String customFormatTime(long time, String fmt) {
        if (time == 0L || fmt == null) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat(fmt);
        return formate.format(new Date(time * 1000L));
    }

    public static String convertTime2DayHourString(long time, Locale lc) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH");
        return formate.format(new Date(time * 1000L));
    }

    public static String convertTime2DayHourString(Long time, Locale lc) {
        return LogUtil.convertTime2DayHourString((long)time, lc);
    }

    public static String getCleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }
}

