/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import com.hs.atic.collector.biz.event.process.SevenEventAttackKey;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public final class SevenEventPaserUtil {
    private static SevenEventPaserUtil instance = null;
    private static ConcurrentHashMap<SevenEventAttackKey, HashSet<SubAttackTypeAtCpu>> subAttackMap = new ConcurrentHashMap();
    private static final int FILTER_ATTACK_VALUE = 62;
    private static final int FILTER_NG_ATTACK_VALUE = 77;
    private static final int NGE_ATTACK_VALUE = 65;
    private static final int TWO_THOUSAND = 2000;
    private static final int ONE_THOUSAND = 1000;
    private static final int EIGHTY_THOUSAND = 80000;

    private SevenEventPaserUtil() {
    }

    public static SevenEventPaserUtil getInstance() {
        if (null == instance) {
            instance = new SevenEventPaserUtil();
        }
        return instance;
    }

    public boolean needPaserSevenPacket(OriginalExceptionEvent event) {
        int attackType = event.getAttackType().getTypeValue();
        return 62 == attackType || 65 == attackType || 77 == attackType;
    }

    public List<OriginalExceptionEvent> parseSevenPacket(UnsignedDataInputStream stream, OriginalExceptionEvent event, int sevenHeadLogNum, boolean isV5) throws IOException {
        ArrayList<OriginalExceptionEvent> subAttackEventList = new ArrayList<OriginalExceptionEvent>();
        OriginalExceptionEvent subAttackEvent = null;
        int attackType = event.getAttackType().getTypeValue();
        HashSet<SubAttackTypeAtCpu> subAttackTypeAtCpuSet = new HashSet<SubAttackTypeAtCpu>();
        SubAttackTypeAtCpu subAttackAtCpu = null;
        for (int size = 0; size < sevenHeadLogNum; ++size) {
            subAttackEvent = event.getNewCopyEvent();
            int subAttackType = stream.readUnsignedShort();
            stream.readUnsignedByte();
            long dropPks = 0L;
            long dropFlow = 0L;
            if (isV5) {
                stream.readUnsignedByte();
                stream.readUnsignedInt();
                dropPks = stream.readUnsignedLong();
                dropFlow = stream.readUnsignedLong();
                subAttackEvent.setDropKbits(dropFlow);
            } else {
                stream.readUnsignedByte();
                dropPks = stream.readUnsignedInt();
            }
            if (62 == attackType) {
                subAttackType += 2000;
            }
            if (65 == attackType) {
                subAttackType += 1000;
            }
            subAttackEvent.getAttackType().setTypeValue(subAttackType);
            subAttackEvent.setDropPkgs(dropPks);
            subAttackEvent.getIdentifier().setCpu(event.getCpu());
            subAttackEventList.add(subAttackEvent);
            subAttackAtCpu = new SubAttackTypeAtCpu(subAttackType, event.getCpu());
            subAttackTypeAtCpuSet.add(subAttackAtCpu);
        }
        SevenEventAttackKey sevenEventAttackKey = this.processSevenEventAttackKey(event);
        if (subAttackMap.containsKey(sevenEventAttackKey)) {
            subAttackMap.get(sevenEventAttackKey).addAll(subAttackTypeAtCpuSet);
        } else {
            subAttackMap.put(sevenEventAttackKey, subAttackTypeAtCpuSet);
        }
        return subAttackEventList;
    }

    public List<OriginalExceptionEvent> parseSevenPacketV7(UnsignedDataInputStream stream, OriginalExceptionEvent event, int sevenHeadLogNum, boolean isV7) throws IOException {
        ArrayList<OriginalExceptionEvent> subAttackEventList = new ArrayList<OriginalExceptionEvent>();
        OriginalExceptionEvent subAttackEvent = null;
        int attackType = event.getAttackType().getTypeValue();
        HashSet<SubAttackTypeAtCpu> subAttackTypeAtCpuSet = new HashSet<SubAttackTypeAtCpu>();
        SubAttackTypeAtCpu subAttackAtCpu = null;
        for (int size = 0; size < sevenHeadLogNum; ++size) {
            subAttackEvent = event.getNewCopyEvent();
            int subAttackType = stream.readUnsignedShort();
            stream.readUnsignedByte();
            long dropPks = 0L;
            long dropFlow = 0L;
            long dropFlowMax = 0L;
            long dropPksMax = 0L;
            stream.readUnsignedByte();
            stream.readUnsignedInt();
            dropPks = stream.readUnsignedLong();
            dropFlow = stream.readUnsignedLong();
            dropPksMax = stream.readUnsignedLong();
            dropFlowMax = stream.readUnsignedLong();
            subAttackEvent.setDropKbits(dropFlow);
            subAttackEvent.setAttackPeakPpsOrQps(dropPksMax);
            subAttackEvent.setAttackPeakKbps(dropFlowMax);
            if (62 == attackType) {
                subAttackType += 2000;
            }
            if (65 == attackType) {
                subAttackType += 1000;
            }
            if (77 == attackType) {
                subAttackType += 80000;
            }
            subAttackEvent.getAttackType().setTypeValue(subAttackType);
            subAttackEvent.setDropPkgs(dropPks);
            subAttackEvent.getIdentifier().setCpu(event.getCpu());
            subAttackEventList.add(subAttackEvent);
            subAttackAtCpu = new SubAttackTypeAtCpu(subAttackType, event.getCpu());
            subAttackTypeAtCpuSet.add(subAttackAtCpu);
        }
        SevenEventAttackKey sevenEventAttackKey = this.processSevenEventAttackKey(event);
        if (subAttackMap.containsKey(sevenEventAttackKey)) {
            subAttackMap.get(sevenEventAttackKey).addAll(subAttackTypeAtCpuSet);
        } else {
            subAttackMap.put(sevenEventAttackKey, subAttackTypeAtCpuSet);
        }
        return subAttackEventList;
    }

    public List<OriginalExceptionEvent> parseSevenPacketV7New(UnsignedDataInputStream stream, OriginalExceptionEvent event, int sevenHeadLogNum, boolean isV7) throws IOException {
        ArrayList<OriginalExceptionEvent> subAttackEventList = new ArrayList<OriginalExceptionEvent>();
        OriginalExceptionEvent subAttackEvent = null;
        int attackType = event.getAttackType().getTypeValue();
        HashSet<SubAttackTypeAtCpu> subAttackTypeAtCpuSet = new HashSet<SubAttackTypeAtCpu>();
        SubAttackTypeAtCpu subAttackAtCpu = null;
        for (int size = 0; size < sevenHeadLogNum; ++size) {
            subAttackEvent = event.getNewCopyEvent();
            int subAttackType = stream.readUnsignedShort();
            stream.readUnsignedByte();
            long dropPks = 0L;
            long dropFlow = 0L;
            long dropFlowMax = 0L;
            long dropPksMax = 0L;
            stream.readUnsignedByte();
            dropPks = stream.readUnsignedInt();
            dropFlow = stream.readUnsignedInt();
            dropPks *= 64L;
            dropPksMax = stream.readUnsignedInt();
            dropFlowMax = stream.readUnsignedInt();
            subAttackEvent.setDropKbits(dropFlow *= 64L);
            subAttackEvent.setAttackPeakPpsOrQps(dropPksMax);
            subAttackEvent.setAttackPeakKbps(dropFlowMax);
            if (62 == attackType) {
                subAttackType += 2000;
            }
            if (65 == attackType) {
                subAttackType += 1000;
            }
            if (77 == attackType) {
                subAttackType += 80000;
            }
            subAttackEvent.getAttackType().setTypeValue(subAttackType);
            subAttackEvent.setDropPkgs(dropPks);
            subAttackEvent.getIdentifier().setCpu(event.getCpu());
            subAttackEventList.add(subAttackEvent);
            subAttackAtCpu = new SubAttackTypeAtCpu(subAttackType, event.getCpu());
            subAttackTypeAtCpuSet.add(subAttackAtCpu);
        }
        SevenEventAttackKey sevenEventAttackKey = this.processSevenEventAttackKey(event);
        if (subAttackMap.containsKey(sevenEventAttackKey)) {
            subAttackMap.get(sevenEventAttackKey).addAll(subAttackTypeAtCpuSet);
        } else {
            subAttackMap.put(sevenEventAttackKey, subAttackTypeAtCpuSet);
        }
        return subAttackEventList;
    }

    private SevenEventAttackKey processSevenEventAttackKey(OriginalExceptionEvent event) {
        SevenEventAttackKey sevenEventAttackKey = new SevenEventAttackKey();
        EventIdentifier identifer = event.getIdentifierCopy();
        sevenEventAttackKey.setCpu(identifer.getCpu());
        sevenEventAttackKey.setDeviceIp(identifer.getDeviceIp());
        sevenEventAttackKey.setDeviceType(identifer.getDeviceType());
        sevenEventAttackKey.setLogTime(identifer.getLogTime());
        sevenEventAttackKey.setZoneId(identifer.getZoneId());
        sevenEventAttackKey.setBizId(identifer.getBizId());
        sevenEventAttackKey.setZoneIp(identifer.getZoneIp());
        sevenEventAttackKey.setTypeValue(identifer.getType());
        sevenEventAttackKey.setProtocol(identifer.getProtocol());
        sevenEventAttackKey.setPort(identifer.getPort());
        sevenEventAttackKey.setSlotId(identifer.getSlotId());
        sevenEventAttackKey.setIsDefaultBiz(identifer.getIsDefaultBiz());
        sevenEventAttackKey.setVersion(identifer.getVersion());
        sevenEventAttackKey.setDesZone(identifer.isDesZone());
        sevenEventAttackKey.setIpLocation(identifer.isIpLocation());
        sevenEventAttackKey.setIpLocationId(identifer.getIpLocationId());
        sevenEventAttackKey.setAttackValue(event.getAttackType().getTypeValue());
        return sevenEventAttackKey;
    }

    public List<OriginalExceptionEvent> processAbnormalOrEndSubAttackEvent(OriginalExceptionEvent event, int abnormalType) {
        ArrayList<OriginalExceptionEvent> subAttackEventList = new ArrayList<OriginalExceptionEvent>();
        SevenEventAttackKey sevenEventAttackKey = this.processSevenEventAttackKey(event);
        HashSet<Object> subAttackTypeAtCpuSet = new HashSet();
        if (subAttackMap.containsKey(sevenEventAttackKey)) {
            subAttackTypeAtCpuSet = subAttackMap.get(sevenEventAttackKey);
        }
        if (abnormalType == 2) {
            subAttackMap.remove(sevenEventAttackKey);
        }
        if (null != subAttackTypeAtCpuSet && !subAttackTypeAtCpuSet.isEmpty()) {
            OriginalExceptionEvent subAttackEvent = null;
            for (SubAttackTypeAtCpu subAttackTypeAtCpu : subAttackTypeAtCpuSet) {
                subAttackEvent = event.getNewCopyEvent();
                subAttackEvent.getAttackType().setTypeValue(subAttackTypeAtCpu.getSubAttackType());
                subAttackEvent.getIdentifier().setCpu(subAttackTypeAtCpu.getCpu());
                subAttackEventList.add(subAttackEvent);
            }
        }
        return subAttackEventList;
    }

    private class SubAttackTypeAtCpu {
        private int subAttackType;
        private int cpu;

        public SubAttackTypeAtCpu(int attack, int cpu2) {
            this.subAttackType = attack;
            this.cpu = cpu2;
        }

        public int getSubAttackType() {
            return this.subAttackType;
        }

        public int getCpu() {
            return this.cpu;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.cpu;
            result = 31 * result + this.subAttackType;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SubAttackTypeAtCpu other = (SubAttackTypeAtCpu)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.cpu != other.cpu) {
                return false;
            }
            return this.subAttackType == other.subAttackType;
        }

        private SevenEventPaserUtil getOuterType() {
            return SevenEventPaserUtil.this;
        }
    }
}

