/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.DevZoneMapService;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class ZoneUitl {
    private static final String DEV_ZONE_MAP_SERVICE = "DevZoneMapService";
    private static Logger logger = LogManager.getInstance().getReceiveLog();
    private static ZoneUitl instance = new ZoneUitl();
    private static Map<Long, String> allZoneDescMap = new HashMap<Long, String>();
    private DevZoneMapService devZoneMapService = null;

    private ZoneUitl() {
    }

    public static ZoneUitl getInstance() {
        return instance;
    }

    public String getZoneNameById(Long zoneId) {
        if (null == zoneId) {
            return "";
        }
        String zoneName = null;
        if (null == allZoneDescMap || allZoneDescMap.isEmpty() || !allZoneDescMap.containsKey(zoneId)) {
            this.getAllZoneName();
        }
        if (null != allZoneDescMap) {
            zoneName = allZoneDescMap.get(zoneId);
        }
        if (null == zoneName) {
            zoneName = "";
        }
        logger.debug((Object)("getZoneNameById: id=" + zoneId + ", name=" + zoneName));
        return zoneName;
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getAllZoneName() {
        try {
            if (null == this.devZoneMapService) {
                this.devZoneMapService = (DevZoneMapService)CommonUtil.retreiveAticRmiService(DEV_ZONE_MAP_SERVICE);
            }
            if (null != this.devZoneMapService) {
                ZoneUitl.setAllZoneDescMap(this.devZoneMapService.getAllZoneDesc());
                logger.debug((Object)("query allZoneNameMap are : " + ZoneUitl.getcleanedMessage(allZoneDescMap.toString())));
            }
        }
        catch (Exception e) {
            logger.error((Object)"get zone name map error", (Throwable)e);
            this.devZoneMapService = null;
        }
    }

    public static Map<Long, String> getAllZoneDescMap() {
        return allZoneDescMap;
    }

    public static void setAllZoneDescMap(Map<Long, String> allZoneDescMap) {
        ZoneUitl.allZoneDescMap = allZoneDescMap;
    }
}

