/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util.protal;

import com.hs.atic.collector.entity.protal.IpLocationObj;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.protal.LocationMessageEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class IpLocationParseUtil {
    private static final Logger LOG = LogManager.getInstance().getMssLogger();
    private static final String IP_LOCATION_CSV_FILE = "conf" + File.separator + "ipLocationMessage.csv";
    private static final String IP_ID_CSV_FILE = "conf" + File.separator + "ipLocationAddressRange.csv";
    private static List<IpLocationObj> ipLocationList = new ArrayList<IpLocationObj>();
    private static Map<Long, LocationMessageEvent> ipLocMessageMap = new HashMap<Long, LocationMessageEvent>();

    private IpLocationParseUtil() {
    }

    public static List<IpLocationObj> getIpLocationList() {
        return ipLocationList;
    }

    public static Map<Long, LocationMessageEvent> getIpLocMessageMap() {
        return ipLocMessageMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        BufferedReader br = null;
        FileInputStream fiStream = null;
        InputStreamReader inReader = null;
        int i = 0;
        IpLocationObj ipLocation = null;
        LocationMessageEvent locationMessage = null;
        try {
            String[] info;
            String lineContent;
            fiStream = new FileInputStream(IP_LOCATION_CSV_FILE);
            inReader = new InputStreamReader((InputStream)fiStream, "gbk");
            br = new BufferedReader(inReader);
            while ((lineContent = br.readLine()) != null) {
                if (++i < 3) continue;
                info = lineContent.split(",");
                long locationId = Long.parseLong(info[0].replace("\"", "").trim());
                long locationMark = Long.parseLong(info[1].replace("\"", "").trim());
                String chineseName = info[2].replace("\"", "").trim();
                String engishName = info[3].replace("\"", "").trim();
                String shortName = info[4].replace("\"", "").trim();
                String longitude = info[5].replace("\"", "").trim();
                String latitude = info[6].replace("\"", "").trim();
                locationMessage = new LocationMessageEvent(locationId, chineseName, engishName, longitude, latitude);
                locationMessage.setLocationMark(locationMark);
                locationMessage.setShortName(shortName);
                ipLocMessageMap.put(locationId, locationMessage);
            }
            br.close();
            fiStream = new FileInputStream(IP_ID_CSV_FILE);
            inReader = new InputStreamReader((InputStream)fiStream, "gbk");
            br = new BufferedReader(inReader);
            lineContent = "";
            i = 0;
            ipLocation = null;
            while ((lineContent = br.readLine()) != null) {
                if (++i < 3) continue;
                info = lineContent.split(",");
                long startIp = Long.parseLong(info[0].replace("\"", "").trim());
                long endIp = Long.parseLong(info[1].replace("\"", "").trim());
                long locationId = Long.parseLong(info[2].replace("\"", "").trim());
                ipLocation = new IpLocationObj(locationId, startIp, endIp);
                ipLocationList.add(ipLocation);
            }
            ComparatorIpLocation comparator = new ComparatorIpLocation();
            Collections.sort(ipLocationList, comparator);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"file not found");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"br.close() is error IOException", (Throwable)e);
                }
            }
            if (null != inReader) {
                try {
                    inReader.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"inReader.close() is error IOException", (Throwable)e);
                }
            }
            if (null != fiStream) {
                try {
                    fiStream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"fiStream.close() is error IOException", (Throwable)e);
                }
            }
        }
    }

    private static class ComparatorIpLocation
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 8372603580601589953L;

        private ComparatorIpLocation() {
        }

        public int compare(Object arg0, Object arg1) {
            IpLocationObj iplocationOne = (IpLocationObj)arg0;
            IpLocationObj iplocationTwo = (IpLocationObj)arg1;
            if (iplocationOne.getStartIp() > iplocationTwo.getStartIp()) {
                return 1;
            }
            if (iplocationOne.getStartIp() == iplocationTwo.getStartIp()) {
                return 0;
            }
            return -1;
        }
    }
}

