/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util.protal;

import com.hs.atic.collector.entity.protal.IpLocationObj;
import com.hs.atic.collector.util.protal.IpLocationParseUtil;
import com.hs.atic.collector.util.protal.LocationMessageEvent;
import java.util.List;
import java.util.Map;

public final class IpLocationTransUtil {
    public static final int LOCATION_TYPE_CONTRY = 1;
    public static final int LOCATION_TYPE_CITY = 2;
    private static final int SAME = 0;
    private static final int BIGGER = 1;
    private static final int SMALLER = 2;
    private static final int ID_CITY_START = 2;
    private static final int ID_CITY_END = 365;
    private static final long ID_UNKNOWN_ZONE = 0L;
    private static final long ID_CHINA = 1L;
    private static List<IpLocationObj> ipLocationList = IpLocationParseUtil.getIpLocationList();
    private static Map<Long, LocationMessageEvent> ipLocMessageMap = IpLocationParseUtil.getIpLocMessageMap();

    private IpLocationTransUtil() {
    }

    public static LocationMessageEvent getLocationIdByIpAddr(long ip, int type) {
        long id = IpLocationTransUtil.getLocationId(ip, 0, ipLocationList.size() - 1);
        if (-1L == id) {
            return ipLocMessageMap.get(0L);
        }
        if (1 == type && id >= 2L && id <= 365L) {
            id = 1L;
        }
        LocationMessageEvent locMessage = ipLocMessageMap.get(id);
        return locMessage;
    }

    private static long getLocationId(long ip, int startIndex, int endIndex) {
        int rst = -1;
        if (startIndex < 0 || endIndex > ipLocationList.size() - 1) {
            return -1L;
        }
        if (startIndex == endIndex || startIndex + 1 == endIndex) {
            rst = IpLocationTransUtil.checkIpOfLocation(ip, ipLocationList.get(startIndex));
            if (0 == rst) {
                return ipLocationList.get(startIndex).getLocationId();
            }
            rst = IpLocationTransUtil.checkIpOfLocation(ip, ipLocationList.get(endIndex));
            if (0 == rst) {
                return ipLocationList.get(endIndex).getLocationId();
            }
            return -1L;
        }
        int betweenIndex = (startIndex + endIndex) / 2;
        rst = IpLocationTransUtil.checkIpOfLocation(ip, ipLocationList.get(betweenIndex));
        if (0 == rst) {
            return ipLocationList.get(betweenIndex).getLocationId();
        }
        if (1 == rst) {
            return IpLocationTransUtil.getLocationId(ip, betweenIndex, endIndex);
        }
        if (2 == rst) {
            return IpLocationTransUtil.getLocationId(ip, startIndex, betweenIndex);
        }
        return -1L;
    }

    private static int checkIpOfLocation(long ip, IpLocationObj ipLocationObj) {
        long startIp = ipLocationObj.getStartIp();
        long endIp = ipLocationObj.getEndIp();
        int rst = -1;
        rst = ip >= startIp && ip <= endIp ? 0 : (ip >= startIp ? 1 : 2);
        return rst;
    }
}

