/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util.protal;

import com.hs.atic.collector.biz.event.protal.ProtalServiceFactory;
import com.hs.atic.collector.conn.ConnectionRmiThread;
import com.hs.atic.collector.db.monitor.DBSysConf;
import com.hs.atic.collector.entity.protal.ProtalServiceConfInfo;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.GetMssConfRmiService;
import com.hs.lego.core.sdk.base.dataprotect.util.AticDataProtector;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public final class ProtalUtil {
    public static final ProtalUtil INSTATNCE = new ProtalUtil();
    private static final String MSS_SERVICE_NAME = "GetMssConfRmiService";
    private static GetMssConfRmiService listener;
    private Logger logger = LogManager.getInstance().getMssLogger();

    private ProtalUtil() {
    }

    public static ProtalUtil getInstance() {
        return INSTATNCE;
    }

    public ProtalServiceConfInfo getMssConfFromManger() {
        ProtalServiceConfInfo sftpConf = new ProtalServiceConfInfo();
        if (listener == null && ConnectionRmiThread.getInstance().getRmiConnection().booleanValue()) {
            ProtalUtil.setListener((GetMssConfRmiService)CommonUtil.retreiveAticRmiService(MSS_SERVICE_NAME));
        }
        if (null != listener) {
            String sftpPwd;
            try {
                sftpConf = listener.getSftpConf();
            }
            catch (RemoteException e) {
                this.logger.info((Object)"GetMssConfFromManger listener.getSftpConf() error", (Throwable)e);
                return new ProtalServiceConfInfo();
            }
            if (null != sftpConf && (sftpPwd = sftpConf.getSftpPwd()) != null && !sftpPwd.isEmpty()) {
                sftpPwd = AticDataProtector.sdpDecrypt(0L, sftpPwd).toString();
                sftpConf.setSftpPwd(sftpPwd);
                this.logger.info((Object)("getSftpConf ok. " + sftpConf.toString()));
            }
        }
        return sftpConf;
    }

    public boolean updateSftpConf(ProtalServiceConfInfo conf) {
        if (null == conf || CommonUtil.isNull(conf.getSftpServerIp()) || "0".equals(conf.getSftpServerIp())) {
            this.logger.info((Object)"updateSftpConf: input conf is impety");
            return false;
        }
        DBSysConf dbSysConf = new DBSysConf();
        boolean serverIpResult = dbSysConf.update("protal_sftp_server", conf.getSftpServerIp());
        boolean serverPortResult = dbSysConf.update("protal_sftp_port", Integer.toString(conf.getSftpPort()));
        boolean userResult = dbSysConf.update("protal_sftp_username", conf.getSftpUser());
        boolean pwdResult = dbSysConf.update("protal_sftp_pwd", AticDataProtector.sdpEncrypt(0L, new StringBuffer(conf.getSftpPwd())));
        if (serverIpResult && serverPortResult && userResult && pwdResult) {
            ProtalServiceFactory.getInstance();
            ProtalServiceFactory.setServiceInfo(conf);
            if (!ProtalServiceFactory.getInstance().isStartProtalProcess()) {
                ProtalServiceFactory.getInstance().setStartProtalProcess(true);
            }
            return true;
        }
        return false;
    }

    public static GetMssConfRmiService getListener() {
        return listener;
    }

    public static void setListener(GetMssConfRmiService listener) {
        ProtalUtil.listener = listener;
    }
}

