/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi;

import com.hs.atic.collector.biz.report.CommomSqlUtil;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.entity.log.FlowCompareCondition;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.IPUtil;
import com.hs.atic.collector.util.LogManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class FlowCompareQueryType
implements Serializable {
    protected static final Logger LOG = LogManager.getInstance().getFlowLog();
    private static final long serialVersionUID = 2014614172334865924L;

    public abstract String getFlowCompareSQL(FlowCompareCondition var1, Map<Integer, Object> var2);

    protected boolean timeTypeOne(FlowCompareCondition flowCompareCondition) {
        return flowCompareCondition.getTimeSpanType() == 0;
    }

    protected boolean timeTypeTwo(FlowCompareCondition flowCompareCondition) {
        return flowCompareCondition.getTimeSpanType() == 1;
    }

    protected List<Object> appendSqlWhere(FlowCompareCondition flowCompareCondition, StringBuffer sql, String tableName, boolean hasDirect) {
        Integer deviceType;
        ArrayList<Object> list = new ArrayList<Object>();
        if (sql.indexOf("where") == -1) {
            sql.append(" where ");
        } else {
            sql.append(" and ");
        }
        int num = 0;
        sql.append(tableName + ".DEVICE_IP in (");
        for (String deviceIp : flowCompareCondition.getDeviceIpList()) {
            if (0 == num) {
                sql.append(" ? ");
                list.add(deviceIp);
            } else {
                sql.append(", ? ");
                list.add(deviceIp);
            }
            ++num;
        }
        sql.append(')');
        Long zoneId = flowCompareCondition.getZoneId();
        if (0L != zoneId) {
            sql.append(" and " + tableName + ".ZONE_ID = ? ");
            list.add(zoneId);
        } else if (!CollectorConstants.QUERY_TYPE_ONLY_DEVICE.equals(flowCompareCondition.getQueryType()) && null != flowCompareCondition.getSessionId() && !flowCompareCondition.getZoneIdList().isEmpty()) {
            sql.append(" and " + tableName + ".ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            list.add(flowCompareCondition.getSessionId());
        }
        if (-1 != flowCompareCondition.getBizType()) {
            DataStatCondition cds = new DataStatCondition();
            cds.setBisId(flowCompareCondition.getBizId());
            cds.setBisType(CollectorConstants.getBizIdToStr().get(flowCompareCondition.getBizType().toString()));
            cds.setIsServiceGroup(flowCompareCondition.getIsServiceGroup());
            cds.setServiceIds(flowCompareCondition.getServiceIds());
            CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
            List<Object> temlist = commomSqlUtil.processServiceSqlWithType(cds, tableName, sql);
            list.addAll(temlist);
        }
        Long startTime = flowCompareCondition.getStartTime();
        sql.append(" and " + tableName + ".LOG_TIME >= ? ");
        list.add(startTime);
        Long endTime = flowCompareCondition.getEndTime();
        sql.append(" and " + tableName + ".LOG_TIME <= ? ");
        list.add(endTime);
        String zoneIp = flowCompareCondition.getZoneIp();
        if (!CommonUtil.isNull(zoneIp)) {
            if (IPUtil.isIpv6(zoneIp)) {
                zoneIp = IPUtil.convert2CompleteIpV6AllZero(IPUtil.convert2CompleteIpV6(zoneIp));
            }
            sql.append(" and " + tableName + ".ZONE_IP = ? ");
            list.add(zoneIp);
        }
        if (null != (deviceType = flowCompareCondition.getDeviceType())) {
            sql.append(" and " + tableName + ".DEVICE_TYPE = ? ");
            list.add(deviceType);
        }
        int direct = flowCompareCondition.getDirection();
        if (hasDirect && (1 == direct || 2 == direct)) {
            sql.append(" and " + tableName + ".DIRECTION = ? ");
            list.add(direct);
        }
        sql.append(" GROUP BY DEVICE_IP,LOG_TIME ");
        sql.append(" order by LOG_TIME asc");
        return list;
    }

    protected void appendLeftCondition(FlowCompareCondition condition, StringBuffer sql, String firstTableName, String secondTableName) {
        if (0L != condition.getZoneId()) {
            sql.append(" and " + firstTableName + ".ZONE_ID = " + secondTableName + ".ZONE_ID");
        }
        if (null != condition.getZoneIp()) {
            sql.append(" and " + firstTableName + ".ZONE_IP = " + secondTableName + ".ZONE_IP");
            if (0L == condition.getZoneId()) {
                sql.append(" and " + firstTableName + ".ZONE_ID = " + secondTableName + ".ZONE_ID");
            }
        }
        if (-1 != condition.getBizType()) {
            sql.append(" and " + firstTableName + ".BIZ_ID = " + secondTableName + ".BIZ_ID");
        }
    }

    protected boolean isZoneIdTable(FlowCompareCondition condition) {
        return CollectorConstants.QUERY_TYPE_DEVICE_AND_ZONEID.equals(condition.getQueryType()) || CollectorConstants.QUERY_TYPE_DEVICE_AND_ZONEID_AND_BISID.equals(condition.getQueryType());
    }

    protected boolean isBizIdTable(FlowCompareCondition condition) {
        return CollectorConstants.QUERY_TYPE_DEVICE_AND_ZONEID_AND_BISID_AND_ZONEIP.equals(condition.getQueryType()) || CollectorConstants.QUERY_TYPE_DEVICE_AND_ZONEID_AND_BISID.equals(condition.getQueryType());
    }

    protected boolean isZoneIpTable(FlowCompareCondition condition) {
        return CollectorConstants.QUERY_TYPE_DEVICE_AND_ZONEID_AND_ZONEIP.equals(condition.getQueryType()) || CollectorConstants.QUERY_TYPE_DEVICE_AND_ZONEID_AND_BISID_AND_ZONEIP.equals(condition.getQueryType());
    }

    public static FlowCompareQueryType getInstance(FlowCompareCondition condition) {
        FlowCompareQueryType instance = null;
        try {
            instance = (FlowCompareQueryType)Class.forName(CollectorConstants.queryTypeMethodMap().get(condition.getQueryType())).newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)("get query type object occurs error : " + e));
        }
        return instance;
    }
}

