/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.biz.report.ZoneSecurityTableUtil;
import com.hs.atic.collector.db.report.DBStat;
import com.hs.atic.collector.entity.log.AnalyzeSuccessRate;
import com.hs.atic.collector.entity.log.AnalyzeSuccessRateCondition;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.AnalyzeSuccessRateService;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ServerSocketFactory;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AnalyzeSuccessRateServiceImpl
extends UnicastRemoteObject
implements AnalyzeSuccessRateService {
    protected static final Logger LOG = LogManager.getInstance().getReportLogger();
    private static final long serialVersionUID = 3135898101246927705L;
    protected final DBStat dao = new DBStat();

    public AnalyzeSuccessRateServiceImpl() throws RemoteException {
    }

    public AnalyzeSuccessRateServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    private void setIpToFormate(AnalyzeSuccessRateCondition analyzeSuccessRateCondition) {
        List<String> devIpList = analyzeSuccessRateCondition.getDeviceIpList();
        if (null != devIpList && !devIpList.isEmpty() && devIpList.size() < 10000) {
            ArrayList<String> tempDeviceList = new ArrayList<String>();
            for (String tempDeviceIp : devIpList) {
                if (!IpTransformer.checkIpInvaild(tempDeviceIp)) continue;
                String tempIpStr = IpTransformer.formatIpAddress(tempDeviceIp);
                tempDeviceList.add(tempIpStr);
            }
            analyzeSuccessRateCondition.getDeviceIpList().clear();
            analyzeSuccessRateCondition.setDeviceIpList(tempDeviceList);
        }
        if (IpTransformer.checkIpInvaild(analyzeSuccessRateCondition.getZoneIp())) {
            analyzeSuccessRateCondition.setZoneIp(IpTransformer.formatIpAddress(analyzeSuccessRateCondition.getZoneIp()));
        }
    }

    @Override
    public List<AnalyzeSuccessRate> queryAnalyzeSuccessRate(AnalyzeSuccessRateCondition analyzeSuccessRateCondition) throws RemoteException {
        if (null == analyzeSuccessRateCondition) {
            LOG.error((Object)"input analyzeSuccessRateCondition is null.");
            return null;
        }
        LOG.info((Object)"start queryAnalyzeSuccessRate");
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        Long sessionId = analyzeSuccessRateCondition.getSessionId();
        List<Long> zoneIdList = analyzeSuccessRateCondition.getZoneIdList();
        if (null != sessionId && null != zoneIdList && !zoneIdList.isEmpty() && zoneIdList.size() < 10000) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(zoneIdList, sessionId);
        }
        this.setIpToFormate(analyzeSuccessRateCondition);
        HashMap<Integer, Object> condition = new HashMap<Integer, Object>();
        String sql = this.generateAnayzeSuccessRateSql(analyzeSuccessRateCondition, condition);
        LOG.info((Object)("sql for analyzeSuccessRate : " + sql));
        List<AnalyzeSuccessRate> analyzeSuccessRateList = this.dao.getAnalyzeSuccessRate(sql, condition);
        LOG.info((Object)("query analyze success rate list. size = " + analyzeSuccessRateList.size()));
        if (null != sessionId && null != zoneIdList && !zoneIdList.isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(sessionId);
        }
        LOG.info((Object)"end queryAnalyzeSuccessRate");
        return analyzeSuccessRateList;
    }

    private String generateAnayzeSuccessRateSql(AnalyzeSuccessRateCondition analyzeSuccessRateCondition, Map<Integer, Object> condition) {
        StringBuffer sql = new StringBuffer("select LOG_TIME, DEVICE_IP, ");
        sql.append("REQUEST_PPS, SERVER_REPLY_PPS from ");
        if (!CommonUtil.isNull(analyzeSuccessRateCondition.getZoneIp())) {
            sql.append("ATIC_IP_BIZ_UDP_DNS");
        } else {
            sql.append("ATIC_ZONE_BIZ_UDP_DNS");
        }
        this.appendByTimeSpanType(sql, analyzeSuccessRateCondition);
        this.appendWhere(sql, analyzeSuccessRateCondition, condition);
        return sql.toString();
    }

    private void appendByTimeSpanType(StringBuffer sql, AnalyzeSuccessRateCondition analyzeSuccessRateCondition) {
        int timeSpanType = analyzeSuccessRateCondition.getTimeSpanType();
        if (timeSpanType == 1) {
            LOG.info((Object)"time is between 1 and 7 days.");
            sql.append("_H");
        } else if (timeSpanType == 2) {
            LOG.info((Object)"time is more than 7 days.");
            sql.append("_D");
        }
    }

    private void appendWhere(StringBuffer sql, AnalyzeSuccessRateCondition analyzeSuccessRateCondition, Map<Integer, Object> condition) {
        Integer devType;
        String zoneIp;
        Long endTime;
        int index = 1;
        sql.append(" where ");
        List<Object> list = this.appendDeviceIpParams(sql, analyzeSuccessRateCondition);
        for (Object object : list) {
            condition.put(index++, object);
        }
        Long zoneId = analyzeSuccessRateCondition.getZoneId();
        if (null != zoneId && zoneId != 0L) {
            sql.append(" and ZONE_ID = ? ");
            condition.put(index++, zoneId);
        } else {
            Long sessionId = analyzeSuccessRateCondition.getSessionId();
            List<Long> zoneIdList = analyzeSuccessRateCondition.getZoneIdList();
            if (null != sessionId && null != zoneIdList && !zoneIdList.isEmpty()) {
                sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
                condition.put(index++, sessionId);
            }
        }
        Long startTime = analyzeSuccessRateCondition.getStartTime();
        if (null != startTime) {
            sql.append(" and LOG_TIME >= ? ");
            condition.put(index++, startTime);
        }
        if (null != (endTime = analyzeSuccessRateCondition.getEndTime())) {
            sql.append(" and LOG_TIME <= ? ");
            condition.put(index++, endTime);
        }
        if (IpTransformer.checkIpInvaild(zoneIp = analyzeSuccessRateCondition.getZoneIp())) {
            sql.append(" and ZONE_IP = ? ");
            condition.put(index++, zoneIp);
        }
        if (null != (devType = analyzeSuccessRateCondition.getDeviceType())) {
            sql.append(" and DEVICE_TYPE = ? ");
            condition.put(index++, devType);
        }
        sql.append(" order by LOG_TIME asc");
    }

    private List<Object> appendDeviceIpParams(StringBuffer sql, AnalyzeSuccessRateCondition analyzeSuccessRateCondition) {
        ArrayList<Object> list = new ArrayList<Object>();
        int num = 0;
        sql.append("DEVICE_IP in (");
        for (String deviceIp : analyzeSuccessRateCondition.getDeviceIpList()) {
            if (0 == num) {
                sql.append(" ? ");
                list.add(deviceIp);
            } else {
                sql.append(", ? ");
                list.add(deviceIp);
            }
            ++num;
        }
        sql.append(')');
        return list;
    }
}

