/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.biz.event.process.BaselineFlowSumHandler;
import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.db.monitor.DBDevice;
import com.hs.atic.collector.entity.baseline.BaseLineQueryBean;
import com.hs.atic.collector.entity.baseline.BaseLineTask;
import com.hs.atic.collector.entity.baseline.BaselineDetailQueryBean;
import com.hs.atic.collector.entity.baseline.BaselineMetaData;
import com.hs.atic.collector.entity.monitor.DeviceObj;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.BaseLineDataRmiService;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ServerSocketFactory;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BaseLineDataServiceRmiImpl
extends UnicastRemoteObject
implements BaseLineDataRmiService {
    protected static final Logger LOGGER = LogManager.getInstance().getBaseLineLog();
    private static final long serialVersionUID = -346964486242119030L;
    private static final String QUERY_COMMIX_SQL = "SELECT BIZ_ID,DEVICE_TYPE,DEVICE_IP,ZONE_ID, MAX(SYN_PPS) SYN_PPS,MAX(SYNACK_PPS) SYNACK_PPS,MAX(ACK_PPS) ACK_PPS,MAX(FINRST_PPS) FINRST_PPS,MAX(TCPFRAG_PPS) TCPFRAG_PPS,MAX(TCP_INCREASE_CON) TCP_INCREASE_CON,MAX(TCP_CUR_CON) TCP_CUR_CON,MAX(UDP_KBPS)/1000 UDP_KBPS,MAX(UDPFRAG_KBPS)/1000 UDPFRAG_KBPS,MAX(ICMP_PPS) ICMP_PPS,MAX(OTHER_KBPS)/1000 OTHER_KBPS,MAX(DNS_REQUSET_PPS) DNS_REQUSET_PPS,MAX(DNS_REPLY_PPS) DNS_REPLY_PPS,MAX(SIP_INVITE_PPS) SIP_INVITE_PPS ,MAX(HTTP_PPS) HTTP_PPS,MAX(HTTPS_PPS) HTTPS_PPS,MAX(HTTP_GET_PPS) HTTP_GET_PPS,MAX(TCP_SRC_INCREASE_CON) TCP_SRC_INCREASE_CON,MAX(TCP_SRC_CUR_CON) TCP_SRC_CUR_CON,MAX(TCP_RATIO) TCP_RATIO,MAX(TCP_L500_RATIO) TCP_L500_RATIO,MAX(SYN_PKT_NUM) SYN_PKT_NUM FROM ATIC_BASELINE_DATA WHERE PKID = ? AND BIZ_ID = ? AND ZONE_ID = ? AND DEVICE_TYPE = ? AND DEVICE_IP = ? AND DIRECTION = ? ORDER BY PKID,BIZ_ID,DEVICE_TYPE,ZONE_ID,DEVICE_IP  ";
    private static final String QUERY_MAX_LOG_TIME_SQL = "SELECT MAX(LOG_TIME) LOG_TIEM FROM ATIC_BASELINE_DETAIL WHERE PKID = ? AND BIZ_ID = ? AND ZONE_ID = ? AND DEVICE_IP = ? AND DIRECTION = ? AND IS_ALERT=0 ORDER BY PKID,BIZ_ID,ZONE_ID,DEVICE_IP  ";
    private static final String QUERY_BASE_LINE_DATAIL_SQL = "SELECT BIZ_ID,DEVICE_TYPE,DEVICE_IP,ZONE_ID, MAX(SYN_PPS) SYN_PPS,MAX(SYNACK_PPS) SYNACK_PPS,MAX(ACK_PPS) ACK_PPS,MAX(FINRST_PPS) FINRST_PPS,MAX(TCPFRAG_PPS) TCPFRAG_PPS,MAX(TCP_INCREASE_CON) TCP_INCREASE_CON,MAX(TCP_CUR_CON) TCP_CUR_CON,MAX(UDP_KBPS)/1000 UDP_KBPS,MAX(UDPFRAG_KBPS)/1000 UDPFRAG_KBPS,MAX(ICMP_PPS) ICMP_PPS,MAX(OTHER_KBPS)/1000 OTHER_KBPS,MAX(DNS_REQUSET_PPS) DNS_REQUSET_PPS,MAX(DNS_REPLY_PPS) DNS_REPLY_PPS,MAX(SIP_INVITE_PPS) SIP_INVITE_PPS ,MAX(HTTP_PPS) HTTP_PPS,MAX(HTTPS_PPS) HTTPS_PPS,MAX(HTTP_GET_PPS) HTTP_GET_PPS ,MAX(TCP_SRC_INCREASE_CON) TCP_SRC_INCREASE_CON,MAX(TCP_SRC_CUR_CON) TCP_SRC_CUR_CON,MAX(TCP_RATIO) TCP_RATIO,MAX(TCP_L500_RATIO) TCP_L500_RATIO,MAX(SYN_PKT_NUM) SYN_PKT_NUM FROM ATIC_BASELINE_DETAIL WHERE PKID = ? AND BIZ_ID = ? AND ZONE_ID = ? AND DEVICE_TYPE = ? AND DEVICE_IP = ? AND LOG_TIME= ? AND DIRECTION = ? ORDER BY PKID,BIZ_ID,DEVICE_TYPE,ZONE_ID,DEVICE_IP  ";
    private static final String NFA_PROTOCOL_PARAM_SQL = "SELECT DEVICE_IP,DEVICE_TYPE,ZONE_ID,BIZ_ID, MAX(SYN_PPS) SYN_PPS,MAX(SYN_KBPS) SYN_KBPS,MAX(ACK_PPS) ACK_PPS,MAX(ACK_KBPS) ACK_KBPS,MAX(FINRST_PPS) FINRST_PPS,MAX(FINRST_KBPS) FINRST_KBPS,MAX(TCPFRAG_PPS) TCPFRAG_PPS,MAX(TCPFRAG_KBPS) TCPFRAG_KBPS,MAX(TCP_PPS) TCP_PPS,MAX(TCP_KBPS) TCP_KBPS,MAX(UDP_PPS) UDP_PPS,MAX(UDP_KBPS) UDP_KBPS,MAX(UDPFRAG_PPS) UDPFRAG_PPS,MAX(UDPFRAG_KBPS) UDPFRAG_KBPS,MAX(ICMP_PPS) ICMP_PPS,MAX(ICMP_KBPS) ICMP_KBPS,MAX(OTHER_PPS) OTHER_PPS,MAX(OTHER_KBPS) OTHER_KBPS, MAX(HTTP_PPS) HTTP_PPS,MAX(HTTP_KBPS) HTTP_KBPS,MAX(HTTPS_PPS) HTTPS_PPS,MAX(HTTPS_KBPS) HTTPS_KBPS,MAX(DNS_REQUSET_PPS) DNS_REQUSET_PPS,MAX(DNS_REQUSET_KBPS) DNS_REQUSET_KBPS,MAX(DNS_REPLY_PPS) DNS_REPLY_PPS,MAX(DNS_REPLY_KBPS) DNS_REPLY_KBPS,MAX(SIP_INVITE_PPS) SIP_INVITE_PPS,MAX(SIP_INVITE_KBPS) SIP_INVITE_KBPS,MAX(TOTAL_PPS) TOTAL_PPS,MAX(TOTAL_KBPS) TOTAL_KBPS ";
    private static final String QUERY_NFA_MAIN_DATA_SQL = "SELECT DEVICE_IP,DEVICE_TYPE,ZONE_ID,BIZ_ID, MAX(SYN_PPS) SYN_PPS,MAX(SYN_KBPS) SYN_KBPS,MAX(ACK_PPS) ACK_PPS,MAX(ACK_KBPS) ACK_KBPS,MAX(FINRST_PPS) FINRST_PPS,MAX(FINRST_KBPS) FINRST_KBPS,MAX(TCPFRAG_PPS) TCPFRAG_PPS,MAX(TCPFRAG_KBPS) TCPFRAG_KBPS,MAX(TCP_PPS) TCP_PPS,MAX(TCP_KBPS) TCP_KBPS,MAX(UDP_PPS) UDP_PPS,MAX(UDP_KBPS) UDP_KBPS,MAX(UDPFRAG_PPS) UDPFRAG_PPS,MAX(UDPFRAG_KBPS) UDPFRAG_KBPS,MAX(ICMP_PPS) ICMP_PPS,MAX(ICMP_KBPS) ICMP_KBPS,MAX(OTHER_PPS) OTHER_PPS,MAX(OTHER_KBPS) OTHER_KBPS, MAX(HTTP_PPS) HTTP_PPS,MAX(HTTP_KBPS) HTTP_KBPS,MAX(HTTPS_PPS) HTTPS_PPS,MAX(HTTPS_KBPS) HTTPS_KBPS,MAX(DNS_REQUSET_PPS) DNS_REQUSET_PPS,MAX(DNS_REQUSET_KBPS) DNS_REQUSET_KBPS,MAX(DNS_REPLY_PPS) DNS_REPLY_PPS,MAX(DNS_REPLY_KBPS) DNS_REPLY_KBPS,MAX(SIP_INVITE_PPS) SIP_INVITE_PPS,MAX(SIP_INVITE_KBPS) SIP_INVITE_KBPS,MAX(TOTAL_PPS) TOTAL_PPS,MAX(TOTAL_KBPS) TOTAL_KBPS  FROM ATIC_BASELINE_NFA_DATA WHERE PKID = ? AND BIZ_ID = ? AND ZONE_ID = ? AND DEVICE_TYPE = ? AND DEVICE_IP = ? AND DIRECTION = ? ORDER BY PKID,BIZ_ID,DEVICE_TYPE,ZONE_ID,DEVICE_IP ";
    private static final String QUERY_NFA_LAST_DETAIL_SQL = "SELECT DEVICE_IP,DEVICE_TYPE,ZONE_ID,BIZ_ID, MAX(SYN_PPS) SYN_PPS,MAX(SYN_KBPS) SYN_KBPS,MAX(ACK_PPS) ACK_PPS,MAX(ACK_KBPS) ACK_KBPS,MAX(FINRST_PPS) FINRST_PPS,MAX(FINRST_KBPS) FINRST_KBPS,MAX(TCPFRAG_PPS) TCPFRAG_PPS,MAX(TCPFRAG_KBPS) TCPFRAG_KBPS,MAX(TCP_PPS) TCP_PPS,MAX(TCP_KBPS) TCP_KBPS,MAX(UDP_PPS) UDP_PPS,MAX(UDP_KBPS) UDP_KBPS,MAX(UDPFRAG_PPS) UDPFRAG_PPS,MAX(UDPFRAG_KBPS) UDPFRAG_KBPS,MAX(ICMP_PPS) ICMP_PPS,MAX(ICMP_KBPS) ICMP_KBPS,MAX(OTHER_PPS) OTHER_PPS,MAX(OTHER_KBPS) OTHER_KBPS, MAX(HTTP_PPS) HTTP_PPS,MAX(HTTP_KBPS) HTTP_KBPS,MAX(HTTPS_PPS) HTTPS_PPS,MAX(HTTPS_KBPS) HTTPS_KBPS,MAX(DNS_REQUSET_PPS) DNS_REQUSET_PPS,MAX(DNS_REQUSET_KBPS) DNS_REQUSET_KBPS,MAX(DNS_REPLY_PPS) DNS_REPLY_PPS,MAX(DNS_REPLY_KBPS) DNS_REPLY_KBPS,MAX(SIP_INVITE_PPS) SIP_INVITE_PPS,MAX(SIP_INVITE_KBPS) SIP_INVITE_KBPS,MAX(TOTAL_PPS) TOTAL_PPS,MAX(TOTAL_KBPS) TOTAL_KBPS  FROM ATIC_BASELINE_NFA_DETAIL WHERE PKID = ? AND BIZ_ID = ? AND ZONE_ID = ? AND DEVICE_TYPE = ? AND DEVICE_IP = ? AND LOG_TIME= ? AND DIRECTION = ? ORDER BY PKID,BIZ_ID,DEVICE_TYPE,ZONE_ID,DEVICE_IP ";
    private static final String QUERY_NFA_MAX_LOG_TIME_SQL = "SELECT MAX(LOG_TIME) LOG_TIEM FROM ATIC_BASELINE_NFA_DETAIL WHERE PKID = ? AND BIZ_ID = ? AND ZONE_ID = ? AND DEVICE_IP = ? AND DIRECTION = ? AND IS_ALERT=0 ORDER BY PKID,BIZ_ID,ZONE_ID,DEVICE_IP  ";
    private static final Map<String, String> DEFAULT_MAPV1 = new HashMap<String, String>();
    private static final Map<String, String> DEFAULT_MAPV3 = new HashMap<String, String>();
    private static final Map<String, String> TCP_MAPV3 = new HashMap<String, String>();
    private static final Map<String, String> UDP_MAPV3 = new HashMap<String, String>();
    private static final Map<String, String> HTTP_MAPV3 = new HashMap<String, String>();
    private static final Map<String, String> HTTPS_MAPV3 = new HashMap<String, String>();
    private static final Map<String, String> UDP_DNS_MAPV3 = new HashMap<String, String>();
    private static final Map<String, String> TCP_DNS_MAPV3 = new HashMap<String, String>();
    private static final Map<String, String> SIP_MAPV3 = new HashMap<String, String>();
    private static final Map<String, String> OTHER_MAPV3 = new HashMap<String, String>();
    private static final Map<String, String> DESTINATION_ZONE_MAP = new HashMap<String, String>();
    private static final Map<String, String> NFA_MAP_V1 = new HashMap<String, String>();

    public BaseLineDataServiceRmiImpl() throws RemoteException {
    }

    public BaseLineDataServiceRmiImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    @Override
    public Map<Long, Long> getBaselieDetail(BaselineDetailQueryBean detailQueryBean) throws RemoteException {
        if (null == detailQueryBean) {
            LOGGER.error((Object)"input param is null.");
            return new HashMap<Long, Long>();
        }
        String devIp = detailQueryBean.getDeviceIp();
        if (!IpTransformer.checkIpInvaild(devIp)) {
            LOGGER.error((Object)"deviceIp is not invalid.");
            return new HashMap<Long, Long>();
        }
        if (this.isNfaDevice(IpTransformer.formatIpAddress(devIp))) {
            return this.queryNfaBaselineDetail(detailQueryBean);
        }
        return this.queryDDoSBaselineDetail(detailQueryBean);
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Long> queryDDoSBaselineDetail(BaselineDetailQueryBean detailQueryBean) {
        LOGGER.info((Object)("The detailQueryBean is " + this.getcleanedMessage(detailQueryBean.toString()) + "in getBaselieDetail"));
        Connection con = DBConnPool.getConnection();
        PreparedStatement query = null;
        ResultSet result = null;
        String device = IpTransformer.formatIpAddress(detailQueryBean.getDeviceIp());
        long zoneId = detailQueryBean.getZoneId();
        long studyId = detailQueryBean.getStudyId();
        long bizIds = detailQueryBean.getBiz();
        int devType = detailQueryBean.getDevType();
        String filedName = detailQueryBean.getFieldName();
        String column = detailQueryBean.isIsDestinationZone() ? DESTINATION_ZONE_MAP.get(filedName) : this.getMap(detailQueryBean.getVersion(), detailQueryBean.getServiceType()).get(filedName);
        String startTime = detailQueryBean.getStartTime();
        long startTimeLong = 0L;
        try {
            startTimeLong = Long.parseLong(startTime);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"getBaselieDetail get startTimeLong NumberFormatException error");
        }
        startTimeLong -= startTimeLong % 3600L;
        String endTime = detailQueryBean.getEndTime();
        String tableSuffix = detailQueryBean.getTableSuffix();
        String tableName = "ATIC_BASELINE_DETAIL";
        HashMap<Integer, Object> condition = new HashMap<Integer, Object>();
        int index = 1;
        Object sql = new StringBuffer();
        ((StringBuffer)sql).append("select LOG_TIME, ");
        if ("UDP_KBPS".equals(column) || "UDPFRAG_KBPS".equals(column) || "OTHER_KBPS".equals(column)) {
            ((StringBuffer)sql).append("MAX(" + column + ")/1000 " + column);
        } else {
            ((StringBuffer)sql).append("MAX(" + column + ") " + column);
        }
        ((StringBuffer)sql).append(" from " + tableName + " where ZONE_ID= ? AND DEVICE_IP = ? ");
        condition.put(index++, zoneId);
        condition.put(index++, device);
        ((StringBuffer)sql).append(" AND PKID = ? ");
        ((StringBuffer)sql).append(" AND BIZ_ID = ? ");
        condition.put(index++, studyId);
        condition.put(index++, bizIds);
        ((StringBuffer)sql).append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, devType);
        ((StringBuffer)sql).append(" AND LOG_TIME >= ? ");
        ((StringBuffer)sql).append(" AND LOG_TIME <= ? ");
        condition.put(index++, startTimeLong);
        condition.put(index++, endTime);
        if ("D".equals(tableSuffix)) {
            String querySql = ((StringBuffer)sql).toString().substring(((StringBuffer)sql).toString().indexOf("LOG_TIME") + "LOG_TIME".length() + 1);
            Object sbSqlQueryDay = new StringBuffer();
            sbSqlQueryDay = ((StringBuffer)sbSqlQueryDay).append("select LOG_TIME,");
            if ("UDP_KBPS".equals(column) || "UDPFRAG_KBPS".equals(column) || "OTHER_KBPS".equals(column)) {
                ((StringBuffer)sbSqlQueryDay).append("MAX(" + column + ")/1000 " + column + " ");
                querySql = querySql.replace(")/1000", ")");
            } else {
                ((StringBuffer)sbSqlQueryDay).append("MAX(" + column + ") " + column + " ");
            }
            String string = querySql.substring(querySql.indexOf("from"));
            sql = sbSqlQueryDay = ((StringBuffer)sbSqlQueryDay).append(string).append(" and " + column + " in ").append("(select " + querySql).append(" GROUP BY (SELECT FROM_UNIXTIME(LOG_TIME,'%Y%m%d'))) GROUP BY (SELECT FROM_UNIXTIME(LOG_TIME,'%Y%m%d'))");
            condition.put(index++, zoneId);
            condition.put(index++, device);
            condition.put(index++, studyId);
            condition.put(index++, bizIds);
            condition.put(index++, devType);
            condition.put(index++, startTimeLong);
            condition.put(index++, endTime);
        } else {
            ((StringBuffer)sql).append(" GROUP BY log_time ");
        }
        LOGGER.info((Object)("getBaselieDetail:" + this.getcleanedMessage(((StringBuffer)sql).toString())));
        HashMap<Long, Long> data = new HashMap<Long, Long>();
        try {
            LOGGER.debug((Object)this.getcleanedMessage(((StringBuffer)sql).toString()));
            query = con.prepareStatement(((StringBuffer)sql).toString());
            for (Map.Entry entry : condition.entrySet()) {
                query.setObject((Integer)entry.getKey(), entry.getValue());
            }
            result = query.executeQuery();
            while (result.next()) {
                Long time = result.getLong("LOG_TIME") * 1000L;
                Long l = result.getLong(column);
                data.put(time, l);
            }
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"getBaselieDetail  error", (Throwable)e);
            }
            catch (Throwable throwable) {
                BaseLineDataServiceRmiImpl.freeDbResource(con, query, result);
                throw throwable;
            }
            BaseLineDataServiceRmiImpl.freeDbResource(con, query, result);
        }
        BaseLineDataServiceRmiImpl.freeDbResource(con, query, result);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Long> queryNfaBaselineDetail(BaselineDetailQueryBean detailQueryBean) {
        LOGGER.info((Object)("Start to  queryNfaBaselineDetail of " + this.getcleanedMessage(detailQueryBean.toString())));
        Connection con = DBConnPool.getConnection();
        PreparedStatement query = null;
        ResultSet result = null;
        HashMap<Integer, Object> condition = new HashMap<Integer, Object>();
        int index = 1;
        String device = IpTransformer.formatIpAddress(detailQueryBean.getDeviceIp());
        long zoneId = detailQueryBean.getZoneId();
        long bizIds = detailQueryBean.getBiz();
        int devType = detailQueryBean.getDevType();
        long studyId = detailQueryBean.getStudyId();
        String filedName = detailQueryBean.getFieldName();
        String column = NFA_MAP_V1.get(filedName);
        String startTime = detailQueryBean.getStartTime();
        long startTimeLong = 0L;
        try {
            startTimeLong = Long.parseLong(startTime);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"getBaselieDetail get startTimeLong NumberFormatException error");
        }
        startTimeLong -= startTimeLong % 3600L;
        String endTime = detailQueryBean.getEndTime();
        String tableSuffix = detailQueryBean.getTableSuffix();
        StringBuffer sql = new StringBuffer();
        sql.append("select LOG_TIME, ");
        sql.append("MAX(" + column + ") " + column);
        sql.append(" from ATIC_BASELINE_NFA_DETAIL where ZONE_ID= ? ");
        condition.put(index++, zoneId);
        sql.append(" AND PKID = ? ");
        condition.put(index++, studyId);
        sql.append(" AND DEVICE_IP = ? ");
        condition.put(index++, device);
        sql.append(" AND BIZ_ID = ? ");
        condition.put(index++, bizIds);
        sql.append(" AND DEVICE_TYPE = ? ");
        condition.put(index++, devType);
        sql.append(" AND LOG_TIME >= ? ");
        condition.put(index++, startTimeLong);
        sql.append(" AND LOG_TIME <= ? ");
        condition.put(index++, endTime);
        if ("D".equals(tableSuffix)) {
            String querySql = sql.toString().substring(sql.toString().indexOf("LOG_TIME") + "LOG_TIME".length() + 1);
            StringBuffer sbSqlQueryDay = new StringBuffer();
            sbSqlQueryDay = sbSqlQueryDay.append("select LOG_TIME,");
            sbSqlQueryDay.append("MAX(" + column + ") " + column + " ");
            String querySqlFromAndWhere = querySql.substring(querySql.indexOf("from"));
            sql = sbSqlQueryDay = sbSqlQueryDay.append(querySqlFromAndWhere).append(" and " + column + " in ").append("(select " + querySql).append(" GROUP BY (SELECT FROM_UNIXTIME(LOG_TIME,'%Y%m%d'))) GROUP BY (SELECT FROM_UNIXTIME(LOG_TIME,'%Y%m%d'))");
            condition.put(index++, zoneId);
            condition.put(index++, studyId);
            condition.put(index++, device);
            condition.put(index++, bizIds);
            condition.put(index++, devType);
            condition.put(index++, startTimeLong);
            condition.put(index++, endTime);
        } else {
            sql.append(" GROUP BY log_time ");
        }
        LOGGER.info((Object)("queryNfaBaselineDetail:" + this.getcleanedMessage(sql.toString())));
        StringBuffer temSql = new StringBuffer(sql);
        temSql.append("");
        HashMap<Long, Long> data = new HashMap<Long, Long>();
        try {
            query = con.prepareStatement(temSql.toString());
            for (Map.Entry entry : condition.entrySet()) {
                query.setObject((Integer)entry.getKey(), entry.getValue());
            }
            result = query.executeQuery();
            while (result.next()) {
                Long time = result.getLong("LOG_TIME") * 1000L;
                Long l = result.getLong(column);
                data.put(time, l);
            }
            BaseLineDataServiceRmiImpl.freeDbResource(con, query, result);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"queryNfaBaselineDetail  error", (Throwable)e);
        }
        finally {
            BaseLineDataServiceRmiImpl.freeDbResource(con, query, result);
        }
        return data;
    }

    @Override
    public List<BaselineMetaData> getBaselieMataData(BaseLineQueryBean queryBean) throws RemoteException {
        if (null == queryBean) {
            LOGGER.error((Object)"input param is null.");
            return new ArrayList<BaselineMetaData>();
        }
        LOGGER.info((Object)("queryBean=" + queryBean.toString()));
        String devIp = queryBean.getRealDevIp();
        if (!IpTransformer.checkIpInvaild(devIp)) {
            LOGGER.error((Object)"deviceIp is not invalid.");
            return new ArrayList<BaselineMetaData>();
        }
        if (this.isNfaDevice(IpTransformer.formatIpAddress(devIp))) {
            return this.queryNfaMainData(queryBean);
        }
        return this.queryDDoSMainData(queryBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaselineMetaData> queryDDoSMainData(BaseLineQueryBean queryBean) {
        ArrayList<BaselineMetaData> result = new ArrayList<BaselineMetaData>();
        Connection con = DBConnPool.getConnection();
        PreparedStatement query = null;
        ResultSet rs = null;
        Map<String, String> rateMap = queryBean.isIsDestinationZone() ? DESTINATION_ZONE_MAP : this.getMap(queryBean.getVersion(), queryBean.getServiceType());
        try {
            query = con.prepareStatement(QUERY_COMMIX_SQL);
            query.setLong(1, queryBean.getStudyId());
            query.setLong(2, queryBean.getRealBiz());
            query.setLong(3, queryBean.getRealZoneId());
            query.setLong(4, queryBean.getRealDevType());
            query.setString(5, IpTransformer.formatIpAddress(queryBean.getRealDevIp()));
            query.setInt(6, queryBean.getDirection());
            if (null != rateMap) {
                StringBuilder sbKey = new StringBuilder();
                StringBuilder sbValue = new StringBuilder();
                for (Map.Entry<String, String> enry : rateMap.entrySet()) {
                    sbKey = sbKey.append(enry.getKey() + ",");
                    sbValue = sbValue.append(enry.getValue() + ",");
                }
                LOGGER.info((Object)("rateMap key is " + this.getcleanedMessage(sbKey.toString())));
                LOGGER.info((Object)("rateMap value is " + this.getcleanedMessage(sbValue.toString())));
            }
            LOGGER.info((Object)"query.");
            rs = query.executeQuery();
            if (null != rateMap) {
                while (rs.next()) {
                    List<BaselineMetaData> data = this.initMetaDataMap(rs, rateMap, queryBean);
                    result.addAll(data);
                }
            }
            BaseLineDataServiceRmiImpl.freeDbResource(null, query, rs);
            if (result.isEmpty()) {
                query = con.prepareStatement(QUERY_MAX_LOG_TIME_SQL);
                query.setLong(1, queryBean.getStudyId());
                query.setLong(2, queryBean.getRealBiz());
                query.setLong(3, queryBean.getRealZoneId());
                query.setString(4, IpTransformer.formatIpAddress(queryBean.getRealDevIp()));
                query.setInt(5, queryBean.getDirection());
                LOGGER.info((Object)"query.");
                rs = query.executeQuery();
                int logtime = 0;
                if (rs.next()) {
                    logtime = rs.getInt(1);
                    BaseLineDataServiceRmiImpl.freeDbResource(null, query, rs);
                    query = con.prepareStatement(QUERY_BASE_LINE_DATAIL_SQL);
                    query.setLong(1, queryBean.getStudyId());
                    query.setLong(2, queryBean.getRealBiz());
                    query.setLong(3, queryBean.getRealZoneId());
                    query.setLong(4, queryBean.getRealDevType());
                    query.setString(5, IpTransformer.formatIpAddress(queryBean.getRealDevIp()));
                    query.setInt(6, logtime);
                    query.setInt(7, queryBean.getDirection());
                    LOGGER.info((Object)"query.");
                    rs = query.executeQuery();
                    if (null != rateMap) {
                        while (rs.next()) {
                            List<BaselineMetaData> data = this.initMetaDataMap(rs, rateMap, queryBean);
                            result.addAll(data);
                        }
                    }
                }
            }
            BaseLineDataServiceRmiImpl.freeDbResource(con, query, rs);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"queryCommixDate error!", (Throwable)e);
        }
        finally {
            BaseLineDataServiceRmiImpl.freeDbResource(con, query, rs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BaselineMetaData> queryNfaMainData(BaseLineQueryBean queryBean) {
        ArrayList<BaselineMetaData> result = new ArrayList<BaselineMetaData>();
        Connection con = DBConnPool.getConnection();
        PreparedStatement query = null;
        Map<String, String> rateMap = NFA_MAP_V1;
        ResultSet rs = null;
        try {
            query = con.prepareStatement(QUERY_NFA_MAIN_DATA_SQL);
            query.setLong(1, queryBean.getStudyId());
            query.setLong(2, queryBean.getRealBiz());
            query.setLong(3, queryBean.getRealZoneId());
            query.setLong(4, queryBean.getRealDevType());
            query.setString(5, IpTransformer.formatIpAddress(queryBean.getDeviceIp()));
            query.setInt(6, queryBean.getDirection());
            rs = query.executeQuery();
            while (rs.next()) {
                List<BaselineMetaData> data = this.initMetaDataMap(rs, rateMap, queryBean);
                result.addAll(data);
            }
            LOGGER.info((Object)("query NFA main data. result.size=" + result.size()));
            BaseLineDataServiceRmiImpl.freeDbResource(null, query, rs);
            if (result.isEmpty()) {
                query = con.prepareStatement(QUERY_NFA_MAX_LOG_TIME_SQL);
                query.setLong(1, queryBean.getStudyId());
                query.setLong(2, queryBean.getRealBiz());
                query.setLong(3, queryBean.getRealZoneId());
                query.setString(4, IpTransformer.formatIpAddress(queryBean.getDeviceIp()));
                query.setInt(5, queryBean.getDirection());
                LOGGER.info((Object)"query nfa max log time. ");
                rs = query.executeQuery();
                int logtime = 0;
                if (rs.next()) {
                    logtime = rs.getInt(1);
                    BaseLineDataServiceRmiImpl.freeDbResource(null, query, rs);
                    query = con.prepareStatement(QUERY_NFA_LAST_DETAIL_SQL);
                    query.setLong(1, queryBean.getStudyId());
                    query.setLong(2, queryBean.getRealBiz());
                    query.setLong(3, queryBean.getRealZoneId());
                    query.setLong(4, queryBean.getRealDevType());
                    query.setString(5, IpTransformer.formatIpAddress(queryBean.getDeviceIp()));
                    query.setInt(6, logtime);
                    query.setInt(7, queryBean.getDirection());
                    LOGGER.info((Object)"query nfa last detail data.");
                    rs = query.executeQuery();
                    while (rs.next()) {
                        List<BaselineMetaData> data = this.initMetaDataMap(rs, rateMap, queryBean);
                        result.addAll(data);
                    }
                    LOGGER.info((Object)("query NFA main data end. result.size=" + result.size()));
                }
            }
            BaseLineDataServiceRmiImpl.freeDbResource(con, query, rs);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"queryCommixDate error!", (Throwable)e);
        }
        finally {
            BaseLineDataServiceRmiImpl.freeDbResource(con, query, rs);
        }
        return result;
    }

    private Map<String, String> getMap(int version, String serviceType) {
        if (version == 3 || version == 4) {
            if ("TCP".equals(serviceType)) {
                return TCP_MAPV3;
            }
            if ("TCP_DNS".equals(serviceType)) {
                return TCP_DNS_MAPV3;
            }
            if ("UDP".equals(serviceType)) {
                return UDP_MAPV3;
            }
            if ("HTTP".equals(serviceType)) {
                return HTTP_MAPV3;
            }
            if ("HTTPS".equals(serviceType)) {
                return HTTPS_MAPV3;
            }
            if ("UDP_DNS".equals(serviceType)) {
                return UDP_DNS_MAPV3;
            }
            if ("SIP".equals(serviceType)) {
                return SIP_MAPV3;
            }
            if ("Other".equals(serviceType)) {
                return OTHER_MAPV3;
            }
            return DEFAULT_MAPV3;
        }
        return DEFAULT_MAPV1;
    }

    protected List<BaselineMetaData> initMetaDataMap(ResultSet result, Map<String, String> initMap, BaseLineQueryBean queryBean) throws SQLException {
        ArrayList<BaselineMetaData> list = new ArrayList<BaselineMetaData>();
        long bizId = result.getLong("BIZ_ID");
        int devType = result.getInt("DEVICE_TYPE");
        long zoneId = result.getLong("ZONE_ID");
        for (Map.Entry<String, String> entry : initMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            long limit = result.getLong(value);
            if (limit <= 0L) continue;
            BaselineMetaData metaData = new BaselineMetaData();
            metaData.setDeviceIp(queryBean.getDeviceIp());
            metaData.setServiceId(queryBean.getBiz());
            metaData.setServiceType(queryBean.getServiceType());
            metaData.setZoneId(queryBean.getZoneId());
            metaData.setDirection(queryBean.getDirection());
            metaData.setKey(key);
            metaData.setValue(limit);
            metaData.setRealBizId(bizId);
            metaData.setRealDevType(devType);
            metaData.setReadDevIp(queryBean.getRealDevIp());
            metaData.setRealZoneId(zoneId);
            list.add(metaData);
        }
        return list;
    }

    protected static void freeDbResource(Connection con, Statement stmt, ResultSet result) {
        if (null != result) {
            try {
                result.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"result.close() is error");
            }
        }
        try {
            if (null != stmt) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close statement error");
        }
        try {
            if (null != con) {
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close connection error");
        }
    }

    protected static void freeDbResource(Connection con, Statement stmt) {
        try {
            if (null != stmt) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close statement error");
        }
        try {
            if (null != con) {
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close connection error");
        }
    }

    @Override
    public boolean modifyBaseLineTask(BaseLineTask task) {
        if (null == task) {
            LOGGER.error((Object)"input param is null");
            return false;
        }
        return BaselineFlowSumHandler.getInstance().modifyBaseLineTask(task);
    }

    private boolean isNfaDevice(String devIp) {
        DBDevice devDb = new DBDevice();
        DeviceObj devObj = devDb.query(devIp);
        return null != devObj && 5 == devObj.getDeviceType();
    }

    static {
        DEFAULT_MAPV1.put("synfloodAlertRate", "SYN_PPS");
        DEFAULT_MAPV1.put("synAckFloodAlertRate", "SYNACK_PPS");
        DEFAULT_MAPV1.put("ackFloodAlertRate", "ACK_PPS");
        DEFAULT_MAPV1.put("finRstFloodAlertRate", "FINRST_PPS");
        DEFAULT_MAPV1.put("tcpFragAlertRate", "TCPFRAG_PPS");
        DEFAULT_MAPV1.put("tcpNewDestipRate", "TCP_INCREASE_CON");
        DEFAULT_MAPV1.put("tcpDesttipNum", "TCP_CUR_CON");
        DEFAULT_MAPV1.put("tcpNewSrctipRate", "TCP_SRC_INCREASE_CON");
        DEFAULT_MAPV1.put("tcpSrctipNum", "TCP_SRC_CUR_CON");
        DEFAULT_MAPV1.put("synratioLimitRate", "TCP_RATIO");
        DEFAULT_MAPV1.put("bigPacketRatio", "TCP_L500_RATIO");
        DEFAULT_MAPV1.put("synratioLimitPackets", "SYN_PKT_NUM");
        DEFAULT_MAPV1.put("alertSpeed", "UDP_KBPS");
        DEFAULT_MAPV1.put("fragAlertSpeed", "UDPFRAG_KBPS");
        DEFAULT_MAPV1.put("alertRate", "DNS_REQUSET_PPS");
        DEFAULT_MAPV1.put("replyFloodAlertRate", "DNS_REPLY_PPS");
        DEFAULT_MAPV1.put("sipAlertRate", "SIP_INVITE_PPS");
        DEFAULT_MAPV1.put("httpsAlertRate", "HTTPS_PPS");
        DEFAULT_MAPV1.put("icmpMaxSpeed", "ICMP_PPS");
        DEFAULT_MAPV3.put("synfloodAlertRate", "SYN_PPS");
        DEFAULT_MAPV3.put("synAckFloodAlertRate", "SYNACK_PPS");
        DEFAULT_MAPV3.put("ackFloodAlertRate", "ACK_PPS");
        DEFAULT_MAPV3.put("finRstFloodAlertRate", "FINRST_PPS");
        DEFAULT_MAPV3.put("tcpNewDestipRate", "TCP_INCREASE_CON");
        DEFAULT_MAPV3.put("tcpDesttipNum", "TCP_CUR_CON");
        DEFAULT_MAPV3.put("tcpNewSrctipRate", "TCP_SRC_INCREASE_CON");
        DEFAULT_MAPV3.put("tcpSrctipNum", "TCP_SRC_CUR_CON");
        DEFAULT_MAPV3.put("synratioLimitRate", "TCP_RATIO");
        DEFAULT_MAPV3.put("bigPacketRatio", "TCP_L500_RATIO");
        DEFAULT_MAPV3.put("synratioLimitPackets", "SYN_PKT_NUM");
        DEFAULT_MAPV3.put("udpMaxSpeed", "UDP_KBPS");
        DEFAULT_MAPV3.put("tcpFragAlertRate", "TCPFRAG_PPS");
        DEFAULT_MAPV3.put("udpFragMaxSpeed", "UDPFRAG_KBPS");
        DEFAULT_MAPV3.put("alertRate", "DNS_REQUSET_PPS");
        DEFAULT_MAPV3.put("replyFloodAlertRate", "DNS_REPLY_PPS");
        DEFAULT_MAPV3.put("sipAlertRate", "SIP_INVITE_PPS");
        DEFAULT_MAPV3.put("httpsAlertRate", "HTTPS_PPS");
        DEFAULT_MAPV3.put("fingerAlert", "OTHER_KBPS");
        DEFAULT_MAPV3.put("httpDestQpsAlertRate", "HTTP_GET_PPS");
        DEFAULT_MAPV3.put("icmpMaxSpeed", "ICMP_PPS");
        TCP_MAPV3.put("synfloodAlertRate", "SYN_PPS");
        TCP_MAPV3.put("ackFloodAlertRate", "ACK_PPS");
        TCP_MAPV3.put("finRstFloodAlertRate", "FINRST_PPS");
        TCP_MAPV3.put("tcpNewDestipRate", "TCP_INCREASE_CON");
        TCP_MAPV3.put("tcpDesttipNum", "TCP_CUR_CON");
        TCP_MAPV3.put("tcpNewSrctipRate", "TCP_SRC_INCREASE_CON");
        TCP_MAPV3.put("tcpSrctipNum", "TCP_SRC_CUR_CON");
        TCP_MAPV3.put("synratioLimitRate", "TCP_RATIO");
        TCP_MAPV3.put("bigPacketRatio", "TCP_L500_RATIO");
        TCP_MAPV3.put("synratioLimitPackets", "SYN_PKT_NUM");
        TCP_DNS_MAPV3.put("synfloodAlertRate", "SYN_PPS");
        TCP_DNS_MAPV3.put("synAckFloodAlertRate", "SYNACK_PPS");
        TCP_DNS_MAPV3.put("ackFloodAlertRate", "ACK_PPS");
        TCP_DNS_MAPV3.put("finRstFloodAlertRate", "FINRST_PPS");
        TCP_DNS_MAPV3.put("tcpNewDestipRate", "TCP_INCREASE_CON");
        TCP_DNS_MAPV3.put("tcpDesttipNum", "TCP_CUR_CON");
        TCP_DNS_MAPV3.put("tcpNewSrctipRate", "TCP_SRC_INCREASE_CON");
        TCP_DNS_MAPV3.put("tcpSrctipNum", "TCP_SRC_CUR_CON");
        TCP_DNS_MAPV3.put("synratioLimitRate", "TCP_RATIO");
        TCP_DNS_MAPV3.put("bigPacketRatio", "TCP_L500_RATIO");
        TCP_DNS_MAPV3.put("synratioLimitPackets", "SYN_PKT_NUM");
        UDP_MAPV3.put("udpFloodAlertSpeed", "UDP_KBPS");
        HTTP_MAPV3.put("synfloodAlertRate", "SYN_PPS");
        HTTP_MAPV3.put("synAckFloodAlertRate", "SYNACK_PPS");
        HTTP_MAPV3.put("ackFloodAlertRate", "ACK_PPS");
        HTTP_MAPV3.put("finRstFloodAlertRate", "FINRST_PPS");
        HTTP_MAPV3.put("tcpNewDestipRate", "TCP_INCREASE_CON");
        HTTP_MAPV3.put("tcpDesttipNum", "TCP_CUR_CON");
        HTTP_MAPV3.put("tcpNewSrctipRate", "TCP_SRC_INCREASE_CON");
        HTTP_MAPV3.put("tcpSrctipNum", "TCP_SRC_CUR_CON");
        HTTP_MAPV3.put("synratioLimitRate", "TCP_RATIO");
        HTTP_MAPV3.put("bigPacketRatio", "TCP_L500_RATIO");
        HTTP_MAPV3.put("synratioLimitPackets", "SYN_PKT_NUM");
        HTTP_MAPV3.put("httpDestQpsAlertRate", "HTTP_GET_PPS");
        HTTPS_MAPV3.put("httpsAlertRate", "HTTPS_PPS");
        HTTPS_MAPV3.put("synfloodAlertRate", "SYN_PPS");
        HTTPS_MAPV3.put("synAckFloodAlertRate", "SYNACK_PPS");
        HTTPS_MAPV3.put("ackFloodAlertRate", "ACK_PPS");
        HTTPS_MAPV3.put("finRstFloodAlertRate", "FINRST_PPS");
        HTTPS_MAPV3.put("tcpNewDestipRate", "TCP_INCREASE_CON");
        HTTPS_MAPV3.put("tcpDesttipNum", "TCP_CUR_CON");
        HTTPS_MAPV3.put("tcpNewSrctipRate", "TCP_SRC_INCREASE_CON");
        HTTPS_MAPV3.put("tcpSrctipNum", "TCP_SRC_CUR_CON");
        HTTPS_MAPV3.put("synratioLimitRate", "TCP_RATIO");
        HTTPS_MAPV3.put("bigPacketRatio", "TCP_L500_RATIO");
        HTTPS_MAPV3.put("synratioLimitPackets", "SYN_PKT_NUM");
        UDP_DNS_MAPV3.put("dnsRequsetAlertRate", "DNS_REQUSET_PPS");
        UDP_DNS_MAPV3.put("dnsReplyFloodAlertRate", "DNS_REPLY_PPS");
        SIP_MAPV3.put("sipAlertRate", "SIP_INVITE_PPS");
        OTHER_MAPV3.put("otherFingerAlert", "OTHER_KBPS");
        DESTINATION_ZONE_MAP.put("synfloodDestzoneAlertRate", "SYN_PPS");
        DESTINATION_ZONE_MAP.put("ackFloodDestzoneAlertRate", "ACK_PPS");
        DESTINATION_ZONE_MAP.put("dnsRequsetAlertRateDestzone", "DNS_REQUSET_PPS");
        DESTINATION_ZONE_MAP.put("dnsReplyFloodDestzoneAlertRate", "DNS_REPLY_PPS");
        NFA_MAP_V1.put("tcpSynFloodPpsThreshold", "SYN_PPS");
        NFA_MAP_V1.put("tcpSynFloodBpsThreshold", "SYN_KBPS");
        NFA_MAP_V1.put("tcpFragmentFloodPpsThreshold", "TCPFRAG_PPS");
        NFA_MAP_V1.put("tcpFragmentFloodBpsThreshold", "TCPFRAG_KBPS");
        NFA_MAP_V1.put("tcpAckFloodPpsThreshold", "ACK_PPS");
        NFA_MAP_V1.put("tcpAckFloodBpsThreshold", "ACK_KBPS");
        NFA_MAP_V1.put("tcpRstFinFloodPpsThreshold", "FINRST_PPS");
        NFA_MAP_V1.put("tcpRstFinFloodBpsThreshold", "FINRST_KBPS");
        NFA_MAP_V1.put("udpFloodPpsThreshold", "UDP_PPS");
        NFA_MAP_V1.put("udpFloodBpsThreshold", "UDP_KBPS");
        NFA_MAP_V1.put("udpFragmentFloodPpsThreshold", "UDPFRAG_PPS");
        NFA_MAP_V1.put("udpFragmentFloodBpsThreshold", "UDPFRAG_KBPS");
        NFA_MAP_V1.put("dnsQueryFloodPpsThreshold", "DNS_REQUSET_PPS");
        NFA_MAP_V1.put("dnsQueryFloodBpsThreshold", "DNS_REQUSET_KBPS");
        NFA_MAP_V1.put("dnsReplyFloodPpsThreshold", "DNS_REPLY_PPS");
        NFA_MAP_V1.put("dnsReplyFloodBpsThreshold", "DNS_REPLY_KBPS");
        NFA_MAP_V1.put("httpFloodPpsThreshold", "HTTP_PPS");
        NFA_MAP_V1.put("httpFloodBpsThreshold", "HTTP_KBPS");
        NFA_MAP_V1.put("httpsFloodPpsThreshold", "HTTPS_PPS");
        NFA_MAP_V1.put("httpsFloodBpsThreshold", "HTTPS_KBPS");
        NFA_MAP_V1.put("sipFloodPpsThreshold", "SIP_INVITE_PPS");
        NFA_MAP_V1.put("sipFloodBpsThreshold", "SIP_INVITE_KBPS");
        NFA_MAP_V1.put("icmpFloodPpsThreshold", "ICMP_PPS");
        NFA_MAP_V1.put("icmpFloodBpsThreshold", "ICMP_KBPS");
        NFA_MAP_V1.put("otherFloodPpsThreshold", "OTHER_PPS");
        NFA_MAP_V1.put("otherFloodBpsThreshold", "OTHER_KBPS");
        NFA_MAP_V1.put("hostTotalPpsThreshold", "TOTAL_PPS");
        NFA_MAP_V1.put("hostTotalBpsThreshold", "TOTAL_KBPS");
    }
}

