/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.biz.pcap.PcapBuilder;
import com.hs.atic.collector.biz.pcap.PcapIdentifier;
import com.hs.atic.collector.db.Repository;
import com.hs.atic.collector.db.RepositoryFactory;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.condition.ConditionSeparator;
import com.hs.atic.collector.db.condition.ConditionSeparatorFactory;
import com.hs.atic.collector.db.condition.PcapConditionField;
import com.hs.atic.collector.entity.pcap.CaptureTask;
import com.hs.atic.collector.entity.pcap.GlobalCaptureTask;
import com.hs.atic.collector.entity.pcap.PcapFileInfo;
import com.hs.atic.collector.entity.pcap.PcapTask;
import com.hs.atic.collector.entity.pcap.ZoneCaptureTask;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.ParamCheckUtil;
import com.hs.atic.rmi.CapturePcapService;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ServerSocketFactory;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CapturePcapServiceImpl
extends UnicastRemoteObject
implements CapturePcapService {
    private static final long serialVersionUID = -554134910775757305L;
    private static final Logger LOGGER = LogManager.getInstance().getPcapLogger();

    public CapturePcapServiceImpl() throws RemoteException {
    }

    public CapturePcapServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    @Override
    public void addPcapTask(PcapTask pcapTask) throws RemoteException {
        if (null == pcapTask) {
            LOGGER.error((Object)"input pcapTask is null.");
            return;
        }
        String devIp = pcapTask.getDeviceIp();
        String fileName = pcapTask.getFileName();
        if (null == devIp || !IpTransformer.checkIpInvaild(devIp) || !ParamCheckUtil.isValidStringNotNull(fileName, 256, "^[\\w|\u4e00-\u9fa5|\\!|\\@|\\#|\\$|\\^|\\+|\\-|\\_|\\=|\\}|\\{|\\]|\\[|\\;|\\.|\\*|\\:|\\,|\\/| |%]*$")) {
            LOGGER.error((Object)"devIp or fileName is not invalid.");
            return;
        }
        PcapIdentifier pcapIdentifer = new PcapIdentifier(pcapTask.getPcapType(), IpTransformer.formatIpAddress(devIp), pcapTask.getZoneId());
        pcapIdentifer.setDeviceType(pcapTask.getDeviceType());
        try {
            CaptureTask task = pcapIdentifer.isZoneType() ? new ZoneCaptureTask(pcapIdentifer, fileName, pcapTask.getPcapId()) : new GlobalCaptureTask(pcapIdentifer, fileName, pcapTask.getPcapId());
            task.setRequiredCaptureNum(pcapTask.getCaptureNum());
            LOGGER.info((Object)("The Capture Task  is " + task.getTaskId()));
            if (PcapBuilder.getInstance().addCaptureTask(task)) {
                LOGGER.info((Object)"add task seccess");
            } else {
                LOGGER.info((Object)"add task fail,the task has been added");
            }
        }
        catch (IOException e) {
            LOGGER.info((Object)"The Capture Task  create error ", (Throwable)e);
        }
    }

    @Override
    public void cancelPcapTask(long pcapId) throws RemoteException {
        LOGGER.info((Object)("The Capture Task  was cancel: " + pcapId));
        pcapId = pcapId << 1 | 1L;
        PcapBuilder.getInstance().removeCaptureTask(pcapId);
    }

    @Override
    public void deletePcapFiles(List<String> fileNameList) throws RemoteException {
        if (!ParamCheckUtil.isValidStringListNotNull(fileNameList, 10000, 256, "^[\\w|\u4e00-\u9fa5|\\!|\\@|\\#|\\$|\\^|\\+|\\-|\\_|\\=|\\}|\\{|\\]|\\[|\\;|\\.|\\*|\\:|\\,|\\/| |%]*$")) {
            LOGGER.error((Object)"input param is error.");
            return;
        }
        PcapConditionField field = new PcapConditionField("fileName");
        LOGGER.info((Object)"Delete PcapFile .");
        ConditionSeparator separator = ConditionSeparatorFactory.getInstance().equal();
        for (String fileName : fileNameList) {
            ConditionClause clause = new ConditionClause();
            clause.setField(field);
            clause.setSeparator(separator);
            clause.setValue(fileName);
            clause.addValueList(clause.getValue());
            Repository repository = RepositoryFactory.getInstance().getRepository(PcapFileInfo.class.getName());
            if (null == repository) continue;
            List fileList = repository.queryObject(clause);
            for (PcapFileInfo file : fileList) {
                file.delete();
            }
            repository.deleteObject(clause);
        }
    }

    @Override
    public boolean queryPcapFiles(List<String> fileNameList) {
        if (!ParamCheckUtil.isValidStringListNotNull(fileNameList, 10000, 256, "^[\\w|\u4e00-\u9fa5|\\!|\\@|\\#|\\$|\\^|\\+|\\-|\\_|\\=|\\}|\\{|\\]|\\[|\\;|\\.|\\*|\\:|\\,|\\/| |%]*$")) {
            LOGGER.error((Object)"input param is error.");
            return false;
        }
        ArrayList pcapFileList = new ArrayList();
        PcapConditionField field = new PcapConditionField("fileName");
        ConditionSeparator separator = ConditionSeparatorFactory.getInstance().equal();
        if (null != fileNameList && !fileNameList.isEmpty()) {
            for (String fileName : fileNameList) {
                List fileList;
                ConditionClause clause = new ConditionClause();
                clause.setField(field);
                clause.setSeparator(separator);
                clause.setValue(fileName);
                clause.addValueList(clause.getValue());
                Repository repository = RepositoryFactory.getInstance().getRepository(PcapFileInfo.class.getName());
                if (null == repository || null == (fileList = repository.queryObject(clause)) || fileList.isEmpty()) continue;
                pcapFileList.addAll(fileList);
            }
        }
        return pcapFileList.isEmpty();
    }

    @Override
    public void deletePcapFilesByTaskId(String taskId) throws RemoteException {
        String regex = "^[0-9]+$";
        if (!ParamCheckUtil.isValidString(taskId, 64, regex)) {
            LOGGER.error((Object)"input param is error");
            return;
        }
        long pcapId = Long.parseLong(taskId);
        LOGGER.info((Object)("The Capture Task  was delete: " + pcapId));
        PcapBuilder.getInstance().removeCaptureTask(pcapId <<= 1);
    }

    @Override
    public List<String> queryPcapFilesByTime(long startTime) throws RemoteException {
        ArrayList<String> pcapFileNameList = new ArrayList<String>();
        PcapConditionField field = new PcapConditionField("start_time");
        ConditionSeparator separator = ConditionSeparatorFactory.getInstance().notBiggerThan();
        ConditionClause clause = new ConditionClause();
        clause.setField(field);
        clause.setSeparator(separator);
        clause.setValue(startTime);
        clause.addValueList(clause.getValue());
        Repository repository = RepositoryFactory.getInstance().getRepository(PcapFileInfo.class.getName());
        if (null != repository) {
            List pcapFileList = repository.queryObject(clause);
            for (PcapFileInfo fileInfo : pcapFileList) {
                pcapFileNameList.add(fileInfo.getFileName());
            }
        }
        return pcapFileNameList;
    }
}

