/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.biz.event.process.DashboardEventHandler;
import com.hs.atic.collector.biz.event.process.SecondFLowHandler;
import com.hs.atic.collector.biz.report.AppFlowDisUtil;
import com.hs.atic.collector.biz.report.AttackCountTrendUtil;
import com.hs.atic.collector.biz.report.AttackDistributeUtil;
import com.hs.atic.collector.biz.report.AttackLogUtil;
import com.hs.atic.collector.biz.report.AttackTrendUtil;
import com.hs.atic.collector.biz.report.ConnCompareUtil;
import com.hs.atic.collector.biz.report.DnsDefendUtil;
import com.hs.atic.collector.biz.report.DropTrendUtil;
import com.hs.atic.collector.biz.report.FlowDisUtil;
import com.hs.atic.collector.biz.report.RequestTrendUtil;
import com.hs.atic.collector.biz.report.SlotFlowUtil;
import com.hs.atic.collector.biz.report.TopNUtil;
import com.hs.atic.collector.biz.report.ZoneSecurityTableUtil;
import com.hs.atic.collector.db.monitor.DBSysConf;
import com.hs.atic.collector.db.report.DBStat;
import com.hs.atic.collector.entity.alarm.IpFlowInfo;
import com.hs.atic.collector.entity.alarm.IpInfoKey;
import com.hs.atic.collector.entity.homepage.DashboardQueryBean;
import com.hs.atic.collector.entity.homepage.FlowTopNObj;
import com.hs.atic.collector.entity.log.AppFlow;
import com.hs.atic.collector.entity.log.AttackCountCompare;
import com.hs.atic.collector.entity.log.AttackCountTrend;
import com.hs.atic.collector.entity.log.AttackExactFlow;
import com.hs.atic.collector.entity.log.AttackExactLog;
import com.hs.atic.collector.entity.log.AttackFlowPeakTopN;
import com.hs.atic.collector.entity.log.AttackIpCountTrend;
import com.hs.atic.collector.entity.log.AttackLog;
import com.hs.atic.collector.entity.log.AttackTopn;
import com.hs.atic.collector.entity.log.AttackTrend;
import com.hs.atic.collector.entity.log.AttackTypeDistributing;
import com.hs.atic.collector.entity.log.BisAttackCountTopN;
import com.hs.atic.collector.entity.log.BisAttackTimeTopN;
import com.hs.atic.collector.entity.log.BisTopN;
import com.hs.atic.collector.entity.log.BizTypePoJo;
import com.hs.atic.collector.entity.log.ConnCompare;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.entity.log.DeviceStopTime;
import com.hs.atic.collector.entity.log.DeviceStopTimeQueryForm;
import com.hs.atic.collector.entity.log.DnsCache;
import com.hs.atic.collector.entity.log.DnsDefendLog;
import com.hs.atic.collector.entity.log.DnsDefendTopN;
import com.hs.atic.collector.entity.log.DnsGraph;
import com.hs.atic.collector.entity.log.DnsTopN;
import com.hs.atic.collector.entity.log.DropTrend;
import com.hs.atic.collector.entity.log.DropTrendUnique;
import com.hs.atic.collector.entity.log.FlowDistributing;
import com.hs.atic.collector.entity.log.IpAttackCountTopN;
import com.hs.atic.collector.entity.log.IpAttackTimeTopN;
import com.hs.atic.collector.entity.log.IpLocationTopN;
import com.hs.atic.collector.entity.log.IpTopN;
import com.hs.atic.collector.entity.log.RequestTrend;
import com.hs.atic.collector.entity.log.RmiTuple;
import com.hs.atic.collector.entity.log.SlotFlow;
import com.hs.atic.collector.entity.log.TimeDurationForm;
import com.hs.atic.collector.entity.log.ZoneAttackCountTopN;
import com.hs.atic.collector.entity.log.ZoneAttackTimeTopN;
import com.hs.atic.collector.entity.log.ZoneTopN;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.ParamCheckUtil;
import com.hs.atic.collector.util.TimeTransformer;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.DataStatService;
import com.hs.atic.rmi.ServerSocketFactory;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DataStatServiceImpl
extends UnicastRemoteObject
implements DataStatService {
    public static final int TOPN_VALUE = 100;
    protected static final Logger LOG = LogManager.getInstance().getReportLogger();
    private static final long serialVersionUID = 1446206959019499562L;
    protected final DBStat dao = new DBStat();
    private DBSysConf sysConfigDao = new DBSysConf();
    private final SecureRandom intRandom = new SecureRandom();
    private Map<Integer, Object> condition;

    public DataStatServiceImpl() throws RemoteException {
    }

    public DataStatServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    @Override
    public RmiTuple<List<AttackLog>, Integer> getAttackLog(DataStatCondition cds, String sortField, String sortType) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackLog");
        AttackLogUtil util = new AttackLogUtil();
        CommonUtil.setIpToFormate(cds);
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getAttackLogSql(cds, sortField, sortType, this.condition);
        LOG.info((Object)("AttackLog: " + sql));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        List<AttackLog> aks = this.dao.findAttackLog(sql, this.condition);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        if (aks.isEmpty()) {
            return null;
        }
        Integer total = aks.size();
        if (total == null || total == 0) {
            return null;
        }
        LOG.info((Object)"end getAttackLog");
        return new RmiTuple<List<AttackLog>, Integer>(aks, total);
    }

    @Override
    public Map<String, List<ConnCompare>> getConnCompare(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getConnCompare");
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        HashMap<String, List<ConnCompare>> allConnCompareMap = new HashMap<String, List<ConnCompare>>();
        if (cds.getDeviceId() > 0L) {
            CommonUtil.setIpToFormate(cds);
            List<ConnCompare> allConnCompare = null;
            allConnCompare = this.processQueryConnCompareDate(cds);
            if (!allConnCompare.isEmpty()) {
                allConnCompareMap.put(cds.getDeviceIp(), allConnCompare);
            }
        } else {
            for (String deviceIp : cds.getDeviceIpList()) {
                cds.setDeviceIp(deviceIp);
                CommonUtil.setIpToFormate(cds);
                List<ConnCompare> allConnCompare = null;
                allConnCompare = this.processQueryConnCompareDate(cds);
                if (allConnCompare.isEmpty()) continue;
                allConnCompareMap.put(cds.getDeviceIp(), allConnCompare);
            }
        }
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getConnCompare");
        return allConnCompareMap;
    }

    private List<ConnCompare> processQueryConnCompareDate(DataStatCondition cds) {
        ArrayList<ConnCompare> allConnCompare = new ArrayList<ConnCompare>();
        if (0 == cds.getAttackType()) {
            if (null != cds.getIsServiceGroup() && cds.getIsServiceGroup().booleanValue()) {
                if (null != cds.getServiceIds() && !cds.getServiceIds().isEmpty()) {
                    for (Map.Entry<String, List<Long>> serviceIdList : cds.getServiceIds().entrySet()) {
                        cds.setBisType(serviceIdList.getKey());
                        List<ConnCompare> connCompareList = this.getConnCompareByDeviceIp(cds);
                        if (null == connCompareList || connCompareList.isEmpty()) continue;
                        allConnCompare.addAll(connCompareList);
                    }
                }
            } else {
                List<ConnCompare> connCompareList = this.getConnCompareByDeviceIp(cds);
                if (null != connCompareList && !connCompareList.isEmpty()) {
                    allConnCompare.addAll(connCompareList);
                }
            }
        } else {
            List<ConnCompare> connCompareList = this.getSrcTcpConnData(cds);
            if (null != connCompareList && !connCompareList.isEmpty()) {
                allConnCompare.addAll(connCompareList);
            }
        }
        return allConnCompare;
    }

    private List<ConnCompare> getSrcTcpConnData(DataStatCondition cds) {
        LOG.info((Object)"start getSrcTcpConnData");
        String deviceIp = cds.getDeviceIp();
        if (null == deviceIp) {
            return null;
        }
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        ConnCompareUtil util = new ConnCompareUtil();
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getSrcTcpConnSql(cds, this.condition);
        LOG.info((Object)("getSrcTcpConnData sql: " + sql));
        List<ConnCompare> ccs = null;
        ccs = this.dao.findSrcTcpConn(sql, this.condition);
        return ccs;
    }

    private List<ConnCompare> getConnCompareByDeviceIp(DataStatCondition cds) {
        LOG.info((Object)"start getConnCompareByDeviceIp");
        String deviceIp = cds.getDeviceIp();
        if (null == deviceIp) {
            return null;
        }
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        Long zoneId = cds.getZoneId();
        String zoneIp = cds.getZoneIp();
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        String querySql = "";
        String tablePrefixName = "";
        String tablePostfixName = "";
        StringBuffer tableName = new StringBuffer();
        ConnCompareUtil util = new ConnCompareUtil();
        tablePostfixName = util.getTablePostfixName(start, end);
        this.condition = new HashMap<Integer, Object>();
        tablePrefixName = !CommonUtil.isNull(zoneIp) ? "ATIC_IP_FLOW_SUM_MAX" : (null != zoneId && zoneId > 0L ? "ATIC_ZONE_FLOW_SUM_MAX" : "ATIC_DEV_FLOW_SUM_MAX");
        tableName.append(tablePrefixName).append(tablePostfixName);
        querySql = util.getNoBizQuerySql(cds, tableName.toString(), this.condition);
        LOG.info((Object)("ConnCompare sql: " + querySql));
        LOG.info((Object)("ConnCompare condition: " + this.condition));
        List<ConnCompare> ccs = null;
        ccs = this.dao.findConnCompare(querySql, this.condition);
        LOG.info((Object)"end getConnCompareByDeviceIp");
        return ccs;
    }

    @Override
    public Map<String, List<AttackTypeDistributing>> getAttackCountsDis(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackCountsDis");
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        AttackDistributeUtil util = new AttackDistributeUtil();
        Map<String, List<AttackTypeDistributing>> attackCountMap = null;
        attackCountMap = util.getAttackCountDis(cds);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getAttackCountsDis");
        return attackCountMap;
    }

    @Override
    public List<AttackTypeDistributing> getAttackDurationAndTrafficPeakCountsDis(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackCountsDis");
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        AttackDistributeUtil util = new AttackDistributeUtil();
        List<AttackTypeDistributing> attackCountMap = null;
        attackCountMap = util.getAttackDurationAndTrafficPeakCountDis(cds);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getAttackCountsDis");
        return attackCountMap;
    }

    @Override
    public List<AttackTypeDistributing> getAttackVectorCountsDis(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackCountsDis");
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        AttackDistributeUtil util = new AttackDistributeUtil();
        List<AttackTypeDistributing> attackCountMap = null;
        attackCountMap = util.getAttackVectorCountDis(cds);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getAttackCountsDis");
        return attackCountMap;
    }

    @Override
    public Map<String, List<AttackTypeDistributing>> getAttackPacketsDis(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackPacketsDis");
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        AttackDistributeUtil util = new AttackDistributeUtil();
        List<TimeDurationForm> durationFormList = util.processTimeByType(cds.getStartTime(), cds.getEndTime());
        Map<String, List<AttackTypeDistributing>> attackPacketMap = null;
        attackPacketMap = this.getSingleDeviceAttackPacket(durationFormList, cds);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getAttackPacketsDis");
        return attackPacketMap;
    }

    public Map<String, List<AttackTypeDistributing>> getSingleDeviceAttackPacket(List<TimeDurationForm> durationFormList, DataStatCondition cds) {
        LOG.info((Object)"start getSingleDeviceAttackPacket");
        HashMap<String, List<AttackTypeDistributing>> allList = new HashMap<String, List<AttackTypeDistributing>>();
        AttackDistributeUtil util = new AttackDistributeUtil();
        if (null != durationFormList) {
            for (TimeDurationForm timeForm : durationFormList) {
                cds.setStartTime(timeForm.getStartTime());
                cds.setEndTime(timeForm.getEndTime());
                Map<String, List<AttackTypeDistributing>> attackList = util.getAttackPacketDis(cds, timeForm.getTimeType());
                if (attackList.isEmpty()) continue;
                for (Map.Entry<String, List<AttackTypeDistributing>> entry : attackList.entrySet()) {
                    if (allList.containsKey(entry.getKey())) {
                        ((List)allList.get(entry.getKey())).addAll((Collection)entry.getValue());
                        continue;
                    }
                    allList.put(entry.getKey(), entry.getValue());
                }
            }
        }
        LOG.info((Object)"end getSingleDeviceAttackPacket");
        return allList;
    }

    @Override
    public List<FlowDistributing> getFlowDis(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getFlowDis");
        FlowDisUtil util = new FlowDisUtil();
        Boolean isQueryDevice = util.isQueryDevice(cds);
        Boolean isNeedZoneSecrurity = false;
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (!isQueryDevice.booleanValue() && null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            isNeedZoneSecrurity = true;
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        ArrayList<FlowDistributing> allFlowDisList = new ArrayList();
        if (cds.getDeviceId() > 0L) {
            CommonUtil.setIpToFormate(cds);
            allFlowDisList = this.queryFlowDis(cds);
        } else if (-1L == cds.getDeviceId()) {
            for (String deviceIp : cds.getDeviceIpList()) {
                cds.setDeviceIp(deviceIp);
                CommonUtil.setIpToFormate(cds);
                List<FlowDistributing> flowDisList = this.queryFlowDis(cds);
                if (null == flowDisList || flowDisList.isEmpty()) continue;
                allFlowDisList.addAll(flowDisList);
            }
        }
        if (isNeedZoneSecrurity.booleanValue()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getFlowDis");
        return allFlowDisList;
    }

    private List<FlowDistributing> queryFlowDis(DataStatCondition cds) {
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        if (null == cds.getDeviceIp()) {
            return null;
        }
        FlowDisUtil util = new FlowDisUtil();
        String tableName = this.getTableName(cds, util);
        this.condition = new HashMap<Integer, Object>();
        String inSql = util.getQuerySql(cds, tableName, this.condition);
        LOG.info((Object)("FlowDistributing flow sql: " + inSql));
        return this.dao.getFlowDisMax(inSql, this.condition);
    }

    private String getTableName(DataStatCondition cds, FlowDisUtil util) {
        String tableName = "";
        Integer isClean = cds.getIsClean();
        tableName = null == cds.getZoneId() && null == cds.getZoneIp() ? "ATIC_DEV_FLOW_SUM" : (null == cds.getZoneIp() ? "ATIC_ZONE_FLOW_SUM" : "ATIC_IP_FLOW_SUM");
        tableName = isClean == 1 ? tableName + "_MAX" : tableName + "_FORWARD_MAX";
        Long startTime = cds.getStartTime();
        Long endTime = cds.getEndTime();
        String tablePostfix = util.getTableType(startTime, endTime);
        tableName = tableName + tablePostfix;
        return tableName;
    }

    @Override
    public Map<String, List<FlowDistributing>> getAllDetectFlowDis(DataStatCondition cds) throws RemoteException {
        LOG.info((Object)"start getAllDetectFlowDis");
        FlowDisUtil util = new FlowDisUtil();
        Boolean isQueryDevice = util.isQueryDevice(cds);
        Boolean isNeedZoneSecrurity = false;
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (!isQueryDevice.booleanValue() && null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            isNeedZoneSecrurity = true;
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        HashMap<String, List<FlowDistributing>> allDetectMap = new HashMap<String, List<FlowDistributing>>();
        if (-2L == cds.getDeviceId()) {
            for (String deviceIp : cds.getDeviceIpList()) {
                cds.setDeviceIp(deviceIp);
                CommonUtil.setIpToFormate(cds);
                List<FlowDistributing> flowDisList = this.queryAllDetectFlow(cds);
                if (flowDisList.isEmpty()) continue;
                allDetectMap.put(cds.getDeviceIp(), flowDisList);
            }
        }
        if (isNeedZoneSecrurity.booleanValue()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getAllDetectFlowDis");
        return allDetectMap;
    }

    private List<FlowDistributing> queryAllDetectFlow(DataStatCondition cds) {
        StringBuffer tableName = new StringBuffer();
        FlowDisUtil util = new FlowDisUtil();
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        String tablePostfix = util.getTableType(cds.getStartTime(), cds.getEndTime());
        if (null == cds.getZoneId() && null == cds.getZoneIp()) {
            tableName.append("ATIC_DEV_FLOW_SUM");
        } else if (null == cds.getZoneIp()) {
            tableName.append("ATIC_ZONE_FLOW_SUM");
        } else {
            tableName.append("ATIC_IP_FLOW_SUM");
        }
        tableName.append(tablePostfix);
        this.condition = new HashMap<Integer, Object>();
        String inSql = util.getAllDetectSql(cds, tableName.toString(), this.condition);
        LOG.info((Object)("FlowDistributing allDetect sql: " + inSql));
        return this.dao.getAllDetectFlowDis(inSql, this.condition);
    }

    @Override
    public Map<String, List<IpTopN>> getIPFlux(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getIPFlux");
        HashMap<String, List<IpTopN>> map = new HashMap<String, List<IpTopN>>();
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        if (cds.getDeviceId() > 0L) {
            CommonUtil.setIpToFormate(cds);
            List<IpTopN> ips = null;
            ips = this.processQueryIpFluxTopN(cds);
            if (!ips.isEmpty()) {
                map.put(cds.getDeviceIp(), ips);
            }
        } else {
            for (String ip : cds.getDeviceIpList()) {
                cds.setDeviceIp(ip);
                CommonUtil.setIpToFormate(cds);
                List<IpTopN> ips = null;
                ips = this.processQueryIpFluxTopN(cds);
                if (ips.isEmpty()) continue;
                map.put(cds.getDeviceIp(), ips);
            }
        }
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getIPFlux");
        return map;
    }

    private List<IpTopN> processQueryIpFluxTopN(DataStatCondition cds) {
        ArrayList<IpTopN> allConnCompare = new ArrayList<IpTopN>();
        Integer protocol = cds.getProtocol();
        if (null != cds.getIsServiceGroup() && cds.getIsServiceGroup().booleanValue()) {
            if (null != cds.getServiceIds() && !cds.getServiceIds().isEmpty()) {
                for (Map.Entry<String, List<Long>> serviceIdList : cds.getServiceIds().entrySet()) {
                    cds.setBisType(serviceIdList.getKey());
                    if (!"DEFAULT".equals(serviceIdList.getKey())) {
                        cds.setProtocol(-1);
                    } else {
                        cds.setProtocol(protocol);
                    }
                    List<IpTopN> temp = null;
                    temp = this.processIpFluxTopNData(cds);
                    if (temp.isEmpty()) continue;
                    allConnCompare.addAll(temp);
                }
            }
        } else {
            List<IpTopN> temp = null;
            temp = this.processIpFluxTopNData(cds);
            if (!temp.isEmpty()) {
                allConnCompare.addAll(temp);
            }
        }
        return allConnCompare;
    }

    private List<IpTopN> processIpFluxTopNData(DataStatCondition cds) {
        TopNUtil util = new TopNUtil();
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getIpFluxSql(cds, this.condition);
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        LOG.info((Object)sql);
        int gra = 1;
        if (cds.getAppType() == 2) {
            gra = cds.isPortalQuery() ? this.getGra(start, end) : this.getGra4FluxTopN(start, end);
        }
        List<IpTopN> tmp = null;
        tmp = this.dao.findIps(sql, gra, cds.getAppType() == 1, this.condition);
        return tmp;
    }

    @Override
    public Map<String, List<ZoneTopN>> getZoneFlux(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getZoneFlux");
        HashMap<String, List<ZoneTopN>> zoneTopnMap = new HashMap<String, List<ZoneTopN>>();
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        TopNUtil util = new TopNUtil();
        if (cds.getDeviceId() > 0L) {
            List<ZoneTopN> zones;
            CommonUtil.setIpToFormate(cds);
            this.condition = new HashMap<Integer, Object>();
            String sql = util.getZoneFluxSql(cds, this.condition);
            LOG.info((Object)("ZoneFlux sql:" + sql));
            int gra = 1;
            if (cds.getAppType() == 2) {
                gra = this.getGra4FluxTopN(start, end);
            }
            if (!(zones = this.dao.findZones(sql, gra, this.condition)).isEmpty()) {
                zoneTopnMap.put(cds.getDeviceIp(), zones);
            }
        } else {
            for (String deviceIp : cds.getDeviceIpList()) {
                List<ZoneTopN> zones;
                cds.setDeviceIp(deviceIp);
                CommonUtil.setIpToFormate(cds);
                this.condition = new HashMap<Integer, Object>();
                String sql = util.getZoneFluxSql(cds, this.condition);
                LOG.info((Object)("ZoneFlux sql:" + sql));
                int gra = 1;
                if (cds.getAppType() == 2) {
                    gra = this.getGra4FluxTopN(start, end);
                }
                if ((zones = this.dao.findZones(sql, gra, this.condition)).isEmpty()) continue;
                zoneTopnMap.put(cds.getDeviceIp(), zones);
            }
        }
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getZoneFlux");
        return zoneTopnMap;
    }

    @Override
    public Map<String, List<ZoneTopN>> getZoneFlux(DataStatCondition cds, List<ZoneTopN> zoneTopNList) throws RemoteException {
        if (null == cds || !cds.isValid() || null == zoneTopNList || zoneTopNList.size() > 10000) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getZoneFlux max");
        HashMap<String, List<ZoneTopN>> zoneTopnMap = new HashMap<String, List<ZoneTopN>>();
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        TopNUtil util = new TopNUtil();
        ArrayList<ZoneTopN> zones = new ArrayList<ZoneTopN>();
        for (ZoneTopN zoneTopn : zoneTopNList) {
            CommonUtil.setIpToFormate(cds);
            this.condition = new HashMap<Integer, Object>();
            String sql = util.getZoneFluxMaxSql(cds, zoneTopn, this.condition);
            LOG.info((Object)("ZoneFlux max sql:" + sql));
            List<ZoneTopN> temp = this.dao.findMaxZones(sql, this.condition);
            if (temp.isEmpty()) continue;
            zones.addAll(temp);
        }
        for (int i = zones.size() - 1; i >= 0; --i) {
            String deviceIp = ((ZoneTopN)zones.get(i)).getDeviceIp();
            if (!zoneTopnMap.containsKey(deviceIp)) {
                ArrayList tmpList = new ArrayList();
                tmpList.add(zones.get(i));
                zoneTopnMap.put(deviceIp, tmpList);
            } else {
                ((List)zoneTopnMap.get(deviceIp)).add(zones.get(i));
            }
            zones.remove(i);
        }
        LOG.info((Object)"end getZoneFlux max");
        return zoneTopnMap;
    }

    @Override
    public Map<String, List<ZoneAttackCountTopN>> getZoneAttackCountTopN(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getZoneAttackCountTopN");
        Map<String, List<ZoneAttackCountTopN>> zoneAttackCountMap = null;
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        TopNUtil util = new TopNUtil();
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getZoneAttackCountTopNSql(cds, this.condition);
        LOG.info((Object)("ZoneAttackCountTopN sql :" + sql));
        zoneAttackCountMap = this.dao.findZoneAttackCountTopN(sql, this.condition);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getZoneAttackCountTopN");
        return zoneAttackCountMap;
    }

    @Override
    public Map<String, List<ZoneAttackTimeTopN>> getZoneAttackTimeTopN(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getZoneAttackTimeTopN");
        Map<String, List<ZoneAttackTimeTopN>> zoneAttackTimeMap = null;
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        TopNUtil util = new TopNUtil();
        if (cds.getDeviceId() > 0L) {
            CommonUtil.setIpToFormate(cds);
            this.condition = new HashMap<Integer, Object>();
            String sql = util.getZoneAttackTimeTopNSql(cds, this.condition);
            LOG.info((Object)("ZoneAttackTimeTopN sql :" + sql));
            zoneAttackTimeMap = this.dao.findZoneAttackTimeTopN(sql, this.condition);
        } else {
            this.condition = new HashMap<Integer, Object>();
            String sql = util.getZoneAttackTimeTopNSql4MultiNE(cds, this.condition);
            LOG.info((Object)("ZoneAttackTimeTopN sql :" + sql));
            zoneAttackTimeMap = this.dao.findZoneAttackTimeTopN(sql, this.condition);
        }
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getZoneAttackTimeTopN");
        return zoneAttackTimeMap;
    }

    @Override
    public Map<String, List<BisAttackCountTopN>> getBisAttackCountTopN(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getBisAttackCountTopN");
        HashMap<String, List<BisAttackCountTopN>> bisAttackCountMap = new HashMap<String, List<BisAttackCountTopN>>();
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        TopNUtil util = new TopNUtil();
        if (cds.getDeviceId() > 0L) {
            CommonUtil.setIpToFormate(cds);
            this.condition = new HashMap<Integer, Object>();
            String sql = util.getBisAttackCountTopNSql(cds, this.condition);
            LOG.info((Object)("BisAttackCountTopN sql :" + sql));
            List<BisAttackCountTopN> bisAttacks = this.dao.findBisAttackCountTopN(sql, this.condition);
            if (!bisAttacks.isEmpty()) {
                bisAttackCountMap.put(cds.getDeviceIp(), bisAttacks);
            }
        } else {
            for (String deviceIp : cds.getDeviceIpList()) {
                cds.setDeviceIp(deviceIp);
                CommonUtil.setIpToFormate(cds);
                this.condition = new HashMap<Integer, Object>();
                String sql = util.getBisAttackCountTopNSql(cds, this.condition);
                LOG.info((Object)("BisAttackCountTopN sql :" + sql));
                List<BisAttackCountTopN> bisAttacks = this.dao.findBisAttackCountTopN(sql, this.condition);
                if (bisAttacks.isEmpty()) continue;
                bisAttackCountMap.put(cds.getDeviceIp(), bisAttacks);
            }
        }
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getBisAttackCountTopN");
        return bisAttackCountMap;
    }

    @Override
    public Map<String, List<BisAttackTimeTopN>> getBisAttackTimeTopN(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getBisAttackTimeTopN");
        HashMap<String, List<BisAttackTimeTopN>> bisAttackMap = new HashMap<String, List<BisAttackTimeTopN>>();
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        TopNUtil util = new TopNUtil();
        if (cds.getDeviceId() > 0L) {
            CommonUtil.setIpToFormate(cds);
            this.condition = new HashMap<Integer, Object>();
            String sql = util.getBisAttackTimeTopNSql(cds, this.condition);
            LOG.info((Object)("BisAttackTimeTopN sql :" + sql));
            List<BisAttackTimeTopN> bisAttackTimes = this.dao.findBisAttackTimeTopN(sql, this.condition);
            if (!bisAttackTimes.isEmpty()) {
                bisAttackMap.put(cds.getDeviceIp(), bisAttackTimes);
            }
        } else {
            for (String deviceIp : cds.getDeviceIpList()) {
                cds.setDeviceIp(deviceIp);
                CommonUtil.setIpToFormate(cds);
                this.condition = new HashMap<Integer, Object>();
                String sql = util.getBisAttackTimeTopNSql4MultiNE(cds, this.condition);
                LOG.info((Object)("BisAttackTimeTopN sql :" + sql));
                List<BisAttackTimeTopN> bisAttackTimes = this.dao.findBisAttackTimeTopN(sql, this.condition);
                if (bisAttackTimes.isEmpty()) continue;
                bisAttackMap.put(cds.getDeviceIp(), bisAttackTimes);
            }
        }
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getBisAttackTimeTopN");
        return bisAttackMap;
    }

    private int getGra(Long start, Long end) {
        Date date = new Date();
        Long now = date.getTime() / 1000L;
        if (end > now) {
            end = now;
        }
        long querySpan = end - start;
        long span = DataStatServiceImpl.getSpan(start, end);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTimeInMillis(end * 1000L);
        int gra = 1;
        if (querySpan < CollectorConstants.ONE_DAY && querySpan > 0L) {
            if (0L != end % CollectorConstants.FIVE_MIN) {
                end = end / CollectorConstants.FIVE_MIN * CollectorConstants.FIVE_MIN;
            }
            gra = now - end > CollectorConstants.FIVE_MIN ? (int)(span / CollectorConstants.FIVE_MIN) + 1 : (int)(span / CollectorConstants.FIVE_MIN);
        } else if (querySpan < CollectorConstants.ONE_WEEK && querySpan >= CollectorConstants.ONE_DAY) {
            if (0L != end % CollectorConstants.ONE_HOUR) {
                end = end / CollectorConstants.ONE_HOUR * CollectorConstants.ONE_HOUR;
            }
            gra = now - end > CollectorConstants.ONE_HOUR ? (int)(span / CollectorConstants.ONE_HOUR) + 1 : (int)(span / CollectorConstants.ONE_HOUR);
        } else if (querySpan < CollectorConstants.ONE_YEAR && querySpan >= CollectorConstants.ONE_WEEK) {
            if (0L != end % CollectorConstants.ONE_DAY) {
                end = end / CollectorConstants.ONE_DAY * CollectorConstants.ONE_DAY;
            }
            gra = now - end > CollectorConstants.ONE_DAY ? (int)(span / CollectorConstants.ONE_DAY) + 1 : (int)(span / CollectorConstants.ONE_DAY);
        } else {
            LOG.debug((Object)("getGra: span is invalid, span=" + span));
        }
        if (0 == gra) {
            gra = 1;
        }
        LOG.debug((Object)("gra=" + gra));
        return gra;
    }

    private static long getSpan(Long start, Long end) {
        long span = end - start;
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTimeInMillis(start * 1000L);
        if (span < CollectorConstants.ONE_DAY && span > 0L) {
            if (0L != start % CollectorConstants.FIVE_MIN) {
                start = (start / CollectorConstants.FIVE_MIN + 1L) * CollectorConstants.FIVE_MIN;
            }
        } else if (span < CollectorConstants.ONE_WEEK && span >= CollectorConstants.ONE_DAY) {
            if (0L != start % CollectorConstants.ONE_HOUR) {
                start = (start / CollectorConstants.ONE_HOUR + 1L) * CollectorConstants.ONE_HOUR;
            }
        } else if (span < CollectorConstants.ONE_YEAR && span >= CollectorConstants.ONE_WEEK && 0L != start % CollectorConstants.ONE_DAY) {
            start = (start / CollectorConstants.ONE_DAY + 1L) * CollectorConstants.ONE_DAY;
        }
        span = end - start;
        return span;
    }

    private int getGra4FluxTopN(Long start, Long end) {
        Date date = new Date();
        Long now = date.getTime() / 1000L;
        if (end > now) {
            end = now;
        }
        long querySpan = end - start;
        long span = this.getGra4FluxSpan(start, end);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTimeInMillis(end * 1000L);
        int gra = 1;
        if (querySpan < CollectorConstants.ONE_WEEK && querySpan > 0L) {
            if (0L != end % CollectorConstants.ONE_HOUR) {
                end = end / CollectorConstants.ONE_HOUR * CollectorConstants.ONE_HOUR;
            }
            gra = now - end > CollectorConstants.ONE_HOUR ? (int)(span / CollectorConstants.ONE_HOUR) + 1 : (int)(span / CollectorConstants.ONE_HOUR);
        } else if (querySpan < CollectorConstants.ONE_YEAR) {
            if (0L != end % CollectorConstants.ONE_DAY) {
                end = end / CollectorConstants.ONE_DAY * CollectorConstants.ONE_DAY;
            }
            gra = now - end > CollectorConstants.ONE_DAY ? (int)(span / CollectorConstants.ONE_DAY) + 1 : (int)(span / CollectorConstants.ONE_DAY);
        } else {
            LOG.debug((Object)("getGra4FluxTopN: span is invalid, span=" + span));
        }
        if (0 == gra) {
            gra = 1;
        }
        LOG.debug((Object)("gra=" + gra));
        return gra;
    }

    private long getGra4FluxSpan(Long start, Long end) {
        long span = end - start;
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTimeInMillis(start * 1000L);
        if (span < CollectorConstants.ONE_WEEK && span >= 0L) {
            if (0L != start % CollectorConstants.ONE_HOUR) {
                start = (start / CollectorConstants.ONE_HOUR + 1L) * CollectorConstants.ONE_HOUR;
            }
        } else if (span < CollectorConstants.ONE_YEAR && 0L != start % CollectorConstants.ONE_DAY) {
            start = (start / CollectorConstants.ONE_DAY + 1L) * CollectorConstants.ONE_DAY;
        }
        span = end - start;
        return span;
    }

    @Override
    public Map<String, List<BisTopN>> getBisFlux(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getBisFlux");
        HashMap<String, List<BisTopN>> map = new HashMap<String, List<BisTopN>>();
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        TopNUtil util = new TopNUtil();
        List<BisTopN> bises = null;
        if (cds.getDeviceId() > 0L) {
            CommonUtil.setIpToFormate(cds);
            this.condition = new HashMap<Integer, Object>();
            String sql = util.getBisFluxSql(cds, this.condition);
            LOG.info((Object)("bis flux sql : " + sql));
            int gra = 1;
            if (cds.getAppType() == 2) {
                gra = this.getGra4FluxTopN(start, end);
            }
            bises = this.dao.findBisTopN(sql, gra, cds.getAppType() == 1, this.condition);
            map.put(cds.getDeviceIp(), bises);
        } else {
            for (String ip : cds.getDeviceIpList()) {
                List<BisTopN> tmp;
                cds.setDeviceIp(ip);
                CommonUtil.setIpToFormate(cds);
                this.condition = new HashMap<Integer, Object>();
                String sql = util.getBisFluxSql(cds, this.condition);
                LOG.info((Object)("bis flux sql : " + sql));
                int gra = 1;
                if (cds.getAppType() == 2) {
                    gra = this.getGra4FluxTopN(start, end);
                }
                if ((tmp = this.dao.findBisTopN(sql, gra, cds.getAppType() == 1, this.condition)).isEmpty()) continue;
                map.put(cds.getDeviceIp(), tmp);
            }
        }
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getBisFlux");
        return map;
    }

    @Override
    public Map<String, List<DnsTopN>> getDnsTopN(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getDnsTopN");
        Map<String, List<DnsTopN>> map = null;
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        int reqType = cds.getAttackType();
        TopNUtil util = new TopNUtil();
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getDnsTopNSql(cds, this.condition);
        LOG.info((Object)("dns topn sql : " + sql));
        map = this.dao.findDnsTopN(sql, reqType, this.condition);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getDnsTopN");
        return map;
    }

    @Override
    public Map<String, List<DnsGraph>> getDnsGraph(DataStatCondition cds, DnsTopN dnsTopN) throws RemoteException {
        if (null == cds || !cds.isValid() || null == dnsTopN) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getDnsGraph");
        Map<String, List<DnsGraph>> map = null;
        int reqType = cds.getAttackType();
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        TopNUtil util = new TopNUtil();
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getDnsGraphSql(cds, dnsTopN, this.condition);
        LOG.info((Object)("dns graph sql : " + sql));
        map = this.dao.findDnsGraph(sql, reqType, this.condition);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getDnsGraph");
        return map;
    }

    @Override
    public Map<String, List<DnsCache>> getDnsCache(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getDnsCache");
        HashMap<String, List<DnsCache>> map = new HashMap<String, List<DnsCache>>();
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        TopNUtil util = new TopNUtil();
        List<DnsCache> dnsCacheList = null;
        if (cds.getDeviceId() > 0L) {
            CommonUtil.setIpToFormate(cds);
            this.condition = new HashMap<Integer, Object>();
            String sql = util.getDnsCacheSql(cds, this.condition);
            LOG.info((Object)("dns cache sql : " + sql));
            dnsCacheList = this.dao.findDnsCache(sql, this.condition);
            if (dnsCacheList.isEmpty()) {
                return null;
            }
            map.put(cds.getDeviceIp(), dnsCacheList);
        } else {
            for (String ip : cds.getDeviceIpList()) {
                cds.setDeviceIp(ip);
                CommonUtil.setIpToFormate(cds);
                this.condition = new HashMap<Integer, Object>();
                String sql = util.getDnsCacheSql(cds, this.condition);
                LOG.info((Object)("dns cache sql : " + sql));
                List<DnsCache> tmp = this.dao.findDnsCache(sql, this.condition);
                if (tmp.isEmpty()) continue;
                map.put(cds.getDeviceIp(), tmp);
            }
        }
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getDnsCache");
        return map;
    }

    @Override
    public Map<String, List<IpAttackTimeTopN>> getIpAttackTimeTopN(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getIpAttackTimeTopN");
        Map<String, List<IpAttackTimeTopN>> ipAttackMap = null;
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        TopNUtil util = new TopNUtil();
        if (cds.getDeviceId() > 0L) {
            CommonUtil.setIpToFormate(cds);
            this.condition = new HashMap<Integer, Object>();
            String sql = util.getIpAttackTimeTopNSql(cds, this.condition);
            LOG.info((Object)("IpAttackTimeTopN sql :" + sql));
            ipAttackMap = this.dao.findIpAttackTimeTopN(sql, this.condition);
        } else {
            this.condition = new HashMap<Integer, Object>();
            String sql = util.getIpAttackTimeTopNSql4MultiNE(cds, this.condition);
            LOG.info((Object)("IpAttackTimeTopN sql :" + sql));
            ipAttackMap = this.dao.findIpAttackTimeTopN(sql, this.condition);
        }
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getIpAttackTimeTopN");
        return ipAttackMap;
    }

    @Override
    public Map<String, List<IpAttackCountTopN>> getIpAttackCountTopN(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getIpAttackCountTopN");
        Map<String, List<IpAttackCountTopN>> ipAttackMap = null;
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        TopNUtil util = new TopNUtil();
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getIpAttackCountTopNSql(cds, this.condition);
        LOG.info((Object)("IpAttackCountTopN sql :" + sql));
        ipAttackMap = this.dao.findIpAttackCountTopN(sql, this.condition);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getIpAttackCountTopN");
        return ipAttackMap;
    }

    public long getRealStartTime(long start, long end) {
        long span = end - start;
        long gra = 0L;
        if (span < CollectorConstants.ONE_DAY && span >= 0L) {
            gra = 300L;
        } else if (span < CollectorConstants.ONE_WEEK && span >= CollectorConstants.ONE_DAY) {
            gra = 3600L;
        } else if (span <= CollectorConstants.ONE_YEAR && span >= CollectorConstants.ONE_WEEK) {
            return this.processStartTime(start);
        }
        return start - start % gra;
    }

    public long processStartTime(long startTime) {
        if (Long.valueOf(startTime) == null) {
            return 0L;
        }
        long timeLong = 0L;
        try {
            SimpleDateFormat fromate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date(startTime * 1000L);
            String timeString = fromate.format(date);
            StringBuffer bufferTime = new StringBuffer(timeString.split(" ")[0]);
            bufferTime.append(" 00:00:00");
            Date startDate = fromate.parse(bufferTime.toString().trim());
            timeLong = startDate.getTime() / 1000L;
        }
        catch (ParseException ex) {
            LOG.error((Object)"Parse time exception to start time !", (Throwable)ex);
        }
        return timeLong;
    }

    @Override
    public Map<String, List<RequestTrend>> getRequestTrend(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getRequestTrend");
        HashMap<String, List<RequestTrend>> requestTrend = new HashMap<String, List<RequestTrend>>();
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        RequestTrendUtil requestTrendUtil = new RequestTrendUtil();
        if (cds.getDeviceId() > 0L) {
            CommonUtil.setIpToFormate(cds);
            ArrayList<RequestTrend> requestTrendList = new ArrayList<RequestTrend>();
            for (String requestType : cds.getRequestTrendType()) {
                this.condition = new HashMap<Integer, Object>();
                String sql = requestTrendUtil.getRequestTrendEachType(cds, requestType, this.condition);
                LOG.info((Object)("RequestTrend " + requestType + " type sql:" + sql));
                List<RequestTrend> requestTrends = this.dao.findRequestTrend(sql, requestType, this.condition);
                if (requestTrends.isEmpty()) continue;
                requestTrendList.addAll(requestTrends);
            }
            requestTrend.put(cds.getDeviceIp(), requestTrendList);
        } else {
            for (String deviceIp : cds.getDeviceIpList()) {
                cds.setDeviceIp(deviceIp);
                CommonUtil.setIpToFormate(cds);
                this.condition = new HashMap<Integer, Object>();
                ArrayList<RequestTrend> requestTrendList = new ArrayList<RequestTrend>();
                for (String requestType : cds.getRequestTrendType()) {
                    String sql = requestTrendUtil.getRequestTrendEachType(cds, requestType, this.condition);
                    LOG.info((Object)("RequestTrend " + requestType + " type sql:" + sql));
                    List<RequestTrend> requestTrends = this.dao.findRequestTrend(sql, requestType, this.condition);
                    if (requestTrends.isEmpty()) continue;
                    requestTrendList.addAll(requestTrends);
                }
                requestTrend.put(cds.getDeviceIp(), requestTrendList);
            }
        }
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getRequestTrend");
        return requestTrend;
    }

    @Override
    public Map<String, List<DropTrend>> getDropTrend(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getDropTrend");
        HashMap<String, List<DropTrend>> dropTrend = new HashMap<String, List<DropTrend>>();
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        DropTrendUtil dropTrendUtil = new DropTrendUtil();
        if (cds.getDeviceId() > 0L) {
            CommonUtil.setIpToFormate(cds);
            this.condition = new HashMap<Integer, Object>();
            List<DropTrend> dropTrendList = null;
            String sql = dropTrendUtil.getDropTrendUtil(cds, this.condition);
            LOG.info((Object)("getDropTrend sql:" + sql));
            dropTrendList = this.dao.findDropTrend(sql, this.condition);
            if (!dropTrendList.isEmpty()) {
                List<DropTrend> temp = this.processDropType(dropTrendList);
                dropTrend.put(cds.getDeviceIp(), temp);
            }
        } else {
            for (String deviceIp : cds.getDeviceIpList()) {
                cds.setDeviceIp(deviceIp);
                CommonUtil.setIpToFormate(cds);
                this.condition = new HashMap<Integer, Object>();
                List<DropTrend> dropTrendList = null;
                String sql = dropTrendUtil.getDropTrendUtil(cds, this.condition);
                dropTrendList = this.dao.findDropTrend(sql, this.condition);
                if (dropTrendList.isEmpty()) continue;
                List<DropTrend> temp = this.processDropType(dropTrendList);
                dropTrend.put(cds.getDeviceIp(), temp);
            }
        }
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getDropTrend");
        return dropTrend;
    }

    private List<DropTrend> processDropType(List<DropTrend> dropTrendList) {
        HashMap<DropTrendUnique, DropTrend> dropTrendMap = new HashMap<DropTrendUnique, DropTrend>();
        DropTrendUtil dropTrendUtil = new DropTrendUtil();
        for (DropTrend dropTrend : dropTrendList) {
            String dropTypeName = dropTrendUtil.getDropTypeName(dropTrend.getAttackType());
            DropTrendUnique dropTrendUnique = new DropTrendUnique();
            dropTrendUnique.setDateTime(dropTrend.getDateTime());
            dropTrendUnique.setDropTypeName(dropTypeName);
            if (dropTrendMap.containsKey(dropTrendUnique)) {
                ((DropTrend)dropTrendMap.get(dropTrendUnique)).setDropPackagePps(((DropTrend)dropTrendMap.get(dropTrendUnique)).getDropPackagePps() + dropTrend.getDropPackagePps());
                continue;
            }
            DropTrend dropTrendTemp = new DropTrend();
            dropTrendTemp.setDateTime(dropTrend.getDateTime());
            dropTrendTemp.setDropPackagePps(dropTrend.getDropPackagePps());
            dropTrendTemp.setDropTypeName(dropTypeName);
            dropTrendMap.put(dropTrendUnique, dropTrendTemp);
        }
        ArrayList<DropTrend> returnList = new ArrayList<DropTrend>();
        for (Map.Entry entry : dropTrendMap.entrySet()) {
            returnList.add((DropTrend)entry.getValue());
        }
        return returnList;
    }

    @Override
    public RmiTuple<List<AttackExactLog>, Integer> getAttackExactLog(Long attackLogPkid, int direction) throws RemoteException {
        LOG.info((Object)"start getAttackExactLog");
        AttackLogUtil util = new AttackLogUtil();
        this.condition = new HashMap<Integer, Object>();
        String querySql = util.getExactLogIdSql(attackLogPkid, direction, this.condition);
        LOG.info((Object)("getAttackExactLogId sql: " + querySql));
        String exactLogId = this.dao.getAttackExactLogId(querySql, this.condition);
        if (null == exactLogId || "".equals(exactLogId)) {
            LOG.error((Object)"Get exact_log_id is null, from atic_ip_attack_log !");
            return null;
        }
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getAttackExactLogSql(exactLogId, direction, this.condition);
        LOG.info((Object)("getAttackExactLog sql:" + sql));
        List<AttackExactLog> aels = this.dao.findAttackExactLog(sql, this.condition);
        if (aels.isEmpty()) {
            return null;
        }
        Integer total = aels.size();
        if (total == null || total == 0) {
            return null;
        }
        LOG.info((Object)"end getAttackExactLog");
        return new RmiTuple<List<AttackExactLog>, Integer>(aels, total);
    }

    @Override
    public RmiTuple<List<AttackExactLog>, Integer> getAttackExactLog4AttackEvent(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackExactLog4AttackEvent");
        AttackLogUtil util = new AttackLogUtil();
        CommonUtil.setIpToFormate(cds);
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getAttackExactLogSql4AttackEvent(cds, this.condition);
        LOG.info((Object)("getAttackExactLog4AttackEvent sql:" + sql));
        List<AttackExactLog> aels = this.dao.findAttackExactLog(sql, this.condition);
        if (aels.isEmpty()) {
            return null;
        }
        Integer total = aels.size();
        if (total == null || total == 0) {
            return null;
        }
        LOG.info((Object)"end getAttackExactLog4AttackEvent");
        return new RmiTuple<List<AttackExactLog>, Integer>(aels, total);
    }

    @Override
    public List<AttackExactLog> getAttackExactLogToPcap(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackExactLogToPcap");
        CommonUtil.setIpToFormate(cds);
        Integer devSerType = cds.getDevSerType();
        List<AttackExactLog> result = null;
        String tmpName = "atic_ip_attack_exact_log";
        if (devSerType == null || devSerType == 0) {
            String partSql = "SELECT device_ip,device_type,zone_ip,biz_id,zone_id,start_time_alert,start_time_attack,end_time,duration,";
            partSql = partSql + "attack_type,attack_status,drop_kbits,drop_packets,src_ip,protocol,port,current_value,limit_value FROM ";
            result = this.query(cds, partSql, tmpName, devSerType);
        } else {
            String partSql = "SELECT device_ip,device_type,zone_ip,biz_id,zone_id,start_time_alert,end_time,duration,attack_type,attack_status,src_ip,protocol,port,current_value,limit_value FROM ";
            result = this.query(cds, partSql, tmpName, devSerType);
        }
        LOG.info((Object)"end getAttackExactLogToPcap");
        return result;
    }

    private List<AttackExactLog> query(DataStatCondition cds, String partSql, String tmpName, Integer devSerType) {
        AttackLogUtil util = new AttackLogUtil();
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getAttackExactLogSqlForPcap(cds, partSql, tmpName, this.condition);
        LOG.info((Object)("getAttackExactLogToPcapFile:" + sql));
        if (devSerType == null || devSerType == 0) {
            return this.dao.findAttackExactLogOfClean(sql, this.condition);
        }
        return this.dao.findAttackExactLogOfDetect(sql, this.condition);
    }

    @Override
    public Map<String, List<IpTopN>> getIPFlux(DataStatCondition cds, List<IpTopN> ipTopNList) throws RemoteException {
        if (null == cds || !cds.isValid() || null == ipTopNList || ipTopNList.size() > 10000) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getIPFlux Max");
        HashMap<String, List<IpTopN>> map = new HashMap<String, List<IpTopN>>();
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        TopNUtil util = new TopNUtil();
        ArrayList<IpTopN> ips = new ArrayList<IpTopN>();
        Integer protocol = cds.getProtocol();
        for (IpTopN iptopn : ipTopNList) {
            CommonUtil.setIpToFormate(cds);
            if (IpTransformer.checkIpInvaild(iptopn.getZoneIp())) {
                iptopn.setZoneIp(IpTransformer.formatIpAddress(iptopn.getZoneIp()));
            }
            this.condition = new HashMap<Integer, Object>();
            if (null != cds.getIsServiceGroup() && cds.getIsServiceGroup().booleanValue()) {
                if (null == cds.getServiceIds() || cds.getServiceIds().isEmpty()) continue;
                for (Map.Entry<String, List<Long>> serviceIdList : cds.getServiceIds().entrySet()) {
                    cds.setBisType(serviceIdList.getKey());
                    if (!"DEFAULT".equals(serviceIdList.getKey())) {
                        cds.setProtocol(-1);
                    } else {
                        cds.setProtocol(protocol);
                    }
                    List<IpTopN> temp = null;
                    String sql = util.getIpFluxMaxSql(cds, iptopn, this.condition);
                    LOG.info((Object)("getIPFlux sql:" + sql));
                    temp = this.dao.findMaxIps(sql, this.condition);
                    if (temp.isEmpty()) continue;
                    ips.addAll(temp);
                }
                continue;
            }
            List<IpTopN> temp = null;
            String sql = util.getIpFluxMaxSql(cds, iptopn, this.condition);
            LOG.info((Object)("getIPFlux sql:" + sql));
            temp = this.dao.findMaxIps(sql, this.condition);
            if (temp.isEmpty()) continue;
            ips.addAll(temp);
        }
        for (int i = ips.size() - 1; i >= 0; --i) {
            String deviceIp = ((IpTopN)ips.get(i)).getDeviceIp();
            if (!map.containsKey(deviceIp)) {
                ArrayList tmpList = new ArrayList();
                tmpList.add(ips.get(i));
                map.put(deviceIp, tmpList);
            } else {
                ((List)map.get(deviceIp)).add(ips.get(i));
            }
            ips.remove(i);
        }
        LOG.info((Object)"end getIPFlux Max");
        return map;
    }

    @Override
    public Map<String, List<BisTopN>> getBisFlux(DataStatCondition cds, List<BisTopN> bisTopNList) throws RemoteException {
        if (null == cds || !cds.isValid() || null == bisTopNList || bisTopNList.size() > 10000) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getBisFlux Max");
        HashMap<String, List<BisTopN>> map = new HashMap<String, List<BisTopN>>();
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        TopNUtil util = new TopNUtil();
        ArrayList<BisTopN> bises = new ArrayList<BisTopN>();
        for (BisTopN bistopn : bisTopNList) {
            CommonUtil.setIpToFormate(cds);
            this.condition = new HashMap<Integer, Object>();
            String sql = util.getBisFluxMaxSql(cds, bistopn, this.condition);
            LOG.info((Object)("getBisFlux sql:" + sql));
            List<BisTopN> temp = this.dao.findMaxBis(sql, this.condition);
            if (temp.isEmpty()) continue;
            bises.addAll(temp);
        }
        for (int i = bises.size() - 1; i >= 0; --i) {
            String deviceIp = ((BisTopN)bises.get(i)).getDeviceIp();
            if (!map.containsKey(deviceIp)) {
                ArrayList tmpList = new ArrayList();
                tmpList.add(bises.get(i));
                map.put(deviceIp, tmpList);
            } else {
                ((List)map.get(deviceIp)).add(bises.get(i));
            }
            bises.remove(i);
        }
        LOG.info((Object)"end getBisFlux Max");
        return map;
    }

    @Override
    public Map<String, List<DeviceStopTime>> getDeviceStopTimeList(DeviceStopTimeQueryForm queryForm) {
        if (null == queryForm) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getDeviceStopTimeList");
        List<String> deviceIpList = queryForm.getDeviceIpList();
        Integer devSerType = queryForm.getDevSerType();
        Long startTime = queryForm.getStartTime();
        Long endTime = queryForm.getEndTime();
        if (null == deviceIpList || deviceIpList.size() > 10000) {
            LOG.error((Object)"deviceIpList is null or size > 10000.");
            return null;
        }
        HashMap<String, List<DeviceStopTime>> stopMap = new HashMap<String, List<DeviceStopTime>>();
        for (String deviceIpTemp : deviceIpList) {
            String deviceIp = deviceIpTemp;
            if (IpTransformer.checkIpInvaild(deviceIp)) {
                deviceIp = IpTransformer.formatIpAddress(deviceIp);
            }
            this.condition = new HashMap<Integer, Object>();
            String sql = this.getDeviceStopTimeSql(deviceIp, devSerType, startTime, endTime);
            List<DeviceStopTime> stopTimeList = this.dao.getDeviceStopTimeList(sql, this.condition);
            if (stopTimeList.isEmpty()) {
                DeviceStopTime deviceStopTime = new DeviceStopTime();
                deviceStopTime.setDeviceIp(deviceIp);
                deviceStopTime.setDeviceType(devSerType);
                deviceStopTime.setHave(0);
                stopTimeList.add(deviceStopTime);
            } else {
                DeviceStopTime stop = stopTimeList.get(0);
                if (stop.getStopTime() < startTime) {
                    stop.setStopTime(startTime);
                }
                if ((stop = stopTimeList.get(stopTimeList.size() - 1)).getStartTime() > endTime) {
                    stop.setStartTime(endTime);
                }
            }
            stopMap.put(deviceIp, stopTimeList);
        }
        LOG.info((Object)"end getDeviceStopTimeList");
        return stopMap;
    }

    public String getDeviceStopTimeSql(String deviceIp, Integer devSerType, Long startTime, Long endTime) {
        if (null == this.condition) {
            this.condition = new HashMap<Integer, Object>();
        }
        int index = 1;
        String tableName = "atic_dev_work_time";
        StringBuffer sql = new StringBuffer();
        sql.append("select device_ip,device_type,stop_time,start_time from ");
        sql.append(tableName);
        sql.append(" where stop_time <= ? ");
        this.condition.put(index++, endTime);
        sql.append(" and start_time >= ? ");
        this.condition.put(index++, startTime);
        sql.append(" and device_type = ? ");
        this.condition.put(index++, devSerType);
        sql.append(" and device_ip= ? ");
        this.condition.put(index++, deviceIp);
        sql.append(" order by stop_time");
        return sql.toString();
    }

    @Override
    public Integer getAttackLogNum(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackLogNum");
        AttackLogUtil util = new AttackLogUtil();
        CommonUtil.setIpToFormate(cds);
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getAttackLogNumSql(cds, this.condition);
        LOG.info((Object)("getAttackLogNum: " + sql));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        Integer num = this.dao.findAttackLogNum(sql, this.condition);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getAttackLogNum");
        return num;
    }

    @Override
    public List<AttackTopn> getAttackEventTopn(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackEventTopn");
        CommonUtil.setIpToFormate(cds);
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        String tableName = "atic_ip_attack_exact_log";
        AttackLogUtil util = new AttackLogUtil();
        this.condition = new HashMap<Integer, Object>();
        String querySql = util.getAttackTopnSql(cds, tableName, this.condition);
        LOG.info((Object)("getAttackTopn sql: " + querySql));
        List<AttackTopn> attackTopNList = this.dao.getAttackTopn(querySql, this.condition);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getAttackEventTopn");
        return attackTopNList;
    }

    public Long getDataGra(Long startTime, Long endTime) {
        long span = endTime - startTime;
        if (span < CollectorConstants.ONE_DAY && span >= 0L) {
            return CollectorConstants.FIVE_MIN;
        }
        if (span < CollectorConstants.ONE_WEEK && span >= CollectorConstants.ONE_DAY) {
            return CollectorConstants.ONE_HOUR;
        }
        if (span < CollectorConstants.ONE_YEAR && span >= CollectorConstants.ONE_WEEK) {
            return CollectorConstants.ONE_DAY;
        }
        return CollectorConstants.FIVE_MIN;
    }

    @Override
    public Map<String, List<AttackTrend>> getAttackTrend(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackTrend");
        Map<String, List<AttackTrend>> attacktTrend = null;
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        HashMap<String, String> attackTypeKeyNameMap = new HashMap<String, String>();
        for (int i = 0; i < cds.getAttackTypeKey().size(); ++i) {
            attackTypeKeyNameMap.put(cds.getAttackTypeKey().get(i), cds.getAttackTypeValue().get(i));
        }
        AttackTrendUtil attackTrendUtil = new AttackTrendUtil();
        this.condition = new HashMap<Integer, Object>();
        String sql = attackTrendUtil.getAttackTrendUtilNoAttackType(cds, this.condition);
        LOG.info((Object)("AttackTrend sql:" + sql));
        LOG.info((Object)("AttackTrend condition:" + this.condition.toString()));
        attacktTrend = this.dao.findAttackTrend(sql, attackTypeKeyNameMap, this.condition);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getAttackTrend");
        return attacktTrend;
    }

    @Override
    public List<AttackExactFlow> getSingleAttackExactFlow(String exactLogId) throws RemoteException {
        if (ParamCheckUtil.isValidStringNotNull(exactLogId, 64)) {
            LOG.error((Object)"error input param.");
            return null;
        }
        LOG.info((Object)"start getSingleAttackExactFlow");
        AttackLogUtil util = new AttackLogUtil();
        String tableName = "atic_ip_attack_exact_flow";
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getAttackExactFlowSql(exactLogId, tableName, this.condition);
        LOG.info((Object)("getAttackExactFlow sql:" + sql));
        List<AttackExactFlow> attackExactFlowList = null;
        attackExactFlowList = this.dao.getAttackExactFlow(sql, this.condition);
        LOG.info((Object)"end getSingleAttackExactFlow");
        return attackExactFlowList;
    }

    @Override
    public List<AttackExactFlow> getSingleAttackExactFlow(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getSingleAttackExactFlow");
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        CommonUtil.setIpToFormate(cds);
        AttackLogUtil util = new AttackLogUtil();
        String tableName = "atic_ip_attack_flow";
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getAttackExactFlowSql(cds, tableName, this.condition);
        LOG.info((Object)("getAttackExactFlow sql:" + sql));
        List<AttackExactFlow> attackExactFlowList = null;
        attackExactFlowList = this.dao.getAttackExactFlow(sql, this.condition);
        LOG.info((Object)"end getSingleAttackExactFlow");
        return attackExactFlowList;
    }

    @Override
    public List<SlotFlow> getSlotFlow(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getSlotFlow");
        CommonUtil.setIpToFormate(cds);
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        List<SlotFlow> slotFlowList = null;
        SlotFlowUtil util = new SlotFlowUtil();
        String querySql = null;
        this.condition = new HashMap<Integer, Object>();
        if (0 == cds.getDevSerType()) {
            querySql = util.getCleanSlotSql(cds, this.condition);
            LOG.info((Object)("getSlotFlow for clean device sql: " + querySql));
            slotFlowList = this.dao.findCleanSlotFlow(querySql, this.condition);
        } else {
            querySql = util.getDetectSlotSql(cds, this.condition);
            LOG.info((Object)("getSlotFlow for detect device sql: " + querySql));
            slotFlowList = this.dao.findDetectSlotFlow(querySql, this.condition);
        }
        LOG.info((Object)"end getSlotFlow");
        return slotFlowList;
    }

    @Override
    public RmiTuple<List<DnsDefendLog>, Integer> getDnsDefendLog(DataStatCondition cds, String sortField, String sortType) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getDnsDefendLog");
        CommonUtil.setIpToFormate(cds);
        DnsDefendUtil util = new DnsDefendUtil();
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getDnsDefendLogSql(cds, sortField, sortType, this.condition);
        LOG.info((Object)("getDnsDefendLog: " + sql));
        List<DnsDefendLog> aks = this.dao.findDnsDefendLog(sql, this.condition);
        if (aks.isEmpty()) {
            return null;
        }
        Integer total = aks.size();
        if (total == null || total == 0) {
            return null;
        }
        LOG.info((Object)"end getDnsDefendLog");
        return new RmiTuple<List<DnsDefendLog>, Integer>(aks, total);
    }

    @Override
    public Integer getDnsDefendLogNum(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getDnsDefendLogNum");
        CommonUtil.setIpToFormate(cds);
        DnsDefendUtil util = new DnsDefendUtil();
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getDnsDefendLogNumSql(cds, this.condition);
        LOG.info((Object)("getDnsDefendLogNum: " + sql));
        Integer num = this.dao.findAttackLogNum(sql, this.condition);
        LOG.info((Object)"end getDnsDefendLogNum");
        return num;
    }

    @Override
    public Map<String, List<DnsDefendTopN>> getDnsDefendTopN(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getDnsDefendTopN");
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        HashMap<String, List<DnsDefendTopN>> requestTrend = new HashMap<String, List<DnsDefendTopN>>();
        DnsDefendUtil dnsDefendUtil = new DnsDefendUtil();
        if (cds.getDeviceId() > 0L) {
            CommonUtil.setIpToFormate(cds);
            this.condition = new HashMap<Integer, Object>();
            String sql = dnsDefendUtil.getDnsDefendTopNSql(cds, this.condition);
            LOG.info((Object)("DnsDefendTopN sql:" + sql));
            List<DnsDefendTopN> requestTrends = this.dao.findDnsDefendTopN(sql, this.condition);
            requestTrend.put(cds.getDeviceIp(), requestTrends);
        } else {
            for (String deviceIp : cds.getDeviceIpList()) {
                cds.setDeviceIp(deviceIp);
                CommonUtil.setIpToFormate(cds);
                this.condition = new HashMap<Integer, Object>();
                String sql = dnsDefendUtil.getDnsDefendTopNSql(cds, this.condition);
                LOG.info((Object)("DnsDefendTopN sql:" + sql));
                List<DnsDefendTopN> requestTrends = this.dao.findDnsDefendTopN(sql, this.condition);
                requestTrend.put(cds.getDeviceIp(), requestTrends);
            }
        }
        LOG.info((Object)"end getDnsDefendTopN");
        return requestTrend;
    }

    @Override
    public Map<String, List<AttackCountTrend>> getAttackCountTrend(DataStatCondition cds) throws RemoteException {
        Map<String, List<AttackCountTrend>> attacktTrendTemp4UnCollect;
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackCountTrend");
        HashMap<String, List<AttackCountTrend>> attacktTrend = new HashMap<String, List<AttackCountTrend>>();
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        HashMap<String, String> attackTypeKeyNameMap = new HashMap<String, String>();
        for (int i = 0; i < cds.getAttackTypeKey().size(); ++i) {
            attackTypeKeyNameMap.put(cds.getAttackTypeKey().get(i), cds.getAttackTypeValue().get(i));
        }
        AttackCountTrendUtil attackCountTrendUtil = new AttackCountTrendUtil();
        this.condition = new HashMap<Integer, Object>();
        String sql = attackCountTrendUtil.getAttackTrendUtilNoAttackType(cds, this.condition);
        LOG.info((Object)("getAttackCountTrend sql:" + sql));
        Map<String, List<AttackCountTrend>> attacktTrendTemp = this.dao.findAttackCountTrend(sql, attackTypeKeyNameMap, this.condition);
        if (!attacktTrendTemp.isEmpty()) {
            attacktTrend.putAll(attacktTrendTemp);
        }
        if (null != (attacktTrendTemp4UnCollect = this.processAttackCountTrend4UnCollect(cds, attackTypeKeyNameMap)) && !attacktTrendTemp4UnCollect.isEmpty()) {
            for (Map.Entry<String, List<AttackCountTrend>> entry : attacktTrendTemp4UnCollect.entrySet()) {
                if (attacktTrend.containsKey(entry.getKey())) {
                    ((List)attacktTrend.get(entry.getKey())).addAll((Collection)entry.getValue());
                    continue;
                }
                attacktTrend.put(entry.getKey(), entry.getValue());
            }
        }
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getAttackCountTrend");
        return attacktTrend;
    }

    private Map<String, List<AttackCountTrend>> processAttackCountTrend4UnCollect(DataStatCondition cds, Map<String, String> attackTypeKeyNameMap) {
        Long time = cds.getEndTime() - cds.getStartTime();
        if (time + 1L >= 7L * CollectorConstants.ONE_DAY) {
            String countTimeStr = this.sysConfigDao.querySysValue("day_count_time");
            Long currentCollectTime = Long.parseLong(countTimeStr);
            if (currentCollectTime <= 0L) {
                currentCollectTime = TimeTransformer.transferWithoutHour(cds.getStartTime() - CollectorConstants.ONE_DAY);
            }
            if (currentCollectTime + CollectorConstants.ONE_DAY < cds.getStartTime()) {
                currentCollectTime = cds.getStartTime() - CollectorConstants.ONE_DAY;
            }
            if (cds.getEndTime() < currentCollectTime + CollectorConstants.ONE_DAY) {
                return null;
            }
            return this.processDayAttackCountTrend4UnCollect(currentCollectTime, cds, attackTypeKeyNameMap, "day");
        }
        String countTimeStr = this.sysConfigDao.querySysValue("hour_count_time");
        Long currentCollectTime = Long.parseLong(countTimeStr);
        if (currentCollectTime <= 0L) {
            currentCollectTime = TimeTransformer.transferWithoutSecond(cds.getStartTime() - CollectorConstants.ONE_HOUR);
        }
        if (currentCollectTime + CollectorConstants.ONE_HOUR < cds.getStartTime()) {
            currentCollectTime = cds.getStartTime() - CollectorConstants.ONE_HOUR;
        }
        if (cds.getEndTime() < currentCollectTime + CollectorConstants.ONE_HOUR) {
            return null;
        }
        return this.processDayAttackCountTrend4UnCollect(currentCollectTime, cds, attackTypeKeyNameMap, "hour");
    }

    private Map<String, List<AttackCountTrend>> processDayAttackCountTrend4UnCollect(Long currentCollectTime, DataStatCondition cds, Map<String, String> attackTypeKeyNameMap, String dataType) {
        HashMap<String, List<AttackCountTrend>> returnData = new HashMap<String, List<AttackCountTrend>>();
        Long endTime = cds.getEndTime();
        Long timeSpan = CollectorConstants.ONE_DAY;
        if (dataType.equals("hour")) {
            timeSpan = CollectorConstants.ONE_HOUR;
        }
        Long startDataTime = currentCollectTime + timeSpan;
        while (startDataTime < endTime) {
            Long endDataTime = startDataTime + timeSpan < endTime ? Long.valueOf(startDataTime + timeSpan) : endTime;
            Map<String, List<AttackCountTrend>> tempData = this.getAttackCounTrendData(startDataTime, endDataTime, cds, attackTypeKeyNameMap);
            if (!tempData.isEmpty()) {
                for (Map.Entry<String, List<AttackCountTrend>> entry : tempData.entrySet()) {
                    if (returnData.containsKey(entry.getKey())) {
                        ((List)returnData.get(entry.getKey())).addAll((Collection)entry.getValue());
                        continue;
                    }
                    returnData.put(entry.getKey(), entry.getValue());
                }
            }
            startDataTime = startDataTime + timeSpan;
        }
        return returnData;
    }

    private Map<String, List<AttackCountTrend>> getAttackCounTrendData(Long startDataTime, Long endDataTime, DataStatCondition cds, Map<String, String> attackTypeKeyNameMap) {
        Map<String, List<AttackCountTrend>> returnData = null;
        AttackCountTrendUtil attackCountTrendUtil = new AttackCountTrendUtil();
        this.condition = new HashMap<Integer, Object>();
        String attackCountSql = attackCountTrendUtil.getAttackCount4UnCollect(startDataTime, endDataTime, cds, this.condition);
        LOG.info((Object)("getAttackCountTrend4UnCollect sql:" + attackCountSql));
        returnData = this.dao.findAttackCountTrend(attackCountSql, attackTypeKeyNameMap, this.condition);
        return returnData;
    }

    @Override
    public Map<String, List<AttackIpCountTrend>> getAttackIpCountTrend(DataStatCondition cds) throws RemoteException {
        Map<String, List<AttackIpCountTrend>> attacktTrendTemp4UnCollect;
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackIpCountTrend");
        HashMap<String, List<AttackIpCountTrend>> attacktTrend = new HashMap<String, List<AttackIpCountTrend>>();
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        AttackCountTrendUtil attackCountTrendUtil = new AttackCountTrendUtil();
        this.condition = new HashMap<Integer, Object>();
        String sql = attackCountTrendUtil.getAttackIpCountTrendUtil(cds, this.condition);
        LOG.info((Object)("getAttackIpCountTrend sql:" + sql));
        Map<String, List<AttackIpCountTrend>> attacktTrendTemp = null;
        attacktTrendTemp = this.dao.findAttackIpCountTrend(sql, this.condition);
        if (!attacktTrendTemp.isEmpty()) {
            attacktTrend.putAll(attacktTrendTemp);
        }
        if (null != (attacktTrendTemp4UnCollect = this.processAttackCountTrend4UnCollect(cds)) && !attacktTrendTemp4UnCollect.isEmpty()) {
            for (Map.Entry<String, List<AttackIpCountTrend>> entry : attacktTrendTemp4UnCollect.entrySet()) {
                if (attacktTrend.containsKey(entry.getKey())) {
                    ((List)attacktTrend.get(entry.getKey())).addAll((Collection)entry.getValue());
                    continue;
                }
                attacktTrend.put(entry.getKey(), entry.getValue());
            }
        }
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getAttackCountTrend");
        return attacktTrend;
    }

    private Map<String, List<AttackIpCountTrend>> processAttackCountTrend4UnCollect(DataStatCondition cds) {
        Long time = cds.getEndTime() - cds.getStartTime();
        if (time + 1L >= 7L * CollectorConstants.ONE_DAY) {
            String countTimeStr = this.sysConfigDao.querySysValue("day_count_time");
            Long currentCollectTime = Long.parseLong(countTimeStr);
            if (currentCollectTime <= 0L) {
                currentCollectTime = TimeTransformer.transferWithoutHour(cds.getStartTime() - CollectorConstants.ONE_DAY);
            }
            if (currentCollectTime + CollectorConstants.ONE_DAY < cds.getStartTime()) {
                currentCollectTime = cds.getStartTime() - CollectorConstants.ONE_DAY;
            }
            if (cds.getEndTime() < currentCollectTime + CollectorConstants.ONE_DAY) {
                return null;
            }
            return this.processDayAttackCountTrend4UnCollect(currentCollectTime, cds, "day");
        }
        String countTimeStr = this.sysConfigDao.querySysValue("hour_count_time");
        Long currentCollectTime = Long.parseLong(countTimeStr);
        if (currentCollectTime <= 0L) {
            currentCollectTime = TimeTransformer.transferWithoutSecond(cds.getStartTime() - CollectorConstants.ONE_HOUR);
        }
        if (currentCollectTime + CollectorConstants.ONE_HOUR < cds.getStartTime()) {
            currentCollectTime = cds.getStartTime() - CollectorConstants.ONE_HOUR;
        }
        if (cds.getEndTime() < currentCollectTime + CollectorConstants.ONE_HOUR) {
            return null;
        }
        return this.processDayAttackCountTrend4UnCollect(currentCollectTime, cds, "hour");
    }

    private Map<String, List<AttackIpCountTrend>> processDayAttackCountTrend4UnCollect(Long currentCollectTime, DataStatCondition cds, String dataType) {
        HashMap<String, List<AttackIpCountTrend>> returnData = new HashMap<String, List<AttackIpCountTrend>>();
        Long endTime = cds.getEndTime();
        Long timeSpan = CollectorConstants.ONE_DAY;
        if (dataType.equals("hour")) {
            timeSpan = CollectorConstants.ONE_HOUR;
        }
        Long startDataTime = currentCollectTime + timeSpan;
        while (startDataTime < endTime) {
            Long endDataTime = startDataTime + timeSpan < endTime ? Long.valueOf(startDataTime + timeSpan) : endTime;
            Map<String, List<AttackIpCountTrend>> tempData = this.getAttackCounTrendData(startDataTime, endDataTime, cds);
            if (!tempData.isEmpty()) {
                for (Map.Entry<String, List<AttackIpCountTrend>> entry : tempData.entrySet()) {
                    if (returnData.containsKey(entry.getKey())) {
                        ((List)returnData.get(entry.getKey())).addAll((Collection)entry.getValue());
                        continue;
                    }
                    returnData.put(entry.getKey(), entry.getValue());
                }
            }
            startDataTime = startDataTime + timeSpan;
        }
        return returnData;
    }

    private Map<String, List<AttackIpCountTrend>> getAttackCounTrendData(Long startDataTime, Long endDataTime, DataStatCondition cds) {
        Map<String, List<AttackIpCountTrend>> returnData = null;
        AttackCountTrendUtil attackCountTrendUtil = new AttackCountTrendUtil();
        this.condition = new HashMap<Integer, Object>();
        String attackCountSql = attackCountTrendUtil.getAttackIpCount4UnCollect(startDataTime, endDataTime, cds, this.condition);
        LOG.info((Object)("getAttackIpCountTrend4UnCollect sql:" + attackCountSql));
        returnData = this.dao.findAttackIpCountTrend(attackCountSql, this.condition);
        return returnData;
    }

    @Override
    public Map<String, List<AttackCountCompare>> getAttackCountCompare(DataStatCondition cds) throws RemoteException {
        Map<String, List<AttackCountCompare>> attacktTrendTemp4UnCollect;
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackCountCompare");
        HashMap<String, List<AttackCountCompare>> attacktTrend = new HashMap<String, List<AttackCountCompare>>();
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        AttackCountTrendUtil attackCountTrendUtil = new AttackCountTrendUtil();
        this.condition = new HashMap<Integer, Object>();
        String sql = attackCountTrendUtil.getAttackCountCompareUtil(cds, this.condition);
        LOG.info((Object)("getAttackCountCompare sql:" + sql));
        Map<String, List<AttackCountCompare>> attacktTrendTemp = this.dao.findAttackCountCompare(sql, this.condition);
        if (!attacktTrendTemp.isEmpty()) {
            attacktTrend.putAll(attacktTrendTemp);
        }
        if (null != (attacktTrendTemp4UnCollect = this.processAttackCountCompare4UnCollect(cds)) && !attacktTrendTemp4UnCollect.isEmpty()) {
            for (Map.Entry<String, List<AttackCountCompare>> entry : attacktTrendTemp4UnCollect.entrySet()) {
                if (attacktTrend.containsKey(entry.getKey())) {
                    ((List)attacktTrend.get(entry.getKey())).addAll((Collection)entry.getValue());
                    continue;
                }
                attacktTrend.put(entry.getKey(), entry.getValue());
            }
        }
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getAttackCountCompare");
        return attacktTrend;
    }

    private Map<String, List<AttackCountCompare>> processAttackCountCompare4UnCollect(DataStatCondition cds) {
        Long time = cds.getEndTime() - cds.getStartTime();
        if (time + 1L >= 7L * CollectorConstants.ONE_DAY) {
            String countTimeStr = this.sysConfigDao.querySysValue("day_count_time");
            Long currentCollectTime = Long.parseLong(countTimeStr);
            if (currentCollectTime <= 0L) {
                currentCollectTime = TimeTransformer.transferWithoutHour(cds.getStartTime() - CollectorConstants.ONE_DAY);
            }
            if (currentCollectTime + CollectorConstants.ONE_DAY < cds.getStartTime()) {
                currentCollectTime = cds.getStartTime() - CollectorConstants.ONE_DAY;
            }
            if (cds.getEndTime() < currentCollectTime + CollectorConstants.ONE_DAY) {
                return null;
            }
            return this.processDayAttackCountCompare4UnCollect(currentCollectTime, cds, "day");
        }
        String countTimeStr = this.sysConfigDao.querySysValue("hour_count_time");
        Long currentCollectTime = Long.parseLong(countTimeStr);
        if (currentCollectTime <= 0L) {
            currentCollectTime = TimeTransformer.transferWithoutSecond(cds.getStartTime() - CollectorConstants.ONE_HOUR);
        }
        if (currentCollectTime + CollectorConstants.ONE_HOUR < cds.getStartTime()) {
            currentCollectTime = cds.getStartTime() - CollectorConstants.ONE_HOUR;
        }
        if (cds.getEndTime() < currentCollectTime + CollectorConstants.ONE_HOUR) {
            return null;
        }
        return this.processDayAttackCountCompare4UnCollect(currentCollectTime, cds, "hour");
    }

    private Map<String, List<AttackCountCompare>> processDayAttackCountCompare4UnCollect(Long currentCollectTime, DataStatCondition cds, String dataType) {
        HashMap<String, List<AttackCountCompare>> returnData = new HashMap<String, List<AttackCountCompare>>();
        Long endTime = cds.getEndTime();
        Long timeSpan = CollectorConstants.ONE_DAY;
        if (dataType.equals("hour")) {
            timeSpan = CollectorConstants.ONE_HOUR;
        }
        Long startDataTime = currentCollectTime + timeSpan;
        while (startDataTime < endTime) {
            Long endDataTime = startDataTime + timeSpan < endTime ? Long.valueOf(startDataTime + timeSpan) : endTime;
            Map<String, List<AttackCountCompare>> tempData = this.getAttackCounCompareData(startDataTime, endDataTime, cds);
            if (!tempData.isEmpty()) {
                for (Map.Entry<String, List<AttackCountCompare>> entry : tempData.entrySet()) {
                    if (returnData.containsKey(entry.getKey())) {
                        ((List)returnData.get(entry.getKey())).addAll((Collection)entry.getValue());
                        continue;
                    }
                    returnData.put(entry.getKey(), entry.getValue());
                }
            }
            startDataTime = startDataTime + timeSpan;
        }
        return returnData;
    }

    private Map<String, List<AttackCountCompare>> getAttackCounCompareData(Long startDataTime, Long endDataTime, DataStatCondition cds) {
        Map<String, List<AttackCountCompare>> returnData = null;
        AttackCountTrendUtil attackCountTrendUtil = new AttackCountTrendUtil();
        this.condition = new HashMap<Integer, Object>();
        String attackCountSql = attackCountTrendUtil.getAttackCountCompare4UnCollect(startDataTime, endDataTime, cds, this.condition);
        LOG.info((Object)("getAttackCounCompareData sql:" + attackCountSql));
        returnData = this.dao.findAttackCountCompare(attackCountSql, this.condition);
        return returnData;
    }

    @Override
    public Map<String, Map<String, Integer>> getTotalCount(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackCountCompare");
        HashMap<String, Map<String, Integer>> attacktData = new HashMap<String, Map<String, Integer>>();
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        if (cds.getDeviceId() > 0L) {
            CommonUtil.setIpToFormate(cds);
            this.processDeviceData(cds, attacktData);
        } else {
            for (String deviceIp : cds.getDeviceIpList()) {
                cds.setDeviceIp(deviceIp);
                CommonUtil.setIpToFormate(cds);
                this.processDeviceData(cds, attacktData);
            }
        }
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getAttackCountCompare");
        return attacktData;
    }

    private void processDeviceData(DataStatCondition cds, Map<String, Map<String, Integer>> attacktData) {
        AttackCountTrendUtil attackCountTrendUtil = new AttackCountTrendUtil();
        this.condition = new HashMap<Integer, Object>();
        String ipCountSql = attackCountTrendUtil.getAttackIpCountUtil(cds, this.condition);
        LOG.info((Object)("getIpAttackCount sql:" + ipCountSql));
        int ipCount = this.dao.findTotalCount(ipCountSql, this.condition);
        this.condition = new HashMap<Integer, Object>();
        String abnormalCountSql = attackCountTrendUtil.getAttackAndAbnormalEventCountUtil(cds, this.condition);
        LOG.info((Object)("abnormalCountSql sql:" + abnormalCountSql));
        int abnormalCount = this.dao.findTotalCount(abnormalCountSql, this.condition);
        this.condition = new HashMap<Integer, Object>();
        String attackCountSql = attackCountTrendUtil.getAttackEventCountUtil(cds, this.condition);
        LOG.info((Object)("attackCountSql sql:" + attackCountSql));
        int attackCount = this.dao.findTotalCount(attackCountSql, this.condition);
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        dataMap.put("ipCount", ipCount);
        dataMap.put("abnormalCount", abnormalCount);
        dataMap.put("attackCount", attackCount);
        attacktData.put(cds.getDeviceIp(), dataMap);
    }

    @Override
    public Map<String, List<AppFlow>> getAppFlowDis(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAppFlowDis");
        HashMap<String, List<AppFlow>> appFlow = new HashMap<String, List<AppFlow>>();
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        AppFlowDisUtil appFlowDisUtil = new AppFlowDisUtil();
        if (cds.getDeviceId() > 0L) {
            CommonUtil.setIpToFormate(cds);
            ArrayList<AppFlow> appFlowList = new ArrayList<AppFlow>();
            for (BizTypePoJo bizType : cds.getBizTypeList4App()) {
                if (bizType.getBizType().equalsIgnoreCase("DEFAULT")) continue;
                this.condition = new HashMap<Integer, Object>();
                String sql = appFlowDisUtil.getAppFlowDisEachType(cds, bizType, this.condition);
                if (CommonUtil.isNull(sql)) continue;
                LOG.info((Object)("getAppFlowDis sql bizType " + bizType.getBizType() + ":" + sql));
                List<AppFlow> appFlows = this.dao.findAppFlowDis(sql, bizType, this.condition);
                if (appFlows.isEmpty()) continue;
                appFlowList.addAll(appFlows);
            }
            appFlow.put(cds.getDeviceIp(), appFlowList);
        } else {
            for (String deviceIp : cds.getDeviceIpList()) {
                cds.setDeviceIp(deviceIp);
                cds.setBizTypeList4App(cds.getBizTypeMap4AppDevice().get(deviceIp));
                CommonUtil.setIpToFormate(cds);
                ArrayList<AppFlow> appFlowList = new ArrayList<AppFlow>();
                for (BizTypePoJo bizType : cds.getBizTypeList4App()) {
                    if (bizType.getBizType().equalsIgnoreCase("DEFAULT")) continue;
                    this.condition = new HashMap<Integer, Object>();
                    String sql = appFlowDisUtil.getAppFlowDisEachType(cds, bizType, this.condition);
                    if (CommonUtil.isNull(sql)) continue;
                    LOG.info((Object)("getAppFlowDis sql bizType " + bizType.getBizType() + ":" + sql));
                    List<AppFlow> appFlows = this.dao.findAppFlowDis(sql, bizType, this.condition);
                    if (appFlows.isEmpty()) continue;
                    appFlowList.addAll(appFlows);
                }
                appFlow.put(cds.getDeviceIp(), appFlowList);
            }
        }
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getAppFlowDis");
        return appFlow;
    }

    @Override
    public List<DashboardQueryBean> queryDashboardData(List<DashboardQueryBean> queryBeans) throws RemoteException {
        if (null == queryBeans || queryBeans.size() > 10000) {
            LOG.error((Object)"error input param");
            return null;
        }
        return DashboardEventHandler.getInstance().queryAllData(queryBeans);
    }

    @Override
    public List<DashboardQueryBean> querySecondFlowEvents(List<DashboardQueryBean> queryBeans) throws RemoteException {
        if (null == queryBeans || queryBeans.isEmpty()) {
            return null;
        }
        for (DashboardQueryBean bean : queryBeans) {
            SecondFLowHandler.getInstance().getSecondFlowEvent(bean);
        }
        return queryBeans;
    }

    @Override
    public RmiTuple<List<AttackExactLog>, Integer> getAttackExactLog4Portal(DataStatCondition cds, String sortField, String sortType) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackExactLog4Portal");
        AttackLogUtil util = new AttackLogUtil();
        CommonUtil.setIpToFormate(cds);
        this.condition = new HashMap<Integer, Object>();
        String baseSql = util.getAttackLogSql4Portal(cds, this.condition);
        String sumSql = new StringBuffer("SELECT COUNT(1) ATT_NUM FROM (").append(baseSql).append(") A").toString();
        StringBuffer baseBuffer = new StringBuffer(baseSql);
        int startRow = cds.getStartRow();
        int limit = cds.getLimit();
        if (null != sortField && !"".equals(sortField) && null != sortType && !"".equals(sortType)) {
            String dataBaseColumn = CollectorConstants.getAttackLog().get(sortField);
            if (null != dataBaseColumn && !"".equals(dataBaseColumn)) {
                String regular = "^[A-Za-z0-9|_]+$";
                if (Pattern.matches(regular, dataBaseColumn)) {
                    baseBuffer.append(" order by ").append(dataBaseColumn).append("DESC".equalsIgnoreCase(sortType) ? " desc" : "");
                }
            } else {
                baseBuffer.append(" order by START_TIME_ALERT DESC ");
            }
        } else {
            baseBuffer.append(" order by START_TIME_ALERT DESC ");
        }
        baseBuffer.append(" LIMIT ").append(startRow).append(',').append(limit);
        String limitSql = baseBuffer.toString();
        LOG.info((Object)("getAttackExactLog4Portal limitSql:" + limitSql));
        LOG.info((Object)("getAttackExactLog4Portal sumSql:" + sumSql));
        List<AttackExactLog> aels = this.dao.findAttackExactLog(limitSql, this.condition);
        int totalSize = this.dao.findTotalCount(sumSql, this.condition);
        return new RmiTuple<List<AttackExactLog>, Integer>(aels, totalSize);
    }

    @Override
    public Map<String, List<IpLocationTopN>> getIpLocationGraph(DataStatCondition cds, IpLocationTopN form) {
        if (null == cds || !cds.isValid() || null == form) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getIpLocationTopNGraph");
        Map<String, List<IpLocationTopN>> map = null;
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        this.condition = new HashMap<Integer, Object>();
        TopNUtil util = new TopNUtil();
        String sql = util.getIpLocationGraphSql(cds, form, this.condition);
        LOG.info((Object)("getIpLocationTopNGraph topn sql : " + sql));
        map = this.dao.findIpLocationGraph(sql, this.condition);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getIpLocationTopNGraph");
        return map;
    }

    @Override
    public Map<String, List<IpLocationTopN>> getIpLocationTopNGraph(DataStatCondition cds, IpLocationTopN form) {
        if (null == cds || !cds.isValid() || null == form) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getIpLocationTopNGraph");
        Map<String, List<IpLocationTopN>> map = null;
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        this.condition = new HashMap<Integer, Object>();
        TopNUtil util = new TopNUtil();
        String sql = util.getIpLocationTopNGraphSql(cds, form, this.condition);
        LOG.info((Object)("getIpLocationTopNGraph topn sql : " + sql));
        map = this.dao.findIpLocationTopNGraph(sql, this.condition);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getIpLocationTopNGraph");
        return map;
    }

    @Override
    public Map<String, List<IpLocationTopN>> getIpLocationTopNTable(DataStatCondition cds) {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getIpLocationTopNTable");
        Map<String, List<IpLocationTopN>> map = null;
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        TopNUtil util = new TopNUtil();
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getIpLocationTopNTableSql(cds, this.condition);
        LOG.info((Object)("getIpLocationTopNTableSql topn sql : " + sql));
        map = this.dao.findIpLocationTopNTable(sql, this.condition);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getIpLocationTopNTable");
        return map;
    }

    @Override
    public List<FlowTopNObj> queryDashBoardTopnData(FlowTopNObj flowTopNObj, boolean isAdmin, List<Long> zoneIds) throws RemoteException {
        if (null == flowTopNObj) {
            LOG.error((Object)"error input param, flowTopNObj is null");
            return new ArrayList<FlowTopNObj>();
        }
        ArrayList<FlowTopNObj> flowTopNList = new ArrayList<FlowTopNObj>();
        String deviceIp = flowTopNObj.getDeviceIp();
        AlarmThread alarmThread = AlarmThread.getInstance();
        Map<IpInfoKey, IpFlowInfo> ipFlow70secMap = alarmThread.getIpFlow70secMapOfDev(deviceIp);
        if (null == ipFlow70secMap || ipFlow70secMap.isEmpty()) {
            LOG.error((Object)("queryDashBoardTopnData: get ipFlow70secMap return empty of deviceIp=" + deviceIp));
            return new ArrayList<FlowTopNObj>();
        }
        int deviceType = flowTopNObj.getDevType();
        long zoneId = flowTopNObj.getZoneId();
        int direction = flowTopNObj.getDirection();
        int topnType = flowTopNObj.getTopnType();
        for (Map.Entry<IpInfoKey, IpFlowInfo> entry : ipFlow70secMap.entrySet()) {
            boolean checkFlowType = false;
            if (!(2 != topnType && 3 != topnType && 4 != topnType || entry.getValue().isZoneType())) {
                checkFlowType = true;
            }
            if (1 == topnType && entry.getValue().isZoneType()) {
                checkFlowType = true;
            }
            if (!checkFlowType || direction != entry.getKey().getDirection()) continue;
            int tempDeviceType = entry.getKey().getDeviceType();
            long tempZoneId = entry.getKey().getZoneId();
            if (deviceType != tempDeviceType) continue;
            if (zoneId > 0L && zoneId == tempZoneId) {
                this.setFlowTopNObj(entry, flowTopNObj, flowTopNList);
                continue;
            }
            if (zoneId != 0L) continue;
            if (isAdmin) {
                this.setFlowTopNObj(entry, flowTopNObj, flowTopNList);
                continue;
            }
            if (null == zoneIds || zoneIds.isEmpty() || zoneIds.size() > 10000) {
                return new ArrayList<FlowTopNObj>();
            }
            if (!zoneIds.contains(tempZoneId)) continue;
            this.setFlowTopNObj(entry, flowTopNObj, flowTopNList);
        }
        return this.countTopNFlowData(flowTopNList);
    }

    private void setFlowTopNObj(Map.Entry<IpInfoKey, IpFlowInfo> entry, FlowTopNObj flowTopNObj, List<FlowTopNObj> flowTopNList) {
        long inKbps = entry.getValue().getCurrInKbps();
        long inPps = entry.getValue().getCurrInPps();
        long maxInKbps = entry.getValue().getMaxInKbps();
        long maxInPps = entry.getValue().getMaxInPps();
        long dropKbps = entry.getValue().getCurrDropKbps();
        long dropPps = entry.getValue().getCurrDropPps();
        long maxDropKbps = entry.getValue().getMaxDropKbps();
        long maxDropPps = entry.getValue().getMaxDropPps();
        long currConn = entry.getValue().getCurrConn();
        long newConn = entry.getValue().getNewConn();
        long maxCurrConn = entry.getValue().getMaxCurrConn();
        long maxNewConn = entry.getValue().getMaxNewConn();
        long maxForwardKbps = entry.getValue().getMaxForwardKbps();
        long maxForwardPps = entry.getValue().getMaxForwardPps();
        FlowTopNObj temp = null;
        temp = flowTopNObj.getFlowTopNObjCopy();
        temp.setZoneId(entry.getKey().getZoneId());
        if (entry.getKey().getLocationId() >= 0L) {
            temp.setLocationId(entry.getKey().getLocationId());
        } else {
            temp.setLocationId(-1L);
        }
        temp.setDirection(entry.getKey().getDirection());
        temp.setZoneIp(entry.getKey().getZoneIp());
        temp.setInKbps(inKbps);
        temp.setInPps(inPps);
        temp.setMaxInKbps(maxInKbps);
        temp.setMaxInPps(maxInPps);
        temp.setDropKbps(dropKbps);
        temp.setDropPps(dropPps);
        temp.setMaxDropKbps(maxDropKbps);
        temp.setMaxDropPps(maxDropPps);
        temp.setCurrConn(currConn);
        temp.setNewConn(newConn);
        temp.setMaxCurrConn(maxCurrConn);
        temp.setMaxNewConn(maxNewConn);
        temp.setMaxForwardKbps(maxForwardKbps);
        temp.setMaxForwardPps(maxForwardPps);
        flowTopNList.add(temp);
    }

    private List<FlowTopNObj> countTopNFlowData(List<FlowTopNObj> flowTopNList) {
        ArrayList<FlowTopNObj> returnListData = new ArrayList<FlowTopNObj>();
        if (null == flowTopNList || flowTopNList.isEmpty()) {
            LOG.error((Object)"There is not iPFlow to match query conditon.");
            return returnListData;
        }
        int topnType = flowTopNList.get(0).getTopnType();
        ArrayList<FlowTopNObj> tempListData = new ArrayList<FlowTopNObj>();
        if (topnType == 1) {
            for (FlowTopNObj temp : flowTopNList) {
                if (temp.getLocationId() >= 0L) continue;
                tempListData.add(temp);
            }
            for (int i = 0; i < tempListData.size(); ++i) {
                for (int j = tempListData.size() - 1; j > i; --j) {
                    if (((FlowTopNObj)tempListData.get(i)).getZoneId() != ((FlowTopNObj)tempListData.get(j)).getZoneId()) continue;
                    ((FlowTopNObj)tempListData.get(i)).setInKbps(((FlowTopNObj)tempListData.get(i)).getInKbps() + ((FlowTopNObj)tempListData.get(j)).getInKbps());
                    ((FlowTopNObj)tempListData.get(i)).setMaxInKbps(((FlowTopNObj)tempListData.get(i)).getMaxInKbps() + ((FlowTopNObj)tempListData.get(j)).getMaxInKbps());
                    ((FlowTopNObj)tempListData.get(i)).setDropKbps(((FlowTopNObj)tempListData.get(i)).getDropKbps() + ((FlowTopNObj)tempListData.get(j)).getDropKbps());
                    ((FlowTopNObj)tempListData.get(i)).setMaxDropKbps(((FlowTopNObj)tempListData.get(i)).getMaxDropKbps() + ((FlowTopNObj)tempListData.get(j)).getMaxDropKbps());
                    ((FlowTopNObj)tempListData.get(i)).setInPps(((FlowTopNObj)tempListData.get(i)).getInPps() + ((FlowTopNObj)tempListData.get(j)).getInPps());
                    ((FlowTopNObj)tempListData.get(i)).setMaxInPps(((FlowTopNObj)tempListData.get(i)).getMaxInPps() + ((FlowTopNObj)tempListData.get(j)).getMaxInPps());
                    ((FlowTopNObj)tempListData.get(i)).setDropPps(((FlowTopNObj)tempListData.get(i)).getDropPps() + ((FlowTopNObj)tempListData.get(j)).getDropPps());
                    ((FlowTopNObj)tempListData.get(i)).setMaxDropPps(((FlowTopNObj)tempListData.get(i)).getMaxDropPps() + ((FlowTopNObj)tempListData.get(j)).getMaxDropPps());
                    ((FlowTopNObj)tempListData.get(i)).setCurrConn(((FlowTopNObj)tempListData.get(i)).getCurrConn() + ((FlowTopNObj)tempListData.get(j)).getCurrConn());
                    ((FlowTopNObj)tempListData.get(i)).setMaxCurrConn(((FlowTopNObj)tempListData.get(i)).getMaxCurrConn() + ((FlowTopNObj)tempListData.get(j)).getMaxCurrConn());
                    ((FlowTopNObj)tempListData.get(i)).setNewConn(((FlowTopNObj)tempListData.get(i)).getNewConn() + ((FlowTopNObj)tempListData.get(j)).getNewConn());
                    ((FlowTopNObj)tempListData.get(i)).setMaxNewConn(((FlowTopNObj)tempListData.get(i)).getMaxNewConn() + ((FlowTopNObj)tempListData.get(j)).getMaxNewConn());
                    ((FlowTopNObj)tempListData.get(i)).setMaxForwardKbps(((FlowTopNObj)tempListData.get(i)).getMaxForwardKbps() + ((FlowTopNObj)tempListData.get(j)).getMaxForwardKbps());
                    ((FlowTopNObj)tempListData.get(i)).setMaxForwardPps(((FlowTopNObj)tempListData.get(i)).getMaxForwardPps() + ((FlowTopNObj)tempListData.get(j)).getMaxForwardPps());
                    tempListData.remove(j);
                }
            }
        } else if (topnType == 2 || topnType == 4) {
            for (FlowTopNObj temp : flowTopNList) {
                if (temp.getLocationId() >= 0L || CommonUtil.isNull(temp.getZoneIp())) continue;
                tempListData.add(temp);
            }
        } else if (topnType == 3) {
            for (FlowTopNObj temp : flowTopNList) {
                if (temp.getLocationId() < 0L) continue;
                tempListData.add(temp);
            }
            for (int i = 0; i < tempListData.size(); ++i) {
                for (int j = tempListData.size() - 1; j > i; --j) {
                    if (((FlowTopNObj)tempListData.get(i)).getLocationId() != ((FlowTopNObj)tempListData.get(j)).getLocationId()) continue;
                    ((FlowTopNObj)tempListData.get(i)).setInKbps(((FlowTopNObj)tempListData.get(i)).getInKbps() + ((FlowTopNObj)tempListData.get(j)).getInKbps());
                    ((FlowTopNObj)tempListData.get(i)).setMaxInKbps(((FlowTopNObj)tempListData.get(i)).getMaxInKbps() + ((FlowTopNObj)tempListData.get(j)).getMaxInKbps());
                    ((FlowTopNObj)tempListData.get(i)).setDropKbps(((FlowTopNObj)tempListData.get(i)).getDropKbps() + ((FlowTopNObj)tempListData.get(j)).getDropKbps());
                    ((FlowTopNObj)tempListData.get(i)).setMaxDropKbps(((FlowTopNObj)tempListData.get(i)).getMaxDropKbps() + ((FlowTopNObj)tempListData.get(j)).getMaxDropKbps());
                    ((FlowTopNObj)tempListData.get(i)).setInPps(((FlowTopNObj)tempListData.get(i)).getInPps() + ((FlowTopNObj)tempListData.get(j)).getInPps());
                    ((FlowTopNObj)tempListData.get(i)).setMaxInPps(((FlowTopNObj)tempListData.get(i)).getMaxInPps() + ((FlowTopNObj)tempListData.get(j)).getMaxInPps());
                    ((FlowTopNObj)tempListData.get(i)).setDropPps(((FlowTopNObj)tempListData.get(i)).getDropPps() + ((FlowTopNObj)tempListData.get(j)).getDropPps());
                    ((FlowTopNObj)tempListData.get(i)).setMaxDropPps(((FlowTopNObj)tempListData.get(i)).getMaxDropPps() + ((FlowTopNObj)tempListData.get(j)).getMaxDropPps());
                    ((FlowTopNObj)tempListData.get(i)).setCurrConn(((FlowTopNObj)tempListData.get(i)).getCurrConn() + ((FlowTopNObj)tempListData.get(j)).getCurrConn());
                    ((FlowTopNObj)tempListData.get(i)).setMaxCurrConn(((FlowTopNObj)tempListData.get(i)).getMaxCurrConn() + ((FlowTopNObj)tempListData.get(j)).getMaxCurrConn());
                    ((FlowTopNObj)tempListData.get(i)).setNewConn(((FlowTopNObj)tempListData.get(i)).getNewConn() + ((FlowTopNObj)tempListData.get(j)).getNewConn());
                    ((FlowTopNObj)tempListData.get(i)).setMaxNewConn(((FlowTopNObj)tempListData.get(i)).getMaxNewConn() + ((FlowTopNObj)tempListData.get(j)).getMaxNewConn());
                    ((FlowTopNObj)tempListData.get(i)).setMaxForwardKbps(((FlowTopNObj)tempListData.get(i)).getMaxForwardKbps() + ((FlowTopNObj)tempListData.get(j)).getMaxForwardKbps());
                    ((FlowTopNObj)tempListData.get(i)).setMaxForwardPps(((FlowTopNObj)tempListData.get(i)).getMaxForwardPps() + ((FlowTopNObj)tempListData.get(j)).getMaxForwardPps());
                    tempListData.remove(j);
                }
            }
        }
        Collections.sort(tempListData, new ComparatorImpl());
        int count = 100 < tempListData.size() ? 100 : tempListData.size();
        FlowTopNObj inFlowInfo = null;
        for (int i = 0; i < count; ++i) {
            inFlowInfo = ((FlowTopNObj)tempListData.get(i)).getFlowTopNObjCopy();
            inFlowInfo.setIndex(i + 1);
            returnListData.add(inFlowInfo);
        }
        return returnListData;
    }

    @Override
    public List<AttackLog> getCur10AttackIpLog(List<String> deviceIpList, List<Long> zoneIdList) {
        List<AttackLog> returnAttackLogs = null;
        LOG.info((Object)"start getCur10AttackIpLog");
        long tempNum = this.intRandom.nextInt();
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != zoneIdList && !zoneIdList.isEmpty() && zoneIdList.size() < 10000) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(zoneIdList, tempNum);
        }
        AttackLogUtil util = new AttackLogUtil();
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getCur10AttackLogSql(deviceIpList, zoneIdList, tempNum, this.condition);
        LOG.info((Object)("Cur10AttackIpLog: " + sql));
        returnAttackLogs = this.dao.findCur10AttackLog(sql, this.condition);
        if (null != zoneIdList && !zoneIdList.isEmpty() && zoneIdList.size() < 10000) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(tempNum);
        }
        LOG.info((Object)"end getCur10AttackIpLog");
        return returnAttackLogs;
    }

    @Override
    public AttackExactLog getAttackSrcFlow(Long attackExactLogPkid) throws RemoteException {
        LOG.info((Object)"start getAttackSrcFlow");
        AttackLogUtil util = new AttackLogUtil();
        LOG.info((Object)("getAttackExactLogId attackExactLogPkid: " + attackExactLogPkid));
        HashMap<Integer, Object> condition4Para = new HashMap<Integer, Object>();
        String sql = util.getAttackExactLogSql(String.valueOf(attackExactLogPkid), 0, condition4Para);
        LOG.info((Object)("getAttackExactLog sql:" + sql));
        List<AttackExactLog> aels = this.dao.findAttackExactLog(sql, condition4Para);
        if (aels.isEmpty()) {
            return new AttackExactLog();
        }
        LOG.info((Object)"end getAttackExactLog");
        return aels.get(0);
    }

    @Override
    public Map<String, List<AttackFlowPeakTopN>> getIpAttackFlowPeakTopN(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getIpAttackTimeTopN");
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        TopNUtil util = new TopNUtil();
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getIpAttackFlowPeakTopNSql(cds, this.condition);
        LOG.info((Object)("IpAttackFlowFeakTopN sql :" + sql));
        Map<String, List<AttackFlowPeakTopN>> ipAttackMap = this.dao.findIpAttackFlowPeakTopN(sql, this.condition);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getIpAttackFlowFeakTopN");
        return ipAttackMap;
    }

    @Override
    public Map<String, List<AttackFlowPeakTopN>> getZoneAttackFlowPeakTopN(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getZoneAttackFlowFeakTopN");
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        TopNUtil util = new TopNUtil();
        CommonUtil.setIpToFormate(cds);
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getZoneAttackFlowPeakTopNSql(cds, this.condition);
        LOG.info((Object)("ZoneAttackFlowFeakTopN sql :" + sql));
        Map<String, List<AttackFlowPeakTopN>> zoneAttackTimeMap = this.dao.findZoneAttackFlowPeakTopN(sql, this.condition);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getZoneAttackFlowFeakTopN");
        return zoneAttackTimeMap;
    }

    @Override
    public List<AttackTrend> getAttackTypeAnalysis(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackTypeAnalysis");
        List<AttackTrend> attacktTrends = null;
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        AttackTrendUtil attackTrendUtil = new AttackTrendUtil();
        this.condition = new HashMap<Integer, Object>();
        String sql = attackTrendUtil.getAttackTypeAnalysis(cds, this.condition);
        LOG.info((Object)("AttackTypeAnalysis sql:" + sql));
        LOG.info((Object)("AttackTypeAnalysis condition:" + this.condition.toString()));
        attacktTrends = this.dao.findAttackTypeAnalysis(sql, this.condition);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getAttackTrend");
        return attacktTrends;
    }

    @Override
    public List<AttackExactLog> getAbnormalOrAttackCount(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAbnormalOrAttackCount");
        List<AttackExactLog> attackLog = null;
        cds.setStartTime(this.getRealStartTime(cds.getStartTime(), cds.getEndTime()));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        AttackLogUtil util = new AttackLogUtil();
        this.condition = new HashMap<Integer, Object>();
        String sql = util.getAbnormalOrAttackCountSql(cds, this.condition);
        LOG.info((Object)("AbnormalOrAttackCount sql:" + sql));
        LOG.info((Object)("AbnormalOrAttackCount condition:" + this.condition.toString()));
        attackLog = this.dao.getAbnormalOrAttackCount(sql, this.condition);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getAbnormalOrAttackCount");
        return attackLog;
    }

    @Override
    public List<AttackExactLog> getAttackTypeLog(DataStatCondition cds, String sortField, String sortType) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackTypeLog");
        CommonUtil.setIpToFormate(cds);
        this.condition = new HashMap<Integer, Object>();
        AttackLogUtil util = new AttackLogUtil();
        String sql = util.getAttackTypeLogSql(cds, sortField, sortType, this.condition);
        LOG.info((Object)("AttackTypeLog: " + sql));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        List<AttackExactLog> aks = this.dao.findAttackExactLog(sql, this.condition);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        if (aks.isEmpty()) {
            return null;
        }
        LOG.info((Object)"end getAttackTypeLog");
        return aks;
    }

    @Override
    public Integer getAttackTypeLogNum(DataStatCondition cds) throws RemoteException {
        if (null == cds || !cds.isValid()) {
            LOG.error((Object)"input cds is error.");
            return null;
        }
        LOG.info((Object)"start getAttackTypeLogNum");
        CommonUtil.setIpToFormate(cds);
        this.condition = new HashMap<Integer, Object>();
        AttackLogUtil util = new AttackLogUtil();
        String sql = util.getAttackTypeLogNumSql(cds, this.condition);
        LOG.info((Object)("getAttackTypeLogNum: " + sql));
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(cds.getZoneIdList(), cds.getSessionId());
        }
        Integer num = this.dao.findAttackLogNum(sql, this.condition);
        if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(cds.getSessionId());
        }
        LOG.info((Object)"end getAttackTypeLogNum");
        return num;
    }

    private static class ComparatorImpl<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 6243067077503407012L;

        private ComparatorImpl() {
        }

        @Override
        public int compare(T t1, T t2) {
            long o1Flow = 0L;
            long o2Flow = 0L;
            FlowTopNObj o1 = null;
            FlowTopNObj o2 = null;
            if (!(t1 instanceof FlowTopNObj) || !(t2 instanceof FlowTopNObj)) {
                return -2;
            }
            o1 = (FlowTopNObj)t1;
            o2 = (FlowTopNObj)t2;
            if (o1.getInOrDrop() == 1) {
                if (o1.getAvgOrPeak() == 1) {
                    if (o1.getUnit() == 1) {
                        o1Flow = o1.getInKbps();
                        o2Flow = o2.getInKbps();
                    } else if (o1.getUnit() == 2) {
                        o1Flow = o1.getInPps();
                        o2Flow = o2.getInPps();
                    } else if (o1.getUnit() == 3) {
                        o1Flow = o1.getCurrConn();
                        o2Flow = o2.getCurrConn();
                    } else if (o1.getUnit() == 4) {
                        o1Flow = o1.getNewConn();
                        o2Flow = o2.getNewConn();
                    }
                } else if (o1.getUnit() == 1) {
                    o1Flow = o1.getMaxInKbps();
                    o2Flow = o2.getMaxInKbps();
                } else if (o1.getUnit() == 2) {
                    o1Flow = o1.getMaxInPps();
                    o2Flow = o2.getMaxInPps();
                } else if (o1.getUnit() == 3) {
                    o1Flow = o1.getMaxCurrConn();
                    o2Flow = o2.getMaxCurrConn();
                } else if (o1.getUnit() == 4) {
                    o1Flow = o1.getMaxNewConn();
                    o2Flow = o2.getMaxNewConn();
                }
            } else if (o1.getAvgOrPeak() == 1) {
                if (o1.getUnit() == 1) {
                    o1Flow = o1.getDropKbps();
                    o2Flow = o2.getDropKbps();
                } else if (o1.getUnit() == 2) {
                    o1Flow = o1.getDropPps();
                    o2Flow = o2.getDropPps();
                } else if (o1.getUnit() == 3) {
                    o1Flow = o1.getCurrConn();
                    o2Flow = o2.getCurrConn();
                } else if (o1.getUnit() == 4) {
                    o1Flow = o1.getNewConn();
                    o2Flow = o2.getNewConn();
                }
            } else if (o1.getUnit() == 1) {
                o1Flow = o1.getMaxDropKbps();
                o2Flow = o2.getMaxDropKbps();
            } else if (o1.getUnit() == 2) {
                o1Flow = o1.getMaxDropPps();
                o2Flow = o2.getMaxDropPps();
            } else if (o1.getUnit() == 3) {
                o1Flow = o1.getMaxCurrConn();
                o2Flow = o2.getMaxCurrConn();
            } else if (o1.getUnit() == 4) {
                o1Flow = o1.getMaxNewConn();
                o2Flow = o2.getMaxNewConn();
            }
            return o1Flow > o2Flow ? -1 : (o1Flow == o2Flow ? 0 : 1);
        }
    }
}

