/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.entity.log.FlowCompareCondition;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.rmi.FlowCompareQueryType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FlowCompareQueryTypeWithBiz
extends FlowCompareQueryType {
    private static final long serialVersionUID = 4227390653882691073L;

    @Override
    public String getFlowCompareSQL(FlowCompareCondition condition, Map<Integer, Object> sqlCondition) {
        StringBuffer sql = new StringBuffer();
        List<String> tableNameList = CollectorConstants.getType4AndTypesTableNamsMap().get(condition.getQueryType());
        this.getFlowCompareSQL0(condition, sql, tableNameList, sqlCondition);
        return sql.toString();
    }

    private void getFlowCompareSQL0(FlowCompareCondition flowCompareCondition, StringBuffer sql, List<String> tableNameList, Map<Integer, Object> sqlCondition) {
        Integer bisType = flowCompareCondition.getBizType();
        switch (bisType) {
            case 0: {
                this.processDefaultBiz(flowCompareCondition, sql, tableNameList, sqlCondition);
                break;
            }
            case 1: {
                this.processTcpBiz(flowCompareCondition, sql, tableNameList, sqlCondition);
                break;
            }
            case 2: {
                this.processUdpBiz(flowCompareCondition, sql, tableNameList, sqlCondition);
                break;
            }
            case 3: {
                this.processHttpBiz(flowCompareCondition, sql, tableNameList, sqlCondition);
                break;
            }
            case 4: {
                this.processHttpsBiz(flowCompareCondition, sql, tableNameList, sqlCondition);
                break;
            }
            case 5: {
                this.processTcpDnsBiz(flowCompareCondition, sql, tableNameList, sqlCondition);
                break;
            }
            case 6: {
                this.processUdpDnsBiz(flowCompareCondition, sql, tableNameList, sqlCondition);
                break;
            }
            case 7: {
                this.processSipBiz(flowCompareCondition, sql, tableNameList, sqlCondition);
                break;
            }
            case 8: {
                this.processOtherBiz(flowCompareCondition, sql, tableNameList, sqlCondition);
                break;
            }
        }
    }

    private void processDefaultBiz(FlowCompareCondition flowCompareCondition, StringBuffer sql, List<String> tableNameList, Map<Integer, Object> sqlCondition) {
        int index = 1;
        String protocol = "";
        switch (flowCompareCondition.getBizId().intValue()) {
            case -2: {
                protocol = "HTTP";
                break;
            }
            case -3: {
                protocol = "HTTPS";
                break;
            }
            case -4: {
                protocol = "DNS_REQUSET";
                break;
            }
            case -5: {
                protocol = "SIP_INVITE";
                break;
            }
            default: {
                protocol = "TOTAL";
            }
        }
        if ("DNS_REQUSET".equalsIgnoreCase(protocol) && "reply".equalsIgnoreCase(flowCompareCondition.getRequestOrReply())) {
            protocol = "DNS_REPLY";
        }
        String unit = "";
        unit = "SIP_INVITE".equalsIgnoreCase(protocol) && 2 == flowCompareCondition.getUnit() ? "QPS" : (("DNS_REQUSET".equalsIgnoreCase(protocol) || "DNS_REPLY".equals(protocol)) && 2 == flowCompareCondition.getUnit() ? "PPS" : CollectorConstants.getUnitMap().get(flowCompareCondition.getUnit()));
        sql.append(" select t1.LOG_TIME, ");
        sql.append(" t1.DEVICE_IP, ");
        if (this.timeTypeOne(flowCompareCondition)) {
            sql.append("SUM(t1.").append(protocol).append('_').append(unit).append("), ");
            sql.append("MAX(t2.").append(protocol).append('_').append(unit).append("), ");
            sql.append("SUM(t3.").append(protocol).append('_').append(unit).append("), ");
            sql.append("MAX(t4.").append(protocol).append('_').append(unit).append("), ");
            sql.append("MAX(t5.").append(protocol).append('_').append(unit).append(") ");
            sql.append(" from ").append(tableNameList.get(0)).append(" t1 ");
            sql.append(" left outer join ").append(tableNameList.get(103)).append(" t2 ");
            sql.append("on t1.LOG_TIME = t2.LOG_TIME");
            sql.append(" and t1.DEVICE_IP = t2.DEVICE_IP");
            sql.append(" and t1.DEVICE_TYPE = t2.DEVICE_TYPE");
            this.appendLeftCondition(flowCompareCondition, sql, "t1", "t2");
            sql.append(" left outer join ").append(tableNameList.get(38)).append(" t3 ");
            sql.append("on t2.LOG_TIME = t3.LOG_TIME");
            sql.append(" and t2.DEVICE_IP = t3.DEVICE_IP");
            sql.append(" and t2.DEVICE_TYPE = t3.DEVICE_TYPE");
            this.appendLeftCondition(flowCompareCondition, sql, "t2", "t3");
            sql.append(" left outer join ").append(tableNameList.get(104)).append(" t4 ");
            sql.append("on t3.LOG_TIME = t4.LOG_TIME");
            sql.append(" and t3.DEVICE_IP = t4.DEVICE_IP");
            sql.append(" and t3.DEVICE_TYPE = t4.DEVICE_TYPE");
            this.appendLeftCondition(flowCompareCondition, sql, "t3", "t4");
            sql.append(" left outer join ").append(tableNameList.get(108)).append(" t5 ");
            sql.append("on t1.LOG_TIME = t5.LOG_TIME");
            sql.append(" and t1.DEVICE_IP = t5.DEVICE_IP");
            sql.append(" and t1.DEVICE_TYPE = t5.DEVICE_TYPE");
            this.appendLeftCondition(flowCompareCondition, sql, "t1", "t5");
        } else {
            sql.append("SUM(t1.").append(protocol).append('_').append(unit).append("), ");
            sql.append("MAX(t1.MAX").append(protocol.equals("TOTAL") ? "" : '_' + protocol).append('_').append(unit).append("), ");
            sql.append("SUM(t2.").append(protocol).append('_').append(unit).append("), ");
            sql.append("MAX(t2.MAX").append(protocol.equals("TOTAL") ? "" : '_' + protocol).append('_').append(unit).append("), ");
            sql.append("MAX(t3.MAX").append(protocol.equals("TOTAL") ? "" : '_' + protocol).append('_').append(unit).append(") ");
            if (this.timeTypeTwo(flowCompareCondition)) {
                sql.append(" from ").append(tableNameList.get(1)).append(" t1 left outer join ");
                sql.append(tableNameList.get(39)).append(" t2 ");
            } else {
                sql.append(" from ").append(tableNameList.get(2)).append(" t1 left outer join ");
                sql.append(tableNameList.get(40)).append(" t2 ");
            }
            sql.append("on t1.LOG_TIME = t2.LOG_TIME");
            sql.append(" and t1.DEVICE_IP = t2.DEVICE_IP");
            sql.append(" and t1.DEVICE_TYPE = t2.DEVICE_TYPE");
            this.appendLeftCondition(flowCompareCondition, sql, "t1", "t2");
            if (this.timeTypeTwo(flowCompareCondition)) {
                sql.append(" left outer join ");
                sql.append(tableNameList.get(106)).append(" t3 ");
            } else {
                sql.append(" left outer join ");
                sql.append(tableNameList.get(107)).append(" t3 ");
            }
            sql.append("on t1.LOG_TIME = t3.LOG_TIME");
            sql.append(" and t1.DEVICE_IP = t3.DEVICE_IP");
            sql.append(" and t1.DEVICE_TYPE = t3.DEVICE_TYPE");
            this.appendLeftCondition(flowCompareCondition, sql, "t1", "t3");
        }
        List<Object> list = this.appendSqlWhere(flowCompareCondition, sql, "t1", true);
        for (Object object : list) {
            sqlCondition.put(index++, object);
        }
    }

    private void processTcpBiz(FlowCompareCondition flowCompareCondition, StringBuffer sql, List<String> tableNameList, Map<Integer, Object> sqlCondition) {
        int index = 1;
        String protocol = CollectorConstants.getProtocolMap().get(flowCompareCondition.getProtocol());
        String unit = CollectorConstants.getUnitMap().get(flowCompareCondition.getUnit());
        sql.append("select tt.LOG_TIME, ");
        sql.append("tt.DEVICE_IP, ");
        sql.append("tt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("1, ");
        sql.append("tt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("2, ");
        sql.append("ttt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("1, ");
        sql.append("ttt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("2, ");
        sql.append("ttt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(' ');
        sql.append("from (select t1.DEVICE_IP, t1.LOG_TIME, ");
        sql.append(" SUM(t1.").append(protocol.equals("TCP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("1, ");
        sql.append(" MAX(t2.").append(protocol.equals("TCP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("2 ");
        if (this.timeTypeOne(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(3));
            sql.append(" t1, ").append(tableNameList.get(87)).append(" t2");
        } else if (this.timeTypeTwo(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(4));
            sql.append(" t1, ").append(tableNameList.get(6)).append(" t2");
        } else {
            sql.append("from ").append(tableNameList.get(5));
            sql.append(" t1, ").append(tableNameList.get(7)).append(" t2 ");
        }
        sql.append(" where t1.LOG_TIME = t2.LOG_TIME");
        sql.append(" and t1.DEVICE_IP = t2.DEVICE_IP");
        sql.append(" and t1.DEVICE_TYPE = t2.DEVICE_TYPE");
        this.appendLeftCondition(flowCompareCondition, sql, "t1", "t2");
        List<Object> temList = this.appendSqlWhere(flowCompareCondition, sql, "t1", false);
        for (Object object : temList) {
            sqlCondition.put(index++, object);
        }
        sql.append(" ) as tt left outer join (");
        sql.append("select t3.DEVICE_IP, t3.LOG_TIME, ");
        sql.append(" SUM(t3.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append(") as ").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("1, ");
        sql.append(" MAX(t4.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append(") as ").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("2, ");
        sql.append(" SUM(t3.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(')').append(" as ").append(protocol.equals("TCP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(' ');
        if (this.timeTypeOne(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(41));
            sql.append(" t3, ").append(tableNameList.get(96)).append(" t4");
        } else if (this.timeTypeTwo(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(42));
            sql.append(" t3, ").append(tableNameList.get(59)).append(" t4");
        } else {
            sql.append("from ").append(tableNameList.get(43));
            sql.append(" t3, ").append(tableNameList.get(60)).append(" t4");
        }
        sql.append(" where t3.LOG_TIME = t4.LOG_TIME");
        sql.append(" and t3.DEVICE_IP = t4.DEVICE_IP");
        sql.append(" and t3.DEVICE_TYPE = t4.DEVICE_TYPE");
        this.appendLeftCondition(flowCompareCondition, sql, "t3", "t4");
        List<Object> tempList = this.appendSqlWhere(flowCompareCondition, sql, "t3", false);
        for (Object object : tempList) {
            sqlCondition.put(index++, object);
        }
        sql.append(" )");
        sql.append(" as ttt on ttt.DEVICE_IP = tt.DEVICE_IP");
        sql.append(" and ttt.LOG_TIME = tt.LOG_TIME");
    }

    private void processUdpBiz(FlowCompareCondition flowCompareCondition, StringBuffer sql, List<String> tableNameList, Map<Integer, Object> sqlCondition) {
        int index = 1;
        String protocol = CollectorConstants.getProtocolMap().get(flowCompareCondition.getProtocol());
        String unit = CollectorConstants.getUnitMap().get(flowCompareCondition.getUnit());
        sql.append("select tt.LOG_TIME, ");
        sql.append("tt.DEVICE_IP, ");
        sql.append("tt.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_').append(unit).append("1, ");
        sql.append("tt.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_').append(unit).append("2, ");
        sql.append("ttt.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_').append(unit).append("1, ");
        sql.append("ttt.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_').append(unit).append("2, ");
        sql.append("ttt.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(' ');
        sql.append("from (select t1.DEVICE_IP, t1.LOG_TIME, ");
        sql.append(" SUM(t1.").append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ");
        sql.append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("1, ");
        sql.append(" MAX(t2.").append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ");
        sql.append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("2 ");
        if (this.timeTypeOne(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(8));
            sql.append(" t1, ").append(tableNameList.get(88)).append(" t2");
        } else if (this.timeTypeTwo(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(9));
            sql.append(" t1, ").append(tableNameList.get(11)).append(" t2");
        } else {
            sql.append("from ").append(tableNameList.get(10));
            sql.append(" t1, ").append(tableNameList.get(12)).append(" t2 ");
        }
        sql.append(" where t1.LOG_TIME = t2.LOG_TIME");
        sql.append(" and t1.DEVICE_IP = t2.DEVICE_IP");
        sql.append(" and t1.DEVICE_TYPE = t2.DEVICE_TYPE");
        this.appendLeftCondition(flowCompareCondition, sql, "t1", "t2");
        List<Object> temList = this.appendSqlWhere(flowCompareCondition, sql, "t1", false);
        for (Object object : temList) {
            sqlCondition.put(index++, object);
        }
        sql.append(" ) as tt left outer join (select t3.DEVICE_IP, t3.LOG_TIME,");
        sql.append(" SUM(t3.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_').append(unit).append(") as ").append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_').append(unit).append("1, ");
        sql.append(" MAX(t4.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_').append(unit).append(") as ").append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_').append(unit).append("2, ");
        sql.append(" SUM(t3.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(')').append(" as ").append(protocol.equals("UDP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(' ');
        if (this.timeTypeOne(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(44)).append(" t3, ");
            sql.append(tableNameList.get(97)).append(" t4");
        } else if (this.timeTypeTwo(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(45)).append(" t3, ");
            sql.append(tableNameList.get(61)).append(" t4");
        } else {
            sql.append("from ").append(tableNameList.get(46)).append(" t3, ");
            sql.append(tableNameList.get(62)).append(" t4");
        }
        sql.append(" where t3.LOG_TIME = t4.LOG_TIME ");
        sql.append(" and t3.DEVICE_IP = t4.DEVICE_IP ");
        sql.append(" and t3.DEVICE_TYPE = t4.DEVICE_TYPE");
        this.appendLeftCondition(flowCompareCondition, sql, "t3", "t4");
        List<Object> tempList = this.appendSqlWhere(flowCompareCondition, sql, "t3", false);
        for (Object object : tempList) {
            sqlCondition.put(index++, object);
        }
        sql.append(" )");
        sql.append(" as ttt on ttt.DEVICE_IP = tt.DEVICE_IP");
        sql.append(" and ttt.LOG_TIME = tt.LOG_TIME");
    }

    private void processOtherBiz(FlowCompareCondition flowCompareCondition, StringBuffer sql, List<String> tableNameList, Map<Integer, Object> sqlCondition) {
        int index = 1;
        String protocol = CollectorConstants.getProtocolMap().get(flowCompareCondition.getProtocol());
        String unit = CollectorConstants.getUnitMap().get(flowCompareCondition.getUnit());
        sql.append("select tt.LOG_TIME, ");
        sql.append("tt.DEVICE_IP, ");
        sql.append("tt.").append(protocol.equals("OTHER") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("1, ");
        sql.append("tt.").append(protocol.equals("OTHER") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("2, ");
        sql.append("ttt.").append(protocol.equals("OTHER") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("1, ");
        sql.append("ttt.").append(protocol.equals("OTHER") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("2 ");
        sql.append("from (select t1.DEVICE_IP, t1.LOG_TIME, ");
        sql.append(" SUM(t1.").append(protocol.equals("OTHER") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ");
        sql.append(protocol.equals("OTHER") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("1, ");
        sql.append(" MAX(t2.").append(protocol.equals("OTHER") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ");
        sql.append(protocol.equals("OTHER") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("2 ");
        if (this.timeTypeOne(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(77));
            sql.append(" t1, ").append(tableNameList.get(101)).append(" t2");
        } else if (this.timeTypeTwo(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(78));
            sql.append(" t1, ").append(tableNameList.get(80)).append(" t2");
        } else {
            sql.append("from ").append(tableNameList.get(79)).append(" t1, ");
            sql.append(tableNameList.get(81)).append(" t2 ");
        }
        sql.append(" where t1.LOG_TIME = t2.LOG_TIME");
        sql.append(" and t1.DEVICE_IP = t2.DEVICE_IP");
        sql.append(" and t1.DEVICE_TYPE = t2.DEVICE_TYPE");
        this.appendLeftCondition(flowCompareCondition, sql, "t1", "t2");
        List<Object> tempList = this.appendSqlWhere(flowCompareCondition, sql, "t1", false);
        for (Object object : tempList) {
            sqlCondition.put(index++, object);
        }
        sql.append(" ) as tt left outer join (select t3.DEVICE_IP, t3.LOG_TIME, SUM(t3.");
        sql.append(protocol.equals("OTHER") ? "TOTAL" : protocol).append('_');
        sql.append(unit).append(") as ").append(protocol.equals("OTHER") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("1, ");
        sql.append("MAX(t4.").append(protocol.equals("OTHER") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ");
        sql.append(protocol.equals("OTHER") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("2  ");
        if (this.timeTypeOne(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(82)).append(" t3, ");
            sql.append(tableNameList.get(102)).append(" t4");
        } else if (this.timeTypeTwo(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(83)).append(" t3, ");
            sql.append(tableNameList.get(85)).append(" t4");
        } else {
            sql.append("from ").append(tableNameList.get(84)).append(" t3, ");
            sql.append(tableNameList.get(86)).append(" t4");
        }
        sql.append(" where t3.LOG_TIME = t4.LOG_TIME ");
        sql.append(" and t3.DEVICE_IP = t4.DEVICE_IP ");
        sql.append(" and t3.DEVICE_TYPE = t4.DEVICE_TYPE");
        this.appendLeftCondition(flowCompareCondition, sql, "t3", "t4");
        List<Object> temList = this.appendSqlWhere(flowCompareCondition, sql, "t3", false);
        for (Object object : temList) {
            sqlCondition.put(index++, object);
        }
        sql.append(" )");
        sql.append(" as ttt on ttt.DEVICE_IP = tt.DEVICE_IP");
        sql.append(" and ttt.LOG_TIME = tt.LOG_TIME");
    }

    private void processHttpBiz(FlowCompareCondition flowCompareCondition, StringBuffer sql, List<String> tableNameList, Map<Integer, Object> sqlCondition) {
        int index = 1;
        String protocol = CollectorConstants.getProtocolMap().get(flowCompareCondition.getProtocol());
        String unit = CollectorConstants.getUnitMap().get(flowCompareCondition.getUnit());
        if ("GET_PPS".equals(unit)) {
            sql.append("select tt.LOG_TIME, ");
            sql.append("tt.DEVICE_IP, ");
            sql.append("tt.").append(unit).append("1, ");
            sql.append("tt.").append(unit).append("2, ");
            sql.append("ttt.").append(unit).append("1, ");
            sql.append("ttt.").append(unit).append("2 ");
            sql.append("from (select t1.DEVICE_IP, t1.LOG_TIME, ");
            sql.append(" SUM(t1.").append(unit).append(") as ");
            sql.append(unit).append("1, ");
            sql.append(" MAX(t2.").append(unit).append(") as ");
            sql.append(unit).append("2 ");
            if (this.timeTypeOne(flowCompareCondition)) {
                sql.append("from ").append(tableNameList.get(13)).append(" t1, ");
                sql.append(tableNameList.get(89)).append(" t2");
            } else if (this.timeTypeTwo(flowCompareCondition)) {
                sql.append("from ").append(tableNameList.get(14)).append(" t1, ");
                sql.append(tableNameList.get(16)).append(" t2");
            } else {
                sql.append("from ").append(tableNameList.get(15)).append(" t1, ");
                sql.append(tableNameList.get(17)).append(" t2 ");
            }
            sql.append(" where t1.LOG_TIME = t2.LOG_TIME");
            sql.append(" and t1.DEVICE_IP = t2.DEVICE_IP");
            sql.append(" and t1.DEVICE_TYPE = t2.DEVICE_TYPE");
            this.appendLeftCondition(flowCompareCondition, sql, "t1", "t2");
            List<Object> temList = this.appendSqlWhere(flowCompareCondition, sql, "t1", false);
            for (Object object : temList) {
                sqlCondition.put(index++, object);
            }
            sql.append(" ) as tt left outer join (select t3.DEVICE_IP, t3.LOG_TIME, SUM(t3.");
            sql.append(unit).append(") as ");
            sql.append(unit).append("1, ");
            sql.append("MAX(t4.").append(unit).append(") as ");
            sql.append(unit).append("2  ");
            if (this.timeTypeOne(flowCompareCondition)) {
                sql.append("from ").append(tableNameList.get(51)).append(" t3, ");
                sql.append(tableNameList.get(98)).append(" t4");
            } else if (this.timeTypeTwo(flowCompareCondition)) {
                sql.append("from ").append(tableNameList.get(52)).append(" t3, ");
                sql.append(tableNameList.get(64)).append(" t4");
            } else {
                sql.append("from ").append(tableNameList.get(63)).append(" t3, ");
                sql.append(tableNameList.get(65)).append(" t4");
            }
            sql.append(" where t3.LOG_TIME = t4.LOG_TIME");
            sql.append(" and t3.DEVICE_IP = t4.DEVICE_IP");
            sql.append(" and t3.DEVICE_TYPE = t4.DEVICE_TYPE");
            this.appendLeftCondition(flowCompareCondition, sql, "t3", "t4");
            List<Object> tempList = this.appendSqlWhere(flowCompareCondition, sql, "t3", false);
            for (Object object : tempList) {
                sqlCondition.put(index++, object);
            }
            sql.append(" )");
            sql.append(" as ttt on ttt.DEVICE_IP = tt.DEVICE_IP");
            sql.append(" and ttt.LOG_TIME = tt.LOG_TIME");
        } else {
            sql.append("select tt.LOG_TIME, ");
            sql.append("tt.DEVICE_IP, ");
            sql.append("tt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("1, ");
            sql.append("tt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("2, ");
            sql.append("ttt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("1, ");
            sql.append("ttt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("2, ");
            sql.append("ttt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(' ');
            sql.append("from (select t1.DEVICE_IP, t1.LOG_TIME, ");
            sql.append(" SUM(t1.").append(protocol.equals("TCP") ? "TOTAL" : protocol);
            sql.append('_').append(unit).append(") as ");
            sql.append(protocol.equals("TCP") ? "TOTAL" : protocol);
            sql.append('_').append(unit).append("1, ");
            sql.append(" MAX(t2.").append(protocol.equals("TCP") ? "TOTAL" : protocol);
            sql.append('_').append(unit).append(") as ");
            sql.append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("2 ");
            if (this.timeTypeOne(flowCompareCondition)) {
                sql.append("from ").append(tableNameList.get(13)).append(" t1, ");
                sql.append(tableNameList.get(89)).append(" t2");
            } else if (this.timeTypeTwo(flowCompareCondition)) {
                sql.append("from ").append(tableNameList.get(14)).append(" t1, ");
                sql.append(tableNameList.get(16)).append(" t2");
            } else {
                sql.append("from ").append(tableNameList.get(15)).append(" t1, ");
                sql.append(tableNameList.get(17)).append(" t2 ");
            }
            sql.append(" where t1.LOG_TIME = t2.LOG_TIME");
            sql.append(" and t1.DEVICE_IP = t2.DEVICE_IP");
            sql.append(" and t1.DEVICE_TYPE = t2.DEVICE_TYPE");
            this.appendLeftCondition(flowCompareCondition, sql, "t1", "t2");
            List<Object> temList = this.appendSqlWhere(flowCompareCondition, sql, "t1", false);
            for (Object object : temList) {
                sqlCondition.put(index++, object);
            }
            sql.append(" ) as tt left outer join (select t3.DEVICE_IP, t3.LOG_TIME, SUM(t3.");
            sql.append(protocol.equals("TCP") ? "TOTAL" : protocol);
            sql.append('_').append(unit).append(") as ");
            sql.append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("1, ");
            sql.append("MAX(t4.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_');
            sql.append(unit).append(") as ");
            sql.append(protocol.equals("TCP") ? "TOTAL" : protocol);
            sql.append('_').append(unit).append("2,  ");
            sql.append(" SUM(t3.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(')').append(" as ").append(protocol.equals("TCP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(' ');
            if (this.timeTypeOne(flowCompareCondition)) {
                sql.append("from ").append(tableNameList.get(51)).append(" t3, ");
                sql.append(tableNameList.get(98)).append(" t4");
            } else if (this.timeTypeTwo(flowCompareCondition)) {
                sql.append("from ").append(tableNameList.get(52)).append(" t3, ");
                sql.append(tableNameList.get(64)).append(" t4");
            } else {
                sql.append("from ").append(tableNameList.get(63)).append(" t3, ");
                sql.append(tableNameList.get(65)).append(" t4");
            }
            sql.append(" where t3.LOG_TIME = t4.LOG_TIME");
            sql.append(" and t3.DEVICE_IP = t4.DEVICE_IP");
            sql.append(" and t3.DEVICE_TYPE = t4.DEVICE_TYPE");
            this.appendLeftCondition(flowCompareCondition, sql, "t3", "t4");
            List<Object> tempList = this.appendSqlWhere(flowCompareCondition, sql, "t3", false);
            Iterator iterator = tempList.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                sqlCondition.put(index++, object);
            }
            sql.append(" )");
            sql.append(" as ttt on ttt.DEVICE_IP = tt.DEVICE_IP");
            sql.append(" and ttt.LOG_TIME = tt.LOG_TIME");
        }
    }

    private void processHttpsBiz(FlowCompareCondition flowCompareCondition, StringBuffer sql, List<String> tableNameList, Map<Integer, Object> sqlCondition) {
        int index = 1;
        String protocol = CollectorConstants.getProtocolMap().get(flowCompareCondition.getProtocol());
        String unit = CollectorConstants.getUnitMap().get(flowCompareCondition.getUnit());
        sql.append("select tt.LOG_TIME, ");
        sql.append("tt.DEVICE_IP, ");
        sql.append("tt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("1, ");
        sql.append("tt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("2, ");
        sql.append("ttt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("1, ");
        sql.append("ttt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("2, ");
        sql.append("ttt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(' ');
        sql.append("from (select t1.DEVICE_IP, t1.LOG_TIME, ");
        sql.append(" SUM(t1.").append(protocol.equals("TCP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ");
        sql.append(protocol.equals("TCP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("1, ");
        sql.append(" MAX(t2.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_');
        sql.append(unit).append(") as ").append(protocol.equals("TCP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("2 ");
        if (this.timeTypeOne(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(18)).append(" t1, ");
            sql.append(tableNameList.get(90)).append(" t2");
        } else if (this.timeTypeTwo(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(19)).append(" t1, ");
            sql.append(tableNameList.get(21)).append(" t2");
        } else {
            sql.append("from ").append(tableNameList.get(20)).append(" t1, ");
            sql.append(tableNameList.get(22)).append(" t2 ");
        }
        sql.append(" where t1.LOG_TIME = t2.LOG_TIME");
        sql.append(" and t1.DEVICE_IP = t2.DEVICE_IP");
        sql.append(" and t1.DEVICE_TYPE = t2.DEVICE_TYPE");
        this.appendLeftCondition(flowCompareCondition, sql, "t1", "t2");
        List<Object> temList = this.appendSqlWhere(flowCompareCondition, sql, "t1", false);
        for (Object object : temList) {
            sqlCondition.put(index++, object);
        }
        sql.append(" ) as tt left outer join (select t3.DEVICE_IP, t3.LOG_TIME, SUM(t3.");
        sql.append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_');
        sql.append(unit).append(") as ").append(protocol.equals("TCP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("1, ");
        sql.append("MAX(t4.").append(protocol.equals("TCP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ").append(protocol.equals("TCP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("2, ");
        sql.append(" SUM(t3.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(')').append(" as ").append(protocol.equals("TCP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(' ');
        if (this.timeTypeOne(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(53)).append(" t3, ");
            sql.append(tableNameList.get(99)).append(" t4");
        } else if (this.timeTypeTwo(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(54)).append(" t3, ");
            sql.append(tableNameList.get(67)).append(" t4");
        } else {
            sql.append("from ").append(tableNameList.get(66)).append(" t3, ");
            sql.append(tableNameList.get(68)).append(" t4");
        }
        sql.append(" where t3.LOG_TIME = t4.LOG_TIME ");
        sql.append(" and t3.DEVICE_IP = t4.DEVICE_IP");
        sql.append(" and t3.DEVICE_TYPE = t4.DEVICE_TYPE");
        this.appendLeftCondition(flowCompareCondition, sql, "t3", "t4");
        List<Object> tempList = this.appendSqlWhere(flowCompareCondition, sql, "t3", false);
        for (Object object : tempList) {
            sqlCondition.put(index++, object);
        }
        sql.append(" )");
        sql.append(" as ttt on ttt.DEVICE_IP = tt.DEVICE_IP");
        sql.append(" and ttt.LOG_TIME = tt.LOG_TIME");
    }

    private void processTcpDnsBiz(FlowCompareCondition flowCompareCondition, StringBuffer sql, List<String> tableNameList, Map<Integer, Object> sqlCondition) {
        int index = 1;
        String protocol = CollectorConstants.getProtocolMap().get(flowCompareCondition.getProtocol());
        String unit = CollectorConstants.getUnitMap().get(flowCompareCondition.getUnit());
        sql.append("select tt.LOG_TIME, ");
        sql.append("tt.DEVICE_IP, ");
        sql.append("tt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("1, ");
        sql.append("tt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("2, ");
        sql.append("ttt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("1, ");
        sql.append("ttt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("2, ");
        sql.append("ttt.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(' ');
        sql.append("from (select t1.DEVICE_IP, t1.LOG_TIME, ");
        sql.append(" SUM(t1.").append(protocol.equals("TCP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ").append(protocol.equals("TCP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("1, ");
        sql.append(" MAX(t2.").append(protocol.equals("TCP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ");
        sql.append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("2 ");
        if (this.timeTypeOne(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(23));
            sql.append(" t1, ").append(tableNameList.get(91)).append(" t2");
        } else if (this.timeTypeTwo(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(24));
            sql.append(" t1, ").append(tableNameList.get(26)).append(" t2");
        } else {
            sql.append("from ").append(tableNameList.get(25));
            sql.append(" t1, ").append(tableNameList.get(27)).append(" t2 ");
        }
        sql.append(" where t1.LOG_TIME = t2.LOG_TIME");
        sql.append(" and t1.DEVICE_IP = t2.DEVICE_IP");
        sql.append(" and t1.DEVICE_TYPE = t2.DEVICE_TYPE");
        this.appendLeftCondition(flowCompareCondition, sql, "t1", "t2");
        List<Object> temList = this.appendSqlWhere(flowCompareCondition, sql, "t1", false);
        for (Object object : temList) {
            sqlCondition.put(index++, object);
        }
        sql.append(" ) as tt left outer join (select t3.DEVICE_IP, t3.LOG_TIME, SUM(t3.");
        sql.append(protocol.equals("TCP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ");
        sql.append(protocol.equals("TCP") ? "TOTAL" : protocol).append('_').append(unit).append("1, ");
        sql.append("MAX(t4.").append(protocol.equals("TCP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ").append(protocol.equals("TCP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("2, ");
        sql.append(" SUM(t3.").append(protocol.equals("TCP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(')').append(" as ").append(protocol.equals("TCP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(' ');
        if (this.timeTypeOne(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(55));
            sql.append(" t3, ").append(tableNameList.get(94)).append(" t4");
        } else if (this.timeTypeTwo(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(69));
            sql.append(" t3, ").append(tableNameList.get(47)).append(" t4");
        } else {
            sql.append("from ").append(tableNameList.get(70));
            sql.append(" t3, ").append(tableNameList.get(48)).append(" t4");
        }
        sql.append(" where t3.LOG_TIME = t4.LOG_TIME");
        sql.append(" and t3.DEVICE_IP = t4.DEVICE_IP");
        sql.append(" and t3.DEVICE_TYPE = t4.DEVICE_TYPE");
        this.appendLeftCondition(flowCompareCondition, sql, "t3", "t4");
        List<Object> tempList = this.appendSqlWhere(flowCompareCondition, sql, "t3", false);
        for (Object object : tempList) {
            sqlCondition.put(index++, object);
        }
        sql.append(" )");
        sql.append(" as ttt on ttt.DEVICE_IP = tt.DEVICE_IP");
        sql.append(" and ttt.LOG_TIME = tt.LOG_TIME");
    }

    private void processUdpDnsBiz(FlowCompareCondition flowCompareCondition, StringBuffer sql, List<String> tableNameList, Map<Integer, Object> sqlCondition) {
        int index = 1;
        String protocol = "REQUEST";
        if ("reply".equalsIgnoreCase(flowCompareCondition.getRequestOrReply())) {
            protocol = "REPLY";
        } else if (!flowCompareCondition.isIsQueryRequestOrReply()) {
            protocol = "UDP";
        }
        String unit = CollectorConstants.getUnitMap().get(flowCompareCondition.getUnit());
        sql.append("select tt.LOG_TIME, tt.DEVICE_IP, ");
        sql.append("tt.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_').append(unit).append('1');
        sql.append(", tt.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_').append(unit).append('2');
        sql.append(", ttt.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_').append(unit).append('1');
        sql.append(", ttt.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_').append(unit).append('2');
        sql.append(", ttt.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(' ');
        sql.append(" from (select t1.DEVICE_IP, t1.LOG_TIME, ");
        sql.append(" SUM(t1.").append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ").append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("1, ");
        sql.append(" MAX(t2.").append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ").append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("2 ");
        if (this.timeTypeOne(flowCompareCondition)) {
            sql.append("from ");
            sql.append(tableNameList.get(28)).append(" t1, ");
            sql.append(tableNameList.get(92)).append(" t2 ");
        } else if (this.timeTypeTwo(flowCompareCondition)) {
            sql.append("from ");
            sql.append(tableNameList.get(29)).append(" t1, ");
            sql.append(tableNameList.get(31)).append(" t2 ");
        } else {
            sql.append("from ");
            sql.append(tableNameList.get(30)).append(" t1, ");
            sql.append(tableNameList.get(32)).append(" t2 ");
        }
        sql.append("where t1.LOG_TIME = t2.LOG_TIME");
        sql.append(" and t1.DEVICE_IP = t2.DEVICE_IP");
        sql.append(" and t1.DEVICE_TYPE = t2.DEVICE_TYPE");
        this.appendLeftCondition(flowCompareCondition, sql, "t1", "t2");
        List<Object> temList = this.appendSqlWhere(flowCompareCondition, sql, "t1", false);
        for (Object object : temList) {
            sqlCondition.put(index++, object);
        }
        sql.append(" ) as tt left outer join (select t3.DEVICE_IP, t3.LOG_TIME, SUM(t3.");
        sql.append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_').append(unit);
        sql.append(") as ").append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("1, ");
        sql.append("MAX(t4.").append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ").append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("2,  ");
        sql.append(" SUM(t3.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(')').append(" as ").append(protocol.equals("UDP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(' ');
        if (this.timeTypeOne(flowCompareCondition)) {
            sql.append("from ");
            sql.append(tableNameList.get(56)).append(" t3, ");
            sql.append(tableNameList.get(95)).append(" t4");
        } else if (this.timeTypeTwo(flowCompareCondition)) {
            sql.append("from ");
            sql.append(tableNameList.get(71)).append(" t3, ");
            sql.append(tableNameList.get(49)).append(" t4");
        } else {
            sql.append("from ");
            sql.append(tableNameList.get(72)).append(" t3, ");
            sql.append(tableNameList.get(50)).append(" t4");
        }
        sql.append(" where t3.LOG_TIME = t4.LOG_TIME");
        sql.append(" and t3.DEVICE_IP = t4.DEVICE_IP");
        sql.append(" and t3.DEVICE_TYPE = t4.DEVICE_TYPE ");
        this.appendLeftCondition(flowCompareCondition, sql, "t3", "t4");
        List<Object> tempList = this.appendSqlWhere(flowCompareCondition, sql, "t3", false);
        for (Object object : tempList) {
            sqlCondition.put(index++, object);
        }
        sql.append(" ) as ttt on ttt.DEVICE_IP = tt.DEVICE_IP");
        sql.append(" and ttt.LOG_TIME = tt.LOG_TIME");
    }

    private void processSipBiz(FlowCompareCondition flowCompareCondition, StringBuffer sql, List<String> tableNameList, Map<Integer, Object> sqlCondition) {
        int index = 1;
        String protocol = CollectorConstants.getProtocolMap().get(flowCompareCondition.getProtocol());
        String unit = CollectorConstants.getUnitMap().get(flowCompareCondition.getUnit());
        sql.append("select tt.LOG_TIME, tt.DEVICE_IP,");
        sql.append("tt.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_').append(unit).append("1, ");
        sql.append("tt.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_').append(unit).append("2, ");
        sql.append("ttt.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_').append(unit).append("1, ");
        sql.append("ttt.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_').append(unit).append("2, ");
        sql.append("ttt.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(' ');
        sql.append("from (select t1.DEVICE_IP, t1.LOG_TIME, ");
        sql.append(" SUM(t1.").append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ").append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("1, ");
        sql.append(" MAX(t2.").append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ").append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("2 ");
        if (this.timeTypeOne(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(57)).append(" t1, ");
            sql.append(tableNameList.get(93)).append(" t2");
        } else if (this.timeTypeTwo(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(34)).append(" t1, ");
            sql.append(tableNameList.get(36)).append(" t2");
        } else {
            sql.append("from ").append(tableNameList.get(35)).append(" t1, ");
            sql.append(tableNameList.get(37)).append(" t2 ");
        }
        sql.append(" where t1.LOG_TIME = t2.LOG_TIME");
        sql.append(" and t1.DEVICE_IP = t2.DEVICE_IP");
        sql.append(" and t1.DEVICE_TYPE = t2.DEVICE_TYPE");
        this.appendLeftCondition(flowCompareCondition, sql, "t1", "t2");
        List<Object> temList = this.appendSqlWhere(flowCompareCondition, sql, "t1", false);
        for (Object object : temList) {
            sqlCondition.put(index++, object);
        }
        sql.append(" ) as tt left outer join (select t3.DEVICE_IP, t3.LOG_TIME, SUM(t3.");
        sql.append(protocol.equals("UDP") ? "TOTAL" : protocol).append('_');
        sql.append(unit).append(") as ").append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("1, ");
        sql.append("MAX(t4.").append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append(") as ").append(protocol.equals("UDP") ? "TOTAL" : protocol);
        sql.append('_').append(unit).append("2, ");
        sql.append(" SUM(t3.").append(protocol.equals("UDP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(')').append(" as ").append(protocol.equals("UDP") ? "TOTAL" : protocol).append("_REBOUND_").append(unit).append(' ');
        if (this.timeTypeOne(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(58)).append(" t3, ");
            sql.append(tableNameList.get(100)).append(" t4");
        } else if (this.timeTypeTwo(flowCompareCondition)) {
            sql.append("from ").append(tableNameList.get(73)).append(" t3, ");
            sql.append(tableNameList.get(75)).append(" t4");
        } else {
            sql.append("from ").append(tableNameList.get(74)).append(" t3, ");
            sql.append(tableNameList.get(76)).append(" t4");
        }
        sql.append(" where t3.LOG_TIME = t4.LOG_TIME ");
        sql.append(" and t3.DEVICE_IP = t4.DEVICE_IP ");
        sql.append("and t3.DEVICE_TYPE = t4.DEVICE_TYPE");
        this.appendLeftCondition(flowCompareCondition, sql, "t3", "t4");
        List<Object> tempList = this.appendSqlWhere(flowCompareCondition, sql, "t3", false);
        for (Object object : tempList) {
            sqlCondition.put(index++, object);
        }
        sql.append(" ) as ttt on ttt.DEVICE_IP = tt.DEVICE_IP");
        sql.append(" and ttt.LOG_TIME = tt.LOG_TIME");
    }
}

