/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.biz.report.ZoneSecurityTableUtil;
import com.hs.atic.collector.db.report.DBStat;
import com.hs.atic.collector.entity.log.FlowCompare;
import com.hs.atic.collector.entity.log.FlowCompareCondition;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.FlowCompareQueryType;
import com.hs.atic.rmi.FlowCompareService;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.rmi.impl.FlowCompareQueryTypeWithBiz;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FlowCompareServiceImpl
extends UnicastRemoteObject
implements FlowCompareService {
    protected static final Logger LOG = LogManager.getInstance().getReportLogger();
    private static final long serialVersionUID = -4240564340960341475L;
    protected final DBStat flowCompareDao = new DBStat();
    private FlowCompareQueryType queryTypeObject;

    public FlowCompareServiceImpl() throws RemoteException {
    }

    public FlowCompareServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    private void setIpToFormate(FlowCompareCondition flowCompareCondition) {
        List<String> devIpList = flowCompareCondition.getDeviceIpList();
        if (null != devIpList && !devIpList.isEmpty() && devIpList.size() < 10000) {
            ArrayList<String> tempDeviceList = new ArrayList<String>();
            for (String tempDeviceIp : devIpList) {
                if (!IpTransformer.checkIpInvaild(tempDeviceIp)) continue;
                String tempIpStr = IpTransformer.formatIpAddress(tempDeviceIp);
                tempDeviceList.add(tempIpStr);
            }
            flowCompareCondition.getDeviceIpList().clear();
            flowCompareCondition.setDeviceIpList(tempDeviceList);
        }
        if (IpTransformer.checkIpInvaild(flowCompareCondition.getZoneIp())) {
            flowCompareCondition.setZoneIp(IpTransformer.formatIpAddress(flowCompareCondition.getZoneIp()));
        }
    }

    @Override
    public List<FlowCompare> queryFlowCompare(FlowCompareCondition flowCompareCondition) throws RemoteException {
        if (null == flowCompareCondition) {
            LOG.error((Object)"input flowCompareCondition is null.");
            return null;
        }
        LOG.info((Object)"start queryFlowCompare");
        HashMap<Integer, Object> condition = null;
        ZoneSecurityTableUtil zoneSecurityTableUtil = new ZoneSecurityTableUtil();
        Long sessionId = flowCompareCondition.getSessionId();
        List<Long> zoneIdList = flowCompareCondition.getZoneIdList();
        if (!CollectorConstants.QUERY_TYPE_ONLY_DEVICE.equals(flowCompareCondition.getQueryType()) && null != sessionId && null != zoneIdList && !zoneIdList.isEmpty() && zoneIdList.size() < 10000) {
            zoneSecurityTableUtil.insertZoneSecurityTableData(zoneIdList, sessionId);
        }
        this.setIpToFormate(flowCompareCondition);
        this.queryTypeObject = FlowCompareQueryType.getInstance(flowCompareCondition);
        List<FlowCompare> flowCompareList = new ArrayList<FlowCompare>();
        if (this.queryTypeObject instanceof FlowCompareQueryTypeWithBiz && null != flowCompareCondition.getIsServiceGroup() && flowCompareCondition.getIsServiceGroup().booleanValue()) {
            Map<String, List<Long>> serviceIdMap = flowCompareCondition.getServiceIds();
            if (null != serviceIdMap && !serviceIdMap.isEmpty() && serviceIdMap.size() < 10000) {
                for (Map.Entry<String, List<Long>> serviceIdList : serviceIdMap.entrySet()) {
                    flowCompareCondition.setBizType(Integer.parseInt(CollectorConstants.getBizStrToId().get(serviceIdList.getKey())));
                    condition = new HashMap();
                    String sql = this.queryTypeObject.getFlowCompareSQL(flowCompareCondition, condition);
                    LOG.info((Object)("sql for flowCompare : " + sql));
                    LOG.info((Object)("condition=" + ((Object)condition).toString()));
                    List<FlowCompare> tempFlowCompareList = null;
                    tempFlowCompareList = this.flowCompareDao.getFlowCompare(sql, condition);
                    LOG.info((Object)("query flow compare list, size : " + flowCompareList.size()));
                    if (tempFlowCompareList.isEmpty()) continue;
                    flowCompareList.addAll(tempFlowCompareList);
                }
            }
        } else {
            if (this.queryTypeObject instanceof FlowCompareQueryTypeWithBiz && (Integer.parseInt("6") == flowCompareCondition.getBizType() && flowCompareCondition.isIsQueryRequestOrReply() || Integer.parseInt("0") == flowCompareCondition.getBizType() && -4 == flowCompareCondition.getBizId().intValue())) {
                flowCompareCondition.setRequestOrReply("request");
                condition = new HashMap();
                String requestSql = this.queryTypeObject.getFlowCompareSQL(flowCompareCondition, condition);
                LOG.info((Object)("sql for flowCompare udp-dns requestSql: " + requestSql));
                LOG.info((Object)("condition=" + ((Object)condition).toString()));
                List<FlowCompare> requestFlowCompareList = null;
                requestFlowCompareList = this.flowCompareDao.getFlowCompare(requestSql, condition);
                flowCompareCondition.setRequestOrReply("reply");
                condition = new HashMap();
                String replySql = this.queryTypeObject.getFlowCompareSQL(flowCompareCondition, condition);
                LOG.info((Object)("sql for flowCompare udp-dns replySql: " + replySql));
                List<FlowCompare> replyFlowCompareList = null;
                replyFlowCompareList = this.flowCompareDao.getFlowCompare(replySql, condition);
                for (FlowCompare tempRequest : requestFlowCompareList) {
                    for (FlowCompare tempReply : replyFlowCompareList) {
                        if (!tempRequest.equals(tempReply)) continue;
                        tempRequest.setReplyInFlow(tempReply.getInFlow());
                        tempRequest.setReplyAttackFlow(tempReply.getAttackFlow());
                        tempRequest.setReplyOutFlow(tempReply.getOutFlow());
                        tempRequest.setReplyMaxInFlow(tempReply.getMaxInFlow());
                        tempRequest.setReplyMaxAttackFlow(tempReply.getMaxAttackFlow());
                        tempRequest.setReplyMaxOutFlow(tempReply.getMaxOutFlow());
                        tempRequest.setReplyReboundFlow(tempReply.getReboundFlow());
                    }
                }
                flowCompareList = requestFlowCompareList;
            } else {
                condition = new HashMap<Integer, Object>();
                String sql = this.queryTypeObject.getFlowCompareSQL(flowCompareCondition, condition);
                LOG.info((Object)("sql for flowCompare : " + sql));
                LOG.info((Object)("condition=" + ((Object)condition).toString()));
                flowCompareList = this.flowCompareDao.getFlowCompare(sql, condition);
            }
            LOG.info((Object)("query flow compare list, size : " + flowCompareList.size()));
        }
        if (!CollectorConstants.QUERY_TYPE_ONLY_DEVICE.equals(flowCompareCondition.getQueryType()) && null != sessionId && null != zoneIdList && !zoneIdList.isEmpty()) {
            zoneSecurityTableUtil.delectZoneSecurityTableData(sessionId);
        }
        LOG.info((Object)"end queryFlowCompare");
        return flowCompareList;
    }
}

