/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.entity.pcap.AttackerCount;
import com.hs.atic.collector.entity.pcap.PcapFileReader;
import com.hs.atic.collector.entity.pcap.ProtocolItem;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.ParamCheckUtil;
import com.hs.atic.collector.util.PcapUtil;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.PcapProtocolQueryService;
import com.hs.atic.rmi.ServerSocketFactory;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class PcapProtocolQueryServiceImpl
extends UnicastRemoteObject
implements PcapProtocolQueryService {
    private static final long serialVersionUID = -1779708290445915682L;
    private static final Logger LOGGER = LogManager.getInstance().getPcapLogger();

    public PcapProtocolQueryServiceImpl() throws RemoteException {
    }

    public PcapProtocolQueryServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    @Override
    public List<ProtocolItem> queryPcapItemContens(String fileName, int offset, int size) {
        LOGGER.info((Object)("start queryPcapItemContens, fileName= " + fileName + ", offset=" + offset + ", size= " + size));
        if (!ParamCheckUtil.isValidStringNotNull(fileName, 256, "^[\\w|\u4e00-\u9fa5|\\!|\\@|\\#|\\$|\\^|\\+|\\-|\\_|\\=|\\}|\\{|\\]|\\[|\\;|\\.|\\*|\\:|\\,|\\/| |%]*$")) {
            LOGGER.error((Object)"input fileName is not valid");
            return new ArrayList<ProtocolItem>();
        }
        PcapFileReader pcapFileReader = new PcapFileReader(PcapUtil.getCanonicalPath(fileName));
        try {
            List<ProtocolItem> ipProtocolList = pcapFileReader.getProtocolList(offset, size);
            LOGGER.info((Object)("query ip protoco list ok , filename is " + PcapProtocolQueryServiceImpl.getcleanedMessage(fileName) + " offset is " + offset + " size is " + size + " result is " + ipProtocolList));
            return ipProtocolList;
        }
        catch (IOException e) {
            LOGGER.error((Object)("when get ip protoco list ,some error happend , filename is " + PcapProtocolQueryServiceImpl.getcleanedMessage(fileName) + " offset is " + offset + " size is " + size), (Throwable)e);
            return new ArrayList<ProtocolItem>();
        }
        catch (Exception e) {
            LOGGER.error((Object)("when get ip protoco list ,some error happend , filename is " + PcapProtocolQueryServiceImpl.getcleanedMessage(fileName) + " offset is " + offset + " size is " + size), (Throwable)e);
            return new ArrayList<ProtocolItem>();
        }
    }

    @Override
    public int queryPcapItemSize(String fileName) {
        if (!ParamCheckUtil.isValidStringNotNull(fileName, 256, "^[\\w|\u4e00-\u9fa5|\\!|\\@|\\#|\\$|\\^|\\+|\\-|\\_|\\=|\\}|\\{|\\]|\\[|\\;|\\.|\\*|\\:|\\,|\\/| |%]*$")) {
            LOGGER.error((Object)"input fileName is not valid");
            return 0;
        }
        PcapFileReader pcapFileReader = new PcapFileReader(PcapUtil.getCanonicalPath(fileName));
        try {
            int size = pcapFileReader.getSize();
            LOGGER.info((Object)("query pcap file size is " + size));
            return size;
        }
        catch (IOException e) {
            LOGGER.error((Object)"query file size error", (Throwable)e);
            return 0;
        }
    }

    @Override
    public List<AttackerCount> getPcapAttackerInfo(String fileName, Integer attackType) throws RemoteException {
        if (!ParamCheckUtil.isValidStringNotNull(fileName, 256, "^[\\w|\u4e00-\u9fa5|\\!|\\@|\\#|\\$|\\^|\\+|\\-|\\_|\\=|\\}|\\{|\\]|\\[|\\;|\\.|\\*|\\:|\\,|\\/| |%]*$") || null == attackType) {
            LOGGER.error((Object)"input fileName is not valid");
            return new ArrayList<AttackerCount>();
        }
        LOGGER.info((Object)("query pcap file size , file name is " + PcapProtocolQueryServiceImpl.getcleanedMessage(fileName)));
        PcapFileReader reader = new PcapFileReader(PcapUtil.getCanonicalPath(fileName));
        List<AttackerCount> attackerInfo = reader.getAttackerInfo(attackType);
        Collections.sort(attackerInfo);
        if (attackerInfo.size() > 500) {
            ArrayList<AttackerCount> result = new ArrayList<AttackerCount>();
            for (int i = 0; i < 500; ++i) {
                result.add(attackerInfo.get(i));
            }
            return result;
        }
        return attackerInfo;
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }
}

