/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.biz.event.process.ServiceLearningEvnetHanlder;
import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.entity.ServiceLearningTask;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.rmi.ServiceLearningData;
import com.hs.atic.rmi.ServiceLearningRmiService;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServiceLearningRMIServiceImpl
extends UnicastRemoteObject
implements ServiceLearningRmiService {
    protected static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private static final long serialVersionUID = -2335115344283050355L;
    private static final int TCP_PROTOCOL = 6;
    private static final int UDP_PROTOCOL = 17;
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;
    private static final int DNS_PORT = 53;
    private static final int SIP_PORT = 5060;

    public ServiceLearningRMIServiceImpl() throws RemoteException {
    }

    public ServiceLearningRMIServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    private String getServiceTypeByProtocolAndPort(int protocolId, int port) {
        switch (protocolId) {
            case 6: {
                switch (port) {
                    case 53: {
                        return "TCP_DNS";
                    }
                    case 80: {
                        return "HTTP";
                    }
                    case 443: {
                        return "HTTPS";
                    }
                }
                return "TCP";
            }
            case 17: {
                switch (port) {
                    case 53: {
                        return "UDP_DNS";
                    }
                    case 5060: {
                        return "SIP";
                    }
                }
                return "UDP";
            }
        }
        return "Other";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServiceLearningData> getServiceLearingData(Map<String, Object> queryMap) throws RemoteException {
        if (null == queryMap || queryMap.size() > 10000) {
            LOGGER.error((Object)"input param is not valid.");
            return new ArrayList<ServiceLearningData>();
        }
        Connection con = DBConnPool.getConnection();
        PreparedStatement query = null;
        ResultSet result = null;
        List<ServiceLearningData> list = null;
        String deviceIPPara = (String)queryMap.get("deviceIP");
        deviceIPPara = IpTransformer.formatIpAddress(deviceIPPara);
        StringBuffer tmp = new StringBuffer();
        String zoneId = (String)queryMap.get("zoneId");
        String alertRate2Query = (String)queryMap.get("alertRate2Query");
        String sql = null;
        try {
            tmp.append(" select device_ip ,zone_id , zone_ip,protocol,").append("dst_port,AVG(biz_pps) biz_pps,AVG(biz_kbps) biz_kbps,service_name ");
            tmp.append(" from atic_biz_info where 1 = 1");
            HashMap<Integer, String> valueMap = new HashMap<Integer, String>();
            int index = 1;
            if (!this.isNull(zoneId)) {
                tmp.append(" and zone_id = ? ");
                valueMap.put(index++, zoneId);
            }
            if (!this.isNull(deviceIPPara)) {
                tmp.append(" and device_ip = ? ");
                valueMap.put(index++, deviceIPPara);
            }
            if (!this.isNull(alertRate2Query)) {
                tmp.append(" and biz_pps >= ? ");
                valueMap.put(index++, alertRate2Query);
            }
            tmp.append("  group by device_ip,zone_id,zone_ip,protocol,dst_port order by biz_pps desc");
            sql = tmp.toString();
            query = con.prepareStatement(sql);
            LOGGER.info((Object)("service learning excute:" + sql));
            for (Map.Entry entry : valueMap.entrySet()) {
                query.setObject((Integer)entry.getKey(), entry.getValue());
            }
            LOGGER.info((Object)("servce learning query is " + query));
            result = query.executeQuery();
            list = this.beanWrapp(result);
            ServiceLearningRMIServiceImpl.freeDbResource(con, query, result);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"query service learning  error", (Throwable)e);
        }
        finally {
            ServiceLearningRMIServiceImpl.freeDbResource(con, query, result);
        }
        return list;
    }

    private boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equals(str);
    }

    private List<ServiceLearningData> beanWrapp(ResultSet result) throws SQLException {
        ArrayList<ServiceLearningData> list = new ArrayList<ServiceLearningData>();
        try {
            while (result.next()) {
                ServiceLearningData serviceLearnData = new ServiceLearningData();
                int protocol = result.getInt("protocol");
                String zoneIp = result.getString("zone_ip");
                int port = result.getInt("dst_port");
                String deviceIp = result.getString("device_ip");
                Long zoneId = result.getLong("zone_id");
                Long flow = result.getLong("biz_kbps");
                Long bizPps = result.getLong("biz_pps");
                String serviceName = result.getString("service_name");
                serviceLearnData.setDeviceIp(deviceIp);
                serviceLearnData.setZoneId(zoneId);
                serviceLearnData.setZoneIp(zoneIp);
                serviceLearnData.setProtocol(Long.valueOf(protocol));
                if (protocol == 6 || protocol == 17) {
                    if (port == 0) continue;
                    serviceLearnData.setPort(Long.valueOf(port));
                    serviceLearnData.setProtocolNum(0);
                } else {
                    serviceLearnData.setPort(Long.parseLong("0"));
                    serviceLearnData.setProtocolNum(protocol);
                }
                serviceLearnData.setFlow(flow);
                serviceLearnData.setBizPps(bizPps);
                serviceLearnData.setServiceName(serviceName);
                serviceLearnData.setServiceType(this.getServiceTypeByProtocolAndPort(protocol, port));
                list.add(serviceLearnData);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.info((Object)("[get servicelearnning data] " + serviceLearnData.getProtocol() + "," + serviceLearnData.getPort() + "," + serviceLearnData.getZoneIp() + "," + serviceLearnData.getState()));
            }
        }
        catch (RuntimeException e) {
            throw new SQLException(e);
        }
        return list;
    }

    protected static void freeDbResource(Connection con, PreparedStatement query, ResultSet result) {
        try {
            if (null != result) {
                result.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close resultSet error");
        }
        try {
            if (null != query) {
                query.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close statement error");
        }
        try {
            if (null != con) {
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close connection error");
        }
    }

    @Override
    public void addServiceLearningTask(ServiceLearningTask task) throws RemoteException {
        if (null == task) {
            LOGGER.error((Object)"input param is null.");
            return;
        }
        ServiceLearningEvnetHanlder.getInstance().addServicelearningEvnetTask(task);
    }

    @Override
    public void removeServiceLearningTask(ServiceLearningTask task) throws RemoteException {
        if (null == task) {
            LOGGER.error((Object)"input param is null.");
            return;
        }
        ServiceLearningEvnetHanlder.getInstance().removeServicelearningEvnetTask(task);
    }
}

