/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.biz.event.process.BaselineFlowSumHandler;
import com.hs.atic.collector.biz.event.process.ServiceLearningEvnetHanlder;
import com.hs.atic.collector.db.daemon.PartitionUtil;
import com.hs.atic.collector.db.monitor.DBCollectorDisk;
import com.hs.atic.collector.db.monitor.DBCollectorPerf;
import com.hs.atic.collector.db.monitor.DBDevice;
import com.hs.atic.collector.db.monitor.DBSysConf;
import com.hs.atic.collector.entity.Collector;
import com.hs.atic.collector.entity.ServiceLearningTask;
import com.hs.atic.collector.entity.baseline.BaseLineTask;
import com.hs.atic.collector.entity.monitor.CollectorDiskObj;
import com.hs.atic.collector.entity.monitor.CollectorMonitorInfo;
import com.hs.atic.collector.entity.monitor.CollectorPerfObj;
import com.hs.atic.collector.entity.monitor.DeviceObj;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.FilterNameUtil;
import com.hs.atic.collector.util.HostIpSysFileManager;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.LogUtil;
import com.hs.atic.collector.util.ParamCheckUtil;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ColBaseLineOrSrvLearningTaskService;
import com.hs.atic.rmi.HeartBeatService;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.rmi.SysManagerService;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SysManagerServiceImpl
extends UnicastRemoteObject
implements SysManagerService {
    private static final Logger LOGGER = LogManager.getInstance().getRMILog();
    private static final long serialVersionUID = -1102201301354908796L;
    private static final String COLLECTOR_IP_AD = System.getProperty("java.rmi.server.hostname");
    private static final String TASK_SERVICE_NAME = "ColBaseLineOrSrvLearningTaskService";
    private static final String SERVICE_NAME = "HeartBeatService";
    private transient HeartBeatService heartBeatService;

    public SysManagerServiceImpl() throws RemoteException {
    }

    public SysManagerServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    @Override
    public boolean addDevice(DeviceObj device) {
        if (null == device) {
            LOGGER.error((Object)"addDevice input parameter error, device is null");
            return false;
        }
        if (!device.isValid()) {
            LOGGER.error((Object)LogUtil.getCleanedMessage("addDevice input parameter error, device=" + device.toString()));
            return false;
        }
        LOGGER.info((Object)("Add device operation, parameter 'device' is " + device.toString()));
        device.setDeviceIp(IpTransformer.formatIpAddress(device.getDeviceIp()));
        if (CommonUtil.isNull(device.getLogIp())) {
            device.setLogIp(device.getDeviceIp());
        }
        device.setLogIp(IpTransformer.formatIpAddress(device.getLogIp()));
        if (!this.addBaseLineTask(device.getMoId())) {
            return false;
        }
        if (!this.addSrvLearningTask(device)) {
            return false;
        }
        boolean result = false;
        DBDevice dbDevice = new DBDevice();
        DeviceObj temp = dbDevice.queryByDevId(device.getMoId());
        result = temp == null ? dbDevice.add(device) : dbDevice.update(device);
        try {
            Collector instance = Collector.getInstance();
            instance.addDevice(device);
        }
        catch (Exception e) {
            LOGGER.error((Object)"addDevice error", (Throwable)e);
        }
        LOGGER.info((Object)(" result is " + result));
        return result;
    }

    private boolean addSrvLearningTask(DeviceObj device) {
        ColBaseLineOrSrvLearningTaskService colBaseLineOrSrvLearningTaskService = (ColBaseLineOrSrvLearningTaskService)CommonUtil.retreiveAticRmiService(TASK_SERVICE_NAME);
        List<ServiceLearningTask> list = null;
        try {
            list = colBaseLineOrSrvLearningTaskService.getSrvLearningTaskByDevId(device.getMoId());
        }
        catch (Exception e) {
            LOGGER.error((Object)"get srvlearning task error!", (Throwable)e);
            return false;
        }
        for (ServiceLearningTask task : list) {
            ServiceLearningEvnetHanlder.getInstance().addServicelearningEvnetTask(task);
        }
        return true;
    }

    private boolean removeSrvLearningTask(Long deviceId) {
        ColBaseLineOrSrvLearningTaskService colBaseLineOrSrvLearningTaskService = (ColBaseLineOrSrvLearningTaskService)CommonUtil.retreiveAticRmiService(TASK_SERVICE_NAME);
        List<ServiceLearningTask> list = null;
        try {
            list = colBaseLineOrSrvLearningTaskService.getSrvLearningTaskByDevId(deviceId);
        }
        catch (Exception e) {
            LOGGER.error((Object)"get srvlearning task error!", (Throwable)e);
            return false;
        }
        for (ServiceLearningTask task : list) {
            ServiceLearningEvnetHanlder.getInstance().removeServicelearningEvnetTask(task);
        }
        return true;
    }

    private boolean addBaseLineTask(Long deviceId) {
        ColBaseLineOrSrvLearningTaskService collectorBaseLineService = (ColBaseLineOrSrvLearningTaskService)CommonUtil.retreiveAticRmiService(TASK_SERVICE_NAME);
        List<BaseLineTask> list = null;
        try {
            list = collectorBaseLineService.getAddBaselineTaskByDevId(deviceId);
        }
        catch (Exception e) {
            LOGGER.error((Object)"get baseline task error!", (Throwable)e);
            return false;
        }
        for (BaseLineTask task : list) {
            BaselineFlowSumHandler.getInstance().modifyBaseLineTask(task);
        }
        return true;
    }

    private boolean removeBaseLineTask(Long deviceId) {
        ColBaseLineOrSrvLearningTaskService colBaseLineOrSrvLearningTaskService = (ColBaseLineOrSrvLearningTaskService)CommonUtil.retreiveAticRmiService(TASK_SERVICE_NAME);
        List<BaseLineTask> list = null;
        try {
            list = colBaseLineOrSrvLearningTaskService.getRemoveBaselineTaskByDevId(deviceId, COLLECTOR_IP_AD);
        }
        catch (Exception e) {
            LOGGER.error((Object)"get baseline task error!", (Throwable)e);
            return false;
        }
        for (BaseLineTask task : list) {
            BaselineFlowSumHandler.getInstance().modifyBaseLineTask(task);
        }
        return true;
    }

    @Override
    public boolean deleteDevice(Long deviceId) {
        if (null == deviceId || 0L == deviceId) {
            LOGGER.error((Object)"Delete device error, parameter 'deviceId' is null or 0");
            return false;
        }
        LOGGER.info((Object)("Delete device operation, parameter 'deviceId' is " + deviceId));
        DBDevice dbDevice = new DBDevice();
        if (!this.removeBaseLineTask(deviceId)) {
            return false;
        }
        if (!this.removeSrvLearningTask(deviceId)) {
            return false;
        }
        String ddosLogIp = dbDevice.getDdosLogIpByDevId(deviceId);
        if (null != ddosLogIp) {
            Collector instance = Collector.getInstance();
            instance.removeDevice(ddosLogIp);
        }
        boolean tt = dbDevice.delete(deviceId);
        LOGGER.info((Object)(" result is " + tt));
        return tt;
    }

    @Override
    public List<CollectorDiskObj> queryCollectorDisk() {
        DBCollectorDisk collectorDisk = new DBCollectorDisk();
        List<CollectorDiskObj> list = collectorDisk.queryCollectorDiskInfo();
        LOGGER.info((Object)("Query collector disk information, result is " + list));
        return list;
    }

    @Override
    public CollectorPerfObj queryCollectorPerformance() {
        DBCollectorPerf collectorPerformance = new DBCollectorPerf();
        CollectorPerfObj cpo = collectorPerformance.queryCollectorPerformanceInfo();
        LOGGER.info((Object)("Query collector performance, result is " + cpo.toString()));
        return cpo;
    }

    @Override
    public String testHello() {
        return "hello";
    }

    @Override
    public CollectorMonitorInfo sayHello(String clientIp, String collectorIp) {
        if (!IpTransformer.isIpV4(clientIp) || !IpTransformer.isIpV4(collectorIp)) {
            LOGGER.error((Object)LogUtil.getCleanedMessage("input paramer error. clientIp=" + clientIp + "; collectorIp=" + collectorIp));
            return null;
        }
        LOGGER.debug((Object)("input clientIp=" + clientIp + "; collectorIp=" + collectorIp));
        String realCollectorIp = System.getProperty("java.rmi.server.hostname");
        LOGGER.debug((Object)("realCollectorIp is :" + realCollectorIp));
        if (null == realCollectorIp || !realCollectorIp.equals(collectorIp)) {
            return null;
        }
        DBSysConf dc = new DBSysConf();
        String oldServerIp = dc.querySysValue("server_ip");
        if (!clientIp.equals(oldServerIp)) {
            LOGGER.info((Object)("server IP changed from db. new serverIp=" + clientIp));
            if (oldServerIp != null) {
                LOGGER.info((Object)("Old serverIp in db is " + oldServerIp));
                HostIpSysFileManager.deleteIpRecordFromSystemFile(oldServerIp);
            }
            HostIpSysFileManager.writeIpRecordToSystemFile(clientIp);
            dc.update("server_ip", clientIp);
        }
        try {
            if (this.heartBeatService == null || !clientIp.equals(oldServerIp)) {
                LOGGER.info((Object)"server IP changed.or heartBeatService is null");
                this.heartBeatService = (HeartBeatService)CommonUtil.retreiveAticRmiService(SERVICE_NAME);
                LOGGER.info((Object)("SERVICE_NAME is" + this.heartBeatService));
            }
            String hello = this.heartBeatService.sayHello();
            LOGGER.debug((Object)hello);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)"Collector can not connect to ATIC");
            this.heartBeatService = null;
            return null;
        }
        LOGGER.debug((Object)"Say hello to Atic Server");
        return this.getCollectorInfo();
    }

    private CollectorMonitorInfo getCollectorInfo() {
        DBCollectorPerf collectorPerformance = new DBCollectorPerf();
        CollectorPerfObj cpo = collectorPerformance.queryCollectorPerformanceInfo();
        DBCollectorDisk collectorDisk = new DBCollectorDisk();
        List<CollectorDiskObj> diskList = collectorDisk.queryCollectorDiskInfo();
        CollectorMonitorInfo collectorInfo = new CollectorMonitorInfo();
        collectorInfo.setCpuUseRatio(cpo.getCpuUseRatio());
        collectorInfo.setMemUseRatio(cpo.getMemUseRatio());
        collectorInfo.setDiskList(diskList);
        collectorInfo.setState(1);
        return collectorInfo;
    }

    @Override
    public boolean updateDevice(DeviceObj device) {
        if (null == device) {
            LOGGER.error((Object)"updateDevice input parameter error, device is null");
            return false;
        }
        if (!device.isValid()) {
            LOGGER.error((Object)LogUtil.getCleanedMessage("updateDevice input parameter error, device=" + device.toString()));
            return false;
        }
        LOGGER.info((Object)("Update device operation, parameter 'device' is " + device.toString()));
        DBDevice dbDevice = new DBDevice();
        Collector instance = Collector.getInstance();
        instance.modifyDevice(device);
        DeviceObj obj = dbDevice.queryByDevId(device.getMoId());
        boolean isUpdateDeviceDone = false;
        isUpdateDeviceDone = obj == null ? dbDevice.add(device) : dbDevice.update(device);
        LOGGER.info((Object)("updateDevice, result is " + isUpdateDeviceDone));
        return isUpdateDeviceDone;
    }

    @Override
    public boolean updateSysVal(String paramName, String paramVal) {
        String regexName = "^[\\w]+$";
        if (!ParamCheckUtil.isValidStringNotNull(paramName, 64, regexName) || !ParamCheckUtil.isValidStringNotNull(paramVal, 255)) {
            LOGGER.error((Object)"input param error ");
            return false;
        }
        LOGGER.info((Object)("Update sysVal operation, parameter 'paramName' is " + LogUtil.getCleanedMessage(paramName) + "'paramVal' is " + LogUtil.getCleanedMessage(paramVal)));
        DBSysConf dc = new DBSysConf();
        dc.update(paramName, paramVal);
        return true;
    }

    public long queryCollectorTimeMillis() {
        return System.currentTimeMillis();
    }

    public int getDbConnState() throws RemoteException {
        LOGGER.info((Object)"Get db conn state");
        DBCollectorPerf dBCollectorPerf = new DBCollectorPerf();
        return dBCollectorPerf.testDbConn();
    }

    @Override
    public boolean setPartitionParameter(int holdOriginal, int holdHour, int holdDay) throws RemoteException {
        LOGGER.info((Object)"udate Partition Parameter begin:");
        LOGGER.info((Object)("holdOriginal:" + holdOriginal));
        LOGGER.info((Object)("holdHour:" + holdHour));
        LOGGER.info((Object)("holdDay:" + holdDay));
        if (holdOriginal == 0 || holdHour == 0 || holdDay == 0) {
            LOGGER.info((Object)"input Partition Parameter  is wrong;");
            return false;
        }
        return PartitionUtil.setPartitionParameter(holdOriginal, holdHour, holdDay);
    }

    @Override
    public boolean setMonitorHoldTime(int holdTime) throws RemoteException {
        return true;
    }

    @Override
    public boolean setFilterInfos(Map<Integer, String> filterMap) throws RemoteException {
        return FilterNameUtil.getInstance().updateAllFilterNames(filterMap);
    }
}

