/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.entity.alarm.IpAlarmEntity;
import com.hs.atic.collector.entity.alarm.IpFlowInfo;
import com.hs.atic.collector.entity.alarm.IpInfoKey;
import com.hs.atic.collector.util.IPUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.rmi.TopNIPFlowInfo;
import com.hs.atic.rmi.TopNIPFlowRmiService;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TopNIPFlowRmiImpl
extends UnicastRemoteObject
implements TopNIPFlowRmiService {
    protected static final Logger LOGGER = LogManager.getInstance().getFlowLog();
    private static final long serialVersionUID = 5716777489218568949L;

    public TopNIPFlowRmiImpl() throws RemoteException {
    }

    public TopNIPFlowRmiImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    @Override
    public List<TopNIPFlowInfo> getTopNIPFlow(Map<String, String> queryMap) throws RemoteException {
        List<TopNIPFlowInfo> topnIPFlowList;
        block5: {
            if (null == queryMap || queryMap.isEmpty() || queryMap.size() > 10000) {
                LOGGER.error((Object)"getTopNIPFlow: the input queryMap is empty");
                return null;
            }
            LOGGER.debug((Object)("getTopNIPFlow start, the queryMap=" + queryMap.toString()));
            topnIPFlowList = new ArrayList<TopNIPFlowInfo>();
            try {
                String deviceIp = queryMap.get("deviceIp");
                String ipStatus = queryMap.get("ipStatus");
                long ipFlowValue = Long.parseLong(queryMap.get("ipFlowValue"));
                int topn = Integer.parseInt(queryMap.get("topn"));
                String ipVersion = queryMap.get("ipVersion");
                List<String[]> ipWhiteList = TopNIPFlowRmiImpl.getIPWhiteList(queryMap.get("ipWhiteList"));
                if ("all".equals(ipStatus)) {
                    topnIPFlowList = this.getTopNAllIpFLow(deviceIp, ipFlowValue, topn, ipVersion, ipWhiteList);
                    break block5;
                }
                if ("attack".equals(ipStatus)) {
                    topnIPFlowList = this.getTopNAttackIpFLow(deviceIp, ipFlowValue, topn, ipVersion, ipWhiteList);
                    break block5;
                }
                LOGGER.error((Object)("Error ipStatus:" + ipStatus));
                return null;
            }
            catch (Exception e) {
                LOGGER.error((Object)"catch Exception:", (Throwable)e);
            }
        }
        LOGGER.debug((Object)("get topnIPFlowList size = " + topnIPFlowList.size()));
        return topnIPFlowList;
    }

    private static List<String[]> getIPWhiteList(String ipWhiteStr) {
        if (null == ipWhiteStr || ipWhiteStr.isEmpty()) {
            return null;
        }
        LOGGER.debug((Object)("The input ipWhiteStr=" + ipWhiteStr));
        ArrayList<String[]> ipWhiteList = new ArrayList<String[]>();
        String[] temp = null;
        String[] ipRange = ipWhiteStr.split(",");
        for (int i = 0; i < ipRange.length; ++i) {
            if (ipRange[i].contains("-")) {
                temp = ipRange[i].split("-");
                ipWhiteList.add(temp);
                continue;
            }
            if (ipRange[i].contains("/")) {
                temp = ipRange[i].split("/");
                ipWhiteList.add(IPUtil.getSubnetRange(temp[0], Integer.parseInt(temp[1])));
                continue;
            }
            LOGGER.error((Object)("IP White Str formt error: " + ipRange[i]));
        }
        return ipWhiteList;
    }

    private List<TopNIPFlowInfo> getTopNAllIpFLow(String deviceIp, long ipFlowValue, int topn, String ipVersion, List<String[]> ipWhiteList) {
        AlarmThread alarmThread = AlarmThread.getInstance();
        Map<IpInfoKey, IpFlowInfo> ipFlow70secMap = alarmThread.getIpFlow70secMapOfDev(deviceIp);
        if (null == ipFlow70secMap || ipFlow70secMap.isEmpty()) {
            LOGGER.error((Object)"getTopNAllIpFLow: get ipFlow70secMap return empty");
            return new ArrayList<TopNIPFlowInfo>();
        }
        ArrayList<IpInFlowInfo> ipFlowList = new ArrayList<IpInFlowInfo>();
        IpInFlowInfo temp = null;
        for (Map.Entry<IpInfoKey, IpFlowInfo> entry : ipFlow70secMap.entrySet()) {
            String zoneIp = entry.getKey().getZoneIp();
            long curInMbps = entry.getValue().getCurrInKbps() / 1000L;
            LOGGER.debug((Object)("entry of ipFlow70secMap, devideIP=" + entry.getKey().getDeviceIp() + "; zoneIP=" + zoneIp + "; curInMbps=" + curInMbps + "; ipFlow70secMap.getValue.getCurrInKbps()=" + entry.getValue().getCurrInKbps()));
            if (this.checkIpVersion(ipVersion, zoneIp)) {
                LOGGER.debug((Object)"checkIpVersion() returns true");
            } else {
                LOGGER.debug((Object)"checkIpVersion() returns false");
            }
            if (!this.checkIpVersion(ipVersion, zoneIp) || curInMbps < ipFlowValue || 1 != entry.getKey().getDirection()) continue;
            temp = new IpInFlowInfo(curInMbps, zoneIp);
            ipFlowList.add(temp);
        }
        return this.countTopNIpFlow(ipFlowList, deviceIp, topn, ipWhiteList);
    }

    private boolean checkIpVersion(String ipVersion, String zoneIp) {
        LOGGER.debug((Object)("the input ipVersion=" + ipVersion + "; zoneIp=" + zoneIp));
        if (null == zoneIp || zoneIp.isEmpty()) {
            return false;
        }
        if ("ipv4".equals(ipVersion)) {
            return IPUtil.isIpv4(zoneIp);
        }
        if ("ipv6".equals(ipVersion)) {
            return IPUtil.isIpv6(zoneIp);
        }
        if ("all".equals(ipVersion)) {
            return true;
        }
        LOGGER.error((Object)("Error ipVersion\uff1a " + ipVersion));
        return false;
    }

    private List<TopNIPFlowInfo> getTopNAttackIpFLow(String deviceIp, long ipFlowValue, int topn, String ipVersion, List<String[]> ipWhiteList) {
        AlarmThread alarmThread = AlarmThread.getInstance();
        Map<IpInfoKey, IpAlarmEntity> ipAlarmMap = alarmThread.getIpAlarmMap();
        Map<IpInfoKey, IpFlowInfo> ipFlow70secMap = alarmThread.getIpFlow70secMapOfDev(deviceIp);
        if (null == ipAlarmMap || ipAlarmMap.isEmpty()) {
            LOGGER.error((Object)"getTopNAttackIpFLow: get ipAlarmMap return empty");
            return new ArrayList<TopNIPFlowInfo>();
        }
        LOGGER.debug((Object)("ipAlarmMap=" + ipAlarmMap.toString()));
        LOGGER.debug((Object)("ipFlow70secMap=" + ipFlow70secMap.toString()));
        ArrayList<IpInFlowInfo> ipFlowList = new ArrayList<IpInFlowInfo>();
        IpInFlowInfo temp = null;
        long curInMbps = 0L;
        for (Map.Entry<IpInfoKey, IpAlarmEntity> entry : ipAlarmMap.entrySet()) {
            IpInfoKey ipInfoKey = entry.getKey();
            String zoneIp = ipInfoKey.getZoneIp();
            if (!deviceIp.equals(ipInfoKey.getDeviceIp())) continue;
            curInMbps = this.getCurrInMbps(ipFlow70secMap, entry, ipInfoKey);
            LOGGER.debug((Object)("getTopNAttackIpFLow, devideIP=" + entry.getKey().getDeviceIp() + "; zoneIP=" + zoneIp + "; curInMbps=" + curInMbps));
            if (!this.checkIpVersion(ipVersion, zoneIp) || curInMbps < ipFlowValue || 1 != ipInfoKey.getDirection()) continue;
            temp = new IpInFlowInfo(curInMbps, zoneIp);
            ipFlowList.add(temp);
        }
        return this.countTopNIpFlow(ipFlowList, deviceIp, topn, ipWhiteList);
    }

    private long getCurrInMbps(Map<IpInfoKey, IpFlowInfo> ipFlow70secMap, Map.Entry<IpInfoKey, IpAlarmEntity> entry, IpInfoKey ipInfoKey) {
        IpFlowInfo ipFlowInfo;
        long curInKbps = 0L;
        curInKbps = null == ipFlow70secMap ? entry.getValue().getCurrInKbps() : (null != (ipFlowInfo = ipFlow70secMap.get(ipInfoKey)) ? ipFlowInfo.getCurrInKbps() : entry.getValue().getCurrInKbps());
        return curInKbps / 1000L;
    }

    private List<TopNIPFlowInfo> countTopNIpFlow(List<IpInFlowInfo> ipFlowList, String deviceIp, int topn, List<String[]> ipWhiteList) {
        ArrayList<TopNIPFlowInfo> topnIPFlowList = new ArrayList<TopNIPFlowInfo>();
        if (ipFlowList.isEmpty()) {
            LOGGER.error((Object)"There is not iPFlow to match query conditon.");
            return topnIPFlowList;
        }
        Collections.sort(ipFlowList, new ComparatorImpl());
        int count = topn < ipFlowList.size() ? topn : ipFlowList.size();
        LOGGER.debug((Object)("the ipFlow count=" + count + ", and the map.size={}" + ipFlowList.size()));
        TopNIPFlowInfo inFlowInfo = null;
        int index = 1;
        String ipAddr = "";
        ArrayList<String> ipAddrList = new ArrayList<String>();
        for (int i = 0; i < ipFlowList.size(); ++i) {
            ipAddr = ipFlowList.get(i).getIpAddr();
            if (this.isInIpRange(ipWhiteList, ipAddr) || index > count || ipAddrList.contains(ipAddr)) continue;
            inFlowInfo = new TopNIPFlowInfo(deviceIp, index, ipAddr, ipFlowList.get(i).getIpFlow());
            topnIPFlowList.add(inFlowInfo);
            ipAddrList.add(ipAddr);
            ++index;
            LOGGER.debug((Object)("get the topnIpFlow." + inFlowInfo.toString()));
        }
        return topnIPFlowList;
    }

    private boolean isInIpRange(List<String[]> ipWhiteList, String ipAddr) {
        if (null == ipWhiteList || ipWhiteList.isEmpty()) {
            return false;
        }
        for (String[] ipRange : ipWhiteList) {
            if (!IPUtil.isInIpRange(ipRange, ipAddr)) continue;
            return true;
        }
        return false;
    }

    private static class ComparatorImpl<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 2687900440352307870L;

        private ComparatorImpl() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 instanceof IpInFlowInfo && o2 instanceof IpInFlowInfo) {
                long o2Flow;
                IpInFlowInfo info1 = (IpInFlowInfo)o1;
                IpInFlowInfo info2 = (IpInFlowInfo)o2;
                long o1Flow = info1.getIpFlow();
                return o1Flow > (o2Flow = info2.getIpFlow().longValue()) ? -1 : (o1Flow == o2Flow ? 0 : 1);
            }
            return -2;
        }
    }

    private static class IpInFlowInfo {
        private Long ipFlow;
        private String ipAddr;

        public IpInFlowInfo(Long ipFlow2, String ipAddr2) {
            this.ipFlow = ipFlow2;
            this.ipAddr = ipAddr2;
        }

        public Long getIpFlow() {
            return this.ipFlow;
        }

        public String getIpAddr() {
            return this.ipAddr;
        }
    }
}

