/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.db.zonedynblacklist.ZoneDynBlackListDb;
import com.hs.atic.collector.entity.log.ZoneBlackCondition;
import com.hs.atic.collector.entity.zonedynblacklist.ZoneDynBlackListObj;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.rmi.ZoneDynBlackListService;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ZoneDynBlackListServiceImpl
extends UnicastRemoteObject
implements ZoneDynBlackListService {
    private static final long serialVersionUID = -4691598192348276633L;
    private static final Logger LOGGER = LogManager.getInstance().getRMILog();

    public ZoneDynBlackListServiceImpl() throws RemoteException {
    }

    public ZoneDynBlackListServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    @Override
    public List<ZoneDynBlackListObj> getZoneDynBlackList(long zoneId) throws RemoteException {
        LOGGER.info((Object)"Get zone dynamic black list.");
        ZoneDynBlackListDb zoneDynBlackListDb = new ZoneDynBlackListDb();
        List<ZoneDynBlackListObj> blist = zoneDynBlackListDb.queryDynBlackList(zoneId);
        LOGGER.info(blist);
        return blist;
    }

    @Override
    public int modifyBlackListState(List<Long> pkids, int enable) throws RemoteException {
        if (null == pkids || pkids.size() > 10000) {
            LOGGER.error((Object)"input pkids is error");
            return -1;
        }
        LOGGER.info((Object)"Update zone dynmaic black list state.");
        ZoneDynBlackListDb zoneDynBlackListDb = new ZoneDynBlackListDb();
        return zoneDynBlackListDb.updateBlackListState(pkids, enable);
    }

    @Override
    public List<ZoneDynBlackListObj> getZoneDynBlackList(List<Long> deviceIpList) throws RemoteException {
        if (null == deviceIpList || deviceIpList.size() > 10000) {
            LOGGER.error((Object)"input param is error.");
            return null;
        }
        LOGGER.info((Object)"Get default zone dynamic black list.");
        String conditon = this.getQueryCondition(deviceIpList);
        LOGGER.info((Object)(" And devices is " + conditon));
        ZoneDynBlackListDb zoneDynBlackListDb = new ZoneDynBlackListDb();
        List<ZoneDynBlackListObj> blist = zoneDynBlackListDb.queryDynBlackListForDefaultZone(conditon);
        LOGGER.info(blist);
        return blist;
    }

    private String getQueryCondition(List<Long> deviceIpList) {
        StringBuffer devIpBuffer = new StringBuffer();
        for (Long deviceIp : deviceIpList) {
            devIpBuffer.append(deviceIp);
            devIpBuffer.append(',');
        }
        int index = devIpBuffer.lastIndexOf(",");
        devIpBuffer.deleteCharAt(index);
        return devIpBuffer.toString();
    }

    @Override
    public List<ZoneDynBlackListObj> getZoneDynBlackList(ZoneBlackCondition condition) throws RemoteException {
        if (null == condition) {
            LOGGER.error((Object)"input param is null.");
            return new ArrayList<ZoneDynBlackListObj>();
        }
        ZoneDynBlackListDb zoneDynBlackListDb = new ZoneDynBlackListDb();
        return zoneDynBlackListDb.queryDynBlackList(condition);
    }

    @Override
    public Long getZoneDynBlackListNumber(ZoneBlackCondition condition) throws RemoteException {
        if (null == condition) {
            LOGGER.error((Object)"input param is null.");
            return 0L;
        }
        ZoneDynBlackListDb zoneDynBlackListDb = new ZoneDynBlackListDb();
        return zoneDynBlackListDb.queryDynBlackListCount(condition);
    }
}

