/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.bis.model.PcapAnalysisResult;
import com.hs.atic.collector.biz.ParseFingerPrint;
import com.hs.atic.collector.biz.zonepacket.ZonePacketInfoBiz;
import com.hs.atic.collector.entity.log.RmiTuple;
import com.hs.atic.collector.entity.pcap.PcapFileQueryObj;
import com.hs.atic.collector.entity.pcap.PcapObj;
import com.hs.atic.collector.entity.pcap.ZonePacket;
import com.hs.atic.collector.entity.zonepacket.ZonePacketInfoObj;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.ParamCheckUtil;
import com.hs.atic.collector.util.PcapUtil;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.rmi.ZonePacketService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ZonePacketServiceImpl
extends UnicastRemoteObject
implements ZonePacketService {
    protected static final Logger LOGGER = LogManager.getInstance().getSysLogLogger();
    private static final long serialVersionUID = 1L;

    public ZonePacketServiceImpl() throws RemoteException {
    }

    public ZonePacketServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    @Override
    public RmiTuple<List<ZonePacketInfoObj>, Long> findAllZonePacketList(int pageIndex, int pageSize, String fileName) throws RemoteException {
        if (StringUtils.isEmpty((String)fileName)) {
            ZonePacketInfoBiz zonePacketInfoBiz = new ZonePacketInfoBiz();
            return zonePacketInfoBiz.findAllZonePacketList(pageIndex, pageSize, fileName);
        }
        if (fileName.length() <= 500) {
            ZonePacketInfoBiz zonePacketInfoBiz = new ZonePacketInfoBiz();
            return zonePacketInfoBiz.findAllZonePacketList(pageIndex, pageSize, fileName);
        }
        LOGGER.error((Object)"input param is error.");
        return null;
    }

    @Override
    public RmiTuple<List<ZonePacketInfoObj>, Long> findAttackZonePacketList(ZonePacket zonePacket) throws RemoteException {
        if (null == zonePacket) {
            LOGGER.error((Object)"input param is null");
            return null;
        }
        ZonePacketInfoBiz zonePacketInfoBiz = new ZonePacketInfoBiz();
        return zonePacketInfoBiz.findAttackZonePacketList(zonePacket);
    }

    @Override
    public List<ZonePacketInfoObj> findZonePacketList(PcapFileQueryObj pcapFileQueryObj) {
        if (null == pcapFileQueryObj) {
            LOGGER.error((Object)"input param is null");
            return null;
        }
        ZonePacketInfoBiz zonePacketInfoBiz = new ZonePacketInfoBiz();
        return zonePacketInfoBiz.findZonePacketList(pcapFileQueryObj);
    }

    @Override
    public int findZonePacketSize(PcapFileQueryObj pcapFileQueryObj) {
        if (null == pcapFileQueryObj) {
            LOGGER.error((Object)"input param is null.");
            return 0;
        }
        ZonePacketInfoBiz zonePacketInfoBiz = new ZonePacketInfoBiz();
        return zonePacketInfoBiz.findZonePacketSize(pcapFileQueryObj);
    }

    public List<String> findAttackSourceIp(String zonePacketId, int start, int limit) throws RemoteException {
        return new ArrayList<String>();
    }

    public List<PcapObj> findZonePacketPcapList(long pcapId) throws RemoteException {
        ZonePacketInfoBiz zonePacketInfoBiz = new ZonePacketInfoBiz();
        return zonePacketInfoBiz.findZonePacketPcapList(pcapId);
    }

    @Override
    public List<PcapAnalysisResult> getZoneFingerPrint(String protocol, String fileName) throws RemoteException {
        if (!ParamCheckUtil.isValidStringNotNull(fileName, 256, "^[\\w|\u4e00-\u9fa5|\\!|\\@|\\#|\\$|\\^|\\+|\\-|\\_|\\=|\\}|\\{|\\]|\\[|\\;|\\.|\\*|\\:|\\,|\\/| |%]*$")) {
            LOGGER.error((Object)"input param is error.");
            return null;
        }
        return ParseFingerPrint.parse(protocol, fileName);
    }

    @Override
    public Boolean findPcapFileByName(String fileName) throws RemoteException {
        if (!this.checkFileName(fileName)) {
            return false;
        }
        File findFile = new File(PcapUtil.getPcapFileDirectory() + File.separator + fileName);
        if (findFile.exists() && !findFile.isDirectory()) {
            return true;
        }
        return false;
    }

    private boolean checkFilePath(String pcapFolderPath, String filePath) {
        try {
            File tempFile = new File(filePath);
            File pcapFolderFile = new File(pcapFolderPath);
            if (tempFile.getCanonicalPath().startsWith(pcapFolderFile.getCanonicalPath())) {
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"getCanonicalPath IOException error");
        }
        return false;
    }

    private boolean checkFileName(String downFileName) {
        if (CommonUtil.isNull(downFileName)) {
            return false;
        }
        int index = downFileName.lastIndexOf(".");
        if (index > 0) {
            String fileName = downFileName.substring(0, index);
            String fileRealType = downFileName.substring(index + 1, downFileName.length());
            if (fileRealType.equalsIgnoreCase("pcap") && fileName.matches("^[\\w|\u4e00-\u9fa5|\\!|\\@|\\#|\\$|\\^|\\+|\\-|\\_|\\=|\\}|\\{|\\]|\\[|\\;|\\.|\\*|\\:|\\,|\\/| |%]*$")) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] downloadPcapFile(String fileName) {
        if (!this.checkFileName(fileName)) {
            return new byte[0];
        }
        String pcapFolderPath = PcapUtil.getPcapFileDirectory();
        String filePath = pcapFolderPath + File.separator + fileName;
        File findFile = new File(filePath);
        if (!this.checkFilePath(pcapFolderPath, filePath)) {
            return new byte[0];
        }
        if (findFile.exists() && !findFile.isDirectory()) {
            byte[] b = new byte[(int)findFile.length()];
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(findFile));
                if (is.read(b) != (int)findFile.length()) {
                    LOGGER.error((Object)"stream read error");
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.error((Object)"file not foud");
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (null != is) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return b;
        }
        return new byte[0];
    }
}

