/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.biz.event.process.NotifyZoneHandler;
import com.hs.atic.collector.entity.event.AbnormalEvent;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.rmi.ZoneState;
import com.hs.atic.rmi.ZoneStateService;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import org.apache.log4j.Logger;

public class ZoneStateServiceImpl
extends UnicastRemoteObject
implements ZoneStateService {
    private static final long serialVersionUID = 4328198122244734590L;
    private static final Logger LOGGER = LogManager.getInstance().getRMILog();

    public ZoneStateServiceImpl() throws RemoteException {
    }

    public ZoneStateServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    @Override
    public int getZoneState(ZoneState state) throws RemoteException {
        if (null == state) {
            LOGGER.error((Object)"input param is null.");
            return -1;
        }
        NotifyZoneHandler notifyZoneHandler = NotifyZoneHandler.getInstance();
        int zoneStatus = notifyZoneHandler.getZoneStatus(state);
        LOGGER.info((Object)("return  zone status success ,zone id is " + state + " state is " + AbnormalEvent.getStateDescription(zoneStatus)));
        return zoneStatus;
    }

    @Override
    public List<ZoneState> getAllZoneState() throws RemoteException {
        NotifyZoneHandler notifyZoneHandler = NotifyZoneHandler.getInstance();
        return notifyZoneHandler.getAllZoneStatus();
    }
}

