/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.base.dataprotect.util;

import com.hs.atic.collector.util.LogManager;
import com.hs.lego.core.sdk.base.dataprotect.DataProtector;
import com.hs.lego.core.sdk.base.dataprotect.KmcFiles;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectConfigHelper;
import org.apache.log4j.Logger;

public abstract class AticDataProtector {
    private static final Logger LOGGER = LogManager.getInstance().getSystemLog();
    private static DataProtector dataProtector = null;
    private static DataProtector dataProtectorInit = null;

    private static synchronized DataProtector getInstance() {
        if (null == dataProtector) {
            String libFolderPath = DataProtectConfigHelper.getKmclibPath();
            String sdpConfigRootPath = DataProtectConfigHelper.getKmcConfigRootPath();
            String kmcLogConfigFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("kmcLogConfigFile");
            String keyStoreFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("keyStoreFile");
            String keyStoreBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("keyStoreBakFile");
            String kmcCfgFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("kmcCfgFile");
            String kmcCfgBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("kmcCfgBakFile");
            KmcFiles kf = new KmcFiles();
            kf.setKeyStoreFile(keyStoreFile);
            kf.setKeyStoreBakFile(keyStoreBakFile);
            kf.setKmcCfgFile(kmcCfgFile);
            kf.setKmcCfgBakFile(kmcCfgBakFile);
            kf.setLogConfigFile(kmcLogConfigFile);
            dataProtector = new DataProtector(libFolderPath, kf);
            LOGGER.info((Object)"dataProtector init end");
        }
        return dataProtector;
    }

    private static synchronized DataProtector getInitInstance() {
        if (null == dataProtectorInit) {
            String libFolderPath = DataProtectConfigHelper.getKmclibPath();
            String sdpConfigRootPath = DataProtectConfigHelper.getKmcConfigRootPath();
            String kmcLogConfigFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("kmcLogConfigFile");
            String initkeyStoreFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-keyStoreFile");
            String initkeyStoreBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-keyStoreBakFile");
            String initkmcCfgFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-kmcCfgFile");
            String initkmcCfgBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-kmcCfgBakFile");
            KmcFiles kfInit = new KmcFiles();
            kfInit.setKeyStoreFile(initkeyStoreFile);
            kfInit.setKeyStoreBakFile(initkeyStoreBakFile);
            kfInit.setKmcCfgFile(initkmcCfgFile);
            kfInit.setKmcCfgBakFile(initkmcCfgBakFile);
            kfInit.setLogConfigFile(kmcLogConfigFile);
            dataProtectorInit = new DataProtector(libFolderPath, kfInit);
        }
        return dataProtectorInit;
    }

    public static String sdpEncrypt(long domainId, StringBuffer pucPlainText) {
        return AticDataProtector.getInstance().sdpEncrypt(domainId, pucPlainText);
    }

    public static String sdpEncryptLocal(StringBuffer pucPlainText) {
        return AticDataProtector.getInstance().sdpEncrypt(0L, pucPlainText);
    }

    public static String sdpEncryptInitData(StringBuffer pucPlainText) {
        return AticDataProtector.getInitInstance().sdpEncrypt(0L, pucPlainText);
    }

    public static StringBuffer sdpDecrypt(long domainId, String pucCipherText) {
        StringBuffer plainText = AticDataProtector.getInstance().sdpDecrypt(domainId, pucCipherText);
        if (null == plainText) {
            LOGGER.info((Object)"sdpDecrypt fail,try sdpDecryptInitData.");
            plainText = AticDataProtector.sdpDecryptInitData(pucCipherText);
            if (null == plainText) {
                LOGGER.info((Object)"sdpDecrypt try decrypt init data fail, pucCipherText.");
                plainText = new StringBuffer();
            }
        }
        return plainText;
    }

    public static StringBuffer sdpDecryptLocal(String pucCipherText) {
        return AticDataProtector.sdpDecrypt(0L, pucCipherText);
    }

    public static StringBuffer sdpDecryptInitData(String pucCipherText) {
        StringBuffer plainText = AticDataProtector.getInitInstance().sdpDecrypt(0L, pucCipherText);
        if (null == plainText) {
            LOGGER.info((Object)"sdpDecryptInitData fail");
        }
        return plainText;
    }

    public static String sdpProtectPwd(StringBuffer pucPlainText) {
        return AticDataProtector.getInstance().sdpProtectPwd(pucPlainText);
    }

    public static String sdpProtectPwdInitData(StringBuffer pucPlainText) {
        return AticDataProtector.getInitInstance().sdpProtectPwd(pucPlainText);
    }

    public static boolean sdpVerifyPwd(String pucPlainText, String pucCipherText) {
        boolean result = AticDataProtector.getInstance().sdpVerifyPwd(pucPlainText, pucCipherText);
        if (!result) {
            result = AticDataProtector.getInitInstance().sdpVerifyPwd(pucPlainText, pucCipherText);
        }
        return result;
    }

    public static String sdpHmac(StringBuffer pucPlainText) {
        return AticDataProtector.getInstance().sdpHmac(pucPlainText);
    }
}

