/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secsyslog;

import com.hs.atic.collector.entity.event.SysLog;
import com.hs.atic.collector.util.CrashThreadHandler;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.syslog.entity.SyslogServerEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;

public abstract class SyslogClientAbstrat
extends Thread {
    protected static final Logger LOGGER = LogManager.getInstance().getSysLogLogger();
    private static final int MAX_SYSLOG_NUM_IN_MEMORY = 100000;
    private BlockingQueue<SysLog> sysLogList = new LinkedBlockingQueue<SysLog>();
    private List<SysLog> dataList = new ArrayList<SysLog>();
    private String serverIp;
    private int serverPort;
    private SyslogServerEntity syslogServerEntity;
    private boolean flag = true;
    private SSLSocketFactory ssf = null;

    public SyslogClientAbstrat(String ip, int port) {
        this.setServerIp(ip);
        this.setServerPort(port);
        this.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
    }

    public void addSysLogList(List<SysLog> data) {
        if (this.sysLogList.size() >= 100000) {
            LOGGER.error((Object)("SysLogClientThread-addSysLogList not add syslog for too many syslog in memory: sysLogList.size()=" + this.sysLogList.size() + ", and drop data.size=" + data.size()));
            return;
        }
        for (SysLog bs : data) {
            try {
                this.sysLogList.put(bs);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"SysLogClientThread-addSysLogList", (Throwable)e);
            }
        }
    }

    public void fetchSysLogList() {
        if (this.dataList.size() <= 100000) {
            this.sysLogList.drainTo(this.dataList);
        } else {
            LOGGER.error((Object)("fetchSysLogList not add syslog for too many syslog in memory: dataList.size()=" + this.dataList.size()));
        }
    }

    public void clearSyslogList() {
        this.sysLogList.clear();
    }

    public void clearDataList() {
        this.dataList.clear();
    }

    public void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception e) {
            LOGGER.error((Object)("sleep time=" + time + " error."), (Throwable)e);
        }
    }

    public abstract void stopClient();

    public String getServerIp() {
        return this.serverIp;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public SyslogServerEntity getSyslogServerEntity() {
        return this.syslogServerEntity;
    }

    public void setSyslogServerEntity(SyslogServerEntity syslogServerEntity) {
        this.syslogServerEntity = syslogServerEntity;
    }

    public boolean isFlag() {
        return this.flag;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public List<SysLog> getDataList() {
        return this.dataList;
    }

    public SSLSocketFactory getSsf() {
        return this.ssf;
    }

    public void setSsf(SSLSocketFactory ssf) {
        this.ssf = ssf;
    }
}

