/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secsyslog;

import com.hs.atic.collector.entity.event.SysLog;
import com.hs.atic.collector.util.CrashThreadHandler;
import com.hs.atic.collector.util.IpTransformer;
import com.huawei.secsyslog.SyslogClientAbstrat;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import javax.net.ssl.SSLSocket;

public class TCPSysLogClientThread
extends SyslogClientAbstrat {
    private Socket socket = null;
    private OutputStream output = null;
    private BufferedOutputStream bos = null;

    public TCPSysLogClientThread(String ip, int port) {
        super(ip, port);
        this.setName("TcpSysLogClient_" + this.getServerIp() + "_" + this.getServerPort());
        this.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public void run() {
        if (!IpTransformer.checkIpInvaild(this.getServerIp())) {
            LOGGER.error((Object)"input serverIP is error, creat UdpSysLogClient failed.");
            return;
        }
        LOGGER.info((Object)("Thread " + this.getName() + " start run."));
        while (this.isFlag()) {
            try {
                if (null == this.socket || !this.socket.isConnected() || null == this.bos) {
                    this.connect();
                }
                if (null != this.bos) {
                    this.fetchSysLogList();
                    int index = 0;
                    if (!this.getDataList().isEmpty()) {
                        LOGGER.info((Object)("TCPSysLogClientThread-to be send dataList size is" + this.getDataList().size()));
                        for (SysLog sysLog : this.getDataList()) {
                            byte[] data = sysLog.getSyslogBytes();
                            StringBuffer dataBuffer = new StringBuffer();
                            String dataStr = new String(data, "UTF-8");
                            dataBuffer.append(dataStr.length());
                            dataBuffer.append(' ');
                            dataBuffer.append(dataStr);
                            this.bos.write(dataBuffer.toString().getBytes("UTF-8"));
                            this.bos.flush();
                            LOGGER.debug((Object)("TCPSysLogClientThread-TCP:" + this.getcleanedMessage(this.getServerIp()) + ':' + this.getServerPort() + '-' + this.getcleanedMessage(dataBuffer.toString())));
                            if (index++ % 50 != 0) continue;
                            this.sleep(2);
                        }
                        this.getDataList().clear();
                        continue;
                    }
                    this.sleep(200);
                    continue;
                }
                LOGGER.error((Object)("tcp connect failed to server=" + this.getServerIp() + ", serverPort=" + this.getServerPort() + ". Clear syslog list and try to reconnect after 60s."));
                this.getDataList().clear();
                this.sleep(60000);
            }
            catch (Exception e) {
                this.closeConnect();
                LOGGER.error((Object)(e.getMessage() + '-' + this.getServerIp()), (Throwable)e);
                this.getDataList().clear();
                this.sleep(5000);
            }
        }
    }

    private void connect() {
        LOGGER.info((Object)"TCPSysLogClientThread-enter connect() start");
        try {
            this.socket = this.getSsf().createSocket(this.getServerIp(), this.getServerPort());
            if (this.socket instanceof SSLSocket) {
                ((SSLSocket)this.socket).setEnabledCipherSuites(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256"});
                ((SSLSocket)this.socket).setEnabledProtocols(new String[]{"TLSv1.2"});
                ((SSLSocket)this.socket).startHandshake();
            }
            this.output = this.socket.getOutputStream();
            if (null != this.output) {
                this.bos = new BufferedOutputStream(this.output);
                LOGGER.info((Object)"TCPSysLogClientThread-enter connect() sucess.");
            }
        }
        catch (ConnectException ce) {
            LOGGER.error((Object)(ce.getMessage() + '-' + this.getServerIp()), (Throwable)ce);
        }
        catch (Exception e) {
            LOGGER.error((Object)(e.getMessage() + '-' + this.getServerIp()), (Throwable)e);
        }
    }

    @Override
    public void stopClient() {
        LOGGER.info((Object)"stopClient");
        this.setFlag(false);
        this.closeConnect();
    }

    private void closeConnect() {
        if (null != this.bos) {
            try {
                this.bos.close();
                this.bos = null;
            }
            catch (IOException e) {
                LOGGER.error((Object)(e.getMessage() + '-' + this.getServerIp()), (Throwable)e);
            }
        }
        if (null != this.output) {
            try {
                this.output.close();
                this.output = null;
            }
            catch (IOException e) {
                LOGGER.error((Object)(e.getMessage() + '-' + this.getServerIp()), (Throwable)e);
            }
        }
        if (null != this.socket) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (IOException e) {
                LOGGER.error((Object)(e.getMessage() + '-' + this.getServerIp()), (Throwable)e);
            }
        }
    }
}

