/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secsyslog;

import com.hs.atic.collector.entity.event.SysLog;
import com.hs.atic.collector.util.CrashThreadHandler;
import com.hs.atic.collector.util.IpTransformer;
import com.huawei.secsyslog.SyslogClientAbstrat;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Random;

public class UDPSysLogClientThread
extends SyslogClientAbstrat {
    private DatagramSocket udpSocket = null;

    public UDPSysLogClientThread(String ip, int port) {
        super(ip, port);
        Random ran = new Random();
        this.setName("UdpSysLogClient_" + this.getServerIp() + "_" + this.getServerPort() + "_" + ran.nextInt());
        this.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
    }

    @Override
    public void run() {
        if (!IpTransformer.checkIpInvaild(this.getServerIp())) {
            LOGGER.error((Object)"input serverIP is error, creat UdpSysLogClient failed.");
            return;
        }
        LOGGER.info((Object)("Thread " + this.getName() + " start run."));
        DatagramPacket packet = null;
        long allNum = 0L;
        long secondFlowNum = 0L;
        int index = 0;
        while (this.isFlag()) {
            try {
                this.fetchSysLogList();
                if (!this.getDataList().isEmpty()) {
                    index = 0;
                    InetAddress serverAddr = InetAddress.getByName(this.getServerIp());
                    int serverPort = this.getServerPort();
                    for (SysLog sysLog : this.getDataList()) {
                        try {
                            byte[] data = sysLog.getSyslogBytes();
                            packet = new DatagramPacket(data, data.length, serverAddr, serverPort);
                            this.udpSocket = new DatagramSocket();
                            this.udpSocket.send(packet);
                            this.udpSocket.close();
                            if (sysLog.isSecondFlowSyslog()) {
                                LOGGER.info((Object)("secondFlowNum=" + ++secondFlowNum + ", Send UDP syslog:" + this.getcleanedMessage(this.getServerIp()) + ':' + serverPort + '-' + this.getcleanedMessage(sysLog.toString())));
                            } else {
                                LOGGER.debug((Object)("Send UDP syslog:" + this.getcleanedMessage(this.getServerIp()) + ':' + serverPort + '-' + this.getcleanedMessage(sysLog.toString())));
                            }
                            ++allNum;
                        }
                        catch (IOException e) {
                            LOGGER.error((Object)"SysLogClient-run error", (Throwable)e);
                        }
                        if (index++ % 100 != 0) continue;
                        this.sleep(2);
                    }
                    LOGGER.info((Object)("all syslog Num = " + allNum + "; secondFlowNum=" + secondFlowNum));
                    this.getDataList().clear();
                    continue;
                }
                this.sleep(100);
            }
            catch (Exception e1) {
                LOGGER.error((Object)"UDPSysLogClient-run error", (Throwable)e1);
                this.clearDataList();
                this.sleep(5000);
            }
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public void stopClient() {
        LOGGER.error((Object)"stopClient");
        this.setFlag(false);
        if (null != this.udpSocket) {
            this.udpSocket.close();
            this.udpSocket = null;
        }
    }
}

