/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.notify.restful.service.impl;

import com.hs.atic.notify.restful.dao.RestfulConfigDao;
import com.hs.atic.notify.restful.model.RestfulConfigForm;
import com.hs.atic.notify.restful.service.RestfulService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;

public class RestfulServiceImpl
implements RestfulService {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SERVER);
    private RestfulConfigDao restfulConfigDao;
    private IDataProtectService dataProtectService;

    @Override
    public List<RestfulConfigForm> getRestfulConfig() {
        List<RestfulConfigForm> restfulConfig = this.restfulConfigDao.getRestfulConfig();
        if (null == restfulConfig || restfulConfig.isEmpty()) {
            return new ArrayList<RestfulConfigForm>();
        }
        for (RestfulConfigForm restfulConfigForm : restfulConfig) {
            String password = restfulConfigForm.getPassword();
            if (null == password) continue;
            String sdpDecrypt = this.dataProtectService.sdpDecrypt(0L, password);
            restfulConfigForm.setPassword(sdpDecrypt);
        }
        return restfulConfig;
    }

    @Override
    public void saveRestfulConfig(RestfulConfigForm form) {
        String password;
        RestfulConfigForm restfulConfigByType = this.restfulConfigDao.getRestfulConfigByType(form.getType());
        if (null != restfulConfigByType) {
            form.setId(restfulConfigByType.getId());
            this.restfulConfigDao.evict(restfulConfigByType);
        }
        if (null != (password = form.getPassword()) && !"".equals(password)) {
            String sdpEncrypt = this.dataProtectService.sdpEncrypt(0L, password);
            form.setPassword(sdpEncrypt);
        }
        logger.info((Object)("save config : " + form.toString()));
        this.restfulConfigDao.saveRestfulConfig(form);
    }

    public RestfulConfigDao getRestfulConfigDao() {
        return this.restfulConfigDao;
    }

    public void setRestfulConfigDao(RestfulConfigDao restfulConfigDao) {
        this.restfulConfigDao = restfulConfigDao;
    }

    public IDataProtectService getDataProtectService() {
        return this.dataProtectService;
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }
}

