/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi;

import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.CollectorSendSyslogService;
import com.hs.atic.rmi.FileTransService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import java.util.Map;

public class ServerCollectorRMIProxy
implements Serializable {
    private static final long serialVersionUID = -7353997750449280835L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SERVER);
    private transient Map<String, Registry> map = new HashMap<String, Registry>();

    private Registry getCollectorRegistry(String collectorIpStr) {
        logger.info((Object)("collectorIpStr:" + collectorIpStr));
        if (null != this.map.get(collectorIpStr)) {
            return this.map.get(collectorIpStr);
        }
        Registry registry = null;
        try {
            ClientSocketFactory csf = new ClientSocketFactory(true);
            registry = LocateRegistry.getRegistry(collectorIpStr, 11099, csf);
            this.map.put(collectorIpStr, registry);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("collectorIpStr:" + collectorIpStr + " have exist in the map"), (Throwable)e);
            return registry;
        }
        catch (Exception e) {
            logger.error((Object)"Regist failed !", (Throwable)e);
            registry = null;
        }
        return registry;
    }

    public CollectorSendSyslogService getCollectorSendSyslogService(String collectorIpStr) {
        CollectorSendSyslogService service = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                service = (CollectorSendSyslogService)registry.lookup("collectorSendSyslogService");
            }
            catch (Exception e) {
                logger.error((Object)"Get CollectorSendSyslogService interface object failed !", (Throwable)e);
                service = null;
            }
        }
        if (service != null) {
            logger.info((Object)("Get CollectorSendSyslogService success:" + service));
        }
        return service;
    }

    public FileTransService getFileTransService(String collectorIpStr) {
        FileTransService fileTransService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                fileTransService = (FileTransService)registry.lookup("fileTransService");
            }
            catch (Exception e) {
                logger.error((Object)"getFileTransService interface object failed !", (Throwable)e);
                fileTransService = null;
            }
        }
        return fileTransService;
    }
}

