/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.syslog.dao;

import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class SyslogServerDao
extends CommonDaoImpl {
    public boolean modifySyslogServer(SyslogServerEntity syslogServer) {
        if (null == syslogServer) {
            return false;
        }
        try {
            SyslogServerEntity server = 0 == syslogServer.getId() ? new SyslogServerEntity() : this.getSyslogServerById(syslogServer.getId());
            server = (SyslogServerEntity)AticUtil.copyProperties((Object)syslogServer, (Object)server);
            super.getHibernateTemplate().saveOrUpdate((Object)server);
            return true;
        }
        catch (Exception e) {
            throw new LegoCheckedException(1548L, (Throwable)e);
        }
    }

    public List<SyslogServerEntity> getSyslogServer() {
        String hql = "from SyslogServerEntity";
        List result = this.findByHql(hql);
        if (null != result && !result.isEmpty()) {
            return result;
        }
        return new ArrayList<SyslogServerEntity>();
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from SyslogServerEntity where (1=1) ";
        String hql4Count = "select count(*) as rowCount ";
        int index = 0;
        String filterName = conditionMap.get("serverIp");
        if (!AticUtil.isNull((String)filterName)) {
            hql = hql + " and lower(serverIp) like ? ";
            queryMap.put(index, "%" + filterName.trim().toLowerCase(Locale.ENGLISH) + "%");
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public SyslogServerEntity getSyslogServerById(int id) {
        String hql = "from SyslogServerEntity where id = ?";
        List result = this.findByHql(hql, new Object[]{id});
        if (null != result && !result.isEmpty()) {
            return (SyslogServerEntity)result.get(0);
        }
        return new SyslogServerEntity();
    }

    public SyslogServerEntity getSyslogServer(Map<String, String> condition) {
        List result;
        String serverPort;
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        int count = 0;
        String hql = "from SyslogServerEntity where ";
        String serverIp = condition.get("serverIp");
        if (null != serverIp) {
            hql = hql + "serverIp = ?";
            param.put(count++, serverIp);
        }
        if (null != (serverPort = condition.get("serverPort"))) {
            hql = hql + " and serverPort = ?";
            param.put(count, serverPort);
        }
        if (null != (result = this.findByHql(hql, param)) && !result.isEmpty()) {
            return (SyslogServerEntity)result.get(0);
        }
        return new SyslogServerEntity();
    }

    public boolean deleteSyslogServer(Map<String, String> condition) {
        String hql = "Delete from SyslogServerEntity where";
        String idInCondition = condition.get("idInCondition");
        if (null != idInCondition) {
            hql = hql + " id In (" + idInCondition + ")";
        }
        this.updateByHql(hql);
        this.logger.info((Object)"delete syslog server.");
        return true;
    }
}

