/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.system;

import com.hs.atic.bis.util.RadioBean;
import com.hs.atic.bis.util.ServerBisUtil;
import com.hs.atic.sdk.syslog.service.ISyslogServerServiceInterface;
import com.hs.atic.syslog.entity.SyslogReceiveConfEntity;
import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.hs.atic.syslog.entity.SyslogServerEntityForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.sdk.common.util.ServerVsmUtil;
import com.huawei.secsyslog.SyslogServerUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class ServerSyslogServerAction
extends BaseAction {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SERVER);
    private static final long serialVersionUID = -8223252142376295903L;
    private static final int SYSLOG_SERVER_CHECKBOX_SUM = 16;
    private static final int BYTE_ARRAY_SIZE = 1024;
    private static final int SEVERITY_WARNING = 1;
    private static final int SEVERITY_MINOR = 2;
    private static final int SEVERITY_MAJOR = 3;
    private static final int SEVERITY_CRITICAL = 4;
    private String checkboxParams = "";
    private String alarmMinLevelData = null;
    private SyslogServerEntity syslogServerEntity = null;
    private String keystoreDetail = "";
    private SyslogReceiveConfEntity syslogReceiveConfEntity = null;
    private List<RadioBean> protocolList = null;
    private List<RadioBean> defaultZoneList = null;
    private File syslogServerKeystore;
    private List<SyslogServerEntityForm> syslogServerList;
    private int id;
    private String serverIds = null;
    private int maxNumber = 5;

    public String getCheckboxParams() {
        return this.checkboxParams;
    }

    public void setCheckboxParams(String checkboxParams) {
        this.checkboxParams = checkboxParams;
    }

    public String getAlarmMinLevelData() {
        return this.alarmMinLevelData;
    }

    public void setAlarmMinLevelData(String alarmMinLevelData) {
        this.alarmMinLevelData = alarmMinLevelData;
    }

    public SyslogServerEntity getSyslogServerEntity() {
        return this.syslogServerEntity;
    }

    public void setSyslogServerEntity(SyslogServerEntity syslogServerEntity) {
        this.syslogServerEntity = syslogServerEntity;
    }

    public List<RadioBean> getProtocolList() {
        return this.protocolList;
    }

    public void setProtocolList(List<RadioBean> protocolList) {
        this.protocolList = protocolList;
    }

    public List<RadioBean> getDefaultZoneList() {
        return this.defaultZoneList;
    }

    public void setDefaultZoneList(List<RadioBean> defaultZoneList) {
        this.defaultZoneList = defaultZoneList;
    }

    public File getSyslogServerKeystore() {
        return this.syslogServerKeystore;
    }

    public void setSyslogServerKeystore(File syslogServerKeystore) {
        this.syslogServerKeystore = syslogServerKeystore;
    }

    public String getKeystoreDetail() {
        return this.keystoreDetail;
    }

    public void setKeystoreDetail(String keystoreDetail) {
        this.keystoreDetail = keystoreDetail;
    }

    public SyslogReceiveConfEntity getSyslogReceiveConfEntity() {
        return this.syslogReceiveConfEntity;
    }

    public void setSyslogReceiveConfEntity(SyslogReceiveConfEntity syslogReceiveConfEntity) {
        this.syslogReceiveConfEntity = syslogReceiveConfEntity;
    }

    public List<SyslogServerEntityForm> getSyslogServerList() {
        return this.syslogServerList;
    }

    public void setSyslogServerList(List<SyslogServerEntityForm> syslogServerList) {
        this.syslogServerList = syslogServerList;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getServerIds() {
        return this.serverIds;
    }

    public void setServerIds(String serverIds) {
        this.serverIds = serverIds;
    }

    public int getMaxNumber() {
        return this.maxNumber;
    }

    public void setMaxNumber(int maxNumber) {
        this.maxNumber = maxNumber;
    }

    public String showSyslogServer() {
        ISyslogServerServiceInterface syslogServerService = ServerBisUtil.getSyslogServerService();
        this.syslogServerList = new ArrayList<SyslogServerEntityForm>();
        if (null != syslogServerService) {
            HashMap<String, String> conditionMap = new HashMap<String, String>();
            Paging paing = syslogServerService.queryByPage(conditionMap, this.start, this.pageSize);
            List servers = paing.getData();
            if (!servers.isEmpty()) {
                for (int i = 0; i < servers.size(); ++i) {
                    SyslogServerEntity server = (SyslogServerEntity)servers.get(i);
                    SyslogServerEntityForm form = new SyslogServerEntityForm();
                    AticUtil.copyProperties((Object)server, (Object)form);
                    form.setShowTransmitType(this.getShowTransmitString(server));
                    this.syslogServerList.add(form);
                }
                this.total = paing.getCount();
            }
            this.maxNumber = SyslogServerUtil.getInstance().getMaxNumber();
        }
        return "success";
    }

    private String getShowTransmitString(SyslogServerEntity syslogServer) {
        String transmitType;
        StringBuffer showTransmitType = new StringBuffer();
        if (1 == syslogServer.getAticOptlog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.aticsyslog") + ",");
        }
        if (1 == syslogServer.getDeviceSyslog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.devicesyslog") + ",");
        }
        if (1 == syslogServer.getThirdSyslog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.thirdsyslog") + ",");
        }
        if (1 == syslogServer.getFlowSyslog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.ddosflowsyslog") + ",");
        }
        if (1 == syslogServer.getFlowSyslogOutbound()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.ddosflowsyslog.outbound") + ",");
        }
        if (1 == syslogServer.getIpFlowSecondsSyslog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.ipFlowSecondsSyslog") + ",");
        }
        if (1 == syslogServer.getAlarmSyslog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.fault") + ",");
        }
        if (1 == syslogServer.getAlarmMinLevel()) {
            showTransmitType.append(this.getText("lego.fault.severity.warning") + ",");
        } else if (2 == syslogServer.getAlarmMinLevel()) {
            showTransmitType.append(this.getText("lego.fault.severity.minor") + ",");
        } else if (3 == syslogServer.getAlarmMinLevel()) {
            showTransmitType.append(this.getText("lego.fault.severity.major") + ",");
        } else if (4 == syslogServer.getAlarmMinLevel()) {
            showTransmitType.append(this.getText("lego.fault.severity.critical") + ",");
        }
        if (1 == syslogServer.getAlarmAbnormityLog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.abnormitylog") + ",");
        }
        if (1 == syslogServer.getAlarmAttackLog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.attacklog") + ",");
        }
        if (1 == syslogServer.getAlarmRefreshLog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.refreshlog") + ",");
        }
        if (1 == syslogServer.getAlarmDetailLog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.detaillog") + ",");
        }
        if (1 == syslogServer.getAlarmAbnormityLogOutbound()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.abnormitylog.outbound") + ",");
        }
        if (1 == syslogServer.getAlarmAttackLogOutbound()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.attacklog.outbound") + ",");
        }
        if (1 == syslogServer.getAlarmRefreshLogOutbound()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.refreshlog.outbound") + ",");
        }
        if (1 == syslogServer.getAlarmDetailLogOutbound()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.detaillog.outbound") + ",");
        }
        if (!(transmitType = showTransmitType.toString()).isEmpty()) {
            transmitType = transmitType.substring(0, transmitType.length() - 1);
        }
        return transmitType;
    }

    public String editSyslogServer() {
        this.alarmMinLevelData = this.getAlarmMinLevelCombData();
        this.initProtocolRadioGroup();
        this.initDefaultZoneTransmitRadioGroup();
        ISyslogServerServiceInterface syslogServerService = ServerBisUtil.getSyslogServerService();
        if (null != syslogServerService) {
            this.syslogServerEntity = 0 != this.id ? syslogServerService.getSyslogServerById(this.id) : new SyslogServerEntity();
            StringBuffer pwd = DataProtectServiceConst.sdpDecryptInitDataBuffer((String)ServerVsmUtil.getInstance().getThridCertPwdFromCfg());
            this.syslogServerEntity.setCerStorePwd(pwd.toString());
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyslogServer() {
        String[] checkboxCheckeds;
        boolean isAdd = 0 == this.syslogServerEntity.getId();
        ISyslogServerServiceInterface syslogServerService = ServerBisUtil.getSyslogServerService();
        if (isAdd) {
            int max = SyslogServerUtil.getInstance().getMaxNumber();
            List<SyslogServerEntity> servers = syslogServerService.getSyslogServer();
            this.maxNumber = max;
            if (servers.size() >= max) {
                this.responseResult("MAX");
                return;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("serverIp", this.syslogServerEntity.getServerIp());
            map.put("serverPort", this.syslogServerEntity.getServerPort() + "");
            SyslogServerEntity server = syslogServerService.getSyslogServer(map);
            if (0 < server.getId()) {
                logger.error((Object)"syslogServerEntity has been existed a same serverip and port server.");
                this.responseResult("EXIST");
                return;
            }
        }
        if ((checkboxCheckeds = this.checkboxParams.split(",")).length != 16) {
            logger.error((Object)("checkboxCheckeds's length is wrong. checkboxCheckeds is :" + checkboxCheckeds.length));
            return;
        }
        this.syslogServerEntity.setAticOptlog(Integer.parseInt(checkboxCheckeds[0]));
        this.syslogServerEntity.setDeviceSyslog(Integer.parseInt(checkboxCheckeds[1]));
        this.syslogServerEntity.setThirdSyslog(Integer.parseInt(checkboxCheckeds[2]));
        this.syslogServerEntity.setFlowSyslog(Integer.parseInt(checkboxCheckeds[3]));
        this.syslogServerEntity.setFlowSyslogOutbound(Integer.parseInt(checkboxCheckeds[4]));
        this.syslogServerEntity.setIpFlowSecondsSyslog(Integer.parseInt(checkboxCheckeds[5]));
        this.syslogServerEntity.setAlarmSyslog(Integer.parseInt(checkboxCheckeds[6]));
        this.syslogServerEntity.setAlarmAbnormityLog(Integer.parseInt(checkboxCheckeds[7]));
        this.syslogServerEntity.setAlarmAttackLog(Integer.parseInt(checkboxCheckeds[8]));
        this.syslogServerEntity.setAlarmRefreshLog(Integer.parseInt(checkboxCheckeds[9]));
        this.syslogServerEntity.setAlarmDetailLog(Integer.parseInt(checkboxCheckeds[10]));
        this.syslogServerEntity.setAlarmAbnormityLogOutbound(Integer.parseInt(checkboxCheckeds[11]));
        this.syslogServerEntity.setAlarmAttackLogOutbound(Integer.parseInt(checkboxCheckeds[12]));
        this.syslogServerEntity.setAlarmRefreshLogOutbound(Integer.parseInt(checkboxCheckeds[13]));
        this.syslogServerEntity.setAlarmDetailLogOutbound(Integer.parseInt(checkboxCheckeds[14]));
        this.syslogServerEntity.setTransferProtocol(Integer.parseInt(checkboxCheckeds[15]));
        boolean isSave = false;
        boolean isSaveServer = false;
        try {
            if (1 == this.syslogServerEntity.getTransferProtocol() && null != this.syslogServerKeystore) {
                this.checkFileSize();
                if ("Analysis failed.".equals(this.checkFileIsCorrect())) {
                    this.responseResult("Analysis failed.");
                    return;
                }
                this.syslogServerEntity.setSyslogServerKeystore(this.syslogServerKeystore);
                if (null != this.syslogServerEntity.getCerStorePwd() && !this.syslogServerEntity.getCerStorePwd().isEmpty()) {
                    this.syslogServerEntity.setCerStorePwd(DataProtectServiceConst.sdpEncryptInitData((String)this.syslogServerEntity.getCerStorePwd()));
                }
                isSaveServer = AticUtil.saveFile((File)this.syslogServerKeystore, (String)(this.getCertsPath() + "third_truststore"));
            } else {
                isSaveServer = true;
            }
            if (null != syslogServerService) {
                isSave = syslogServerService.modifySyslogServer(this.syslogServerEntity);
            }
        }
        catch (Exception e) {
            logger.error((Object)"syslogServerEntity saved failed", (Throwable)e);
            this.responseResult("OFFLINE");
        }
        finally {
            SysOptLog oOptLog = new SysOptLog();
            Date date = new Date();
            oOptLog.setDate(date);
            oOptLog.setLevel(3);
            oOptLog.setTarget("lego.lab.com.syslogserver");
            oOptLog.setTargetLocal(Boolean.valueOf(true));
            oOptLog.setModule("lego.dic.module.system");
            if (isAdd) {
                oOptLog.setOperation("lego.lab.com.syslog.server.create.title");
            } else {
                oOptLog.setOperation("lego.lab.log.func.modifysyslogsrv");
            }
            User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
            String usrName = currentUser.getUserName();
            oOptLog.setOperator(usrName);
            oOptLog.setTerminalIp(currentUser.getIpAdr());
            if (!isSave) {
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.lab.log.func.modifysyslogsrv.failed");
            } else if (!isSaveServer) {
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.lab.log.func.modifysyslogsrv.save.failed");
            } else {
                oOptLog.setResult(1);
                oOptLog.setDetail(this.syslogServerEntity.getServerIp() + "," + this.syslogServerEntity.getServerPort());
            }
            ISysOptLog sysOpLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
            sysOpLog.writeOptLog(oOptLog);
        }
        if (!isSave) {
            logger.error((Object)"syslogServerEntity saved config failed");
            this.responseResult("OFFLINE");
        } else if (!isSaveServer) {
            logger.error((Object)"syslogServerEntity saved syslogServerKeystore failed");
            this.responseResult("SAVE_FEILED");
        } else {
            logger.info((Object)"syslogServerEntity saved result is = success");
            this.responseResult("success");
        }
    }

    public void deleteSyslogServer() {
        if (!StringUtils.isEmpty((CharSequence)this.serverIds)) {
            boolean isDeleteServer = false;
            ISyslogServerServiceInterface syslogServerService = ServerBisUtil.getSyslogServerService();
            HashMap<String, String> conditionMap = new HashMap<String, String>();
            String ids = this.serverIds.substring(0, this.serverIds.length() - 1);
            conditionMap.put("idInCondition", ids);
            User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
            conditionMap.put("userName", currentUser.getUserName());
            conditionMap.put("userIp", currentUser.getIpAdr());
            isDeleteServer = syslogServerService.deleteSyslogServer(conditionMap);
            if (!isDeleteServer) {
                logger.error((Object)"syslogServerEntity delete failed");
                this.responseResult("DELETE_FEILED");
                return;
            }
        }
        this.responseResult("success");
    }

    public String showKeystoreDetail() {
        try {
            StringBuffer pwd = DataProtectServiceConst.sdpDecryptInitDataBuffer((String)ServerVsmUtil.getInstance().getThridCertPwdFromCfg());
            this.keystoreDetail = ServerVsmUtil.getInstance().printKeystoreInfo(this.getCertsPath() + "third_truststore", pwd.toString());
        }
        catch (RuntimeException e) {
            this.keystoreDetail = "Analysis failed.";
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void downloadThirdTruststore() {
        block8: {
            FileInputStream fileInputStream = null;
            BufferedInputStream input = null;
            ServletOutputStream servletOutputStream = null;
            BufferedOutputStream output = null;
            try {
                String[] detailPara = new String[]{"third_truststore"};
                this.getOperateLog().normal("atic.lab.com.syslog.keystore.download", "lego.dic.module.system", "third_truststore", false, "atic.lab.com.syslog.keystore.download.detail", detailPara);
                HttpServletResponse response = this.getResponse();
                response.setContentType("application/x-download");
                response.setHeader("Content-Disposition", "attachment;filename=" + new String("third_truststore".getBytes("gb2312"), "ISO-8859-1"));
                fileInputStream = new FileInputStream(this.getCertsPath() + "third_truststore");
                input = new BufferedInputStream(fileInputStream);
                servletOutputStream = response.getOutputStream();
                output = new BufferedOutputStream((OutputStream)servletOutputStream);
                byte[] b = new byte[1024];
                int len = 0;
                while ((len = input.read(b)) != -1) {
                    output.write(b, 0, len);
                }
                output.flush();
                this.closeInput(input);
            }
            catch (IOException e) {
                logger.error((Object)"download error IOException", (Throwable)e);
                break block8;
            }
            catch (RuntimeException e2) {
                logger.error((Object)"download error RuntimeException", (Throwable)e2);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeInput(input);
                this.closeFileInputStream(fileInputStream);
                this.closeOutput(output);
                this.closeServletOutputStream(servletOutputStream);
            }
            this.closeFileInputStream(fileInputStream);
            this.closeOutput(output);
            this.closeServletOutputStream(servletOutputStream);
        }
    }

    private void closeInput(BufferedInputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"input close IOException");
        }
    }

    private void closeFileInputStream(FileInputStream fileInputStream) {
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"fileInputStream close IOException");
        }
    }

    private void closeOutput(BufferedOutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"output close IOException");
        }
    }

    private void closeServletOutputStream(ServletOutputStream servletOutputStream) {
        try {
            if (servletOutputStream != null) {
                servletOutputStream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"servletOutputStream close IOException");
        }
    }

    public boolean validateParams() {
        if (!this.checkParas()) {
            return false;
        }
        return this.checkboxParams != null && !"".equals(this.checkboxParams);
    }

    private boolean checkParas() {
        if ("0".equals(this.fetchRequest().getParameter("1")) || "0".equals(this.fetchRequest().getParameter("0"))) {
            return this.checkUdpParams();
        }
        if ("1".equals(this.fetchRequest().getParameter("1")) || "1".equals(this.fetchRequest().getParameter("0"))) {
            return this.checkTcpParams();
        }
        return false;
    }

    private boolean checkTcpParams() {
        if (!this.checkTcpParamsBefore()) {
            return false;
        }
        String port = this.fetchRequest().getParameter("syslogServerEntity.serverPort");
        if (null == port || "".equals(port.trim())) {
            return false;
        }
        if (1 > Integer.parseInt(port) || 65535 < Integer.parseInt(port)) {
            return false;
        }
        String alarmMinLevel = this.fetchRequest().getParameter("syslogServerEntity.alarmMinLevel");
        return null == alarmMinLevel || "1".equals(alarmMinLevel) || "2".equals(alarmMinLevel) || "3".equals(alarmMinLevel) || "4".equals(alarmMinLevel);
    }

    private void checkFileSize() {
        if (null != this.syslogServerKeystore && this.syslogServerKeystore.length() > 0x100000L) {
            throw new LegoCheckedException(573000L);
        }
    }

    private String checkFileIsCorrect() {
        String result = "Analysis failed.";
        String filePath = this.getCertsPath() + "third_truststore" + "_temp";
        boolean isSaveServer = AticUtil.saveFile((File)this.syslogServerKeystore, (String)filePath);
        StringBuffer cerPwd = new StringBuffer();
        if (null != this.syslogServerEntity) {
            cerPwd.append(this.syslogServerEntity.getCerStorePwd());
        }
        if (isSaveServer) {
            String detail = ServerVsmUtil.getInstance().printKeystoreInfo(filePath, cerPwd.toString());
            File file = new File(filePath);
            boolean deleteSucceed = file.delete();
            if (!deleteSucceed) {
                logger.error((Object)"delete file third_truststore_temp error");
            }
            result = detail;
        }
        return result;
    }

    private boolean checkTcpParamsBefore() {
        String ips;
        if (null != this.syslogServerKeystore) {
            String cerStorePwd = this.fetchRequest().getParameter("syslogServerEntity.cerStorePwd");
            if (AticUtil.isNull((String)cerStorePwd) || cerStorePwd.length() > 64 || cerStorePwd.length() < 6) {
                return false;
            }
            Pattern p1 = Pattern.compile("[a-zA-Z]+");
            Pattern p2 = Pattern.compile("[0-9]+");
            Pattern p3 = Pattern.compile("[=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]");
            Matcher m1 = p1.matcher(cerStorePwd);
            Matcher m2 = p2.matcher(cerStorePwd);
            Matcher m3 = p3.matcher(cerStorePwd);
            if (!(m1.find() && m2.find() && m3.find())) {
                return false;
            }
            String pwdregex = "[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
            if (!cerStorePwd.matches(pwdregex)) {
                return false;
            }
        }
        if (null == (ips = this.fetchRequest().getParameter("syslogServerEntity.serverIp")) || "".equals(ips.trim())) {
            return false;
        }
        if (ips.length() < 255) {
            String[] split;
            for (String ip : split = ips.split(",")) {
                if (IPUtil.isIpv4((String)ip) || IPUtil.isIpv6((String)ip)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkUdpParams() {
        if (!this.checkUdpParamsBefore()) {
            return false;
        }
        String port = this.fetchRequest().getParameter("syslogServerEntity.serverPort");
        if (null == port || "".equals(port.trim())) {
            return false;
        }
        if (1 > Integer.parseInt(port) || 65535 < Integer.parseInt(port)) {
            return false;
        }
        String alarmMinLevel = this.fetchRequest().getParameter("syslogServerEntity.alarmMinLevel");
        return null == alarmMinLevel || "1".equals(alarmMinLevel) || "2".equals(alarmMinLevel) || "3".equals(alarmMinLevel) || "4".equals(alarmMinLevel);
    }

    private boolean checkUdpParamsBefore() {
        String ips = this.fetchRequest().getParameter("syslogServerEntity.serverIp");
        if (null == ips || "".equals(ips.trim())) {
            return false;
        }
        if (ips.length() < 255) {
            String[] split;
            for (String ip : split = ips.split(",")) {
                if (IPUtil.isIpv4((String)ip) || IPUtil.isIpv6((String)ip)) continue;
                return false;
            }
        }
        return true;
    }

    private String getCertsPath() {
        String savePath = ServerVsmUtil.getInstallPath() + File.separator + "LegoRuntime" + File.separator + "cert" + File.separator;
        return savePath;
    }

    public String getAlarmMinLevelCombData() {
        StringBuffer combData = new StringBuffer();
        combData.append("[['").append(4).append("','").append(this.getText("lego.fault.severity.critical")).append("'],");
        combData.append("['").append(3).append("','").append(this.getText("lego.fault.severity.major")).append("'],");
        combData.append("['").append(2).append("','").append(this.getText("lego.fault.severity.minor")).append("'],");
        combData.append("['").append(1).append("','").append(this.getText("lego.fault.severity.warning")).append("']]");
        return combData.toString();
    }

    private void initProtocolRadioGroup() {
        this.protocolList = new ArrayList<RadioBean>();
        RadioBean appointIpRadio = new RadioBean();
        appointIpRadio.setKey(0);
        appointIpRadio.setLabel(this.getText("lego.lab.com.syslog.protocol.udp"));
        this.protocolList.add(appointIpRadio);
        RadioBean zoneIpRadio = new RadioBean();
        zoneIpRadio.setKey(1);
        zoneIpRadio.setLabel(this.getText("lego.lab.com.syslog.protocol.tcp"));
        this.protocolList.add(zoneIpRadio);
    }

    private void initDefaultZoneTransmitRadioGroup() {
        this.defaultZoneList = new ArrayList<RadioBean>();
        RadioBean appointIpRadio = new RadioBean();
        appointIpRadio.setKey(1);
        appointIpRadio.setLabel(this.getText("lego.lab.com.syslog.server.transmit"));
        this.defaultZoneList.add(appointIpRadio);
        RadioBean zoneIpRadio = new RadioBean();
        zoneIpRadio.setKey(0);
        zoneIpRadio.setLabel(this.getText("lego.lab.com.syslog.server.no.transmit"));
        this.defaultZoneList.add(zoneIpRadio);
    }

    public boolean validatePort() {
        String[] checkboxCheckeds;
        if (null == this.syslogReceiveConfEntity) {
            return false;
        }
        int tcpPort = this.syslogReceiveConfEntity.getTcpReceivePort();
        int udpPort = this.syslogReceiveConfEntity.getUdpReceivePort();
        if (null != this.checkboxParams && (checkboxCheckeds = this.checkboxParams.split(",")).length == 2) {
            this.syslogReceiveConfEntity.setEnableTcpReceive("1".equals(checkboxCheckeds[0]));
            this.syslogReceiveConfEntity.setEnableUdpReceive("1".equals(checkboxCheckeds[1]));
        }
        if (this.syslogReceiveConfEntity.isEnableTcpReceive()) {
            if (tcpPort < 1 || tcpPort > 65535) {
                return false;
            }
        } else {
            this.syslogReceiveConfEntity.setTcpReceivePort(6514);
        }
        if (this.syslogReceiveConfEntity.isEnableUdpReceive()) {
            if (udpPort < 1 || udpPort > 65535) {
                return false;
            }
        } else {
            this.syslogReceiveConfEntity.setUdpReceivePort(514);
        }
        return true;
    }
}

