/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.notify.send;

import java.util.ArrayList;
import java.util.List;

public abstract class SmsContentSplit {
    private static final int MAX_CHINESE_LEN = 65;
    private static final int MAX_ENGLISH_LEN = 65;

    public static List<String> getMsgListBy(String strMsg) {
        List<String> aList = SmsContentSplit.getSplitMsgList(strMsg);
        ArrayList<String> fList = new ArrayList<String>();
        int page = aList.size();
        int pageInd = 0;
        for (String one : aList) {
            StringBuilder content = new StringBuilder();
            content.append('<');
            content.append(++pageInd);
            content.append('/');
            content.append(page);
            content.append('>');
            content.append(one);
            fList.add(content.toString());
        }
        return fList;
    }

    private static List<String> getSplitMsgList(String strMsg) {
        String[] aArr;
        int maxLen = 65;
        if (!SmsContentSplit.isIncludeChineseChar(strMsg)) {
            maxLen = 65;
        }
        int length = strMsg.length();
        ArrayList<String> aList = new ArrayList<String>();
        if (maxLen >= length) {
            aList.add(strMsg);
            return aList;
        }
        String split = ";#;";
        StringBuilder builder = new StringBuilder();
        char[] aChar = strMsg.toCharArray();
        int k = 0;
        int len = aChar.length;
        for (int i = 0; i < len; ++i) {
            if (k == maxLen) {
                int n;
                k = n = SmsContentSplit.processWordsSplit(";#;", builder, aChar, i);
            }
            builder.append(aChar[i]);
            ++k;
        }
        for (String one : aArr = builder.toString().split(";#;")) {
            aList.add(one.trim());
        }
        return aList;
    }

    private static int processWordsSplit(String split, StringBuilder builder, char[] aChar, int i) {
        char a;
        int nextChar = 32;
        if (i != aChar.length - 1) {
            nextChar = aChar[i];
        }
        if ((a = aChar[i]) > '\u0100' || nextChar == 32) {
            builder.append(split);
            return 0;
        }
        int index = SmsContentSplit.includeChineseChar(builder.toString()) + 1;
        if (aChar[index] == ':') {
            ++index;
        }
        int startIndex = builder.toString().lastIndexOf(" ") > builder.toString().lastIndexOf("\n") ? builder.toString().lastIndexOf(" ") : builder.toString().lastIndexOf("\n");
        String oldStr = "";
        String trimStr = "";
        if (index > startIndex) {
            oldStr = builder.toString().substring(0, index);
            trimStr = builder.toString().substring(index);
        } else {
            oldStr = builder.toString().substring(0, startIndex);
            trimStr = builder.toString().substring(startIndex + 1);
        }
        builder.delete(0, builder.length());
        builder.append(oldStr);
        builder.append(split);
        builder.append(trimStr);
        return trimStr.length();
    }

    private static boolean isIncludeChineseChar(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isLetter(c) || Character.getType(c) != 5) continue;
            return true;
        }
        return false;
    }

    private static int includeChineseChar(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (!Character.isLetter(c) || Character.getType(c) != 5) continue;
            return i;
        }
        return -1;
    }
}

