/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.notify.send;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SmsParser {
    private static final int MAX_CHINESE_LEN = 65;
    private static final int MAX_ENGLISH_LEN = 65;
    private static final String COUNTRYCODEFRONT1 = "0011000";
    private static final String COUNTRYCODEFRONT2 = "91";
    private static final String COUNTRYCODEBACK = "0008A7";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SERVER);

    public String convertTelphoneNo(String telphone) {
        char[] pChar;
        if (null == telphone) {
            return "";
        }
        int len = telphone.length();
        boolean isOdd = false;
        if (len % 2 != 0) {
            pChar = new char[len + 1];
            isOdd = true;
        } else {
            pChar = new char[len];
        }
        for (int i = 0; i < len; i += 2) {
            if (i > len - 2) continue;
            pChar[i] = telphone.charAt(i + 1);
            pChar[i + 1] = telphone.charAt(i);
        }
        if (isOdd) {
            pChar[len - 1] = 70;
            pChar[len] = telphone.charAt(len - 1);
        }
        return new String(pChar);
    }

    public String parseMessageToUnicode(String content) {
        StringBuffer sb = new StringBuffer();
        try {
            byte[] bt = content.getBytes("UTF-16BE");
            for (int i = 0; i < bt.length; ++i) {
                String tmp = null;
                if (bt[i] < 17 && bt[i] >= 0) {
                    tmp = "0";
                    tmp = tmp + Integer.toHexString(bt[i]);
                } else {
                    tmp = bt[i] == -1 ? "ff" : Integer.toHexString(bt[i]);
                }
                if (tmp.length() > 2) {
                    tmp = tmp.substring(tmp.length() - 2, tmp.length());
                }
                sb.append(tmp);
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"UnsupportedEncodingException: ", (Throwable)e);
        }
        return sb.toString();
    }

    public List<String> getMsgListBy(String strMsg) {
        List<String> aList = this.getSplitMsgList(strMsg);
        ArrayList<String> fList = new ArrayList<String>();
        int page = aList.size();
        int pageInd = 0;
        for (String one : aList) {
            StringBuilder content = new StringBuilder();
            content.append('<');
            content.append(++pageInd);
            content.append('/');
            content.append(page);
            content.append('>');
            content.append(one);
            fList.add(content.toString());
        }
        return fList;
    }

    private List<String> getSplitMsgList(String strMsg) {
        String[] aArr;
        int maxLen = 65;
        if (!SmsParser.isIncludeChineseChar(strMsg)) {
            maxLen = 65;
        }
        int length = strMsg.length();
        ArrayList<String> aList = new ArrayList<String>();
        if (maxLen >= length) {
            aList.add(strMsg);
            return aList;
        }
        String split = ";#;";
        StringBuilder builder = new StringBuilder();
        char[] aChar = strMsg.toCharArray();
        int k = 0;
        int len = aChar.length;
        for (int i = 0; i < len; ++i) {
            if (k == maxLen) {
                int n;
                k = n = this.processWordsSplit(";#;", builder, aChar, i);
            }
            builder.append(aChar[i]);
            ++k;
        }
        for (String one : aArr = builder.toString().split(";#;")) {
            aList.add(one.trim());
        }
        return aList;
    }

    private int processWordsSplit(String split, StringBuilder builder, char[] aChar, int i) {
        char a;
        int nextChar = 32;
        if (i != aChar.length - 1) {
            nextChar = aChar[i];
        }
        if ((a = aChar[i]) > '\u0100' || nextChar == 32 || nextChar == 58) {
            builder.append(split);
            return 0;
        }
        int index = this.includeChineseChar(builder.toString()) + 1;
        if (aChar[index] == ':') {
            ++index;
        }
        int startIndex = builder.toString().lastIndexOf(" ") > builder.toString().lastIndexOf("\n") ? builder.toString().lastIndexOf(" ") : builder.toString().lastIndexOf("\n");
        String oldStr = "";
        String trimStr = "";
        if (index > startIndex) {
            oldStr = builder.toString().substring(0, index);
            trimStr = builder.toString().substring(index);
        } else {
            oldStr = builder.toString().substring(0, startIndex);
            trimStr = builder.toString().substring(startIndex + 1);
        }
        builder.delete(0, builder.length());
        builder.append(oldStr);
        builder.append(split);
        builder.append(trimStr);
        return trimStr.length();
    }

    private static boolean isIncludeChineseChar(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isLetter(c) || Character.getType(c) != 5) continue;
            return true;
        }
        return false;
    }

    public int includeChineseChar(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (!Character.isLetter(c) || Character.getType(c) != 5) continue;
            return i;
        }
        return -1;
    }

    public String getCountryCodeBack() {
        return COUNTRYCODEBACK;
    }

    public String getCountryCodeFront(String telphoneNo, String countryCode) {
        return COUNTRYCODEFRONT1 + Integer.toHexString((countryCode + telphoneNo).length()).toUpperCase(Locale.getDefault()) + COUNTRYCODEFRONT2;
    }
}

