/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.notify.service;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.notify.dao.ISmsServerDAO;
import com.hs.lego.core.notify.send.SmsSendService;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sp.sdk.model.SmsConfig;
import com.hs.lego.nem.fault.sdk.model.SmsServer;
import com.hs.lego.nem.fault.sdk.service.ISmsServerService;

public class SmsServerServiceImpl
implements ISmsServerService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SERVER);
    private ISmsServerDAO smsServerDAO;
    private SmsSendService smsSendService;
    private IDataProtectService dataProtectService;

    public SmsServer getSmsServer() {
        String proxyPwd;
        SmsServer smsServer = this.smsServerDAO.getSmsServer();
        String pwd = smsServer.getPassword();
        if (null != pwd && !"".equals(pwd)) {
            smsServer.setPassword(this.dataProtectService.sdpDecrypt(0L, pwd));
        }
        if (null != (proxyPwd = smsServer.getProxyPassword()) && !"".equals(proxyPwd)) {
            smsServer.setProxyPassword(this.dataProtectService.sdpDecrypt(0L, proxyPwd));
        }
        return smsServer;
    }

    public boolean modifyModemServer(SmsServer smsServer) {
        String proxyPwd;
        String pwd = smsServer.getPassword();
        if (null != pwd) {
            smsServer.setPassword(this.dataProtectService.sdpEncrypt(0L, pwd));
        }
        if (null != (proxyPwd = smsServer.getProxyPassword())) {
            smsServer.setProxyPassword(this.dataProtectService.sdpEncrypt(0L, proxyPwd));
        }
        return this.smsServerDAO.modifyModemServer(smsServer);
    }

    public boolean modifyQXTSpServer(SmsServer smsServer) {
        return this.smsServerDAO.modifyQXTSpServer(smsServer);
    }

    public int testSendSms(SmsConfig smsConfig) {
        try {
            return this.smsSendService.testSendSms(smsConfig);
        }
        catch (Exception e) {
            LOGGER.error((Object)"test sms exception.", (Throwable)e);
            return -1;
        }
    }

    public ISmsServerDAO getSmsServerDAO() {
        return this.smsServerDAO;
    }

    public void setSmsServerDAO(ISmsServerDAO smsServerDAO) {
        this.smsServerDAO = smsServerDAO;
    }

    public SmsSendService getSmsSendService() {
        return this.smsSendService;
    }

    public void setSmsSendService(SmsSendService smsSendService) {
        this.smsSendService = smsSendService;
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }
}

