/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.notify.trap;

import com.hs.atic.util.CrashThreadHandler;
import com.hs.lego.cbb.nms.sdk.model.NmsConfig;
import com.hs.lego.cbb.nms.sdk.service.ISlaveService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.notify.sdk.model.EmailBean;
import com.hs.lego.core.system.notify.sdk.model.SmsBean;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class NotifyTrapSender
implements Runnable {
    private static final int QUEUE_SIZE = 10240;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SERVER);
    private Thread thisThread = null;
    private ISlaveService slaveService = null;
    private BlockingQueue<String[]> northTrapVaribles = new LinkedBlockingQueue<String[]>(10240);

    public void start() {
        if (null == this.thisThread) {
            this.thisThread = new Thread(this);
            this.thisThread.setName("remote notify trap send thread");
            this.thisThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
            this.thisThread.start();
        }
        this.northTrapVaribles.clear();
    }

    public void stop() {
        Thread tmpThread = this.thisThread;
        this.thisThread = null;
        if (null != tmpThread) {
            tmpThread.interrupt();
        }
        this.northTrapVaribles.clear();
    }

    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        while (this.thisThread == thread) {
            try {
                String[] snmpVarible = this.northTrapVaribles.take();
                for (NmsConfig nmsConfig : this.getAllMasterNms()) {
                    this.sendTrap(nmsConfig.getNmsIp(), snmpVarible);
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                LOGGER.info((Object)"interrupt Thread[remote notify trap send thread].");
            }
            catch (Exception e) {
                LOGGER.error((Object)"throwable caught in NotifyTrapSender.", (Throwable)e);
            }
        }
    }

    private List<NmsConfig> getAllMasterNms() {
        return this.slaveService.getAllMasterNms();
    }

    private void sendTrap(String trapIp, String[] snmpVarible) {
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("try to send notify trap to: ").append(trapIp).append(", var: (");
            for (String var : snmpVarible) {
                buf.append(var);
                buf.append(", ");
            }
            buf.append(')');
            LOGGER.info((Object)buf.toString());
            LOGGER.info((Object)"send notify trap success.");
        }
        catch (Exception e) {
            if (e.getMessage().contains("snmp operation failed, errorCode: -1,")) {
                LOGGER.info((Object)"send notify trap success.");
                return;
            }
            LOGGER.error((Object)"send notify trap exception.", (Throwable)e);
        }
    }

    public void notifySms(SmsBean smsBean) {
        if (this.northTrapVaribles.size() >= 10240) {
            LOGGER.error((Object)"add a remote notify trap variable in NotifyTrapSender.");
            return;
        }
        this.northTrapVaribles.add(this.convertTrapVar(smsBean));
    }

    public void notifyEmail(EmailBean emailBean) {
        if (this.northTrapVaribles.size() >= 10240) {
            LOGGER.error((Object)"add a remote notify trap variable in NotifyTrapSender.");
            return;
        }
        this.northTrapVaribles.add(this.convertTrapVar(emailBean));
    }

    private String[] convertTrapVar(Object remoteBean) {
        if (null == remoteBean) {
            LOGGER.error((Object)"convertTrapVariable failed, param remoteBean is null.");
            return new String[0];
        }
        try {
            String[] var = new String[5];
            if (remoteBean instanceof SmsBean) {
                SmsBean smsBean = (SmsBean)remoteBean;
                var[0] = String.valueOf(smsBean.getSmsMode());
                var[1] = this.codeSnmpString(this.convert2String(smsBean.getPhoneTo()));
                var[2] = "";
                var[3] = this.codeSnmpString(smsBean.getContentKey());
                var[4] = this.codeSnmpString(String.valueOf(smsBean.getLanguage()));
            } else if (remoteBean instanceof EmailBean) {
                EmailBean emailBean = (EmailBean)remoteBean;
                var[0] = "3";
                var[1] = this.codeSnmpString(this.convert2String(emailBean.getEmailTo()));
                var[2] = this.codeSnmpString(emailBean.getTitleKey());
                var[3] = this.codeSnmpString(emailBean.getContentKey());
                var[4] = this.codeSnmpString(String.valueOf(emailBean.getLanguage()));
            }
            return var;
        }
        catch (Exception e) {
            LOGGER.error((Object)"getAlarmVariables error in NotifyTrapSender.", (Throwable)e);
            return new String[0];
        }
    }

    private String convert2String(String[] strArray) {
        StringBuffer buf = new StringBuffer();
        for (String string : strArray) {
            buf.append(string);
            buf.append(',');
        }
        String strs = buf.toString();
        return strs.substring(0, strs.length() - 1);
    }

    private String codeSnmpString(String str) {
        try {
            if (null != str) {
                return new String(str.getBytes("ISO8859-1"), "ISO8859-1");
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"codeSnmpString with ISO8859-1 failed in NotifyTrapSender.", (Throwable)e);
        }
        return str;
    }

    public ISlaveService getSlaveService() {
        return this.slaveService;
    }

    public void setSlaveService(ISlaveService slaveService) {
        this.slaveService = slaveService;
    }
}

