/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.sdk.common.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import com.huawei.atic.util.CertFileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public final class ServerVsmUtil {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SERVER);
    private static final ServerVsmUtil INSTANCE = new ServerVsmUtil();
    private static final int MAX_COUNT = 0x100000;

    private ServerVsmUtil() {
    }

    public static ServerVsmUtil getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String printKeystoreInfo(String path, String pwd) {
        String str;
        BufferedReader errorRead;
        InputStream errorIn;
        BufferedReader read;
        InputStream in;
        Process p;
        block11: {
            if (null == path || null == pwd) {
                logger.error((Object)"printKeystoreInfo error, path or pwd is null");
                return "Analysis failed.";
            }
            p = null;
            in = null;
            read = null;
            StringBuffer buffer = new StringBuffer();
            errorIn = null;
            errorRead = null;
            StringBuffer errorBuffer = new StringBuffer();
            str = "";
            StringBuffer cmd = new StringBuffer();
            cmd.append(ServerVsmUtil.getInstallPath() + File.separator + "jre6.0.18" + File.separator + "bin" + File.separator);
            cmd.append("keytool -list -v -keystore ");
            cmd.append(path);
            cmd.append(" -storepass ");
            cmd.append(pwd);
            try {
                String line;
                p = Runtime.getRuntime().exec(cmd.toString());
                in = p.getInputStream();
                if (null != in) {
                    read = new BufferedReader(new InputStreamReader(in, "gb2312"));
                    line = null;
                    while ((line = read.readLine()) != null && buffer.length() <= 0x100000) {
                        buffer.append(line);
                        buffer.append("\n\r");
                    }
                }
                if ((str = buffer.toString()).contains("Exception")) {
                    str = "Analysis failed.";
                }
                if (null == (errorIn = p.getErrorStream())) break block11;
                errorRead = new BufferedReader(new InputStreamReader(errorIn, "gb2312"));
                line = null;
                while ((line = errorRead.readLine()) != null) {
                    errorBuffer.append(line);
                    errorBuffer.append("\n\r");
                }
                if (errorBuffer.length() <= 0) break block11;
                logger.error((Object)("errorBuffer content is:" + errorBuffer.toString()));
            }
            catch (IOException e) {
                logger.error((Object)e);
                str = "Analysis failed.";
                ServerVsmUtil.closeStream(in);
                ServerVsmUtil.closeReader(read);
                ServerVsmUtil.closeStream(errorIn);
                ServerVsmUtil.closeReader(errorRead);
                ServerVsmUtil.closeProcess(p);
            }
            catch (RuntimeException e2) {
                logger.error((Object)e2);
                str = "Analysis failed.";
                {
                    catch (Throwable throwable) {
                        ServerVsmUtil.closeStream(in);
                        ServerVsmUtil.closeReader(read);
                        ServerVsmUtil.closeStream(errorIn);
                        ServerVsmUtil.closeReader(errorRead);
                        ServerVsmUtil.closeProcess(p);
                        throw throwable;
                    }
                }
                ServerVsmUtil.closeStream(in);
                ServerVsmUtil.closeReader(read);
                ServerVsmUtil.closeStream(errorIn);
                ServerVsmUtil.closeReader(errorRead);
                ServerVsmUtil.closeProcess(p);
            }
        }
        ServerVsmUtil.closeStream(in);
        ServerVsmUtil.closeReader(read);
        ServerVsmUtil.closeStream(errorIn);
        ServerVsmUtil.closeReader(errorRead);
        ServerVsmUtil.closeProcess(p);
        return str;
    }

    public static String getInstallPath() {
        return AticInstallUtil.getInstance().getAticInstallPath();
    }

    public String getThridCertPwdFromCfg() {
        String certPwd = null;
        Properties properties = CertFileUtil.getInstance().loadLegoCertInfoProperties();
        certPwd = properties.getProperty("truststore.third.password");
        return certPwd;
    }

    private static void closeStream(InputStream is) {
        if (null != is) {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    private static void closeReader(BufferedReader reader) {
        if (null != reader) {
            try {
                reader.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    private static void closeProcess(Process process) {
        if (null != process) {
            process.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFileBytes(String fileName) {
        String rootPath = ServerVsmUtil.getInstallPath();
        String filePath = rootPath + File.separator + "LegoRuntime" + File.separator + "cert" + File.separator + fileName;
        File findFile = new File(filePath);
        if (findFile.exists() && !findFile.isDirectory()) {
            byte[] b = new byte[(int)findFile.length()];
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(findFile));
                if (is.read(b) != (int)findFile.length()) {
                    logger.error((Object)"stream read error");
                }
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"file not foud", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (null != is) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return b;
        }
        logger.error((Object)"file not exist or is directory");
        return new byte[0];
    }
}

