/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.base.dataprotect;

import com.hs.lego.core.sdk.base.dataprotect.KmcFiles;
import com.hs.lego.core.sdk.base.dataprotect.KmcManager;
import com.hs.lego.core.sdk.base.dataprotect.exception.EncryptException;
import com.hs.lego.core.sdk.util.StringConverter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DataProtector {
    public static final String CHARSETNAME = "UTF-8";
    private static final long SUCCESS = 0L;
    private static final int MIN_CIPHER_BUFF_LEN = 144;
    private static final Object LOCK = new Object();
    private KmcManager kmc = null;

    public DataProtector(String libFolderPath, KmcFiles kmcFileNames) {
        KmcManager.loadKmcLib(libFolderPath);
        this.kmc = new KmcManager(kmcFileNames);
    }

    public DataProtector(String libFolderPath, KmcFiles kmcFileNames, byte[] dhParamP, byte[] dhParamG) {
        KmcManager.loadKmcLib(libFolderPath);
        this.kmc = new KmcManager(kmcFileNames);
    }

    public final String sdpEncrypt(long domainId, String pucPlainText) {
        try {
            if (null == pucPlainText) {
                pucPlainText = "";
            }
            byte[] pucPlainBytes = pucPlainText.getBytes(CHARSETNAME);
            return this.doSdpEncrypt(domainId, pucPlainBytes);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public final String sdpEncrypt(long domainId, byte[] pucPlainBytes) {
        if (null == pucPlainBytes) {
            pucPlainBytes = new byte[]{};
        }
        return this.doSdpEncrypt(domainId, pucPlainBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String doSdpEncrypt(long domainId, byte[] pucPlainBytes) {
        Long pulCipherLen;
        Object object = LOCK;
        synchronized (object) {
            this.kmc.doBeforeUse();
            pulCipherLen = this.kmc.sdpGetCipherDataLenWrapper(pucPlainBytes.length);
        }
        if (pulCipherLen <= 0L) {
            return null;
        }
        byte[] pucCipherBytes = new byte[pulCipherLen.intValue()];
        long errorCode = 0L;
        Object object2 = LOCK;
        synchronized (object2) {
            this.kmc.doBeforeUse();
            errorCode = this.kmc.sdpEncryptWrapper(domainId, pucPlainBytes, pucPlainBytes.length, pucCipherBytes, pulCipherLen);
        }
        if (errorCode < 0L) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(pucCipherBytes);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[] result = new byte[pulCipherLen.intValue()];
        buffer.get(result, 0, result.length);
        String pucCipherText = StringConverter.getInstanse().parseByte2HexStr(result);
        this.cleanArray(pucPlainBytes);
        return pucCipherText;
    }

    public final String sdpDecrypt(long domainId, String pucCipherText) {
        if (null == pucCipherText || pucCipherText.isEmpty()) {
            return pucCipherText;
        }
        byte[] result = this.doSdpDecrypt(pucCipherText, domainId);
        try {
            String plainText = new String(result, CHARSETNAME);
            return plainText;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public final byte[] sdpDecrypt(String pucCipherText, long domainId) {
        if (null == pucCipherText || pucCipherText.isEmpty()) {
            return new byte[0];
        }
        byte[] result = this.doSdpDecrypt(pucCipherText, domainId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] doSdpDecrypt(String pucCipherText, long domainId) {
        byte[] pucCipherBytes = StringConverter.getInstanse().parseHexStr2Byte(pucCipherText);
        Integer pulPTLen = Math.max(pucCipherBytes.length * 2, 144);
        byte[] pucPlainByte = new byte[pulPTLen.intValue()];
        long errorCode = 0L;
        Object object = LOCK;
        synchronized (object) {
            this.kmc.doBeforeUse();
            errorCode = this.kmc.sdpDecryptWrapper(domainId, pucCipherBytes, pucCipherBytes.length, pucPlainByte, pulPTLen);
        }
        if (0L == errorCode) {
            ByteBuffer buffer = ByteBuffer.wrap(pucPlainByte);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            byte[] result = new byte[pulPTLen.intValue()];
            buffer.get(result, 0, result.length);
            return result;
        }
        return new byte[0];
    }

    public final String sdpProtectPwd(String pucPlainText) {
        try {
            if (null == pucPlainText) {
                pucPlainText = "";
            }
            byte[] pucPlainBytes = pucPlainText.getBytes(CHARSETNAME);
            return this.doSdpProtectPwd(pucPlainBytes);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public final String sdpProtectPwd(byte[] pucPlainBytes) {
        if (null == pucPlainBytes) {
            pucPlainBytes = new byte[]{};
        }
        return this.doSdpProtectPwd(pucPlainBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String doSdpProtectPwd(byte[] pucPlainBytes) {
        long pulCipherLen = 0L;
        Object object = LOCK;
        synchronized (object) {
            this.kmc.doBeforeUse();
            pulCipherLen = this.kmc.sdpGetPwdCipherLenWrapper(pucPlainBytes.length);
        }
        if (pulCipherLen <= 0L) {
            return null;
        }
        byte[] pulCipherBytes = new byte[Long.valueOf(pulCipherLen).intValue()];
        long errorCode = 0L;
        Object object2 = LOCK;
        synchronized (object2) {
            this.kmc.doBeforeUse();
            errorCode = this.kmc.sdpProtectPwdWrapper(pucPlainBytes, pucPlainBytes.length, pulCipherBytes, pulCipherLen);
        }
        if (0L != errorCode) {
            return null;
        }
        String pucCipherText = StringConverter.getInstanse().parseByte2HexStr(pulCipherBytes);
        this.cleanArray(pucPlainBytes);
        return pucCipherText;
    }

    public final boolean sdpVerifyPwd(String pucPlainText, String pucCipherText) {
        if (null == pucPlainText) {
            pucPlainText = "";
        }
        if (null == pucCipherText || pucCipherText.isEmpty()) {
            throw new EncryptException("KMC sdpVerifyPwd input error,pucCipherText is null or empty");
        }
        try {
            byte[] pucPlainByte = pucPlainText.getBytes(CHARSETNAME);
            return this.doSdpVerifyPwd(pucPlainByte, pucCipherText);
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    public final boolean sdpVerifyPwd(byte[] pucPlainByte, String pucCipherText) {
        if (null == pucPlainByte) {
            pucPlainByte = new byte[]{};
        }
        if (null == pucCipherText || pucCipherText.isEmpty()) {
            throw new EncryptException("KMC sdpVerifyPwd input error,pucCipherText is null or empty");
        }
        return this.doSdpVerifyPwd(pucPlainByte, pucCipherText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doSdpVerifyPwd(byte[] pucPlainByte, String pucCipherText) {
        byte[] pucCipherBytes = StringConverter.getInstanse().parseHexStr2Byte(pucCipherText);
        long errorCode = 0L;
        Object object = LOCK;
        synchronized (object) {
            this.kmc.doBeforeUse();
            errorCode = this.kmc.sdpVerifyPwdWrapper(pucPlainByte, pucPlainByte.length, pucCipherBytes, pucCipherBytes.length);
        }
        if (0L != errorCode) {
            return false;
        }
        this.cleanArray(pucPlainByte);
        return true;
    }

    public final String sdpHmac(String pucPlainText) {
        if (null == pucPlainText) {
            pucPlainText = "";
        }
        try {
            byte[] pucPlainByte = pucPlainText.getBytes(CHARSETNAME);
            return this.doSdpHmac(pucPlainByte);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncryptException(e);
        }
    }

    public final String sdpHmac(byte[] pucPlainByte) {
        if (null == pucPlainByte) {
            pucPlainByte = new byte[]{};
        }
        return this.doSdpHmac(pucPlainByte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String doSdpHmac(byte[] pucPlainByte) {
        byte[] pucCipherBytes = null;
        Object object = LOCK;
        synchronized (object) {
            pucCipherBytes = this.kmc.sdpHmac(pucPlainByte);
        }
        String pucCipherText = StringConverter.getInstanse().parseByte2HexStr(pucCipherBytes);
        this.cleanArray(pucPlainByte);
        return pucCipherText;
    }

    private void cleanArray(byte[] pucPlainByte) {
        for (int j = 0; j < pucPlainByte.length; ++j) {
            pucPlainByte[j] = 0;
        }
    }
}

