/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.cloudclean.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.cloudclean.form.CloudCleanConfigDevFlowForm;
import com.hs.atic.cloudclean.form.CloudCleanConfigForm;
import com.hs.atic.cloudclean.form.LocationIpForm;
import com.hs.atic.sdk.cloudclean.service.ICloudCleanConfigService;
import com.hs.atic.sdk.cloudclean.service.IMonitorDeviceFlowService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import org.apache.struts2.ServletActionContext;

public class CloudCleanConfigAction
extends BaseAction {
    public static final String DEVFLOW_SUCCESS = "lego.err.631051";
    public static final String DEVFLOW_FAIL = "lego.err.631052";
    public static final int REFRESH_SUCCESS = 631051;
    public static final String TEST_CLOUDCLEAN_CONFIG = "atic.bis.cloud.clean.config.test.log";
    public static final String CREATE_CLOUDCLEAN_CONFIG = "atic.bis.cloudclean.config.title";
    public static final String MODE_AUTO = "auto";
    public static final String MODE_MANUAL = "manual";
    public static final String ATTACK = "attack";
    public static final String ALL = "all";
    public static final String CLEAN = "clean";
    public static final String BLOCK = "block";
    private static final String NOTHING = "nothing";
    private static final String ALL_NET = "1";
    private static final String OTHER_DOMESTIC = "2";
    private static final String OTHER_FOREIGN = "3";
    private static final String OTHER = "4";
    private static final long serialVersionUID = -1L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_CLOUDCLEAN);
    private String ipSplitRange = "-";
    private String ipSplitMask = "/";
    private String nextLine = "\n";
    private List<LangPair> modeList;
    private List<LangPair> ipStatusList;
    private List<LangPair> defendActionList;
    private List<LangPair> serviceProviderList;
    private List<LangPair> defaultPolicyList;
    private CloudCleanConfigForm configForm;
    private CloudCleanConfigDevFlowForm devFlowForm;
    private String serviceProvider;
    private String defaultPolicy;
    private ICloudCleanConfigService cloudCleanConfigService;
    private IAticDeviceService aticDeviceService;
    private List<AticDevice> deviceList;
    private List<AticDevice> cleanDeviceList;
    private String deviceName;
    private String selectedJsonItems;
    private boolean devEdit;
    private String isChangeFlowValue;
    private IMonitorDeviceFlowService monitorDeviceFlowService;
    private String url;
    private String publicKey;
    private String privateKey;
    private String ipWhite;
    private boolean disable = false;

    public String showConfigCloudClean() {
        this.configForm = this.cloudCleanConfigService.findCloudCleanConfig();
        if (null == this.configForm) {
            this.configForm = new CloudCleanConfigForm();
        }
        User user = (User)this.getSession().getAttribute("currentUser");
        Boolean isAdmin = Boolean.valueOf(user.getIsAdmin());
        List devices = this.aticDeviceService.getAllDevice(user.getUserID(), isAdmin.booleanValue());
        HashSet<Long> deviceSet = new HashSet<Long>();
        for (AticDevice item : devices) {
            deviceSet.add(item.getMoId());
        }
        List<CloudCleanConfigDevFlowForm> cloudCleanConfigDevFlows = this.configForm.getCloudCleanConfigDevFlows();
        ArrayList<CloudCleanConfigDevFlowForm> illegalDevice = new ArrayList<CloudCleanConfigDevFlowForm>();
        for (CloudCleanConfigDevFlowForm item : cloudCleanConfigDevFlows) {
            if (deviceSet.contains(item.getDeviceId())) continue;
            illegalDevice.add(item);
        }
        if (!illegalDevice.isEmpty()) {
            cloudCleanConfigDevFlows.removeAll(illegalDevice);
        }
        this.initView();
        return "success";
    }

    public String addDevFlowConfig() {
        return "success";
    }

    public String selectDeviceView() {
        this.deviceViewList();
        return "success";
    }

    public String selectCleanDeviceView() {
        try {
            User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
            this.cleanDeviceList = this.aticDeviceService.getCleanDevice(currentUser.getUserID());
        }
        catch (Exception e) {
            logger.info((Object)("Exception happened when get the discovered devicelist " + e.getMessage()));
            this.cleanDeviceList = new ArrayList<AticDevice>();
        }
        return "success";
    }

    public void saveCloudCleanConfig() {
        if (null != this.configForm) {
            if (!this.validateParams()) {
                throw new LegoCheckedException(570505L);
            }
            this.cloudCleanConfigSetAndUpdate();
            this.attachCloudCleanConfigDevFlowForm();
            if (this.devEdit && 631051L != this.monitorDeviceFlowService.refreshDevFlowList(this.configForm.getCloudCleanConfigDevFlows())) {
                logger.info((Object)("Exception happened when refresh the discovered devicelist " + this.monitorDeviceFlowService.refreshDevFlowList(this.configForm.getCloudCleanConfigDevFlows())));
                String[] str = new String[]{};
                this.getOperateLog().normal(CREATE_CLOUDCLEAN_CONFIG, "lego.dic.module.AticBis", "atic.bis.cloud.clean.log.module", true, DEVFLOW_FAIL, str);
                this.responseResult(DEVFLOW_FAIL);
                return;
            }
            try {
                if (!AticUtil.isNull((String)this.ipWhite)) {
                    this.ipWhite = this.ipWhite.replace(",", "\r\n");
                    this.processBeforeAdd(this.ipWhite);
                    String[] ipLists = this.checkIpNumMore50(this.ipWhite);
                    this.isExistIpWhiteList(ipLists);
                }
            }
            catch (LegoCheckedException e) {
                String errorInfo = this.getText("lego.err." + e.getErrorCode());
                Object[] para = e.getParameters();
                if (null != para && para.length > 0) {
                    errorInfo = MessageFormat.format(errorInfo, para);
                }
                String[] str = new String[]{};
                this.getOperateLog().normal(CREATE_CLOUDCLEAN_CONFIG, "lego.dic.module.AticBis", "atic.bis.cloud.clean.log.module", true, errorInfo, str);
                this.responseResult(errorInfo);
                throw e;
            }
            catch (Exception e) {
                String[] str = new String[]{};
                this.getOperateLog().normal(CREATE_CLOUDCLEAN_CONFIG, "lego.dic.module.AticBis", "atic.bis.cloud.clean.log.module", true, "lego.err.570507", str);
                this.responseResult(this.getText("lego.err.570507"));
            }
            this.configForm.setIpWhiteList(this.ipWhite);
            if (null != this.configForm.getPublicKey()) {
                this.configForm.setPublicKey(DataProtectServiceConst.sdpEncryptLocal((StringBuffer)new StringBuffer(this.configForm.getPublicKey())));
            }
            if (null != this.configForm.getPrivateKey()) {
                this.configForm.setPrivateKey(DataProtectServiceConst.sdpEncryptLocal((StringBuffer)new StringBuffer(this.configForm.getPrivateKey())));
            }
            if (this.isChangeFlowValue != null && this.isChangeFlowValue.equals("true")) {
                this.cloudCleanConfigService.saveCloudCleanConfig(this.configForm, true);
            } else {
                this.cloudCleanConfigService.saveCloudCleanConfig(this.configForm, false);
            }
            String[] str = new String[]{};
            this.getOperateLog().normal(CREATE_CLOUDCLEAN_CONFIG, "lego.dic.module.AticBis", "atic.bis.cloud.clean.log.module", true, "atic.bis.cloudclean.config.success", str);
            this.responseResult("success");
        } else {
            String[] str = new String[]{};
            this.getOperateLog().normal(CREATE_CLOUDCLEAN_CONFIG, "lego.dic.module.AticBis", "atic.bis.cloud.clean.log.module", true, "atic.bis.cloudclean.config.failed", str);
            this.responseResult("error");
        }
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void cloudCleanConfigSetAndUpdate() {
        if (null != this.defaultPolicy && !"".equals(this.defaultPolicy)) {
            this.configForm.setDefaultPolicy(this.defaultPolicy);
        } else {
            this.configForm.setDefaultPolicy(ALL_NET);
        }
        if (null != this.serviceProvider && !"".equals(this.serviceProvider)) {
            this.configForm.setServiceProvider(this.serviceProvider);
            this.updateForDataBase(this.configForm);
        } else {
            this.configForm.setServiceProvider(NOTHING);
            this.updateForDataBase(this.configForm);
        }
    }

    public boolean validateParams() {
        if (null != this.serviceProvider && !NOTHING.equals(this.serviceProvider)) {
            if (!CLEAN.equals(this.configForm.getDefendAction()) && !BLOCK.equals(this.configForm.getDefendAction())) {
                logger.error((Object)("validate defendAction is error,defendAction is " + CloudCleanConfigAction.getcleanedMessage(this.configForm.getDefendAction())));
                return false;
            }
            try {
                int unBlockTime = Integer.parseInt(this.configForm.getUnblockTime());
                if (unBlockTime < 0 || unBlockTime > 1200) {
                    logger.error((Object)"validate cancel-delay-time is out of the range");
                    return false;
                }
            }
            catch (NumberFormatException e) {
                logger.error((Object)"validate cancel-delay-time is NumberFormatException");
                return false;
            }
            if (CloudCleanConfigAction.isNull(this.configForm.getUrl())) {
                logger.error((Object)"validate url is null");
                return false;
            }
            if (!this.validatePwd()) {
                return false;
            }
        }
        return true;
    }

    private boolean validatePwd() {
        if (!AticUtil.isNullForVpn((String)this.configForm.getPublicKey()) && !AticUtil.validatePwd((String)this.configForm.getPublicKey())) {
            return false;
        }
        return AticUtil.isNullForVpn((String)this.configForm.getPrivateKey()) || AticUtil.validatePwd((String)this.configForm.getPrivateKey());
    }

    private void attachCloudCleanConfigDevFlowForm() {
        if (null != this.selectedJsonItems && !this.selectedJsonItems.isEmpty()) {
            JSONArray fromObject = JSONArray.fromObject((Object)this.selectedJsonItems);
            CloudCleanConfigDevFlowForm[] selectedItems = (CloudCleanConfigDevFlowForm[])JSONArray.toArray((JSONArray)fromObject, CloudCleanConfigDevFlowForm.class);
            List<CloudCleanConfigDevFlowForm> selectedList = Arrays.asList(selectedItems);
            ArrayList<CloudCleanConfigDevFlowForm> tem = new ArrayList<CloudCleanConfigDevFlowForm>();
            ArrayList<Long> moIDList = new ArrayList<Long>();
            if (!selectedList.isEmpty()) {
                for (CloudCleanConfigDevFlowForm f : selectedList) {
                    f.setId(null);
                    tem.add(f);
                    moIDList.add(f.getDeviceId());
                }
                BisUtil.checkUserSecurity(moIDList);
                this.configForm.setCloudCleanConfigDevFlows(tem);
            }
        }
    }

    private void updateForDataBase(CloudCleanConfigForm form) {
        if (NOTHING.equals(form.getServiceProvider())) {
            form.setUrl("");
            form.setPrivateKey("");
            form.setPublicKey("");
            form.setUnblockTime("");
            form.setDefaultPolicy(ALL_NET);
            form.setDefendAction(CLEAN);
        } else if ("HW".equals(form.getServiceProvider())) {
            form.setDefaultPolicy(ALL_NET);
        } else {
            form.setDefendAction(CLEAN);
        }
    }

    private void initView() {
        this.initRadioGroup();
        this.initCombobox();
        this.initComboboxView();
        this.initRadioGroupView();
        this.initIpWhiteList();
    }

    private void initIpWhiteList() {
        StringBuffer ip = new StringBuffer();
        this.ipWhite = this.configForm.getIpWhiteList();
        if (null != this.ipWhite) {
            String[] strArr = this.ipWhite.split(",");
            for (int i = 0; i < strArr.length; ++i) {
                ip.append(strArr[i] + "\n");
            }
            this.ipWhite = ip.substring(0, ip.length() - 1);
        }
        this.configForm.setIpWhiteList(this.ipWhite);
    }

    private void initRadioGroup() {
        this.modeList = new ArrayList<LangPair>();
        LangPair auto = new LangPair(MODE_AUTO, this.getText("atic.bis.cloudclean.mode.auto"));
        LangPair manual = new LangPair(MODE_MANUAL, this.getText("atic.bis.cloudclean.mode.manual"));
        this.modeList.add(auto);
        this.modeList.add(manual);
        this.ipStatusList = new ArrayList<LangPair>();
        LangPair attack = new LangPair(ATTACK, this.getText("atic.bis.cloudclean.ipStatus.attack"));
        LangPair all = new LangPair(ALL, this.getText("atic.bis.cloudclean.ipStatus.all"));
        this.ipStatusList.add(attack);
        this.ipStatusList.add(all);
        this.defendActionList = new ArrayList<LangPair>();
        LangPair clean = new LangPair(CLEAN, this.getText("atic.bis.cloudclean.config.defend.clean"));
        LangPair block = new LangPair(BLOCK, this.getText("atic.bis.cloudclean.config.defend.block"));
        this.defendActionList.add(clean);
        this.defendActionList.add(block);
    }

    private void initCombobox() {
        this.serviceProviderList = new ArrayList<LangPair>();
        LangPair nothing = new LangPair(NOTHING, this.getText("atic.bis.cloudclean.service.provider.nothing"));
        LangPair hw = new LangPair("HW", this.getText("atic.bis.cloudclean.service.provider.hw"));
        this.serviceProviderList.add(nothing);
        this.serviceProviderList.add(hw);
        this.defaultPolicyList = new ArrayList<LangPair>();
        LangPair allnet = new LangPair(ALL_NET, this.getText("atic.bis.cloudclean.default.policy.all"));
        LangPair otherDe = new LangPair(OTHER_DOMESTIC, this.getText("atic.bis.cloudclean.default.policy.other.domestic.provider"));
        LangPair otherFo = new LangPair(OTHER_FOREIGN, this.getText("atic.bis.cloudclean.default.policy.other.foreign.provider"));
        LangPair other = new LangPair(OTHER, this.getText("atic.bis.cloudclean.default.policy.other"));
        this.defaultPolicyList.add(allnet);
        this.defaultPolicyList.add(otherDe);
        this.defaultPolicyList.add(otherFo);
        this.defaultPolicyList.add(other);
    }

    private void initComboboxView() {
        if (null == this.configForm.getServiceProvider()) {
            this.configForm.setServiceProvider(NOTHING);
        }
        if (null == this.configForm.getDefaultPolicy()) {
            this.configForm.setDefaultPolicy(ALL_NET);
        }
    }

    private void initRadioGroupView() {
        if (null == this.configForm.getMode()) {
            this.configForm.setMode(MODE_AUTO);
        }
        if (null == this.configForm.getIpStatus()) {
            this.configForm.setIpStatus(ATTACK);
        }
        if (null == this.configForm.getDefendAction()) {
            this.configForm.setDefendAction(CLEAN);
        }
    }

    public void deviceViewList() {
        try {
            User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
            this.deviceList = this.aticDeviceService.getAntiDDoSDevice(currentUser.getUserID());
        }
        catch (Exception e) {
            logger.info((Object)("Exception happened when get the discovered devicelist " + e.getMessage()));
            this.deviceList = new ArrayList<AticDevice>();
        }
    }

    public void testCloudCleanConfig() {
        if (NOTHING.equals(this.serviceProvider)) {
            String[] str = new String[]{};
            this.getOperateLog().normal(TEST_CLOUDCLEAN_CONFIG, "lego.dic.module.AticBis", CREATE_CLOUDCLEAN_CONFIG, true, "atic.bis.cloudclean.config.test.success.log", str);
            this.responseResult("success");
        } else {
            try {
                CloudCleanConfigForm cleanConfigForm;
                StringBuffer pubPWD = new StringBuffer();
                StringBuffer priPWD = new StringBuffer();
                if ("********".equals(this.publicKey)) {
                    cleanConfigForm = this.cloudCleanConfigService.findCloudCleanConfig();
                    if (null != cleanConfigForm) {
                        pubPWD.append(cleanConfigForm.getPublicKey());
                    }
                } else {
                    pubPWD.append(DataProtectServiceConst.sdpEncryptLocal((StringBuffer)new StringBuffer(this.publicKey)));
                }
                if ("********".equals(this.privateKey)) {
                    cleanConfigForm = this.cloudCleanConfigService.findCloudCleanConfig();
                    if (null != cleanConfigForm) {
                        priPWD.append(cleanConfigForm.getPrivateKey());
                    }
                } else {
                    priPWD.append(DataProtectServiceConst.sdpEncryptLocal((StringBuffer)new StringBuffer(this.privateKey)));
                }
                Map<String, String> map = this.cloudCleanConfigService.testCloudCleanConfig(this.serviceProvider, this.url, pubPWD, priPWD);
                if (null != map) {
                    String[] str = new String[]{};
                    this.getOperateLog().normal(TEST_CLOUDCLEAN_CONFIG, "lego.dic.module.AticBis", CREATE_CLOUDCLEAN_CONFIG, true, "atic.bis.cloudclean.config.test.success.log", str);
                    this.responseResult("success");
                } else {
                    String[] str = new String[]{};
                    this.getOperateLog().normal(TEST_CLOUDCLEAN_CONFIG, "lego.dic.module.AticBis", CREATE_CLOUDCLEAN_CONFIG, true, "atic.bis.cloudclean.config.test.failed.log", str);
                    this.responseResult("success");
                }
            }
            catch (LegoCheckedException e) {
                String[] str = new String[]{};
                this.getOperateLog().normal(TEST_CLOUDCLEAN_CONFIG, "lego.dic.module.AticBis", CREATE_CLOUDCLEAN_CONFIG, true, "atic.bis.cloudclean.config.test.failed.log", str);
                throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
            }
        }
    }

    private void processBeforeAdd(String ipWhiteList) {
        String ipTemp = ipWhiteList.replace("\r", "");
        String[] ipListTemp = ipTemp.trim().split(this.nextLine);
        ArrayList<String> listIp = new ArrayList<String>();
        for (int i = 0; i < ipListTemp.length; ++i) {
            if ("".equals(ipListTemp[i])) continue;
            listIp.add(ipListTemp[i]);
        }
        String[] ipList = listIp.toArray(new String[0]);
        for (int i = 0; i < ipList.length; ++i) {
            String[] ipAddress;
            String ip = ipList[i].trim();
            if (ip.contains(this.ipSplitRange)) {
                ipAddress = ip.split(this.ipSplitRange);
                if (IPUtil.isIpv4((String)ipAddress[0]) && !IPUtil.isIpv4((String)ipAddress[1])) {
                    logger.error((Object)("ip format wrong, srcIpStr: " + ip));
                    String[] params = new String[]{ip};
                    throw new LegoCheckedException(571913L, params);
                }
                if ("0.0.0.0".equals(ipAddress[0]) && "0.0.0.0".equals(ipAddress[1])) {
                    logger.error((Object)("ip format wrong, srcIpStr: " + ip));
                    String[] params = new String[]{ip};
                    throw new LegoCheckedException(571913L, params);
                }
                if (IPUtil.isIpv4((String)ipAddress[0])) continue;
                logger.error((Object)("ip format wrong, srcIpStr: " + ip));
                String[] params = new String[]{ip};
                throw new LegoCheckedException(571913L, params);
            }
            if (ip.contains(this.ipSplitMask)) {
                ipAddress = ip.split(this.ipSplitMask);
                if (!CloudCleanConfigAction.isIpv4Mask(ipAddress[1])) {
                    logger.error((Object)("ip format wrong, srcIpStr: " + ip));
                    String[] params = new String[]{ip};
                    throw new LegoCheckedException(571913L, params);
                }
                if ("0.0.0.0".equals(ipAddress[0])) {
                    logger.error((Object)("ip format wrong, srcIpStr: " + ip));
                    String[] params = new String[]{ip};
                    throw new LegoCheckedException(571913L, params);
                }
                if (IPUtil.isIpv4((String)ipAddress[0])) continue;
                logger.error((Object)("ip format wrong, srcIpStr: " + ip));
                String[] params = new String[]{ip};
                throw new LegoCheckedException(571913L, params);
            }
            logger.error((Object)("ip format wrong, srcIpStr: " + ip));
            String[] params = new String[]{ip};
            throw new LegoCheckedException(571913L, params);
        }
    }

    public static boolean isIpv4Mask(String maskIpv4) {
        String regex = "^1[6-9]|2[0-9]|3[0-2]$";
        return !CloudCleanConfigAction.isNull(maskIpv4) && maskIpv4.matches(regex);
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equalsIgnoreCase(str);
    }

    private String[] checkIpNumMore50(String ipWhiteList) {
        ArrayList<String> whiteIplist = new ArrayList<String>();
        String[] ipListTemp = ipWhiteList.split(this.nextLine);
        for (int i = 0; i < ipListTemp.length; ++i) {
            if ("\r".equals(ipListTemp[i])) continue;
            whiteIplist.add(ipListTemp[i]);
        }
        if (whiteIplist.size() > 50) {
            logger.error((Object)"locationCustom num more than 50.");
            throw new LegoCheckedException(571972L);
        }
        String[] ipLists = whiteIplist.toArray(new String[0]);
        return ipLists;
    }

    private void isExistIpWhiteList(String[] ipList) {
        ArrayList<LocationIpForm> locationIpFormList = new ArrayList<LocationIpForm>();
        for (int i = ipList.length - 1; i >= 0; --i) {
            String ipStr = ipList[i].trim();
            if ("".equals(ipStr)) continue;
            boolean ipFormatIsRight = true;
            LocationIpForm locationIpForm = new LocationIpForm();
            if (ipStr.contains(this.ipSplitRange)) {
                locationIpForm.setIpString(ipStr);
                String startIp = IPUtil4Atic.convert2CompleteIp((String)ipStr.split(this.ipSplitRange)[0]);
                String endIp = IPUtil4Atic.convert2CompleteIp((String)ipStr.split(this.ipSplitRange)[1]);
                String[] startAndEnd = new String[]{startIp, endIp};
                if (AticUtil.isNull((String)startIp) || AticUtil.isNull((String)endIp) || !IPUtil4Atic.checkStartEndIpArray((String[])startAndEnd)) {
                    ipFormatIsRight = false;
                }
                locationIpForm.setStartIp(startIp);
                locationIpForm.setEndIp(endIp);
                locationIpFormList.add(locationIpForm);
            } else if (ipStr.contains(this.ipSplitMask)) {
                locationIpForm.setIpString(ipStr);
                String ipAddress = ipStr.split(this.ipSplitMask)[0];
                String maskInput = ipStr.split(this.ipSplitMask)[1];
                int maskInteger = 0;
                if (AticUtil.isNum((String)maskInput).booleanValue()) {
                    maskInteger = Integer.parseInt(maskInput);
                }
                if (IPUtil.isIpv4((String)ipAddress) && (maskInteger > 32 || maskInteger < 1)) {
                    logger.error((Object)("ip format wrong, srcIpStr: " + ipStr));
                    String[] params = new String[]{ipStr};
                    throw new LegoCheckedException(571914L, params);
                }
                String startIp = IPUtil4Atic.convert2CompleteIp((String)IPUtil.getSubnetRange((String)ipAddress, (int)maskInteger)[0]);
                String endIp = IPUtil4Atic.convert2CompleteIp((String)IPUtil.getSubnetRange((String)ipAddress, (int)maskInteger)[1]);
                if (AticUtil.isNull((String)startIp) || AticUtil.isNull((String)endIp)) {
                    ipFormatIsRight = false;
                }
                locationIpForm.setStartIp(startIp);
                locationIpForm.setEndIp(endIp);
                locationIpFormList.add(locationIpForm);
            } else {
                ipFormatIsRight = false;
            }
            if (ipFormatIsRight) continue;
            logger.error((Object)("ip format wrong, srcIpStr: " + ipStr));
            String[] params = new String[]{ipStr};
            throw new LegoCheckedException(571913L, params);
        }
        for (LocationIpForm form : locationIpFormList) {
            int index = locationIpFormList.indexOf(form);
            String[] srcIpRange = new String[]{form.getStartIp(), form.getEndIp()};
            for (int j = index + 1; j < locationIpFormList.size(); ++j) {
                String endIp;
                String startIp = ((LocationIpForm)locationIpFormList.get(j)).getStartIp();
                String[] ipRange = new String[]{startIp, endIp = ((LocationIpForm)locationIpFormList.get(j)).getEndIp()};
                boolean isCross = IPUtil4Atic.isCrossIpRange((String[])ipRange, (String[])srcIpRange);
                if (!isCross) continue;
                this.log.error((Object)("ipRange conflict,srcIpStr: " + form.getIpString() + ", srcIpRange:" + form.getIpString() + "," + startIp + "---" + endIp));
                String[] params = new String[]{form.getIpString()};
                throw new LegoCheckedException(571909L, params);
            }
        }
    }

    public List<LangPair> getModeList() {
        return this.modeList;
    }

    public void setModeList(List<LangPair> modeList) {
        this.modeList = modeList;
    }

    public List<LangPair> getIpStatusList() {
        return this.ipStatusList;
    }

    public void setIpStatusList(List<LangPair> ipStatusList) {
        this.ipStatusList = ipStatusList;
    }

    public List<LangPair> getServiceProviderList() {
        return this.serviceProviderList;
    }

    public void setServiceProviderList(List<LangPair> serviceProviderList) {
        this.serviceProviderList = serviceProviderList;
    }

    public List<LangPair> getDefaultPolicyList() {
        return this.defaultPolicyList;
    }

    public void setDefaultPolicyList(List<LangPair> defaultPolicyList) {
        this.defaultPolicyList = defaultPolicyList;
    }

    public CloudCleanConfigForm getConfigForm() {
        return this.configForm;
    }

    public void setConfigForm(CloudCleanConfigForm configForm) {
        this.configForm = configForm;
    }

    public String getServiceProvider() {
        return this.serviceProvider;
    }

    public void setServiceProvider(String serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public String getDefaultPolicy() {
        return this.defaultPolicy;
    }

    public void setDefaultPolicy(String defaultPolicy) {
        this.defaultPolicy = defaultPolicy;
    }

    public ICloudCleanConfigService getService() {
        return this.cloudCleanConfigService;
    }

    public void setService(ICloudCleanConfigService service) {
        this.cloudCleanConfigService = service;
    }

    public List<AticDevice> getDeviceList() {
        return this.deviceList;
    }

    public void setDeviceList(List<AticDevice> deviceList) {
        this.deviceList = deviceList;
    }

    public CloudCleanConfigDevFlowForm getDevFlowForm() {
        return this.devFlowForm;
    }

    public void setDevFlowForm(CloudCleanConfigDevFlowForm devFlowForm) {
        this.devFlowForm = devFlowForm;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getSelectedJsonItems() {
        return this.selectedJsonItems;
    }

    public void setSelectedJsonItems(String selectedJsonItems) {
        this.selectedJsonItems = selectedJsonItems;
    }

    public boolean isDevEdit() {
        return this.devEdit;
    }

    public void setDevEdit(boolean devEdit) {
        this.devEdit = devEdit;
    }

    public IMonitorDeviceFlowService getMonitorDeviceFlowService() {
        return this.monitorDeviceFlowService;
    }

    public void setMonitorDeviceFlowService(IMonitorDeviceFlowService monitorDeviceFlowService) {
        this.monitorDeviceFlowService = monitorDeviceFlowService;
    }

    public List<LangPair> getDefendActionList() {
        return this.defendActionList;
    }

    public void setDefendActionList(List<LangPair> defendActionList) {
        this.defendActionList = defendActionList;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getIpWhite() {
        return this.ipWhite;
    }

    public void setIpWhite(String ipWhite) {
        this.ipWhite = AticUtil.htmlEncode((String)ipWhite);
    }

    public boolean isDisable() {
        return this.disable;
    }

    public void setDisable(boolean disable) {
        this.disable = disable;
    }

    public String getIsChangeFlowValue() {
        return this.isChangeFlowValue;
    }

    public void setIsChangeFlowValue(String isChangeFlowValue) {
        this.isChangeFlowValue = isChangeFlowValue;
    }

    public List<AticDevice> getCleanDeviceList() {
        return this.cleanDeviceList;
    }

    public void setCleanDeviceList(List<AticDevice> cleanDeviceList) {
        this.cleanDeviceList = cleanDeviceList;
    }

    public ICloudCleanConfigService getCloudCleanConfigService() {
        return this.cloudCleanConfigService;
    }

    public void setCloudCleanConfigService(ICloudCleanConfigService cloudCleanConfigService) {
        this.cloudCleanConfigService = cloudCleanConfigService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }
}

