/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.cloudclean.dao;

import com.hs.atic.cloudclean.model.CloudClean;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class CloudCleanDao
extends CommonDaoImpl {
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_CLOUDCLEAN);

    public void deleteById(Long id) {
        String hql = "delete from CloudClean where id=?";
        this.logger.info((Object)("deleteById: " + hql));
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void batchDeteleCloudClean(List<CloudClean> cloudCleanList) {
        this.getHibernateTemplate().deleteAll(cloudCleanList);
        StringBuffer sb = new StringBuffer();
        for (CloudClean cloudClean : cloudCleanList) {
            sb.append(cloudClean.getIpMask()).append(", ");
        }
        this.logger.info((Object)("batchDeteleCloudClean success! The delete CloudClean is :" + sb.toString()));
    }

    public List<CloudClean> queryByDeviceId(Long id) {
        String hql = "from CloudClean where deviceId= ? ";
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, id.toString());
        List list = this.findByHql(hql, queryMap);
        this.logger.info((Object)("queryByDeviceId: " + hql));
        return list;
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        Paging page = new Paging();
        HashMap queryMap = new HashMap();
        String hql = "from CloudClean where (1=1) ";
        String hql4Count = "select count(*) as rowCount ";
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public List<CloudClean> getByIpMaskAndPolicyType(String ipMask, String sp, String policyType) {
        String hql = "from CloudClean where ipMask=? and sp=? and policyType=?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, ipMask);
        param.put(1, sp);
        param.put(2, policyType);
        this.logger.info((Object)("getByIpMaskAndPolicyType: " + hql));
        List cloudCleans = this.findByHql(hql, param);
        return cloudCleans;
    }

    public List<CloudClean> getByIdAndStatus(Long protectIpId, String status) {
        String hql = "from CloudClean where protectIpId=? and status=?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(protectIpId));
        param.put(1, status);
        this.logger.info((Object)("getCloudCleanByProtectIpIdAndStatus: protectIpId: " + protectIpId + ", status:" + status));
        List cloudCleans = this.findByHql(hql, param);
        if (null == cloudCleans) {
            return new ArrayList<CloudClean>();
        }
        return cloudCleans;
    }

    public List<CloudClean> getCloudCleanByProtectId(Long protectIpId) {
        String hql = "from CloudClean where protectIpId=?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(protectIpId));
        this.logger.info((Object)("getCloudCleanByProtectId: protectIpId: " + protectIpId));
        List cloudCleans = this.findByHql(hql, param);
        if (null == cloudCleans) {
            return new ArrayList<CloudClean>();
        }
        return cloudCleans;
    }

    public List<CloudClean> queryByIpMaskAndDeviceId(String ipMask, String sp, Long deviceId) {
        String hql = "from CloudClean where ipMask=? and sp=? and deviceId=?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, ipMask);
        param.put(1, sp);
        param.put(2, String.valueOf(deviceId));
        this.logger.info((Object)("queryByIpMaskAndDeviceId: " + hql));
        List cloudCleans = this.findByHql(hql, param);
        return cloudCleans;
    }

    public Integer getByStaticPolicy() {
        Iterator iterator;
        String hql = "SELECT COUNT(*) FROM CloudClean WHERE policyType='static'";
        this.logger.info((Object)("getByStaticPolicy: " + hql));
        List countList = this.findByHql(hql);
        if (null != countList && !countList.isEmpty() && (iterator = countList.iterator()).hasNext()) {
            Long count = (Long)iterator.next();
            return Integer.valueOf(String.valueOf(count));
        }
        return null;
    }

    public List<CloudClean> deleteByAlarm(long deviceId) {
        String selectHql = "from CloudClean where status = 'disable' and policyType != 'static' and deviceId=?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(deviceId));
        List delCloudCleanList = this.findByHql(selectHql, param);
        String hql = "delete from CloudClean where status = 'disable' and policyType != 'static' and deviceId=?";
        this.logger.info((Object)("deleteByAlarm: " + hql));
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceId});
        return delCloudCleanList;
    }
}

