/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.cloudclean.rmi;

import com.hs.atic.cloudclean.rmi.ClientSocketFactory;
import com.hs.atic.rmi.TopNIPFlowRmiService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import java.util.Map;

public class CollectorRMIProxy
implements Serializable {
    private static final long serialVersionUID = -7353997750449280835L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_CLOUDCLEAN);
    private static transient Map<String, Registry> map = new HashMap<String, Registry>();

    public TopNIPFlowRmiService getTopNIPFlowRmiService(String collectorIpStr) {
        TopNIPFlowRmiService service = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                service = (TopNIPFlowRmiService)registry.lookup("toponIPFlowService");
            }
            catch (Exception e) {
                logger.error((Object)"Get ShowCollectorCounterService interface object failed !", (Throwable)e);
                service = null;
            }
        }
        if (service != null) {
            logger.info((Object)("Get ShowCollectorCounterService success:" + service));
        }
        return service;
    }

    private Registry getCollectorRegistry(String collectorIpStr) {
        logger.info((Object)("collectorIpStr:" + collectorIpStr));
        if (null != map.get(collectorIpStr)) {
            return map.get(collectorIpStr);
        }
        Registry registry = null;
        try {
            ClientSocketFactory csf = new ClientSocketFactory(true);
            registry = LocateRegistry.getRegistry(collectorIpStr, 11099, csf);
            map.put(collectorIpStr, registry);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("collectorIpStr:" + collectorIpStr + " have exist in the map"), (Throwable)e);
            return registry;
        }
        catch (Exception e) {
            logger.error((Object)"Regist failed !", (Throwable)e);
            registry = null;
        }
        return registry;
    }
}

