/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.cloudclean.service.impl;

import com.hs.atic.bis.dao.DivertTacticsDao;
import com.hs.atic.bis.model.DivertTactics;
import com.hs.atic.cloudclean.dao.CloudCleanConfigDao;
import com.hs.atic.cloudclean.dao.CloudCleanConfigDevFlowDao;
import com.hs.atic.cloudclean.dao.CloudCleanDao;
import com.hs.atic.cloudclean.dao.CloudCleanProtectIpDao;
import com.hs.atic.cloudclean.dao.CloudCleanProtectIpDeviceDao;
import com.hs.atic.cloudclean.form.CloudCleanConfigDevFlowForm;
import com.hs.atic.cloudclean.form.CloudCleanConfigForm;
import com.hs.atic.cloudclean.form.CloudCleanProtectIpDeviceForm;
import com.hs.atic.cloudclean.form.CloudCleanProtectIpForm;
import com.hs.atic.cloudclean.form.DeviceIpTopN;
import com.hs.atic.cloudclean.model.CloudClean;
import com.hs.atic.cloudclean.model.CloudCleanConfig;
import com.hs.atic.cloudclean.model.CloudCleanConfigDevFlow;
import com.hs.atic.cloudclean.model.CloudCleanProtectIp;
import com.hs.atic.cloudclean.model.CloudCleanProtectIpDevice;
import com.hs.atic.cloudclean.rmi.CollectorRMIProxy;
import com.hs.atic.cloudclean.util.CloudCleanAlarmHandler;
import com.hs.atic.cloudclean.util.CloudCleanThreadDeal;
import com.hs.atic.cloudclean.util.CloudCleanTimeThread;
import com.hs.atic.cloudclean.util.CloudCleanUtil;
import com.hs.atic.rmi.TopNIPFlowInfo;
import com.hs.atic.rmi.TopNIPFlowRmiService;
import com.hs.atic.sdk.bis.form.CloudCleanForm;
import com.hs.atic.sdk.bis.form.DivertTacticsForm;
import com.hs.atic.sdk.bis.service.IDateTableFileService;
import com.hs.atic.sdk.bis.service.IDivertTacticsService;
import com.hs.atic.sdk.cloudclean.service.ICloudCleanService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.service.IDefendGroupService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CloudCleanServiceImpl
implements ICloudCleanService {
    private static final int SUCCESS = 1;
    private static final int FAIL = 0;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_CLOUDCLEAN);
    private boolean isOpenKIO = false;
    private boolean isOpenLoopBack300 = false;
    private int loopBack300DelayTime = 0;
    private CloudCleanDao cloudCleanDao;
    private CloudCleanProtectIpDao cloudCleanProtectIpDao;
    private CloudCleanProtectIpDeviceDao cloudCleanProtectIpDeviceDao;
    private CollectorRMIProxy cloudCollectorRMIProxy;
    private CloudCleanConfigDao configDao;
    private CloudCleanThreadDeal cloudCleanThreadDeal;
    private DivertTacticsDao divertTacticsDao;
    private ICollectorService collectorService;
    private ICollectorDeviceService collectorDevSer;
    private CloudCleanConfigDevFlowDao cloudCleanConfigDevDao;
    private CloudCleanAlarmHandler cloudCleanAlarmHandler;
    private IDataProtectService dataProtectService;
    private IDefendGroupService defendGroupService;
    private IDivertTacticsService divertTacticsService;
    private IAticDeviceService aticDeviceService;
    private List<DeviceIpTopN> adeviceIpTopNList;
    private IDateTableFileService dateTableFileService;

    @Override
    public void saveCloudClean(CloudCleanForm cloudCleanForm) {
        if (null == cloudCleanForm) {
            this.logger.error((Object)"can't save null cloud clean");
            return;
        }
        this.logger.info((Object)("save cloudClean : " + cloudCleanForm.getServiceProvider() + " " + cloudCleanForm.getIpMask()));
        CloudClean cloudClean = (CloudClean)AticUtil.copyProperties((Object)cloudCleanForm, (Object)new CloudClean());
        this.cloudCleanDao.saveOrUpdate(cloudClean);
    }

    @Override
    public Long saveProtectIp(CloudCleanProtectIpForm cloudCleanProtectIpForm) {
        if (null == cloudCleanProtectIpForm) {
            this.logger.error((Object)"can't save null protectip");
            return 0L;
        }
        this.logger.error((Object)" save protectip");
        CloudCleanProtectIp cloudCleanProtectIp = (CloudCleanProtectIp)AticUtil.copyProperties((Object)cloudCleanProtectIpForm, (Object)new CloudCleanProtectIp());
        this.cloudCleanProtectIpDao.save(cloudCleanProtectIp);
        return cloudCleanProtectIp.getId();
    }

    @Override
    public void saveProtectIpDevice(List<CloudCleanProtectIpDeviceForm> protectIpDeviceFormList) {
        if (null == protectIpDeviceFormList || protectIpDeviceFormList.isEmpty()) {
            return;
        }
        HashSet<CloudCleanProtectIpDevice> protectIpDevices = new HashSet<CloudCleanProtectIpDevice>();
        for (CloudCleanProtectIpDeviceForm protectIpDeviceForm : protectIpDeviceFormList) {
            CloudCleanProtectIpDevice protectIpDevice = new CloudCleanProtectIpDevice();
            AticUtil.copyProperties((Object)protectIpDeviceForm, (Object)protectIpDevice);
            protectIpDevices.add(protectIpDevice);
        }
        this.cloudCleanProtectIpDeviceDao.saveAll(protectIpDevices);
    }

    @Override
    public void batchDeteleProtectIpForm(List<CloudCleanProtectIpForm> listIpForms) {
        if (null == listIpForms) {
            this.logger.error((Object)"can't delete null protectip list");
            return;
        }
        ArrayList<CloudCleanProtectIp> ipList = new ArrayList<CloudCleanProtectIp>();
        ArrayList<CloudCleanProtectIpDevice> protectIpDevices = new ArrayList<CloudCleanProtectIpDevice>();
        for (CloudCleanProtectIpForm ipForm : listIpForms) {
            CloudCleanProtectIp ip = new CloudCleanProtectIp();
            AticUtil.copyProperties((Object)ipForm, (Object)ip);
            ipList.add(ip);
            List<CloudCleanProtectIpDeviceForm> ipDeviceList = ipForm.getIpDevs();
            for (CloudCleanProtectIpDeviceForm ipDeviceForm : ipDeviceList) {
                CloudCleanProtectIpDevice ipDevice = new CloudCleanProtectIpDevice();
                AticUtil.copyProperties((Object)ipDeviceForm, (Object)ipDevice);
                protectIpDevices.add(ipDevice);
            }
        }
        if (!ipList.isEmpty()) {
            this.cloudCleanProtectIpDao.batchDeteleProtectIp(ipList);
        }
        if (!protectIpDevices.isEmpty()) {
            this.cloudCleanProtectIpDeviceDao.batchDeteleProtectIpDevice(protectIpDevices);
        }
        for (CloudCleanProtectIpForm ipForm : listIpForms) {
            List<CloudClean> cloudCleanList = this.getCloudCleanByProtectId(ipForm.getId());
            for (CloudClean cloudClean : cloudCleanList) {
                cloudClean.setReInjectDeviceName("--");
                cloudClean.setProtectIpId(null);
                this.cloudCleanDao.saveOrUpdate(cloudClean);
            }
        }
    }

    private List<CloudClean> getCloudCleanByProtectId(Long id) {
        return this.cloudCleanDao.getCloudCleanByProtectId(id);
    }

    public List<CloudCleanForm> findAll() {
        this.logger.info((Object)"findAll Cloud Clean");
        ArrayList<CloudCleanForm> cloudCleanFormList = new ArrayList<CloudCleanForm>();
        String hql = "from CloudClean where 1=1";
        List cloudCleanList = this.cloudCleanDao.findByHql(hql);
        for (CloudClean cc : cloudCleanList) {
            CloudCleanForm ccf = new CloudCleanForm();
            AticUtil.copyProperties((Object)cc, (Object)ccf);
            cloudCleanFormList.add(ccf);
        }
        return cloudCleanFormList;
    }

    @Override
    public CloudCleanForm getById(Long id) {
        this.logger.info((Object)("getById CloudClean.id=" + id));
        CloudCleanForm cloudCleanForm = new CloudCleanForm();
        CloudClean cloudClean = (CloudClean)this.cloudCleanDao.get(CloudClean.class, id);
        if (null != cloudClean) {
            AticUtil.copyProperties((Object)cloudClean, (Object)cloudCleanForm);
            return cloudCleanForm;
        }
        return null;
    }

    @Override
    public Boolean canBeDeleted(Long cloudCleanProtectIpId) {
        List<CloudClean> cloudCleans = this.cloudCleanDao.getByIdAndStatus(cloudCleanProtectIpId, "enable");
        if (cloudCleans.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public void deleteCloudCleanProtectIpDevice(Long deviceId) {
        this.cloudCleanProtectIpDeviceDao.deleteByDevId(deviceId);
    }

    @Override
    public void deteleByForm(List<CloudCleanForm> cloudCleanFormList) {
        this.logger.info((Object)"deteleByForm CloudClean");
        ArrayList<CloudClean> cloudCleanList = new ArrayList<CloudClean>();
        ArrayList<CloudCleanForm> hwCCList = new ArrayList<CloudCleanForm>();
        ArrayList<CloudCleanForm> ctccCCList = new ArrayList<CloudCleanForm>();
        for (CloudCleanForm cloudCleanForm : cloudCleanFormList) {
            CloudCleanConfigForm ccf = this.getCloudCleanConf();
            if (null != cloudCleanForm.getStatus() && "enable".equals(cloudCleanForm.getStatus()) && null != ccf) {
                if ("HW".equals(cloudCleanForm.getServiceProvider())) {
                    hwCCList.add(cloudCleanForm);
                } else {
                    ctccCCList.add(cloudCleanForm);
                }
            }
            if (!hwCCList.isEmpty()) {
                this.disableCloudClean4HW(hwCCList);
            }
            if (!ctccCCList.isEmpty()) {
                this.disableCloudClean4CTCC(ctccCCList);
            }
            if (null != cloudCleanForm.getPolicyType() && !"static".equals(cloudCleanForm.getPolicyType())) {
                CloudClean cc = new CloudClean();
                AticUtil.copyProperties((Object)cloudCleanForm, (Object)cc);
                cloudCleanList.add(cc);
            }
            this.cloudCleanDao.deleteById(cloudCleanForm.getId());
            String[] detailPara = new String[]{cloudCleanForm.getIpMask()};
            this.writeSysLog("atic.bis.cloud.clean.operation.delete", cloudCleanForm.getIpMask(), "atic.bis.cloudclean.delete.policy.success.oplog", detailPara, 1);
        }
        this.cloudCleanThreadDeal.removeDeleteList(cloudCleanList);
    }

    private void writeSysLog(String operation, String target, String detail, String[] detailPara, int result) {
        ISysOptLog sysOptLogMgr = CloudCleanUtil.getSysOptLog();
        SysOptLog sysOptLog = new SysOptLog();
        sysOptLog.setOperation(operation);
        sysOptLog.setModule("atic.bis.cloudClean");
        sysOptLog.setTerminalIp("127.0.0.1");
        sysOptLog.setOperator("system");
        sysOptLog.setLevel(SysoplogLevel.normal.getValue());
        sysOptLog.setResult(result);
        sysOptLog.setTarget(target);
        sysOptLog.setDetail(detail);
        sysOptLog.setDetailPara(detailPara);
        if (null != sysOptLogMgr) {
            sysOptLogMgr.writeOptLog(sysOptLog);
        }
    }

    @Override
    public void updateCloudClean(CloudCleanForm cloudCleanForm) {
        CloudClean cloudClean = new CloudClean();
        AticUtil.copyProperties((Object)cloudCleanForm, (Object)cloudClean);
        this.cloudCleanDao.saveOrUpdate(cloudClean);
        this.logger.info((Object)("updateCloudClean cloudCleanForm.id" + cloudCleanForm.getId()));
    }

    @Override
    public void updateCloudCleanProtectIp(CloudCleanProtectIpForm cloudCleanProtectIpForm) {
        CloudCleanProtectIp cloudCleanProtectIp = new CloudCleanProtectIp();
        AticUtil.copyProperties((Object)cloudCleanProtectIpForm, (Object)cloudCleanProtectIp);
        this.cloudCleanProtectIpDao.updateCloudCleanProtectIp(cloudCleanProtectIp);
        this.logger.info((Object)("updateCloudCleanProtectIp cloudCleanProtectIpForm.id" + cloudCleanProtectIpForm.getId()));
    }

    @Override
    public List<DeviceIpTopN> getTopNIPFlow(Long deviceId, Map<String, String> map) {
        ArrayList<DeviceIpTopN> deviceIpTopNList;
        block7: {
            this.logger.info((Object)("getTopNIPFlow deviceId=" + deviceId + "map" + map.toString()));
            deviceIpTopNList = new ArrayList<DeviceIpTopN>();
            if (null != this.collectorDevSer.getCollectorIdByDevId(deviceId)) {
                CollectorInfo collectorInfo = this.collectorService.getCollectorInfo(this.collectorDevSer.getCollectorIdByDevId(deviceId).longValue());
                String collectorIp = collectorInfo.getIpAddress();
                TopNIPFlowRmiService toponIPFlowService = this.cloudCollectorRMIProxy.getTopNIPFlowRmiService(collectorIp);
                try {
                    if (null != toponIPFlowService) {
                        List<TopNIPFlowInfo> topNIPFlowInfoList = toponIPFlowService.getTopNIPFlow(map);
                        if (null != topNIPFlowInfoList && !topNIPFlowInfoList.isEmpty()) {
                            for (TopNIPFlowInfo flowInfo : topNIPFlowInfoList) {
                                DeviceIpTopN dTopN = new DeviceIpTopN();
                                AticUtil.copyProperties((Object)flowInfo, (Object)dTopN);
                                deviceIpTopNList.add(dTopN);
                            }
                        }
                        break block7;
                    }
                    this.logger.error((Object)"toponIPFlowService is null");
                }
                catch (RemoteException e) {
                    this.logger.error((Object)("get Collector Remote Service failed, " + e.getMessage()));
                }
            } else {
                this.logger.info((Object)"According to the deviceId obtained the collector is null");
            }
        }
        this.logger.info((Object)("deviceIpTopNList size " + deviceIpTopNList.size()));
        return deviceIpTopNList;
    }

    @Override
    public CloudCleanConfigForm getCloudCleanConf() {
        Iterator iterator;
        this.logger.info((Object)"getCloudCleanConf");
        List cloudCleanConfList = this.configDao.getAll();
        CloudCleanConfigForm cloudCleanConfForm = null;
        if (null != cloudCleanConfList && !cloudCleanConfList.isEmpty() && (iterator = cloudCleanConfList.iterator()).hasNext()) {
            CloudCleanConfig ccf = (CloudCleanConfig)iterator.next();
            cloudCleanConfForm = new CloudCleanConfigForm();
            AticUtil.copyProperties((Object)ccf, (Object)cloudCleanConfForm);
            return cloudCleanConfForm;
        }
        return null;
    }

    @Override
    public CloudCleanConfigDevFlowForm getCloudCleanConfDevByDeviceId(Long deviceId) {
        this.logger.info((Object)("getCloudCleanConfDevByDeviceId deviceId=" + deviceId));
        CloudCleanConfigDevFlowForm cloudCleanConfigDevForm = null;
        try {
            String hql = "from CloudCleanConfigDevFlow where deviceId= ? ";
            List cloudCleanConfDevList = this.cloudCleanConfigDevDao.findByHql(hql, deviceId);
            for (CloudCleanConfigDevFlow ccfd : cloudCleanConfDevList) {
                cloudCleanConfigDevForm = new CloudCleanConfigDevFlowForm();
                AticUtil.copyProperties((Object)ccfd, (Object)cloudCleanConfigDevForm);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("getCloudCleanConfDevByDeviceId failed " + e.getMessage()));
        }
        return cloudCleanConfigDevForm;
    }

    @Override
    public List<CloudClean> queryNotStatic() {
        String hql = "from CloudClean where policyType='auto' or policyType='manual'";
        this.logger.info((Object)("queryNotStatic " + hql));
        List cloudCleanList = this.cloudCleanDao.findByHql(hql);
        return cloudCleanList;
    }

    @Override
    public void deteleByInfo(List<CloudClean> cloudCleanList) {
        for (CloudClean cloudClean : cloudCleanList) {
            this.cloudCleanDao.deleteById(cloudClean.getId());
        }
        this.logger.info((Object)"deteleByInfo CloudClean");
    }

    @Override
    public void disableCloudClean4CTCC(List<CloudCleanForm> cloudCleanFormList) {
        CloudCleanConfigForm ccf = this.getCloudCleanConf();
        if (null != ccf && null != cloudCleanFormList && !cloudCleanFormList.isEmpty()) {
            this.logger.info((Object)("Disable CTCC Cloud Clean!" + cloudCleanFormList.toString()));
            for (CloudCleanForm cc : cloudCleanFormList) {
                StringBuffer pubKey = new StringBuffer();
                StringBuffer priKey = new StringBuffer();
                try {
                    pubKey.append(this.dataProtectService.sdpDecrypt(ccf.getPublicKey(), 0L));
                    priKey.append(this.dataProtectService.sdpDecrypt(ccf.getPrivateKey(), 0L));
                }
                catch (Exception e) {
                    this.logger.error((Object)("CloudCleanServiceImpl.disableCloudClean4HW  decrypt failed " + e.getMessage()));
                }
                CloudCleanUtil.getInstance();
                CloudCleanUtil.disableCloudClean4CTCC(ccf.getUrl(), pubKey, priKey, cc.getIpMask());
                Long curTime = System.currentTimeMillis();
                cc.setEndTime(String.valueOf(curTime));
                cc.setStatus("disable");
                this.updateCloudClean(cc);
            }
        }
    }

    @Override
    public void disableCloudClean4HW(List<CloudCleanForm> cloudCleanFormList) {
        if (null != cloudCleanFormList && !cloudCleanFormList.isEmpty()) {
            this.logger.info((Object)("Disable HuaWei Cloud Clean!" + cloudCleanFormList.toString()));
            CloudCleanConfigForm ccf = this.getCloudCleanConf();
            if (null != ccf) {
                for (CloudCleanForm cloudCleanForm : cloudCleanFormList) {
                    block7: {
                        StringBuffer pubKey = new StringBuffer();
                        StringBuffer priKey = new StringBuffer();
                        try {
                            pubKey.append(this.dataProtectService.sdpDecrypt(ccf.getPublicKey(), 0L));
                            priKey.append(this.dataProtectService.sdpDecrypt(ccf.getPrivateKey(), 0L));
                        }
                        catch (Exception e) {
                            this.logger.error((Object)("CloudCleanServiceImpl.disableCloudClean4HW  decrypt failed " + e.getMessage()));
                        }
                        try {
                            CloudCleanUtil.getInstance().disableCloudClean4HW(ccf.getUrl(), pubKey, priKey, cloudCleanForm.getEventId());
                        }
                        catch (LegoCheckedException e) {
                            if (571954L == e.getErrorCode()) break block7;
                            throw new LegoCheckedException(e.getErrorCode());
                        }
                    }
                    Long curTime = System.currentTimeMillis();
                    cloudCleanForm.setEndTime(String.valueOf(curTime));
                    cloudCleanForm.setStatus("disable");
                    this.updateCloudClean(cloudCleanForm);
                }
            }
        }
    }

    @Override
    public void enableCloudClean4CTCC(List<CloudCleanForm> cloudCleanFormList) {
        CloudCleanConfigForm ccf = this.getCloudCleanConf();
        HashMap<String, String> mapParams = new HashMap<String, String>();
        if (null != ccf && null != cloudCleanFormList && !cloudCleanFormList.isEmpty()) {
            this.logger.info((Object)("enableCloudClean4CTCC " + cloudCleanFormList.toString()));
            ArrayList<CloudCleanForm> cloudCleanFormManualList = new ArrayList<CloudCleanForm>();
            for (CloudCleanForm ccForm : cloudCleanFormList) {
                mapParams.put("ip", ccForm.getIpMask());
                mapParams.put("zone", String.valueOf(ccForm.getDefendScope()));
                mapParams.put("unblockTime", ccForm.getUnblockTime());
                StringBuffer pubKey = new StringBuffer();
                StringBuffer priKey = new StringBuffer();
                try {
                    pubKey.append(this.dataProtectService.sdpDecrypt(ccf.getPublicKey(), 0L));
                    priKey.append(this.dataProtectService.sdpDecrypt(ccf.getPrivateKey(), 0L));
                }
                catch (Exception e) {
                    this.logger.error((Object)("CloudCleanServiceImpl.disableCloudClean4CTTC  decrypt failed " + e.getMessage()));
                }
                try {
                    CloudCleanUtil.getInstance().enableCloudClean4CTCC(ccf.getUrl(), pubKey, priKey, mapParams);
                }
                catch (LegoCheckedException e) {
                    throw new LegoCheckedException(e.getErrorCode());
                }
                Long curTiem = System.currentTimeMillis();
                if (null == ccForm.getBeginTime()) {
                    ccForm.setFirstEnableTime(String.valueOf(curTiem));
                }
                ccForm.setBeginTime(String.valueOf(curTiem));
                ccForm.setEndTime(null);
                ccForm.setStatus("enable");
                this.updateCloudClean(ccForm);
                cloudCleanFormManualList.add(ccForm);
            }
            ArrayList<CloudClean> cloudCleanFormList1 = new ArrayList<CloudClean>();
            for (CloudCleanForm ccform : cloudCleanFormManualList) {
                CloudClean cc = new CloudClean();
                AticUtil.copyProperties((Object)ccform, (Object)cc);
                cloudCleanFormList1.add(cc);
            }
            this.cloudCleanThreadDeal.setList(cloudCleanFormList1);
        }
    }

    @Override
    public void enableCloudClean4HW(List<CloudCleanForm> cloudCleanFormList) {
        this.logger.info((Object)("Enable HuaWei Cloud Clean!" + cloudCleanFormList.toString()));
        CloudCleanConfigForm ccf = this.getCloudCleanConf();
        if (null == ccf) {
            this.logger.error((Object)"ccf is null");
            return;
        }
        ArrayList<CloudCleanForm> cloudCleanFormManualList = new ArrayList<CloudCleanForm>();
        for (CloudCleanForm cloudForm : cloudCleanFormList) {
            CloudCleanForm cleanForm = this.deployCloudClean(cloudForm, ccf);
            if (null == cleanForm) continue;
            cloudCleanFormManualList.add(cleanForm);
        }
        ArrayList<CloudClean> cloudCleanFormList1 = new ArrayList<CloudClean>();
        for (CloudCleanForm ccform : cloudCleanFormManualList) {
            CloudClean cc = new CloudClean();
            AticUtil.copyProperties((Object)ccform, (Object)cc);
            cloudCleanFormList1.add(cc);
        }
        this.cloudCleanThreadDeal.setList(cloudCleanFormList1);
    }

    private CloudCleanForm deployCloudClean(CloudCleanForm cloudForm, CloudCleanConfigForm ccf) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        if (null != cloudForm.getDeviceId()) {
            CloudCleanConfigDevFlowForm ccfdevForm = this.getCloudCleanConfDevByDeviceId(cloudForm.getDeviceId());
            if (ccfdevForm != null) {
                mapParam.put("curFlow", ccfdevForm.getCurFlowValue());
            } else {
                this.logger.error((Object)"ccfdevForm is null");
            }
        } else {
            mapParam.put("curFlow", "");
        }
        mapParam.put("ipMask", cloudForm.getIpMask());
        mapParam.put("defendAction", cloudForm.getDefendAction());
        StringBuffer pubKey = new StringBuffer();
        StringBuffer priKey = new StringBuffer();
        try {
            pubKey.append(this.dataProtectService.sdpDecrypt(ccf.getPublicKey(), 0L));
            priKey.append(this.dataProtectService.sdpDecrypt(ccf.getPrivateKey(), 0L));
        }
        catch (Exception e) {
            this.logger.error((Object)("CloudCleanServiceImpl.enableCloudClean4HW  decrypt failed " + e.getMessage()));
        }
        String eventId = null;
        try {
            eventId = CloudCleanUtil.getInstance().enableCloudClean4HW(ccf.getUrl(), pubKey, priKey, mapParam);
        }
        catch (LegoCheckedException e) {
            throw new LegoCheckedException(e.getErrorCode());
        }
        if (null != eventId) {
            cloudForm.setEventId(eventId);
            cloudForm.setStatus("enable");
            Long curTiem = System.currentTimeMillis();
            if (null == cloudForm.getBeginTime()) {
                cloudForm.setFirstEnableTime(String.valueOf(curTiem));
            }
            cloudForm.setBeginTime(String.valueOf(curTiem));
            cloudForm.setEndTime(null);
            this.updateCloudClean(cloudForm);
            this.logger.info((Object)("Enable HuaWei Cloud Clean!" + eventId));
            return cloudForm;
        }
        return null;
    }

    private void enableCloudClean4HW(CloudCleanForm cloudCleanForm) {
        this.logger.info((Object)("Enable HuaWei Cloud Clean!" + cloudCleanForm));
        CloudCleanConfigForm ccf = this.getCloudCleanConf();
        if (null == ccf) {
            this.logger.error((Object)"ccf is null");
            return;
        }
        ArrayList<CloudCleanForm> cloudCleanFormManualList = new ArrayList<CloudCleanForm>();
        CloudCleanForm cleanForm = this.deployCloudClean(cloudCleanForm, ccf);
        if (null != cleanForm) {
            cloudCleanFormManualList.add(cleanForm);
        }
        ArrayList<CloudClean> cloudCleanFormList1 = new ArrayList<CloudClean>();
        for (CloudCleanForm ccform : cloudCleanFormManualList) {
            CloudClean cc = new CloudClean();
            AticUtil.copyProperties((Object)ccform, (Object)cc);
            cloudCleanFormList1.add(cc);
        }
        this.cloudCleanThreadDeal.setList(cloudCleanFormList1);
    }

    private List<CloudCleanForm> getAllCloudCleanTasks() {
        String hql = "from CloudClean";
        ArrayList<CloudCleanForm> cloudCleanFormList = new ArrayList<CloudCleanForm>();
        List ccInfoList = this.cloudCleanDao.findByHql(hql);
        for (CloudClean cc : ccInfoList) {
            CloudCleanForm ccform = new CloudCleanForm();
            AticUtil.copyProperties((Object)cc, (Object)ccform);
            cloudCleanFormList.add(ccform);
        }
        return cloudCleanFormList;
    }

    private boolean isCloudCleanTaskExist(List<CloudCleanForm> ccFormList, DeviceIpTopN dtn) {
        for (CloudCleanForm cloudCleanForm : ccFormList) {
            try {
                if (null == cloudCleanForm.getIpMask() || cloudCleanForm.getIpMask().isEmpty() || !IPUtil4Atic.isInIpRange((String[])IPUtil.getSubnetRange((String)cloudCleanForm.getIpMask().split("/")[0], (int)Integer.parseInt(cloudCleanForm.getIpMask().split("/")[1])), (String)dtn.getIpAddr())) continue;
                this.logger.info((Object)("cloud clean task already exist. topn ip :" + dtn.getIpAddr() + ", cloud clean task :" + cloudCleanForm.getIpMask()));
                return true;
            }
            catch (RuntimeException e) {
                this.logger.error((Object)"isCloudCleanTaskExist exception:", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public List<CloudClean> autoCreateCloudClean(Long deviceId) {
        this.logger.info((Object)("autoCreateCloudClean in the CloudCleanServiceImpl " + deviceId));
        List<CloudCleanForm> ccFormList = this.getAllCloudCleanTasks();
        CloudCleanConfigForm ccf = this.getCloudCleanConf();
        HashMap<String, String> mapDetail = null;
        if (null != ccf) {
            CloudCleanConfigDevFlowForm ccfdevForm = this.getCloudCleanConfDevByDeviceId(deviceId);
            if (null == ccfdevForm) {
                this.logger.error((Object)"ccfdevForm is null");
                return null;
            }
            mapDetail = new HashMap<String, String>();
            mapDetail.put("deviceIp", ccfdevForm.getDeviceIp());
            mapDetail.put("ipStatus", ccf.getIpStatus());
            mapDetail.put("ipFlowValue", ccf.getIpFlowValue());
            mapDetail.put("topn", ccf.getIpFlowTopn());
            mapDetail.put("ipVersion", "ipv4");
            String ipWhiteList = ccf.getIpWhiteList();
            ipWhiteList = ipWhiteList.replace("\r", "");
            ipWhiteList = ipWhiteList.replace("\n", ",");
            mapDetail.put("ipWhiteList", ipWhiteList);
            this.adeviceIpTopNList = this.getTopNIPFlow(deviceId, mapDetail);
            if (this.adeviceIpTopNList.isEmpty()) {
                try {
                    Thread.sleep(20000L);
                    this.adeviceIpTopNList = this.getTopNIPFlow(deviceId, mapDetail);
                    if (this.adeviceIpTopNList.isEmpty()) {
                        Thread.sleep(20000L);
                        this.adeviceIpTopNList = this.getTopNIPFlow(deviceId, mapDetail);
                        if (this.adeviceIpTopNList.isEmpty()) {
                            Thread.sleep(20000L);
                            this.adeviceIpTopNList = this.getTopNIPFlow(deviceId, mapDetail);
                        }
                        if (this.adeviceIpTopNList.isEmpty()) {
                            Thread.sleep(10000L);
                            this.adeviceIpTopNList = this.getTopNIPFlow(deviceId, mapDetail);
                        }
                    }
                }
                catch (InterruptedException e) {
                    this.logger.error((Object)("autoCreateCloudClean-getTopNIPFlow is null " + deviceId));
                }
            }
            HashSet<CloudClean> cloudCleanFormSet = new HashSet<CloudClean>();
            ArrayList<CloudCleanForm> cloudCleanFormList = new ArrayList<CloudCleanForm>();
            if (null != this.adeviceIpTopNList && !this.adeviceIpTopNList.isEmpty()) {
                this.logger.info((Object)("get IpTopNList " + this.adeviceIpTopNList.size()));
                if ("HW".equalsIgnoreCase(ccf.getServiceProvider())) {
                    this.logger.info((Object)("Automatic create task, service provider is HW, CloudCleanConfigForm is" + ccf.toString()));
                    ArrayList<CloudClean> cloudCleanInfoList = new ArrayList<CloudClean>();
                    for (DeviceIpTopN dtn : this.adeviceIpTopNList) {
                        if (this.isCloudCleanTaskExist(ccFormList, dtn)) continue;
                        CloudCleanForm cloudForm = new CloudCleanForm();
                        CloudClean cloudCleanInfo = new CloudClean();
                        if ("block".equals(ccf.getDefendAction())) {
                            cloudForm.setIpMask(dtn.getIpAddr() + "/32");
                        } else {
                            String ipMask = this.getNetAddr(dtn.getIpAddr(), this.mask24ToIp());
                            cloudForm.setIpMask(ipMask + "/24");
                        }
                        CloudCleanProtectIpForm protectIpForm = this.getProtectIpByIp(cloudForm.getIpMask());
                        if (null == protectIpForm) {
                            String[] detailPara = new String[]{cloudForm.getIpMask()};
                            this.writeSysLog("atic.bis.cloud.clean.operation.create", cloudForm.getIpMask(), "atic.bis.cloudclean.create.policy.failed.oplog.autocreate", detailPara, 0);
                            continue;
                        }
                        cloudForm.setServiceProvider(ccf.getServiceProvider());
                        cloudForm.setPolicyType(ccf.getMode());
                        cloudForm.setDeviceId(deviceId);
                        cloudForm.setDeviceName(ccfdevForm.getDeviceName());
                        cloudForm.setUnblockTime(ccf.getUnblockTime());
                        cloudForm.setDefendAction(ccf.getDefendAction());
                        cloudForm.setDefendScope(null);
                        cloudForm.setStatus("disable");
                        cloudForm.setOperator("--");
                        cloudForm.setReInjectDeviceName(protectIpForm.getReInjectDeviceName());
                        cloudForm.setProtectIpId(protectIpForm.getId());
                        AticUtil.copyProperties((Object)cloudForm, (Object)cloudCleanInfo);
                        cloudCleanFormSet.add(cloudCleanInfo);
                    }
                    this.cloudCleanDao.saveAll(cloudCleanFormSet);
                    CloudCleanForm ccForm = null;
                    for (CloudClean ccInfo : cloudCleanFormSet) {
                        ccForm = new CloudCleanForm();
                        AticUtil.copyProperties((Object)ccInfo, (Object)ccForm);
                        cloudCleanFormList.add(ccForm);
                        String[] detailPara = new String[]{ccInfo.getIpMask()};
                        this.writeSysLog("atic.bis.cloud.clean.operation.create", ccInfo.getIpMask(), "atic.bis.cloudclean.create.policy.success.oplog.autocreate", detailPara, 1);
                    }
                    if ("auto".equals(ccf.getMode())) {
                        this.logger.info((Object)"enable enableCloudClean4HW");
                        for (CloudCleanForm ccfo : cloudCleanFormList) {
                            try {
                                if (null == this.aticDeviceService) {
                                    this.aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
                                }
                                Long protectIpId = ccfo.getProtectIpId();
                                CloudCleanProtectIpForm form = this.getIpById(protectIpId);
                                List<CloudCleanProtectIpDeviceForm> forms = form.getIpDevs();
                                Boolean result = true;
                                if (forms.isEmpty()) {
                                    result = false;
                                }
                                for (CloudCleanProtectIpDeviceForm ipDevform : forms) {
                                    Object reInjectDevice = null;
                                    if (null == ipDevform) continue;
                                    reInjectDevice = this.aticDeviceService.getDeviceByMoid(ipDevform.getDevId().longValue());
                                    String[] detailPara = new String[]{ccfo.getIpMask(), "LoopBack100", reInjectDevice.getName()};
                                    Boolean res = this.deployDivert(ccfo, (AticDevice)reInjectDevice, "LoopBack100");
                                    if (!res.booleanValue()) {
                                        this.writeSysLog("atic.bis.cloud.clean.operation.deploy", ccfo.getIpMask(), "atic.bis.cloudclean.disable.policy.failed.oplog.deployDivert", detailPara, 0);
                                        this.logger.error((Object)("deployDivert LoopBack100 failed for " + ccfo.getIpMask() + " on reInjectDevice" + reInjectDevice.getName()));
                                        result = false;
                                        break;
                                    }
                                    this.writeSysLog("atic.bis.cloud.clean.operation.deploy", ccfo.getIpMask(), "atic.bis.cloudclean.disable.policy.success.oplog.deployDivert", detailPara, 1);
                                    this.logger.info((Object)("deployDivert LoopBack100 success for " + ccfo.getIpMask() + " on reInjectDevice" + reInjectDevice.getName()));
                                }
                                this.initKIOSwitch();
                                this.logger.info((Object)("isOpenLoopBack300 is " + this.isOpenLoopBack300));
                                if (this.isOpenLoopBack300) {
                                    if (!result.booleanValue()) {
                                        this.logger.error((Object)("deployDivert LoopBack100 failed for " + ccfo.getIpMask()));
                                        ccfo.setStatus("disable");
                                        throw new LegoCheckedException(570503L);
                                    }
                                    AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
                                    List linkageDeviceList = this.defendGroupService.getUpGroupCleanDevices(device);
                                    for (AticDevice dev : linkageDeviceList) {
                                        String[] detailParas = new String[]{ccfo.getIpMask(), "LoopBack300", dev.getName()};
                                        Boolean res = this.deployDivert(ccfo, dev, "LoopBack300");
                                        if (!res.booleanValue()) {
                                            this.writeSysLog("atic.bis.cloud.clean.operation.deploy", ccfo.getIpMask(), "atic.bis.cloudclean.disable.policy.failed.oplog.deployDivert", detailParas, 0);
                                            this.logger.error((Object)("deployDivert LoopBack300 failed for " + ccfo.getIpMask() + " on SC deviceName " + dev.getName()));
                                            result = false;
                                            break;
                                        }
                                        this.writeSysLog("atic.bis.cloud.clean.operation.deploy", ccfo.getIpMask(), "atic.bis.cloudclean.disable.policy.success.oplog.deployDivert", detailParas, 1);
                                        this.logger.info((Object)("deployDivert LoopBack300 success for " + ccfo.getIpMask() + " on SC deviceName " + dev.getName()));
                                    }
                                }
                                if (!result.booleanValue()) {
                                    this.logger.error((Object)("deployDivert failed for " + ccfo.getIpMask()));
                                    ccfo.setStatus("disable");
                                    throw new LegoCheckedException(570503L);
                                }
                                this.logger.info((Object)("deployDivert success for " + ccfo.getIpMask() + " on all reInjectDevices."));
                                try {
                                    this.enableCloudClean4HW(ccfo);
                                }
                                catch (LegoCheckedException e) {
                                    this.logger.error((Object)"enableCloudClean4HW is error", (Throwable)e);
                                    throw new LegoCheckedException(571971L);
                                }
                                String[] detailPara = new String[]{ccfo.getIpMask()};
                                if ("enable".equals(ccfo.getStatus())) {
                                    try {
                                        this.deleteGroupDeviceDivert(ccfo);
                                    }
                                    catch (LegoCheckedException e) {
                                        this.logger.error((Object)"deleteGroupDeviceDivert error", (Throwable)e);
                                        throw new LegoCheckedException(571212L);
                                    }
                                    this.writeSysLog("atic.bis.cloud.clean.operation.enable", ccfo.getIpMask(), "atic.bis.cloud.clean.enable.alter.success", detailPara, 1);
                                    if (!this.isOpenLoopBack300 || this.loopBack300DelayTime <= 0) continue;
                                    CloudCleanTimeThread timeThread = new CloudCleanTimeThread(ccfo);
                                    ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
                                    timer.schedule(timeThread, (long)this.loopBack300DelayTime, TimeUnit.SECONDS);
                                    continue;
                                }
                                this.writeSysLog("atic.bis.cloud.clean.operation.enable", ccfo.getIpMask(), "atic.bis.cloud.clean.enable.alter.fail", detailPara, 0);
                            }
                            catch (LegoCheckedException e) {
                                String[] detailPara = new String[]{ccfo.getIpMask()};
                                String detail = "";
                                Long errorCode = e.getErrorCode();
                                detail = 571212 == errorCode.intValue() ? "atic.bis.cloud.clean.enable.alter.fail.delete.divert" : (570503 == errorCode.intValue() ? "atic.bis.cloud.clean.enable.alter.fail.divert" : (571971 == errorCode.intValue() ? "atic.bis.cloud.clean.enable.alter.fail.hw" : "atic.bis.cloud.clean.enable.alter.fail"));
                                this.writeSysLog("atic.bis.cloud.clean.operation.enable", ccfo.getIpMask(), detail, detailPara, 0);
                            }
                        }
                        if (!cloudCleanInfoList.isEmpty()) {
                            this.cloudCleanThreadDeal.setList(cloudCleanInfoList);
                        }
                    }
                    for (CloudCleanForm ccform : cloudCleanFormList) {
                        if (null == this.queryCloudClean(ccform.getIpMask(), ccform.getServiceProvider(), ccform.getDeviceId())) continue;
                        cloudCleanInfoList.add(this.queryCloudClean(ccform.getIpMask(), ccform.getServiceProvider(), ccform.getDeviceId()));
                    }
                    this.cloudCleanThreadDeal.setList(cloudCleanInfoList);
                    return cloudCleanInfoList;
                }
                if ("nothing".equals(ccf.getServiceProvider())) {
                    this.logger.info((Object)("get serviceProvider is null " + ccf.getServiceProvider()));
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public Boolean deployDivert(CloudCleanForm cloudCleanForm, AticDevice reInjectDevice, String loopback) {
        this.logger.info((Object)("start deploy " + loopback + " for ip " + cloudCleanForm.getIpMask() + " on reInjectDevice " + reInjectDevice.getName()));
        try {
            this.deployCmdOnDevice(cloudCleanForm, reInjectDevice, loopback);
        }
        catch (LegoCheckedException e) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ee) {
                this.logger.error((Object)"doDeployDivert sleep error", (Throwable)ee);
            }
            try {
                this.deployCmdOnDevice(cloudCleanForm, reInjectDevice, loopback);
            }
            catch (LegoCheckedException e1) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ee) {
                    this.logger.error((Object)"doDeployDivert sleep error", (Throwable)ee);
                }
                try {
                    this.deployCmdOnDevice(cloudCleanForm, reInjectDevice, loopback);
                }
                catch (LegoCheckedException e2) {
                    this.cloudCleanAlarmHandler.staticRouterCreate(cloudCleanForm, reInjectDevice);
                    this.logger.error((Object)("fail to deploy " + loopback + " for ip " + cloudCleanForm.getIpMask() + " on reInjectDevice " + reInjectDevice.getName()));
                    return false;
                }
            }
        }
        catch (Exception e2) {
            this.cloudCleanAlarmHandler.staticRouterCreate(cloudCleanForm, reInjectDevice);
            this.logger.error((Object)("fail to deploy " + loopback + " for ip " + cloudCleanForm.getIpMask() + " on reInjectDevice " + reInjectDevice.getName()), (Throwable)e2);
            return false;
        }
        this.logger.info((Object)("success to deploy " + loopback + " for ip " + cloudCleanForm.getIpMask() + " on reInjectDevice " + reInjectDevice.getName()));
        return true;
    }

    public void deployCmdOnDevice(CloudCleanForm cloudCleanForm, AticDevice reInjectDevice, String loopback) {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("system");
        String[] ipMask = cloudCleanForm.getIpMask().split("/");
        String cmd = null;
        if ("LoopBack100".equalsIgnoreCase(loopback)) {
            cmd = "ip route-static " + ipMask[0] + " " + ipMask[1] + " LoopBack100";
        } else if ("LoopBack200".equalsIgnoreCase(loopback)) {
            cmd = "ip route-static " + ipMask[0] + " " + ipMask[1] + " LoopBack200 preference 59";
        } else if ("LoopBack300".equalsIgnoreCase(loopback)) {
            cmd = "ip route-static " + ipMask[0] + " " + ipMask[1] + " LoopBack300";
        }
        cmds.add(cmd);
        Integer errorCode = 570503;
        try {
            List cmdResult = CmdUtil.execCmds((long)reInjectDevice.getMoId(), cmds);
            this.logger.info((Object)("cmdResult result is " + cmdResult + " for cmd " + cmd));
            errorCode = this.cmdResult(cmdResult);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("deploy divert error for " + cmd));
        }
        if (errorCode != null && errorCode != 1) {
            throw new LegoCheckedException((long)errorCode.intValue());
        }
    }

    @Override
    public void deleteGroupDeviceDivert(CloudCleanForm ccfo) {
        if (!this.isOpenKIO) {
            this.logger.info((Object)"deleteGroupDeviceDivert, isOpenKIO is false .");
            return;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.logger.info((Object)"deleteGroupDeviceDivert, isOpenKIO is true .");
        this.logger.info((Object)"deleteGroupDeviceDivert, in to ....");
        Long deviceId = ccfo.getDeviceId();
        String ipMask = ccfo.getIpMask();
        String ipAddress = ipMask.substring(0, ipMask.indexOf("/"));
        AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
        if (null != device) {
            List linkageDeviceList = this.defendGroupService.getUpGroupCleanDevices(device);
            List groupDeviceList = this.defendGroupService.getDownGroupCleanDevices(device);
            if (!linkageDeviceList.isEmpty()) {
                this.logger.info((Object)"deleteGroupDeviceDivert, linkageDeviceList has data!");
                this.deleteDivertTactics(ipAddress, linkageDeviceList);
            }
            if (groupDeviceList.isEmpty()) {
                this.logger.info((Object)"deleteGroupDeviceDivert, groupDeviceList has not data!");
                groupDeviceList.add(device);
            }
            this.deleteDivertTactics(ipAddress, groupDeviceList);
        }
        this.logger.info((Object)"deleteGroupDeviceDivert end ....");
    }

    private DivertTactics createDivert(long deviceId, String zoneIp) {
        String[] ipRange = null;
        DivertTactics divertTactics = new DivertTactics();
        divertTactics.setDeviceId(Long.valueOf(deviceId));
        divertTactics.setDivertIp(zoneIp);
        if (IPUtil.isIpv4((String)zoneIp)) {
            ipRange = IPUtil.getSubnetRange((String)zoneIp, (int)24);
            divertTactics.setMask(Integer.valueOf(24));
            divertTactics.setStartIp(ipRange[0]);
            divertTactics.setEndIp(ipRange[1]);
            return divertTactics;
        }
        return null;
    }

    private void deleteDivertTactics(String zoneIp, List<AticDevice> aticDeviceList) {
        for (AticDevice device : aticDeviceList) {
            DivertTactics divertTactics = this.createDivert(device.getMoId(), zoneIp);
            if (null == divertTactics) {
                return;
            }
            List divert24MaskInDBs = this.divertTacticsDao.getConflictDivert(divertTactics, 24);
            this.logger.info((Object)("deleteDivertTactics, has divertTactics is 24 mask in same segment :" + divert24MaskInDBs.size()));
            if (!divert24MaskInDBs.isEmpty()) {
                this.logger.info((Object)("deleteDivertTactics, has divertTactics is 24 mask in same segment " + zoneIp + "/" + divertTactics.getMask()));
                this.logger.info((Object)"deleteDivertTactics, begin to delete....");
                for (DivertTactics divertTacticsTemp : divert24MaskInDBs) {
                    DivertTacticsForm dtDivertTacticsForm = new DivertTacticsForm();
                    divertTacticsTemp.setOperator("system");
                    String clientIp = System.getProperty("nms.server.host");
                    divertTacticsTemp.setClientIp(clientIp);
                    AticUtil.copyProperties((Object)divertTacticsTemp, (Object)dtDivertTacticsForm);
                    this.divertTacticsService.stopAndDelDivert(dtDivertTacticsForm);
                    this.logger.info((Object)("delete DB divert , deviceIp=" + device.getIpAddress() + ", zoneIp=" + divertTacticsTemp.getDivertIp() + ",  divertMode =" + divertTacticsTemp.getDivertMode() + ", divertStatus=" + divertTacticsTemp.getDivertStatus()));
                }
                this.logger.info((Object)"deleteDivertTactics, end to delete....");
                continue;
            }
            this.logger.info((Object)("deleteDivertTactics, not divertTactics is 24 mask in same segment " + zoneIp + "/" + divertTactics.getMask()));
        }
    }

    @Override
    public Boolean undoDeployDivert(CloudCleanForm cloudCleanForm, AticDevice reInjectDevice, String loopback) {
        this.logger.info((Object)("start undo deploy " + loopback + " for ip " + cloudCleanForm.getIpMask() + " on reInjectDevice " + reInjectDevice.getName()));
        try {
            this.undoDeployCmdOnDevice(cloudCleanForm, reInjectDevice, loopback);
        }
        catch (LegoCheckedException e) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ee) {
                this.logger.error((Object)"undoDeployDivert sleep error", (Throwable)ee);
            }
            try {
                this.undoDeployCmdOnDevice(cloudCleanForm, reInjectDevice, loopback);
            }
            catch (LegoCheckedException e1) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ee) {
                    this.logger.error((Object)"undoDeployDivert sleep error", (Throwable)ee);
                }
                try {
                    this.undoDeployCmdOnDevice(cloudCleanForm, reInjectDevice, loopback);
                }
                catch (LegoCheckedException e2) {
                    this.cloudCleanAlarmHandler.staticRouterDelete(cloudCleanForm, reInjectDevice);
                    this.logger.error((Object)("fail to undo deploy " + loopback + " for ip " + cloudCleanForm.getIpMask() + " on reInjectDevice " + reInjectDevice.getName()));
                    return false;
                }
            }
        }
        catch (Exception e2) {
            this.cloudCleanAlarmHandler.staticRouterDelete(cloudCleanForm, reInjectDevice);
            this.logger.error((Object)("fail to undo deploy " + loopback + " for ip " + cloudCleanForm.getIpMask() + " on reInjectDevice " + reInjectDevice.getName()), (Throwable)e2);
            return false;
        }
        this.logger.info((Object)("success to undo deploy " + loopback + " for ip " + cloudCleanForm.getIpMask() + " on reInjectDevice " + reInjectDevice.getName()));
        return true;
    }

    public void undoDeployCmdOnDevice(CloudCleanForm cloudCleanForm, AticDevice reInjectDevice, String loopback) {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("system");
        String[] ipMask = cloudCleanForm.getIpMask().split("/");
        String cmd = null;
        if ("LoopBack100".equalsIgnoreCase(loopback)) {
            cmd = "undo ip route-static " + ipMask[0] + " " + ipMask[1] + " LoopBack100";
        } else if ("LoopBack200".equalsIgnoreCase(loopback)) {
            cmd = "undo ip route-static " + ipMask[0] + " " + ipMask[1] + " LoopBack200 preference 59";
        } else if ("LoopBack300".equalsIgnoreCase(loopback)) {
            cmd = "undo ip route-static " + ipMask[0] + " " + ipMask[1] + " LoopBack300";
        }
        cmds.add(cmd);
        Integer errorCode = 570503;
        try {
            List cmdResult = CmdUtil.execCmds((long)reInjectDevice.getMoId(), cmds);
            this.logger.info((Object)("cmdResult result is " + cmdResult + " for cmd " + cmd));
            errorCode = this.cmdResult(cmdResult);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("undo deploy divert error for " + cmd));
        }
        if (errorCode != null && errorCode != 1) {
            throw new LegoCheckedException((long)errorCode.intValue());
        }
    }

    @Override
    public void undoDeployDivert300(CloudCleanForm cloudCleanForm) {
        Long deviceId = cloudCleanForm.getDeviceId();
        if (null == deviceId) {
            return;
        }
        AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
        if (null == device) {
            return;
        }
        List linkageDeviceList = this.defendGroupService.getUpGroupCleanDevices(device);
        for (AticDevice dev : linkageDeviceList) {
            String[] detailParas = new String[]{cloudCleanForm.getIpMask(), "LoopBack300", dev.getName()};
            Boolean res = this.undoDeployDivert(cloudCleanForm, dev, "LoopBack300");
            if (!res.booleanValue()) {
                this.writeSysLog("atic.bis.cloud.clean.operation.undoDeploy", cloudCleanForm.getIpMask(), "atic.bis.cloudclean.disable.policy.failed.oplog.undoDeployDivert", detailParas, 0);
                this.logger.error((Object)("undoDeployDivert LoopBack300 failed for " + cloudCleanForm.getIpMask() + " on deviceName " + dev.getName()));
                continue;
            }
            this.writeSysLog("atic.bis.cloud.clean.operation.undoDeploy", cloudCleanForm.getIpMask(), "atic.bis.cloudclean.disable.policy.success.oplog.undoDeployDivert", detailParas, 1);
            this.logger.info((Object)("undoDeployDivert LoopBack300 failed for " + cloudCleanForm.getIpMask() + " on deviceName " + dev.getName()));
        }
    }

    private Integer cmdResult(List<String> cmdResult) {
        for (String cmd : cmdResult) {
            if (cmd.contains("Error: Invalid IP address")) {
                return 571208;
            }
            if (cmd.contains("Error: The number of IP addresses of traffic diversion reaches limit already")) {
                return 571209;
            }
            if (cmd.contains("Error: Please specify IP address of next hop first")) {
                return 571210;
            }
            if (cmd.contains("Error: Traffic IP addresses conflict")) {
                return 571211;
            }
            if (cmd.contains("Error: The IP address does not exist")) {
                return 1;
            }
            if (cmd.contains("Error: The specified route does not exist")) {
                return 1;
            }
            if (cmd.contains("Error: The route already exists.")) {
                return 1;
            }
            if (cmd.contains("Error: This traffic diversion policy does not exist")) {
                return 571212;
            }
            if (cmd.contains("Route-Distinguisher has not been set to this VPN-Instance")) {
                return 571214;
            }
            if (cmd.contains("The specified VPN-Instance does not exist")) {
                return 571215;
            }
            if (cmd.contains("The static route of this policy is the same as an existing one")) {
                return 571216;
            }
            if (cmd.contains("Error:")) {
                return 570503;
            }
            if (cmdResult.contains("Info: The system is busy in collecting the current configuration. Please wait...")) {
                return 571217;
            }
            if (!cmdResult.contains("The system is busy in saving or comparing the current configuration. Please wait...")) continue;
            return 571217;
        }
        return 1;
    }

    private String getNetAddr(String ipAddress, String mask) {
        String netAddress = null;
        int ipCount = 4;
        try {
            StringBuffer result = new StringBuffer();
            StringTokenizer ipToken = new StringTokenizer(ipAddress, ".");
            StringTokenizer maskToken = new StringTokenizer(mask, ".");
            if (ipToken.countTokens() == ipCount && maskToken.countTokens() == ipCount) {
                while (ipToken.hasMoreTokens()) {
                    String tempIP = ipToken.nextToken();
                    String tempMask = maskToken.nextToken();
                    int tempNet = Integer.parseInt(tempIP) & Integer.parseInt(tempMask);
                    result.append(tempNet).append('.');
                }
                netAddress = result.substring(0, result.length() - 1);
            }
        }
        catch (RuntimeException e) {
            netAddress = null;
        }
        return netAddress;
    }

    private String mask24ToIp() {
        int mask = 24;
        String part = "";
        StringBuffer buffer = new StringBuffer();
        int x = mask / 8;
        for (int i = 0; i < x; ++i) {
            buffer.append("255.");
        }
        part = part + buffer.toString();
        int sum = 0;
        StringBuffer buf = new StringBuffer();
        part = part + sum + buf.toString();
        return part;
    }

    @Override
    public CloudCleanForm getByIpMaskAndPolicyType(String ipMask, String sp, String policyType) {
        List<CloudClean> cloudCleanList = this.cloudCleanDao.getByIpMaskAndPolicyType(ipMask, sp, policyType);
        CloudCleanForm cloudCleanForm = null;
        if (null != cloudCleanList && !cloudCleanList.isEmpty()) {
            for (CloudClean cc : cloudCleanList) {
                cloudCleanForm = new CloudCleanForm();
                AticUtil.copyProperties((Object)cc, (Object)cloudCleanForm);
            }
        }
        return cloudCleanForm;
    }

    @Override
    public CloudCleanProtectIpForm getProtectIpByIp(String ipMask) {
        List<CloudCleanProtectIp> protectIpList = this.cloudCleanProtectIpDao.getAllProtectIpMask();
        CloudCleanProtectIpForm protectIpForm = null;
        if (!protectIpList.isEmpty()) {
            String[] ipMas = ipMask.split("/");
            for (CloudCleanProtectIp ip : protectIpList) {
                String[] ipRange = IPUtil.getSubnetRange((String)ipMas[0], (int)Integer.parseInt(ipMas[1]));
                String[] srcIpRange = IPUtil.getSubnetRange((String)ip.getProtectIp(), (int)ip.getMask());
                Boolean res = IPUtil4Atic.isInIpRange((String[])srcIpRange, (String[])ipRange);
                if (!res.booleanValue()) continue;
                ip = this.cloudCleanProtectIpDeviceDao.queryProtectIp(ip);
                CloudCleanProtectIpForm form = new CloudCleanProtectIpForm();
                AticUtil.copyProperties((Object)ip, (Object)form);
                List<CloudCleanProtectIpDevice> deviceList = ip.getIpDevs();
                if (!deviceList.isEmpty()) {
                    ArrayList<CloudCleanProtectIpDeviceForm> deviceFormList = new ArrayList<CloudCleanProtectIpDeviceForm>();
                    for (CloudCleanProtectIpDevice device : deviceList) {
                        CloudCleanProtectIpDeviceForm ipDeviceForm = new CloudCleanProtectIpDeviceForm();
                        AticUtil.copyProperties((Object)device, (Object)ipDeviceForm);
                        deviceFormList.add(ipDeviceForm);
                    }
                    form.setIpDevs(deviceFormList);
                }
                protectIpForm = form;
                break;
            }
        }
        protectIpForm = this.handleReInjectDeviceName(protectIpForm);
        return protectIpForm;
    }

    private List<CloudCleanProtectIpForm> handleReInjectDeviceName(List<CloudCleanProtectIpForm> protectIpFormList) {
        List devices = this.aticDeviceService.getAllDevice();
        HashMap<Long, String> devMap = new HashMap<Long, String>();
        for (AticDevice device : devices) {
            devMap.put(device.getMoId(), device.getName());
        }
        for (CloudCleanProtectIpForm form : protectIpFormList) {
            List<CloudCleanProtectIpDeviceForm> forms = form.getIpDevs();
            if (null == forms || forms.isEmpty()) continue;
            StringBuffer deviceName = new StringBuffer();
            for (CloudCleanProtectIpDeviceForm ipDeviceForm : forms) {
                deviceName.append((String)devMap.get(ipDeviceForm.getDevId())).append(",");
            }
            form.setReInjectDeviceName(deviceName.substring(0, deviceName.length() - 1));
        }
        return protectIpFormList;
    }

    private CloudCleanProtectIpForm handleReInjectDeviceName(CloudCleanProtectIpForm protectIpForm) {
        if (null != protectIpForm) {
            List devices = this.aticDeviceService.getAllDevice();
            HashMap<Long, String> devMap = new HashMap<Long, String>();
            for (AticDevice device : devices) {
                devMap.put(device.getMoId(), device.getName());
            }
            List<CloudCleanProtectIpDeviceForm> forms = protectIpForm.getIpDevs();
            if (null != forms && !forms.isEmpty()) {
                StringBuffer deviceName = new StringBuffer();
                for (CloudCleanProtectIpDeviceForm ipDeviceForm : forms) {
                    deviceName.append((String)devMap.get(ipDeviceForm.getDevId())).append(",");
                }
                protectIpForm.setReInjectDeviceName(deviceName.substring(0, deviceName.length() - 1));
            }
        }
        return protectIpForm;
    }

    @Override
    public CloudCleanProtectIpForm getByProtectIpMask(String ipMask) {
        List<CloudCleanProtectIp> protectIpList = this.cloudCleanProtectIpDao.getAllProtectIpMask();
        CloudCleanProtectIpForm protectIpForm = null;
        if (!protectIpList.isEmpty()) {
            String[] ipMas = ipMask.split("/");
            for (CloudCleanProtectIp ip : protectIpList) {
                String[] ipRange = IPUtil.getSubnetRange((String)ipMas[0], (int)Integer.parseInt(ipMas[1]));
                String[] srcIpRange = IPUtil.getSubnetRange((String)ip.getProtectIp(), (int)ip.getMask());
                Boolean res = IPUtil4Atic.isCrossIpRange((String[])srcIpRange, (String[])ipRange);
                if (!res.booleanValue()) continue;
                CloudCleanProtectIpForm form = new CloudCleanProtectIpForm();
                AticUtil.copyProperties((Object)ip, (Object)form);
                List<CloudCleanProtectIpDevice> deviceList = ip.getIpDevs();
                if (!deviceList.isEmpty()) {
                    ArrayList<CloudCleanProtectIpDeviceForm> deviceFormList = new ArrayList<CloudCleanProtectIpDeviceForm>();
                    for (CloudCleanProtectIpDevice device : deviceList) {
                        CloudCleanProtectIpDeviceForm ipDeviceForm = new CloudCleanProtectIpDeviceForm();
                        AticUtil.copyProperties((Object)device, (Object)ipDeviceForm);
                        deviceFormList.add(ipDeviceForm);
                    }
                    form.setIpDevs(deviceFormList);
                }
                protectIpForm = form;
                break;
            }
        }
        return protectIpForm;
    }

    @Override
    public CloudCleanProtectIpForm getIpById(Long id) {
        this.logger.info((Object)("getIpById CloudCleanProtectIp.id = " + id));
        CloudCleanProtectIpForm cloudCleanProtectIpForm = new CloudCleanProtectIpForm();
        List<CloudCleanProtectIp> ipList = this.cloudCleanProtectIpDao.getIpById(id);
        if (!ipList.isEmpty()) {
            CloudCleanProtectIp cloudCleanProtectIp = null;
            cloudCleanProtectIp = this.cloudCleanProtectIpDeviceDao.queryProtectIp(ipList.get(0));
            AticUtil.copyProperties((Object)cloudCleanProtectIp, (Object)cloudCleanProtectIpForm);
            List<CloudCleanProtectIpDevice> deviceList = cloudCleanProtectIp.getIpDevs();
            if (!deviceList.isEmpty()) {
                ArrayList<CloudCleanProtectIpDeviceForm> deviceFormList = new ArrayList<CloudCleanProtectIpDeviceForm>();
                for (CloudCleanProtectIpDevice device : deviceList) {
                    CloudCleanProtectIpDeviceForm ipDeviceForm = new CloudCleanProtectIpDeviceForm();
                    AticUtil.copyProperties((Object)device, (Object)ipDeviceForm);
                    deviceFormList.add(ipDeviceForm);
                }
                cloudCleanProtectIpForm.setIpDevs(deviceFormList);
            }
            cloudCleanProtectIpForm = this.handleReInjectDeviceName(cloudCleanProtectIpForm);
            return cloudCleanProtectIpForm;
        }
        return cloudCleanProtectIpForm;
    }

    @Override
    public Paging queryByPage(Map<String, String> queryMap, int iStart, int iLength) {
        this.logger.info((Object)"queryByPage in the CloudCleanServiceImpl");
        Paging page = this.cloudCleanDao.queryByPage(queryMap, iStart, iLength);
        List cloudCleanInfoList = page.getData();
        ArrayList<CloudCleanForm> cloudCleanFormList = new ArrayList<CloudCleanForm>();
        for (CloudClean ccInfo : cloudCleanInfoList) {
            CloudCleanProtectIpForm protectIpForm = null;
            Long protectIpId = ccInfo.getProtectIpId();
            if (null == protectIpId) {
                protectIpForm = this.getProtectIpByIp(ccInfo.getIpMask());
                if (null != protectIpForm) {
                    ccInfo.setReInjectDeviceName(protectIpForm.getReInjectDeviceName());
                    ccInfo.setProtectIpId(protectIpForm.getId());
                    this.cloudCleanDao.saveOrUpdate(ccInfo);
                }
            } else {
                protectIpForm = this.getIpById(protectIpId);
                if (null == protectIpForm) {
                    protectIpForm = this.getProtectIpByIp(ccInfo.getIpMask());
                    if (null == protectIpForm) {
                        ccInfo.setReInjectDeviceName("--");
                        ccInfo.setProtectIpId(null);
                    } else {
                        ccInfo.setReInjectDeviceName(protectIpForm.getReInjectDeviceName());
                        ccInfo.setProtectIpId(protectIpForm.getId());
                    }
                    this.cloudCleanDao.saveOrUpdate(ccInfo);
                } else {
                    ccInfo.setReInjectDeviceName(protectIpForm.getReInjectDeviceName());
                }
            }
            CloudCleanForm ccf = new CloudCleanForm();
            AticUtil.copyProperties((Object)ccInfo, (Object)ccf);
            cloudCleanFormList.add(ccf);
        }
        page.setData(cloudCleanFormList);
        return page;
    }

    @Override
    public Paging queryIpByPage(Map<String, String> queryMap, int iStart, int iLength) {
        this.logger.info((Object)"queryIpByPage in the CloudCleanServiceImpl");
        Paging page = this.cloudCleanProtectIpDao.queryIpByPage(queryMap, iStart, iLength);
        List<CloudCleanProtectIp> protectIpInfoList = page.getData();
        if (null == protectIpInfoList || protectIpInfoList.isEmpty()) {
            return page;
        }
        protectIpInfoList = this.cloudCleanProtectIpDeviceDao.queryProtectIpList(protectIpInfoList);
        List<CloudCleanProtectIpForm> protectIpFormList = new ArrayList<CloudCleanProtectIpForm>();
        for (CloudCleanProtectIp ip : protectIpInfoList) {
            CloudCleanProtectIpForm ipForm = new CloudCleanProtectIpForm();
            AticUtil.copyProperties((Object)ip, (Object)ipForm);
            List<CloudCleanProtectIpDevice> deviceList = ip.getIpDevs();
            if (!deviceList.isEmpty()) {
                ArrayList<CloudCleanProtectIpDeviceForm> deviceFormList = new ArrayList<CloudCleanProtectIpDeviceForm>();
                for (CloudCleanProtectIpDevice device : deviceList) {
                    CloudCleanProtectIpDeviceForm ipDeviceForm = new CloudCleanProtectIpDeviceForm();
                    AticUtil.copyProperties((Object)device, (Object)ipDeviceForm);
                    deviceFormList.add(ipDeviceForm);
                }
                ipForm.setIpDevs(deviceFormList);
            }
            protectIpFormList.add(ipForm);
        }
        protectIpFormList = this.handleReInjectDeviceName(protectIpFormList);
        page.setData(protectIpFormList);
        return page;
    }

    @Override
    public CloudClean queryCloudClean(String ipMask, String sp, Long deviceId) {
        Iterator<CloudClean> iterator;
        this.logger.info((Object)("queryCloudClean in the CloudCleanServiceImpl:" + ipMask + "," + sp + "," + deviceId));
        List<CloudClean> cloudCleanInfoList = this.cloudCleanDao.queryByIpMaskAndDeviceId(ipMask, sp, deviceId);
        if (null != cloudCleanInfoList && !cloudCleanInfoList.isEmpty() && (iterator = cloudCleanInfoList.iterator()).hasNext()) {
            CloudClean cc = iterator.next();
            return cc;
        }
        return null;
    }

    private void initKIOSwitch() {
        this.isOpenKIO = this.dateTableFileService.isOpenKIO();
        this.isOpenLoopBack300 = this.dateTableFileService.isOpenLoopBack300();
        this.loopBack300DelayTime = this.dateTableFileService.getLoopBack300DelayTime();
    }

    @Override
    public Integer getByStaticPolicy() {
        this.logger.info((Object)"getByStaticPolicy in the CloudCleanServiceImpl");
        return this.cloudCleanDao.getByStaticPolicy();
    }

    @Override
    public Integer getProtectIpNum() {
        this.logger.info((Object)"getProtectIpNum in the CloudCleanServiceImpl");
        return this.cloudCleanProtectIpDao.getProtectIpNum();
    }

    public IDataProtectService getDataProtectService() {
        return this.dataProtectService;
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }

    public CloudCleanThreadDeal getCloudCleanThreadDeal() {
        return this.cloudCleanThreadDeal;
    }

    public void setCloudCleanThreadDeal(CloudCleanThreadDeal cloudCleanThreadDeal) {
        this.cloudCleanThreadDeal = cloudCleanThreadDeal;
    }

    public CloudCleanConfigDevFlowDao getCloudCleanConfigDevDao() {
        return this.cloudCleanConfigDevDao;
    }

    public void setCloudCleanConfigDevDao(CloudCleanConfigDevFlowDao cloudCleanConfigDevDao) {
        this.cloudCleanConfigDevDao = cloudCleanConfigDevDao;
    }

    public ICollectorDeviceService getCollectorDevSer() {
        return this.collectorDevSer;
    }

    public void setCollectorDevSer(ICollectorDeviceService collectorDevSer) {
        this.collectorDevSer = collectorDevSer;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public CloudCleanDao getCloudCleanDao() {
        return this.cloudCleanDao;
    }

    public void setCloudCleanDao(CloudCleanDao cloudCleanDao) {
        this.cloudCleanDao = cloudCleanDao;
    }

    public CloudCleanProtectIpDao getCloudCleanProtectIpDao() {
        return this.cloudCleanProtectIpDao;
    }

    public void setCloudCleanProtectIpDao(CloudCleanProtectIpDao cloudCleanProtectIpDao) {
        this.cloudCleanProtectIpDao = cloudCleanProtectIpDao;
    }

    public CloudCleanConfigDao getConfigDao() {
        return this.configDao;
    }

    public void setConfigDao(CloudCleanConfigDao configDao) {
        this.configDao = configDao;
    }

    public DivertTacticsDao getDivertTacticsDao() {
        return this.divertTacticsDao;
    }

    public void setDivertTacticsDao(DivertTacticsDao divertTacticsDao) {
        this.divertTacticsDao = divertTacticsDao;
    }

    public IDefendGroupService getDefendGroupService() {
        return this.defendGroupService;
    }

    public void setDefendGroupService(IDefendGroupService defendGroupService) {
        this.defendGroupService = defendGroupService;
    }

    public IDivertTacticsService getDivertTacticsService() {
        return this.divertTacticsService;
    }

    public void setDivertTacticsService(IDivertTacticsService divertTacticsService) {
        this.divertTacticsService = divertTacticsService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public CloudCleanProtectIpDeviceDao getCloudCleanProtectIpDeviceDao() {
        return this.cloudCleanProtectIpDeviceDao;
    }

    public void setCloudCleanProtectIpDeviceDao(CloudCleanProtectIpDeviceDao cloudCleanProtectIpDeviceDao) {
        this.cloudCleanProtectIpDeviceDao = cloudCleanProtectIpDeviceDao;
    }

    public CloudCleanAlarmHandler getCloudCleanAlarmHandler() {
        return this.cloudCleanAlarmHandler;
    }

    public void setCloudCleanAlarmHandler(CloudCleanAlarmHandler cloudCleanAlarmHandler) {
        this.cloudCleanAlarmHandler = cloudCleanAlarmHandler;
    }

    public IDateTableFileService getDateTableFileService() {
        return this.dateTableFileService;
    }

    public void setDateTableFileService(IDateTableFileService dateTableFileService) {
        this.dateTableFileService = dateTableFileService;
    }

    public CollectorRMIProxy getCloudCollectorRMIProxy() {
        return this.cloudCollectorRMIProxy;
    }

    public void setCloudCollectorRMIProxy(CollectorRMIProxy cloudCollectorRMIProxy) {
        this.cloudCollectorRMIProxy = cloudCollectorRMIProxy;
    }
}

