/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.cloudclean.service.impl;

import com.hs.atic.cloudclean.form.CloudCleanConfigDevFlowForm;
import com.hs.atic.cloudclean.model.CloudCleanConfigDevFlow;
import com.hs.atic.sdk.cloudclean.service.ICloudCleanConfigService;
import com.hs.atic.sdk.cloudclean.service.IMonitorDeviceFlowService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.init.thread.util.MonitorDevIfTraffic;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MonitorDeviceFlowServiceImpl
implements IMonitorDeviceFlowService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_CLOUDCLEAN);
    private ICloudCleanConfigService iCloudCleanConfigService;
    private MonitorDevIfTraffic trafficMonitor;

    @Override
    public long refreshDevFlowList(List<CloudCleanConfigDevFlowForm> liFlowForms) {
        Map devFlowMap = this.trafficMonitor.getDevFlowMap();
        devFlowMap.clear();
        try {
            if (null != liFlowForms && !liFlowForms.isEmpty()) {
                for (CloudCleanConfigDevFlowForm cloFlowForm : liFlowForms) {
                    this.logger.info((Object)("Single Device Threshold deviceId is : " + cloFlowForm.getDeviceId() + "; device threshold is :" + cloFlowForm.getDevFlowValue()));
                    CloudCleanConfigDevFlow cleanConfigDevFlow = new CloudCleanConfigDevFlow();
                    AticUtil.copyProperties((Object)cloFlowForm, (Object)cleanConfigDevFlow);
                    devFlowMap.put(cloFlowForm.getDeviceId(), cleanConfigDevFlow);
                }
                this.trafficMonitor.setDevFlowMap(devFlowMap);
            } else {
                this.trafficMonitor.setDevFlowMap(new HashMap());
            }
        }
        catch (LegoCheckedException e) {
            return e.getErrorCode();
        }
        catch (Exception e) {
            return 631052L;
        }
        return 631051L;
    }

    public ICloudCleanConfigService getiCloudCleanConfigService() {
        return this.iCloudCleanConfigService;
    }

    public void setiCloudCleanConfigService(ICloudCleanConfigService iCloudCleanConfigServices) {
        this.iCloudCleanConfigService = iCloudCleanConfigServices;
    }

    public MonitorDevIfTraffic getTrafficMonitor() {
        return this.trafficMonitor;
    }

    public void setTrafficMonitor(MonitorDevIfTraffic trafficMonitor) {
        this.trafficMonitor = trafficMonitor;
    }
}

