/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.cloudclean.util;

import com.hs.atic.cloudclean.form.CloudCleanConfigForm;
import com.hs.atic.cloudclean.model.CloudClean;
import com.hs.atic.cloudclean.model.CloudCleanConfigDevFlow;
import com.hs.atic.sdk.bis.form.CloudCleanForm;
import com.hs.atic.sdk.bis.model.AticAlarmObject;
import com.hs.atic.sdk.bis.service.IAlarmService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.parents.servcice.CloudCleanAlarmHandlerService;

public class CloudCleanAlarmHandler
implements CloudCleanAlarmHandlerService {
    public static final int DEFEND_SCPOE_1 = 1;
    public static final int DEFEND_SCPOE_2 = 2;
    public static final int DEFEND_SCPOE_3 = 3;
    public static final int DEFEND_SCPOE_4 = 4;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_CLOUDCLEAN);
    private IAlarmService alarmService;

    public void cloudCleanAbnormalAlarm(CloudCleanConfigDevFlow thresholdFlow) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            long devId = thresholdFlow.getDeviceId();
            String deviceName = thresholdFlow.getDeviceName();
            String deviceIp = thresholdFlow.getDeviceIp();
            Long curDeviceAllFlow = Long.valueOf(thresholdFlow.getCurFlowValue());
            String curDevFlow = String.valueOf(curDeviceAllFlow);
            String devFlow = thresholdFlow.getDevFlowValue();
            String[] alarmParam = new String[]{deviceName, deviceIp, curDevFlow, devFlow};
            alarmObject.setAlarmId("0x0000000803240818");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setMoId(Long.valueOf(devId));
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("cloudCleanAbnormalAlarm error, divertIp:" + deviceIp + ", deviceIp:" + deviceIp), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"cloudCleanAbnormalAlarm error", (Throwable)e);
        }
    }

    public void cloudCleanAbnormalAlarmClear(CloudCleanConfigDevFlow thresholdFlow) {
        try {
            AticAlarmObject alarmObject = new AticAlarmObject();
            long devId = thresholdFlow.getDeviceId();
            String deviceName = thresholdFlow.getDeviceName();
            String deviceIp = thresholdFlow.getDeviceIp();
            Long curDeviceAllFlow = Long.valueOf(thresholdFlow.getCurFlowValue());
            String curDevFlow = String.valueOf(curDeviceAllFlow);
            String devFlow = thresholdFlow.getDevFlowValue();
            String[] alarmParam = new String[]{deviceName, deviceIp, curDevFlow, devFlow};
            alarmObject.setAlarmId("0x0000000803240818");
            alarmObject.setAlarmParam(alarmParam);
            alarmObject.setIsAlarm(Boolean.valueOf(false));
            alarmObject.setMoId(Long.valueOf(devId));
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(deviceIp);
            alarmObject.setAlertTime(System.currentTimeMillis());
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (Exception e) {
                logger.error((Object)("cloudCleanAbnormalAlarmClear error, divertIp=" + deviceIp + ", deviceIp=" + deviceIp), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"cloudCleanAbnormalAlarmClear error", (Throwable)e);
        }
    }

    public void cloudCleanAlarmCancel(CloudClean info, CloudCleanConfigForm form, CloudCleanConfigDevFlow deviceInfo) {
        AticAlarmObject alarmObject = new AticAlarmObject();
        long devId = deviceInfo.getDeviceId();
        String deviceName = deviceInfo.getDeviceName();
        String deviceIp = deviceInfo.getDeviceIp();
        String sp = "";
        String scopeOrAction = "";
        sp = "atic.bis.cloudclean.service.provider.hw";
        scopeOrAction = info.getDefendAction();
        if ("clean".equals(scopeOrAction)) {
            scopeOrAction = "atic.bis.cloud.clean.defend.clean";
        } else if ("block".equals(scopeOrAction)) {
            scopeOrAction = "atic.bis.cloud.clean.defend.block";
        }
        String status = "atic.bis.cloudclean.ipStatus.attack";
        String ipFlowValue = form.getIpFlowValue();
        String ipFlowTopn = form.getIpFlowTopn();
        String ipMask = info.getIpMask();
        String reInject = info.getReInjectDeviceName();
        String[] alarmParam = new String[]{deviceName, ipMask, sp, status, ipFlowValue, ipFlowTopn, scopeOrAction, reInject};
        alarmObject.setAlarmId("0x0000000803240833");
        alarmObject.setAlarmParam(alarmParam);
        alarmObject.setIsAlarm(Boolean.valueOf(true));
        alarmObject.setMoId(Long.valueOf(devId));
        alarmObject.setMoName(deviceName);
        alarmObject.setMoIp(ipMask);
        alarmObject.setAlertTime(System.currentTimeMillis());
        try {
            this.alarmService.callAlarmQueue(alarmObject);
        }
        catch (Exception e) {
            logger.error((Object)("cloudCleanAlarmEnd error, divertIp=" + deviceIp + ", ipMask is " + ipMask), (Throwable)e);
        }
    }

    public void staticRouterCreate(CloudCleanForm cloudCleanForm, AticDevice reInjectDevice) {
        AticAlarmObject alarmObject = new AticAlarmObject();
        Long devId = cloudCleanForm.getDeviceId();
        String deviceName = cloudCleanForm.getDeviceName();
        String ipMask = cloudCleanForm.getIpMask();
        String reinject = reInjectDevice.getName();
        String[] alarmParam = new String[]{reinject, ipMask};
        alarmObject.setAlarmId("0x0000000803240866");
        alarmObject.setAlarmParam(alarmParam);
        alarmObject.setIsAlarm(Boolean.valueOf(true));
        if ("--".equals(deviceName)) {
            alarmObject.setMoId(Long.valueOf(1L));
            alarmObject.setMoName("system");
        } else {
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
        }
        alarmObject.setMoIp(ipMask);
        alarmObject.setAlertTime(System.currentTimeMillis());
        try {
            this.alarmService.callAlarmQueue(alarmObject);
        }
        catch (Exception e) {
            logger.error((Object)("cloudCleanAlarmEnd error, deviceName=" + deviceName), (Throwable)e);
        }
    }

    public void staticRouterDelete(CloudCleanForm cloudCleanForm, AticDevice reInjectDevice) {
        AticAlarmObject alarmObject = new AticAlarmObject();
        Long devId = cloudCleanForm.getDeviceId();
        String deviceName = cloudCleanForm.getDeviceName();
        String ipMask = cloudCleanForm.getIpMask();
        String reinject = reInjectDevice.getName();
        String[] alarmParam = new String[]{reinject, ipMask};
        alarmObject.setAlarmId("0x0000000803240855");
        alarmObject.setAlarmParam(alarmParam);
        alarmObject.setIsAlarm(Boolean.valueOf(true));
        if ("--".equals(deviceName)) {
            alarmObject.setMoId(Long.valueOf(1L));
            alarmObject.setMoName("system");
        } else {
            alarmObject.setMoId(devId);
            alarmObject.setMoName(deviceName);
        }
        alarmObject.setMoIp(ipMask);
        alarmObject.setAlertTime(System.currentTimeMillis());
        try {
            this.alarmService.callAlarmQueue(alarmObject);
        }
        catch (Exception e) {
            logger.error((Object)("cloudCleanAlarmEnd error, deviceName=" + deviceName), (Throwable)e);
        }
    }

    public void cloudCleanAlarmStart(CloudCleanConfigDevFlow deviceInfo, CloudCleanConfigForm form, CloudClean info) {
        AticAlarmObject alarmObject = new AticAlarmObject();
        long devId = deviceInfo.getDeviceId();
        String deviceName = deviceInfo.getDeviceName();
        String deviceIp = deviceInfo.getDeviceIp();
        String serviceProvider = form.getServiceProvider();
        String sp = "";
        String scopeOrAction = "";
        if ("CTCC".equalsIgnoreCase(serviceProvider)) {
            sp = "atic.bis.cloudclean.service.provider.ctcc";
            int defendScpoe = info.getDefendScope();
            if (1 == defendScpoe) {
                scopeOrAction = "atic.bis.cloudclean.default.policy.all";
            } else if (2 == defendScpoe) {
                scopeOrAction = "atic.bis.cloudclean.default.policy.other.domestic.provider";
            } else if (3 == defendScpoe) {
                scopeOrAction = "atic.bis.cloudclean.default.policy.other.foreign.provider";
            } else if (4 == defendScpoe) {
                scopeOrAction = "atic.bis.cloudclean.default.policy.other";
            }
        } else {
            sp = "atic.bis.cloudclean.service.provider.hw";
            scopeOrAction = info.getDefendAction();
            if ("clean".equals(scopeOrAction)) {
                scopeOrAction = "atic.bis.cloud.clean.defend.clean";
            } else if ("block".equals(scopeOrAction)) {
                scopeOrAction = "atic.bis.cloud.clean.defend.block";
            }
        }
        String ipStatus = form.getIpStatus();
        String ipFlowValue = form.getIpFlowValue();
        String ipFlowTopn = form.getIpFlowTopn();
        String ipMask = info.getIpMask();
        String unblockTime = form.getUnblockTime();
        String[] alarmParam = new String[]{deviceName, ipMask, sp, ipStatus, ipFlowValue, ipFlowTopn, scopeOrAction, unblockTime};
        alarmObject.setAlarmId("0x0000000803240819");
        alarmObject.setAlarmParam(alarmParam);
        alarmObject.setIsAlarm(Boolean.valueOf(true));
        alarmObject.setMoId(Long.valueOf(devId));
        alarmObject.setMoName(deviceName);
        alarmObject.setMoIp(ipMask);
        alarmObject.setAlertTime(System.currentTimeMillis());
        try {
            this.alarmService.callAlarmQueue(alarmObject);
        }
        catch (Exception e) {
            logger.error((Object)("cloudCleanAlarmStart error, divertIp=" + deviceIp), (Throwable)e);
        }
    }

    public void cloudCleanAlarmEnd(CloudClean info, CloudCleanConfigForm form, CloudCleanConfigDevFlow deviceInfo) {
        AticAlarmObject alarmObject = new AticAlarmObject();
        long devId = deviceInfo.getDeviceId();
        String deviceName = deviceInfo.getDeviceName();
        String deviceIp = deviceInfo.getDeviceIp();
        String serviceProvider = form.getServiceProvider();
        String sp = "";
        String scopeOrAction = "";
        if ("CTCC".equalsIgnoreCase(serviceProvider)) {
            sp = "atic.bis.cloudclean.service.provider.ctcc";
            int defendScpoe = info.getDefendScope();
            if (1 == defendScpoe) {
                scopeOrAction = "atic.bis.cloudclean.default.policy.all";
            } else if (2 == defendScpoe) {
                scopeOrAction = "atic.bis.cloudclean.default.policy.other.domestic.provider";
            } else if (3 == defendScpoe) {
                scopeOrAction = "atic.bis.cloudclean.default.policy.other.foreign.provider";
            } else if (4 == defendScpoe) {
                scopeOrAction = "atic.bis.cloudclean.default.policy.other";
            }
        } else {
            sp = "atic.bis.cloudclean.service.provider.hw";
            scopeOrAction = info.getDefendAction();
            if ("clean".equals(scopeOrAction)) {
                scopeOrAction = "atic.bis.cloud.clean.defend.clean";
            } else if ("block".equals(scopeOrAction)) {
                scopeOrAction = "atic.bis.cloud.clean.defend.block";
            }
        }
        String status = form.getIpStatus();
        String ipFlowValue = form.getIpFlowValue();
        String ipFlowTopn = form.getIpFlowTopn();
        String ipMask = info.getIpMask();
        String unblockTime = form.getUnblockTime();
        String[] alarmParam = new String[]{deviceName, ipMask, sp, status, ipFlowValue, ipFlowTopn, scopeOrAction, unblockTime};
        alarmObject.setAlarmId("0x0000000803240819");
        alarmObject.setAlarmParam(alarmParam);
        alarmObject.setIsAlarm(Boolean.valueOf(false));
        alarmObject.setMoId(Long.valueOf(devId));
        alarmObject.setMoName(deviceName);
        alarmObject.setMoIp(ipMask);
        alarmObject.setAlertTime(System.currentTimeMillis());
        try {
            this.alarmService.callAlarmQueue(alarmObject);
        }
        catch (Exception e) {
            logger.error((Object)("cloudCleanAlarmEnd error, divertIp=" + deviceIp), (Throwable)e);
        }
    }

    public void cloudCleanAlarmStartFailed(CloudCleanConfigDevFlow deviceInfo, CloudCleanConfigForm form, CloudClean info) {
        AticAlarmObject alarmObject = new AticAlarmObject();
        long devId = deviceInfo.getDeviceId();
        String deviceName = deviceInfo.getDeviceName();
        String deviceIp = deviceInfo.getDeviceIp();
        String serviceProvider = form.getServiceProvider();
        String sp = "";
        String scopeOrAction = "";
        if ("CTCC".equalsIgnoreCase(serviceProvider)) {
            sp = "atic.bis.cloudclean.service.provider.ctcc";
            int defendScpoe = info.getDefendScope();
            if (1 == defendScpoe) {
                scopeOrAction = "atic.bis.cloudclean.default.policy.all";
            } else if (2 == defendScpoe) {
                scopeOrAction = "atic.bis.cloudclean.default.policy.other.domestic.provider";
            } else if (3 == defendScpoe) {
                scopeOrAction = "atic.bis.cloudclean.default.policy.other.foreign.provider";
            } else if (4 == defendScpoe) {
                scopeOrAction = "atic.bis.cloudclean.default.policy.other";
            }
        } else {
            sp = "atic.bis.cloudclean.service.provider.hw";
            scopeOrAction = info.getDefendAction();
            if ("clean".equals(scopeOrAction)) {
                scopeOrAction = "atic.bis.cloud.clean.defend.clean";
            } else if ("block".equals(scopeOrAction)) {
                scopeOrAction = "atic.bis.cloud.clean.defend.block";
            }
        }
        String status = form.getIpStatus();
        String ipFlowValue = form.getIpFlowValue();
        String ipFlowTopn = form.getIpFlowTopn();
        String ipMask = info.getIpMask();
        String unblockTime = form.getUnblockTime();
        String[] alarmParam = new String[]{deviceName, ipMask, sp, status, ipFlowValue, ipFlowTopn, scopeOrAction, unblockTime};
        alarmObject.setAlarmId("0x0000000803240820");
        alarmObject.setAlarmParam(alarmParam);
        alarmObject.setIsAlarm(Boolean.valueOf(true));
        alarmObject.setMoId(Long.valueOf(devId));
        alarmObject.setMoName(deviceName);
        alarmObject.setMoIp(ipMask);
        alarmObject.setAlertTime(System.currentTimeMillis());
        try {
            this.alarmService.callAlarmQueue(alarmObject);
        }
        catch (Exception e) {
            logger.error((Object)("cloudCleanAlarmStart failed, divertIp=" + deviceIp), (Throwable)e);
        }
    }

    public IAlarmService getAlarmService() {
        return this.alarmService;
    }

    public void setAlarmService(IAlarmService alarmService) {
        this.alarmService = alarmService;
    }
}

