/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.cloudclean.util;

import com.hs.atic.cloudclean.util.CloudCleanThreadDeal;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class CloudCleanThread
implements InitializingBean,
Runnable {
    private static final long TIME = 300000L;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_CLOUDCLEAN);
    private boolean start = false;
    private CloudCleanThreadDeal cloudCleanThreadDeal;

    @Override
    public void run() {
        try {
            this.cloudCleanThreadDeal.getCloudCleanFromDataBase();
        }
        catch (Exception e) {
            this.logger.error((Object)"get cloud clean from database error", (Throwable)e);
        }
        while (this.start) {
            Long startTime = System.currentTimeMillis();
            try {
                this.cloudCleanThreadDeal.listenAndDeletePolicy();
            }
            catch (Exception e) {
                this.logger.error((Object)"cloud clean thread error", (Throwable)e);
            }
            Long endTime = System.currentTimeMillis();
            Long processTime = endTime - startTime;
            try {
                if (processTime > 300000L) {
                    Thread.sleep(1000L);
                    continue;
                }
                Thread.sleep(300000L - processTime);
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"sleep get error.", (Throwable)e);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        Thread thread = new Thread(new CloudCleanThread());
        thread.setName("cloudCleanThread");
        this.setStart(true);
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean isStart) {
        this.start = isStart;
    }

    public CloudCleanThreadDeal getCloudCleanThreadDeal() {
        return this.cloudCleanThreadDeal;
    }

    public void setCloudCleanThreadDeal(CloudCleanThreadDeal cloudCleanThreadDeal) {
        this.cloudCleanThreadDeal = cloudCleanThreadDeal;
    }
}

