/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.cloudclean.util;

import com.hs.atic.cloudclean.form.CloudCleanConfigForm;
import com.hs.atic.cloudclean.form.CloudCleanProtectIpDeviceForm;
import com.hs.atic.cloudclean.form.CloudCleanProtectIpForm;
import com.hs.atic.cloudclean.model.CloudClean;
import com.hs.atic.cloudclean.model.CloudCleanConfigDevFlow;
import com.hs.atic.cloudclean.util.CloudCleanAlarmHandler;
import com.hs.atic.cloudclean.util.CloudCleanUtil;
import com.hs.atic.sdk.bis.form.CloudCleanForm;
import com.hs.atic.sdk.bis.service.IDateTableFileService;
import com.hs.atic.sdk.cloudclean.service.ICloudCleanConfigService;
import com.hs.atic.sdk.cloudclean.service.ICloudCleanService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CloudCleanThreadDeal {
    public static final String CLOUD_CLEAN_STATUS_STOP = "stop";
    public static final int STOP_MAX = 3;
    public static final String CLOUD_CLEAN_STATUS_PENDING = "pending";
    public static final int PENDING_MAX = 6;
    public static final String CLOUD_CLEAN_STATUS_ONGOING = "ongoing";
    private static final int SUCCESS = 1;
    private static final int FAIL = 0;
    private static Map<String, Integer> pendingMap = new HashMap<String, Integer>();
    private static Map<String, Integer> stopMap = new HashMap<String, Integer>();
    private static CloudCleanThreadDeal cloudCleanTDeal = null;
    private volatile CloudCleanConfigForm cloudCleanConfigForm = null;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_CLOUDCLEAN);
    private ICloudCleanService cloudCleanService;
    private IAticDeviceService aticDeviceService;
    private ICloudCleanConfigService cloudCleanConfigService;
    private List<CloudClean> list;
    private List<CloudClean> delayCancelList = new ArrayList<CloudClean>();
    private Map<CloudClean, List<AticDevice>> create200SuccessMap = new ConcurrentHashMap<CloudClean, List<AticDevice>>();
    private CloudCleanConfigDevFlow cloudCleanConfigDevFlow;
    private CloudCleanAlarmHandler cloudCleanAlarmHandler;
    private IDateTableFileService dateTableFileService;
    private boolean isChangeFlowValue;

    public static CloudCleanThreadDeal getCloudCleanThreadDeal() {
        return cloudCleanTDeal;
    }

    public static void setCloudCleanThreadDeal(CloudCleanThreadDeal cloudCleanThreadDeal) {
        cloudCleanTDeal = cloudCleanThreadDeal;
    }

    public void getCloudCleanFromDataBase() {
        this.list = this.cloudCleanService.queryNotStatic();
    }

    public void listenAndDeletePolicy() {
        this.logger.info((Object)"cloud clean:listenAndDeletePolicy");
        this.cloudCleanConfigForm = this.cloudCleanConfigService.findCloudCleanConfig();
        List<CloudClean> deleteList = this.getDeleteList();
        if (!deleteList.isEmpty()) {
            String delayTime = this.cloudCleanConfigForm.getUnblockTime();
            if (Integer.parseInt(delayTime) == 0) {
                this.cancelCloudCleanList(deleteList);
            } else {
                this.process4DelayCancel(deleteList);
            }
            this.list.removeAll(deleteList);
        } else {
            this.logger.info((Object)" cloud clean :deleteList is empty");
        }
    }

    private List<CloudClean> getDeleteList() {
        this.logger.info((Object)("start to get DELETE-LIST from LIST, the size of LIST is " + this.list.size()));
        ArrayList<CloudClean> deleteList = new ArrayList<CloudClean>();
        if (null == this.cloudCleanConfigForm) {
            this.cloudCleanConfigForm = this.cloudCleanConfigService.findCloudCleanConfig();
        }
        if (null == this.cloudCleanConfigForm) {
            this.logger.error((Object)"can't not get cloudCleanConfigForm");
            return deleteList;
        }
        Boolean needDelete = false;
        for (CloudClean form : this.list) {
            if (null == form.getStatus()) {
                this.logger.info((Object)(" cloud clean : form.getStatus() is null, ip is " + form.getIpMask()));
                continue;
            }
            if ("static".equals(form.getPolicyType())) {
                this.logger.info((Object)(" cloud clean : form.getStatus() is static, ip is " + form.getIpMask()));
                continue;
            }
            if ("enable".equals(form.getStatus())) {
                String cloudCleanStatus = null;
                cloudCleanStatus = this.getStatus(form, this.cloudCleanConfigForm);
                needDelete = this.checkStatus(form.getEventId(), cloudCleanStatus);
            }
            if (!needDelete.booleanValue()) continue;
            deleteList.add(form);
        }
        if (!deleteList.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (CloudClean cloudClean : deleteList) {
                sb.append(cloudClean.getIpMask()).append(", ");
            }
            this.logger.info((Object)("get DELETE-LIST from LIST end, the size of DELETE-LIST is " + deleteList.size() + " and the content of DELETE-LIST is " + sb.toString()));
        } else {
            this.logger.info((Object)"get DELETE-LIST from LIST end, but the DELETE-LIST is empty");
        }
        return deleteList;
    }

    private String getStatus(CloudClean cloudClean, CloudCleanConfigForm config) {
        String status = null;
        try {
            status = CloudCleanUtil.getInstance().getCloudCleanStatus4HW(config.getUrl(), new StringBuffer(config.getPublicKey()), new StringBuffer(config.getPrivateKey()), cloudClean.getEventId());
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("get status error for " + cloudClean.getIpMask()), (Throwable)e);
        }
        return status;
    }

    private Boolean checkStatus(String eventId, String cloudCleanStatus) {
        if (CLOUD_CLEAN_STATUS_STOP.equals(cloudCleanStatus)) {
            Integer count = stopMap.get(eventId);
            this.logger.info((Object)("the status for " + eventId + " is " + cloudCleanStatus + " and the num is " + count));
            if (null == count) {
                pendingMap.put(eventId, 0);
                stopMap.put(eventId, 1);
            } else {
                if (count == 2) {
                    pendingMap.remove(eventId);
                    stopMap.remove(eventId);
                    return true;
                }
                if (count < 2) {
                    pendingMap.put(eventId, 0);
                    stopMap.put(eventId, stopMap.get(eventId) + 1);
                }
            }
        } else if (CLOUD_CLEAN_STATUS_PENDING.equals(cloudCleanStatus)) {
            Integer count = pendingMap.get(eventId);
            this.logger.info((Object)("the status for " + eventId + " is " + cloudCleanStatus + " and the num is " + count));
            if (null == count) {
                pendingMap.put(eventId, 1);
                stopMap.put(eventId, 0);
            } else {
                if (count == 5) {
                    pendingMap.remove(eventId);
                    stopMap.remove(eventId);
                    return true;
                }
                if (count < 5) {
                    stopMap.put(eventId, 0);
                    pendingMap.put(eventId, pendingMap.get(eventId) + 1);
                }
            }
        } else {
            this.logger.info((Object)("the status for " + eventId + " is " + cloudCleanStatus));
            pendingMap.put(eventId, 0);
            stopMap.put(eventId, 0);
        }
        return false;
    }

    private void cancelCloudCleanList(List<CloudClean> deleteList) {
        this.logger.info((Object)("start cancel cloud clean list when delay-time is 0, the size of DELETE-LIST is " + deleteList.size()));
        if (null == this.cloudCleanConfigService) {
            this.cloudCleanConfigService = (ICloudCleanConfigService)ServiceContext.getInstance().getService("cloudCleanConfigService", ICloudCleanConfigService.class);
        }
        if (null == this.cloudCleanConfigForm) {
            this.cloudCleanConfigForm = this.cloudCleanConfigService.findCloudCleanConfig();
        }
        ArrayList<CloudClean> successList = new ArrayList<CloudClean>();
        for (CloudClean info : deleteList) {
            this.cancelSingleCloudClean(info, successList);
        }
        this.cloudCleanService.deteleByInfo(successList);
        StringBuffer sb = new StringBuffer();
        for (CloudClean ccdel : successList) {
            sb.append(ccdel.getIpMask()).append(", ");
            String[] detailParas = new String[]{ccdel.getIpMask()};
            this.writeSysLog("atic.bis.cloud.clean.operation.delete", ccdel.getIpMask(), "atic.bis.cloudclean.delete.policy.success.oplog.autocreate", detailParas, 1);
        }
        this.logger.info((Object)("cancel cloud clean list end when delay-time is 0, the size of SUCCESS-LIST is " + successList.size() + " and the content of SUCCESS-LIST is " + sb.toString()));
    }

    private void cancelSingleCloudClean(CloudClean info, List<CloudClean> successList) {
        this.logger.info((Object)("cancel single cloud clean start for " + info.getIpMask()));
        if (null == this.cloudCleanService) {
            this.cloudCleanService = (ICloudCleanService)ServiceContext.getInstance().getService("cloudCleanService", ICloudCleanService.class);
        }
        if (null == this.aticDeviceService) {
            this.aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        }
        if (AticUtil.isNull((String)info.getStatus())) {
            this.logger.info((Object)("cloudClean status for " + info.getIpMask() + " is null"));
        } else if ("enable".equals(info.getStatus())) {
            try {
                CloudCleanForm form = new CloudCleanForm();
                AticUtil.copyProperties((Object)info, (Object)form);
                boolean isOpenLoopBack300 = this.dateTableFileService.isOpenLoopBack300();
                int loopBack300DelayTime = this.dateTableFileService.getLoopBack300DelayTime();
                if (isOpenLoopBack300 && loopBack300DelayTime == 0) {
                    this.cloudCleanService.undoDeployDivert300(form);
                }
                this.closeCloudClean(info, this.cloudCleanConfigForm);
                Boolean result = false;
                Long protectIpId = info.getProtectIpId();
                CloudCleanProtectIpForm protectIpForm = this.cloudCleanService.getIpById(protectIpId);
                List<CloudCleanProtectIpDeviceForm> forms = protectIpForm.getIpDevs();
                for (CloudCleanProtectIpDeviceForm ipDevform : forms) {
                    AticDevice reInjectDevice = null;
                    if (null == ipDevform) continue;
                    reInjectDevice = this.aticDeviceService.getDeviceByMoid(ipDevform.getDevId().longValue());
                    Boolean res = this.cloudCleanService.undoDeployDivert(form, reInjectDevice, "LoopBack100");
                    String[] detailParas = new String[]{form.getIpMask(), "LoopBack100", reInjectDevice.getName()};
                    if (!res.booleanValue()) {
                        this.writeSysLog("atic.bis.cloud.clean.operation.undoDeploy", form.getIpMask(), "atic.bis.cloudclean.disable.policy.failed.oplog.undoDeployDivert", detailParas, 0);
                        continue;
                    }
                    result = true;
                    this.writeSysLog("atic.bis.cloud.clean.operation.undoDeploy", form.getIpMask(), "atic.bis.cloudclean.disable.policy.success.oplog.undoDeployDivert", detailParas, 1);
                }
                if (result.booleanValue()) {
                    String delayTime;
                    successList.add(info);
                    if (null == this.cloudCleanConfigForm) {
                        this.cloudCleanConfigForm = this.cloudCleanConfigService.findCloudCleanConfig();
                    }
                    if (Integer.parseInt(delayTime = this.cloudCleanConfigForm.getUnblockTime()) == 0) {
                        this.logger.info((Object)("cancel single cloud clean success for " + info.getIpMask()));
                        String[] detailParas = new String[]{form.getIpMask()};
                        this.writeSysLog("atic.bis.cloud.clean.operation.disable", form.getIpMask(), "atic.bis.cloudclean.disable.policy.success.oplog.autocreate", detailParas, 1);
                        this.cloudCleanConfigDevFlow = this.cloudCleanConfigService.queryDevFlowById(String.valueOf(info.getDeviceId()));
                        this.logger.info((Object)"cloud clean close, alarm recovery start");
                        if (null != this.cloudCleanConfigDevFlow) {
                            this.cloudCleanAlarmHandler.cloudCleanAlarmEnd(info, this.cloudCleanConfigForm, this.cloudCleanConfigDevFlow);
                        }
                        this.logger.info((Object)"cloud clean close, alarm recovery end");
                    }
                } else {
                    this.logger.error((Object)("cancel single cloud clean failed for " + info.getIpMask() + ", because undo LoopBack100 failed on all reInjectDevices."));
                    String[] detailParas = new String[]{form.getIpMask()};
                    this.writeSysLog("atic.bis.cloud.clean.operation.disable", form.getIpMask(), "atic.bis.cloudclean.disable.policy.failed.oplog.autocreate", detailParas, 0);
                    if (null == this.cloudCleanConfigForm) {
                        this.cloudCleanConfigForm = this.cloudCleanConfigService.findCloudCleanConfig();
                    }
                    this.cloudCleanConfigDevFlow = this.cloudCleanConfigService.queryDevFlowById(String.valueOf(info.getDeviceId()));
                    this.cloudCleanAlarmHandler.cloudCleanAlarmCancel(info, this.cloudCleanConfigForm, this.cloudCleanConfigDevFlow);
                }
            }
            catch (RuntimeException e) {
                String[] detailParas = new String[]{info.getIpMask()};
                this.writeSysLog("atic.bis.cloud.clean.operation.disable", info.getIpMask(), "atic.bis.cloudclean.disable.policy.failed.oplog.autocreate", detailParas, 0);
                this.logger.error((Object)("cancel single cloud clean failed for " + info.getIpMask() + ", because close cloud clean failed"));
                if (null == this.cloudCleanConfigForm) {
                    this.cloudCleanConfigForm = this.cloudCleanConfigService.findCloudCleanConfig();
                }
                this.cloudCleanConfigDevFlow = this.cloudCleanConfigService.queryDevFlowById(String.valueOf(info.getDeviceId()));
                this.cloudCleanAlarmHandler.cloudCleanAlarmCancel(info, this.cloudCleanConfigForm, this.cloudCleanConfigDevFlow);
            }
        }
    }

    private void process4DelayCancel(List<CloudClean> deleteList) {
        this.logger.info((Object)("start to get CANCEL-DELAY-LIST from DELETE-LIST when delay-time is not 0, the size of DELETE-LIST is " + deleteList.size()));
        ArrayList<CloudClean> tempList = new ArrayList<CloudClean>();
        if (null == this.cloudCleanService) {
            this.cloudCleanService = (ICloudCleanService)ServiceContext.getInstance().getService("", ICloudCleanService.class);
        }
        if (null == this.aticDeviceService) {
            this.aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        }
        for (CloudClean info : deleteList) {
            CloudCleanForm form = new CloudCleanForm();
            AticUtil.copyProperties((Object)info, (Object)form);
            Boolean result = false;
            Long protectIpId = info.getProtectIpId();
            CloudCleanProtectIpForm protectIpForm = this.cloudCleanService.getIpById(protectIpId);
            List<CloudCleanProtectIpDeviceForm> forms = protectIpForm.getIpDevs();
            ArrayList<AticDevice> create200SuccessList = new ArrayList<AticDevice>();
            for (CloudCleanProtectIpDeviceForm ipDevform : forms) {
                AticDevice reInjectDevice = null;
                if (null == ipDevform) continue;
                reInjectDevice = this.aticDeviceService.getDeviceByMoid(ipDevform.getDevId().longValue());
                Boolean res = this.cloudCleanService.deployDivert(form, reInjectDevice, "LoopBack200");
                String[] detailParas = new String[]{form.getIpMask(), "LoopBack200", reInjectDevice.getName()};
                if (!res.booleanValue()) {
                    this.writeSysLog("atic.bis.cloud.clean.operation.deploy", form.getIpMask(), "atic.bis.cloudclean.disable.policy.failed.oplog.deployDivert", detailParas, 0);
                    continue;
                }
                result = true;
                create200SuccessList.add(reInjectDevice);
                this.writeSysLog("atic.bis.cloud.clean.operation.deploy", form.getIpMask(), "atic.bis.cloudclean.disable.policy.success.oplog.deployDivert", detailParas, 1);
            }
            if (result.booleanValue()) {
                boolean isOpenLoopBack300 = this.dateTableFileService.isOpenLoopBack300();
                int loopBack300DelayTime = this.dateTableFileService.getLoopBack300DelayTime();
                if (isOpenLoopBack300 && loopBack300DelayTime == 0) {
                    this.cloudCleanService.undoDeployDivert300(form);
                }
                long currentTime = System.currentTimeMillis();
                info.setUnblockTime(String.valueOf(currentTime));
                this.cloudCleanService.updateCloudClean(form);
                tempList.add(info);
                this.create200SuccessMap.put(info, create200SuccessList);
                continue;
            }
            this.logger.error((Object)("cancel single cloud clean failed for " + info.getIpMask() + ", because undo LoopBack200 failed on all reInjectDevices."));
            String[] detailParas = new String[]{form.getIpMask()};
            this.writeSysLog("atic.bis.cloud.clean.operation.disable", form.getIpMask(), "atic.bis.cloudclean.disable.policy.failed.oplog.autocreate", detailParas, 0);
            if (null == this.cloudCleanConfigForm) {
                this.cloudCleanConfigForm = this.cloudCleanConfigService.findCloudCleanConfig();
            }
            this.cloudCleanConfigDevFlow = this.cloudCleanConfigService.queryDevFlowById(String.valueOf(info.getDeviceId()));
            this.cloudCleanAlarmHandler.cloudCleanAlarmCancel(info, this.cloudCleanConfigForm, this.cloudCleanConfigDevFlow);
        }
        if (!tempList.isEmpty()) {
            this.updateDelayList(tempList);
        } else {
            this.logger.info((Object)"skip update CANCEL-DELAY-LIST, because the tempList is empty.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDelayList(List<CloudClean> tempList) {
        this.logger.info((Object)"start update CANCEL-DELAY-LIST");
        List<CloudClean> list = this.delayCancelList;
        synchronized (list) {
            this.delayCancelList.addAll(tempList);
            if (!this.delayCancelList.isEmpty()) {
                StringBuffer sb = new StringBuffer();
                for (CloudClean cloudClean : this.delayCancelList) {
                    sb.append(cloudClean.getIpMask()).append(", ");
                }
                this.logger.info((Object)("after update, the size of CANCEL-DELAY-LIST is " + this.delayCancelList.size() + " and the content of CANCEL-DELAY-LIST is " + sb.toString()));
            } else {
                this.logger.info((Object)"after update, the size of CANCEL-DELAY-LIST is 0");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitorCancelDelay() {
        if (null == this.cloudCleanConfigService) {
            this.cloudCleanConfigService = (ICloudCleanConfigService)ServiceContext.getInstance().getService("cloudCleanConfigService", ICloudCleanConfigService.class);
        }
        this.cloudCleanConfigForm = this.cloudCleanConfigService.findCloudCleanConfig();
        if (null == this.cloudCleanConfigForm) {
            this.logger.error((Object)"cloudCleanConfigForm is null");
            return;
        }
        ArrayList<CloudClean> successList = new ArrayList<CloudClean>();
        ArrayList<CloudClean> processedList = new ArrayList<CloudClean>();
        String delayTime = this.cloudCleanConfigForm.getUnblockTime();
        long currentTime = System.currentTimeMillis();
        List<CloudClean> list = this.delayCancelList;
        synchronized (list) {
            String[] detailParas;
            this.logger.info((Object)("monitor cancel delay cloudclean task, the current time is " + currentTime + ", and the delay time is " + delayTime + ", and the size of DELAY-CANCEL-LIST is " + this.delayCancelList.size()));
            for (CloudClean info : this.delayCancelList) {
                String[] detailParas2;
                String[] detailParas3;
                Boolean res;
                this.logger.info((Object)("the delay start time for " + info.getIpMask() + " is " + info.getUnblockTime()));
                if (currentTime - Long.parseLong(info.getUnblockTime()) <= Long.parseLong(delayTime) * 1000L) continue;
                processedList.add(info);
                try {
                    this.closeCloudClean(info, this.cloudCleanConfigForm);
                }
                catch (RuntimeException e) {
                    this.create200SuccessMap.remove(info);
                    detailParas = new String[]{info.getIpMask()};
                    this.writeSysLog("atic.bis.cloud.clean.operation.disable", info.getIpMask(), "atic.bis.cloudclean.disable.policy.failed.oplog.autocreate", detailParas, 0);
                    this.logger.error((Object)("cancel single cloud clean failed for " + info.getIpMask() + ", because close cloud clean failed"));
                    if (null == this.cloudCleanConfigForm) {
                        this.cloudCleanConfigForm = this.cloudCleanConfigService.findCloudCleanConfig();
                    }
                    this.cloudCleanConfigDevFlow = this.cloudCleanConfigService.queryDevFlowById(String.valueOf(info.getDeviceId()));
                    this.cloudCleanAlarmHandler.cloudCleanAlarmCancel(info, this.cloudCleanConfigForm, this.cloudCleanConfigDevFlow);
                    continue;
                }
                ArrayList<AticDevice> cancel100SuccessList = new ArrayList<AticDevice>();
                List<AticDevice> create200SuccessList = this.create200SuccessMap.get(info);
                CloudCleanForm form = new CloudCleanForm();
                AticUtil.copyProperties((Object)info, (Object)form);
                Boolean result = false;
                for (AticDevice reInjectDevice : create200SuccessList) {
                    res = this.cloudCleanService.undoDeployDivert(form, reInjectDevice, "LoopBack100");
                    detailParas3 = new String[]{form.getIpMask(), "LoopBack100", reInjectDevice.getName()};
                    if (!res.booleanValue()) {
                        this.writeSysLog("atic.bis.cloud.clean.operation.undoDeploy", form.getIpMask(), "atic.bis.cloudclean.disable.policy.failed.oplog.undoDeployDivert", detailParas3, 0);
                        continue;
                    }
                    result = true;
                    cancel100SuccessList.add(reInjectDevice);
                    this.writeSysLog("atic.bis.cloud.clean.operation.undoDeploy", form.getIpMask(), "atic.bis.cloudclean.disable.policy.success.oplog.undoDeployDivert", detailParas3, 1);
                }
                this.create200SuccessMap.remove(info);
                if (!result.booleanValue()) {
                    this.logger.error((Object)("cancel single cloud clean failed for " + info.getIpMask() + ", because undo LoopBack100 failed on all reInjectDevices."));
                    detailParas2 = new String[]{form.getIpMask()};
                    this.writeSysLog("atic.bis.cloud.clean.operation.disable", form.getIpMask(), "atic.bis.cloudclean.disable.policy.failed.oplog.autocreate", detailParas2, 0);
                    if (null == this.cloudCleanConfigForm) {
                        this.cloudCleanConfigForm = this.cloudCleanConfigService.findCloudCleanConfig();
                    }
                    this.cloudCleanConfigDevFlow = this.cloudCleanConfigService.queryDevFlowById(String.valueOf(info.getDeviceId()));
                    this.cloudCleanAlarmHandler.cloudCleanAlarmCancel(info, this.cloudCleanConfigForm, this.cloudCleanConfigDevFlow);
                    continue;
                }
                result = false;
                for (AticDevice reInjectDevice : cancel100SuccessList) {
                    res = this.cloudCleanService.undoDeployDivert(form, reInjectDevice, "LoopBack200");
                    detailParas3 = new String[]{form.getIpMask(), "LoopBack200", reInjectDevice.getName()};
                    if (!res.booleanValue()) {
                        this.writeSysLog("atic.bis.cloud.clean.operation.undoDeploy", form.getIpMask(), "atic.bis.cloudclean.disable.policy.failed.oplog.undoDeployDivert", detailParas3, 0);
                        continue;
                    }
                    result = true;
                    this.writeSysLog("atic.bis.cloud.clean.operation.undoDeploy", form.getIpMask(), "atic.bis.cloudclean.disable.policy.success.oplog.undoDeployDivert", detailParas3, 1);
                }
                if (result.booleanValue()) {
                    successList.add(info);
                    this.logger.info((Object)("cancel single cloud clean success for " + info.getIpMask()));
                    detailParas2 = new String[]{form.getIpMask()};
                    this.writeSysLog("atic.bis.cloud.clean.operation.disable", form.getIpMask(), "atic.bis.cloudclean.disable.policy.success.oplog.autocreate", detailParas2, 1);
                    this.cloudCleanConfigDevFlow = this.cloudCleanConfigService.queryDevFlowById(String.valueOf(info.getDeviceId()));
                    this.logger.info((Object)"cloud clean close, alarm recovery start");
                    if (null != this.cloudCleanConfigDevFlow) {
                        this.cloudCleanAlarmHandler.cloudCleanAlarmEnd(info, this.cloudCleanConfigForm, this.cloudCleanConfigDevFlow);
                    }
                    this.logger.info((Object)"cloud clean close, alarm recovery end");
                    continue;
                }
                this.logger.error((Object)("cancel single cloud clean failed for " + info.getIpMask() + ", because undo LoopBack200 failed on all reInjectDevices."));
                detailParas2 = new String[]{form.getIpMask()};
                this.writeSysLog("atic.bis.cloud.clean.operation.disable", form.getIpMask(), "atic.bis.cloudclean.disable.policy.failed.oplog.autocreate", detailParas2, 0);
                if (null == this.cloudCleanConfigForm) {
                    this.cloudCleanConfigForm = this.cloudCleanConfigService.findCloudCleanConfig();
                }
                this.cloudCleanConfigDevFlow = this.cloudCleanConfigService.queryDevFlowById(String.valueOf(info.getDeviceId()));
                this.cloudCleanAlarmHandler.cloudCleanAlarmCancel(info, this.cloudCleanConfigForm, this.cloudCleanConfigDevFlow);
            }
            StringBuffer sb = new StringBuffer();
            this.cloudCleanService.deteleByInfo(successList);
            for (CloudClean ccdel : successList) {
                sb.append(ccdel.getIpMask()).append(", ");
                detailParas = new String[]{ccdel.getIpMask()};
                this.writeSysLog("atic.bis.cloud.clean.operation.delete", ccdel.getIpMask(), "atic.bis.cloudclean.delete.policy.success.oplog.autocreate", detailParas, 1);
            }
            this.logger.info((Object)("cancel cloud clean delay list end when delay-time is not 0, the size of SUCCESS-LIST is " + successList.size() + " and the content of SUCCESS-LIST is " + sb.toString()));
            this.delayCancelList.removeAll(processedList);
        }
    }

    public ISysOptLog getSysOptLog() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            ISysOptLog sysOptLog = (ISysOptLog)context.getService("sysLogService", ISysOptLog.class);
            if (sysOptLog != null) {
                return sysOptLog;
            }
            this.logger.error((Object)"get system/sysLogService service error");
        }
        this.logger.error((Object)"get system/sysLogService service error");
        return null;
    }

    private void writeSysLog(String operation, String target, String detail, String[] detailPara, int result) {
        ISysOptLog sysOptLogMgr = CloudCleanUtil.getSysOptLog();
        SysOptLog sysOptLog = new SysOptLog();
        sysOptLog.setOperation(operation);
        sysOptLog.setModule("atic.bis.cloudClean");
        sysOptLog.setTerminalIp("127.0.0.1");
        sysOptLog.setOperator("system");
        sysOptLog.setLevel(SysoplogLevel.normal.getValue());
        sysOptLog.setResult(result);
        sysOptLog.setTarget(target);
        sysOptLog.setDetail(detail);
        sysOptLog.setDetailPara(detailPara);
        if (null != sysOptLogMgr) {
            sysOptLogMgr.writeOptLog(sysOptLog);
        }
    }

    private void closeCloudClean(CloudClean info, CloudCleanConfigForm configForm) {
        String serviceProvider = configForm.getServiceProvider();
        if ("CTCC".equals(serviceProvider)) {
            String ip = info.getIpMask();
            if (null != ip) {
                ip = ip.split("/")[0];
            }
            this.logger.info((Object)"close cloud clean CTCC");
            CloudCleanUtil.disableCloudClean4CTCC(configForm.getUrl(), new StringBuffer(configForm.getPublicKey()), new StringBuffer(configForm.getPrivateKey()), ip);
        } else if ("HW".equals(serviceProvider)) {
            this.logger.info((Object)"close cloud clean :hw");
            try {
                CloudCleanUtil.getInstance().disableCloudClean4HW(configForm.getUrl(), new StringBuffer(configForm.getPublicKey()), new StringBuffer(configForm.getPrivateKey()), info.getEventId());
            }
            catch (Exception e) {
                this.logger.error((Object)("close cloud clean fail for " + info.getIpMask()));
                throw new LegoCheckedException("", (Throwable)e);
            }
        }
    }

    public void removeDeleteList(List<CloudClean> deleteList) {
        if (null != this.list && !this.list.isEmpty()) {
            this.list.removeAll(deleteList);
        }
    }

    public List<CloudClean> getList() {
        return this.list;
    }

    public void setList(List<CloudClean> addList) {
        if (null == this.list) {
            this.list = new ArrayList<CloudClean>();
        }
        ArrayList<CloudClean> deleteList = new ArrayList<CloudClean>();
        for (CloudClean cloudClean : addList) {
            this.logger.info((Object)("auto create policy :cloudClean.id=" + cloudClean.getId()));
            for (CloudClean cloudClean1 : this.list) {
                if (!cloudClean1.getId().equals(cloudClean.getId())) continue;
                deleteList.add(cloudClean1);
            }
        }
        this.list.removeAll(deleteList);
        this.list.addAll(addList);
    }

    public CloudCleanConfigForm getCloudCleanConfigForm() {
        return this.cloudCleanConfigForm;
    }

    public void setCloudCleanConfigForm(CloudCleanConfigForm cloudCleanConfigForm) {
        this.cloudCleanConfigForm = cloudCleanConfigForm;
    }

    public CloudCleanConfigDevFlow getCloudCleanConfigDevFlow() {
        return this.cloudCleanConfigDevFlow;
    }

    public void setCloudCleanConfigDevFlow(CloudCleanConfigDevFlow cloudCleanConfigDevFlow) {
        this.cloudCleanConfigDevFlow = cloudCleanConfigDevFlow;
    }

    public ICloudCleanService getCloudCleanService() {
        return this.cloudCleanService;
    }

    public void setCloudCleanService(ICloudCleanService cloudCleanService) {
        this.cloudCleanService = cloudCleanService;
    }

    public ICloudCleanConfigService getCloudCleanConfigService() {
        return this.cloudCleanConfigService;
    }

    public void setCloudCleanConfigService(ICloudCleanConfigService cloudCleanConfigService) {
        this.cloudCleanConfigService = cloudCleanConfigService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IDateTableFileService getDateTableFileService() {
        return this.dateTableFileService;
    }

    public void setDateTableFileService(IDateTableFileService dateTableFileService) {
        this.dateTableFileService = dateTableFileService;
    }

    public boolean isIsChangeFlowValue() {
        return this.isChangeFlowValue;
    }

    public void setChangeFlowValue(boolean isChangeFlowValues) {
        this.isChangeFlowValue = isChangeFlowValues;
    }

    public synchronized List<CloudClean> getDelayCancelList() {
        return this.delayCancelList;
    }

    public void setDelayCancelList(List<CloudClean> delayCancelList) {
        this.delayCancelList = delayCancelList;
    }

    public CloudCleanAlarmHandler getCloudCleanAlarmHandler() {
        return this.cloudCleanAlarmHandler;
    }

    public void setCloudCleanAlarmHandler(CloudCleanAlarmHandler cloudCleanAlarmHandler) {
        this.cloudCleanAlarmHandler = cloudCleanAlarmHandler;
    }
}

