/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.unicom.service.impl;

import com.hs.atic.bis.unicom.dao.TaskUnicomDao;
import com.hs.atic.sdk.bis.unicom.entity.TaskUnicomEntity;
import com.hs.atic.sdk.bis.unicom.service.TaskUnicomService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.unicom.util.FormatTimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TaskUnicomServiceImpl
implements TaskUnicomService {
    private TaskUnicomDao taskUnicomDao;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);

    @Override
    public void saveTaskUnicom(TaskUnicomEntity task) {
        this.logger.info((Object)"save or update task start!");
        this.taskUnicomDao.saveOrUpdate(task);
        this.logger.info((Object)("saveOrUpdate Task :" + task.getTaskId()));
    }

    @Override
    public List<TaskUnicomEntity> getTaskUnicom() {
        return this.taskUnicomDao.getTaskUnicom();
    }

    @Override
    public TaskUnicomEntity getTaskUnicomById(String taskId) {
        return this.taskUnicomDao.getTaskUnicomById(taskId);
    }

    @Override
    public List<TaskUnicomEntity> getTaskByIdAndCleanEqIp(String taskId, String cleanEqIp) {
        return this.taskUnicomDao.getTaskByIdAndCleanEqIp(taskId, cleanEqIp);
    }

    @Override
    public List<TaskUnicomEntity> getTaskByCleanEqIp(String cleanEqIp) {
        return this.taskUnicomDao.getTaskByCleanEqIp(cleanEqIp);
    }

    @Override
    public Paging getTaskByPage(Map<String, String> conditionMap, int start, int pageSize) {
        Paging taskByPage = this.taskUnicomDao.getTaskByPage(conditionMap, start, pageSize);
        List data = taskByPage.getData();
        if (null != data && !data.isEmpty()) {
            this.logger.info((Object)"taskList is not null, data");
            ArrayList<TaskUnicomEntity> tasks = new ArrayList<TaskUnicomEntity>();
            for (TaskUnicomEntity taskUnicomEntity : data) {
                taskUnicomEntity.setShowCreateTime(FormatTimeUtil.formateTime(taskUnicomEntity.getCreateTime()));
                tasks.add(taskUnicomEntity);
            }
            taskByPage.setData(tasks);
        }
        return taskByPage;
    }

    public TaskUnicomDao getTaskUnicomDao() {
        return this.taskUnicomDao;
    }

    public void setTaskUnicomDao(TaskUnicomDao taskUnicomDao) {
        this.taskUnicomDao = taskUnicomDao;
    }
}

